/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.forms;

import com.openbravo.basic.BasicException;
import com.openbravo.beans.JFlowPanel;
import com.openbravo.dao.DataLogicItems;
import com.openbravo.dao.DataLogicSales;
import com.openbravo.dao.DataLogicStats;
import com.openbravo.dao.DataLogicSystem;
import com.openbravo.data.gui.CustomJButton;
import com.openbravo.format.Formats;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.AppView;
import com.openbravo.pos.forms.BeanFactoryApp;
import com.openbravo.pos.forms.BeanFactoryException;
import com.openbravo.pos.forms.JPanelView;
import com.openbravo.pos.notify.NPosition;
import com.openbravo.pos.notify.NotifyType;
import com.openbravo.pos.notify.NotifyWindow;
import com.openbravo.pos.panels.PaymentsModel;
import com.openbravo.pos.printer.Decreaser;
import com.openbravo.pos.printer.PrinterHelper;
import com.openbravo.pos.ticket.MarqueNFC;
import com.openbravo.pos.ticket.PaymentLine;
import com.openbravo.pos.ticket.TaxLineInfo;
import com.openbravo.pos.ticket.TaxeLine;
import com.openbravo.pos.ticket.UserCaisseInfo;
import com.openbravo.pos.util.Event;
import com.openbravo.pos.util.InactivityListener;
import com.openbravo.pos.util.Journal;
import com.openbravo.pos.util.LogToFile;
import fr.protactile.procaisse.dao.entities.CaisseInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.TextAttribute;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;

public class JPanelFermeture
extends JPanel
implements JPanelView,
BeanFactoryApp {
    protected AppView m_App;
    protected DataLogicSystem dlSystem;
    private Action logout;
    private InactivityListener listener;
    private Integer delay = 0;
    private DataLogicSales dlSales;
    private DataLogicItems dlItems;
    private PaymentsModel m_PaymentsCaisse;
    private CaisseInfo caisse;
    private SimpleDateFormat dateFormatterFull;
    private JLabel openByLabel;
    private JLabel dateLabel;
    private JPanel caPanel;
    private JLabel titleCA;
    private JLabel valCA;
    private JLabel titleTVA;
    private JLabel valTVA;
    private JPanel tvaPanel;
    private JLabel paymentLabel;
    private JLabel employeLabel;
    private JPanel fondPanel;
    private JLabel fondTitelLabel;
    private JLabel fondvalLabel;
    private CustomJButton valider;
    private JFlowPanel panelClose;
    JScrollPane scroll;
    private DataLogicStats dlStats;
    private JButton jValider;

    public JPanelFermeture() {
        this.initComponents();
        this.panelClose = new JFlowPanel();
        this.scroll = new JScrollPane(this.panelClose);
        this.scroll = new JScrollPane(this.panelClose);
        this.scroll.setHorizontalScrollBarPolicy(31);
        this.scroll.setVerticalScrollBarPolicy(20);
        this.scroll.getVerticalScrollBar().setPreferredSize(new Dimension(25, 35));
        this.panelClose.setAlignmentY(0.5f);
        this.add((Component)this.scroll, "Center");
    }

    @Override
    public void init(AppView app) throws BeanFactoryException {
        this.m_App = app;
        this.dlSystem = (DataLogicSystem)this.m_App.getBean("com.openbravo.dao.DataLogicSystem");
        this.dlSales = (DataLogicSales)this.m_App.getBean("com.openbravo.dao.DataLogicSales");
        this.dlItems = (DataLogicItems)this.m_App.getBean("com.openbravo.dao.DataLogicItems");
        this.dlSales.setDlItems(this.dlItems);
        this.dlStats = (DataLogicStats)this.m_App.getBean("com.openbravo.dao.DataLogicStats");
        this.dateFormatterFull = new SimpleDateFormat("dd/MM/yyyy - HH:mm");
    }

    @Override
    public Object getBean() {
        return this;
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public void activate() throws BasicException {
        String autoLogoff = this.m_App.getProperties().getProperty("till.autoLogoff");
        if (autoLogoff != null && autoLogoff.equals("true")) {
            try {
                this.delay = Integer.parseInt(this.m_App.getProperties().getProperty("till.autotimer"));
            }
            catch (NumberFormatException e) {
                this.delay = 0;
            }
            this.delay = this.delay * 1000;
        }
        if (this.delay != 0) {
            this.listener = new InactivityListener(this.logout, this.delay);
            this.listener.start();
        }
        this.load();
    }

    @Override
    public boolean deactivate() {
        return true;
    }

    public void load() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int width = (int)screenSize.getWidth();
        this.panelClose.removeAll();
        try {
            this.caisse = this.dlSales.getCaisse(AppLocal.token);
        }
        catch (BasicException ex) {
            new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "une erreur est servenu.", 1500, NPosition.CENTER);
        }
        this.caisse.setOuverte(false);
        this.caisse.setDateClose(new Date());
        this.caisse.setUser_close(this.m_App.getAppUserView().getUser().getUserInfo());
        try {
            this.m_PaymentsCaisse = PaymentsModel.loadBydateOpen(this.m_App, this.caisse.getDateOpen());
        }
        catch (BasicException ex) {
            new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "une erreur est servenu.", 1500, NPosition.CENTER);
        }
        this.openByLabel = new JLabel();
        this.openByLabel.setHorizontalAlignment(0);
        this.openByLabel.setFont(new Font("Arial", 1, 20));
        this.openByLabel.setText("Ouverture par " + this.caisse.getUser_open().getName());
        this.openByLabel.setPreferredSize(new Dimension(width, 50));
        this.panelClose.add(this.openByLabel);
        this.dateLabel = new JLabel();
        this.dateLabel.setHorizontalAlignment(0);
        this.dateLabel.setFont(new Font("Arial", 0, 20));
        this.dateLabel.setText("Le " + this.dateFormatterFull.format(this.caisse.getDateOpen()));
        this.dateLabel.setPreferredSize(new Dimension(width, 30));
        this.panelClose.add(this.dateLabel);
        this.caPanel = new JPanel();
        this.caPanel.setLayout(new GridLayout());
        this.caPanel.setPreferredSize(new Dimension(width, 30));
        this.titleCA = new JLabel();
        this.titleCA.setHorizontalAlignment(4);
        this.titleCA.setText("CA total:      ");
        this.titleCA.setForeground(new Color(52, 152, 219));
        this.valCA = new JLabel();
        this.valCA.setHorizontalAlignment(2);
        this.valCA.setText("      " + this.m_PaymentsCaisse.printPaymentsTotal());
        this.caPanel.add(this.titleCA);
        this.caPanel.add(this.valCA);
        this.panelClose.add(this.caPanel);
        this.tvaPanel = new JPanel();
        this.tvaPanel.setLayout(new GridLayout());
        this.tvaPanel.setPreferredSize(new Dimension(width, 30));
        this.titleTVA = new JLabel();
        this.titleTVA.setHorizontalAlignment(4);
        this.titleTVA.setText("TVA \u00e0 reverser:      ");
        this.titleTVA.setForeground(new Color(52, 152, 219));
        this.valTVA = new JLabel();
        this.valTVA.setHorizontalAlignment(2);
        this.tvaPanel.add(this.titleTVA);
        this.tvaPanel.add(this.valTVA);
        this.panelClose.add(this.tvaPanel);
        double totalTax = 0.0;
        for (TaxLineInfo saleLine : this.m_PaymentsCaisse.getSaleLines()) {
            JPanel panelTVA = new JPanel();
            panelTVA.setLayout(new GridLayout());
            panelTVA.setPreferredSize(new Dimension(width, 30));
            JLabel labelTitleTVA = new JLabel();
            labelTitleTVA.setHorizontalAlignment(4);
            labelTitleTVA.setForeground(new Color(52, 152, 219));
            JLabel labelvalTVA = new JLabel();
            labelvalTVA.setHorizontalAlignment(2);
            labelTitleTVA.setText("TVA " + saleLine.getName() + ":       ");
            labelvalTVA.setText("      " + saleLine.printAmount());
            panelTVA.add(labelTitleTVA);
            panelTVA.add(labelvalTVA);
            this.panelClose.add(panelTVA);
            totalTax += saleLine.getAmount();
        }
        this.valTVA.setText("      " + Formats.CURRENCY.formatValue(totalTax));
        this.paymentLabel = new JLabel();
        this.paymentLabel.setHorizontalAlignment(0);
        this.paymentLabel.setFont(new Font("Arial", 0, 20));
        Font fontPayment = this.paymentLabel.getFont();
        Map<TextAttribute, ?> attributesPayment = fontPayment.getAttributes();
        attributesPayment.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        this.paymentLabel.setFont(fontPayment.deriveFont(attributesPayment));
        this.paymentLabel.setText("CA par mode de paiement");
        this.paymentLabel.setPreferredSize(new Dimension(width, 30));
        this.panelClose.add(this.paymentLabel);
        for (PaymentsModel.PaymentsLine paymentLine : this.m_PaymentsCaisse.getPaymentLines()) {
            JPanel panelPayment = new JPanel();
            panelPayment.setLayout(new GridLayout());
            panelPayment.setPreferredSize(new Dimension(width, 30));
            JLabel labelTitlePayment = new JLabel();
            labelTitlePayment.setForeground(new Color(52, 152, 219));
            labelTitlePayment.setHorizontalAlignment(4);
            JLabel labelPayment = new JLabel();
            labelPayment.setHorizontalAlignment(2);
            labelTitlePayment.setText(paymentLine.printType() + ":      ");
            labelPayment.setText("      " + paymentLine.printValue());
            panelPayment.add(labelTitlePayment);
            panelPayment.add(labelPayment);
            this.panelClose.add(panelPayment);
        }
        this.employeLabel = new JLabel();
        this.employeLabel.setFont(new Font("Arial", 0, 20));
        this.employeLabel.setText("CA par employ\u00e9");
        Font font = this.employeLabel.getFont();
        Map<TextAttribute, ?> attributes = font.getAttributes();
        attributes.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        this.employeLabel.setFont(font.deriveFont(attributes));
        this.employeLabel.setHorizontalAlignment(0);
        this.employeLabel.setPreferredSize(new Dimension(width, 30));
        this.panelClose.add(this.employeLabel);
        for (UserCaisseInfo user : this.m_PaymentsCaisse.getM_users()) {
            JPanel panelEmploye = new JPanel();
            panelEmploye.setLayout(new GridLayout());
            panelEmploye.setPreferredSize(new Dimension(width, 30));
            JLabel labelTitleEmploye = new JLabel();
            labelTitleEmploye.setForeground(new Color(52, 152, 219));
            labelTitleEmploye.setHorizontalAlignment(4);
            JLabel labelEmploye = new JLabel();
            labelEmploye.setHorizontalAlignment(2);
            labelTitleEmploye.setText(user.getName() + ":      ");
            labelEmploye.setText("      " + user.printTotal());
            panelEmploye.add(labelTitleEmploye);
            panelEmploye.add(labelEmploye);
            this.panelClose.add(panelEmploye);
        }
        this.fondPanel = new JPanel();
        this.fondPanel.setLayout(new GridLayout());
        this.fondPanel.setPreferredSize(new Dimension(width, 30));
        this.fondTitelLabel = new JLabel();
        this.fondTitelLabel.setHorizontalAlignment(4);
        this.fondTitelLabel.setText("<html>Fond de caisse    <br>\u00e0 la fermeture:     <br></html>");
        this.fondvalLabel = new JLabel();
        this.fondvalLabel.setHorizontalAlignment(2);
        this.fondvalLabel.setText("      " + String.valueOf(this.caisse.printFondCaisse()));
        this.fondPanel.add(this.fondTitelLabel);
        this.fondPanel.add(this.fondvalLabel);
        this.panelClose.add(this.fondPanel);
        this.panelClose.revalidate();
        this.panelClose.repaint();
    }

    @Override
    public String getTitle() {
        return "Fermeture de la caisse";
    }

    private void initComponents() {
        this.jValider = new JButton();
        this.setLayout(new BorderLayout());
        this.jValider.setBackground(new Color(101, 198, 187));
        this.jValider.setText("Valider Fermeture");
        this.jValider.setBorderPainted(false);
        this.jValider.setFocusPainted(false);
        this.jValider.setPreferredSize(new Dimension(73, 30));
        this.jValider.setRequestFocusEnabled(false);
        this.jValider.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelFermeture.this.jValiderActionPerformed(evt);
            }
        });
        this.add((Component)this.jValider, "Last");
    }

    private void jValiderActionPerformed(ActionEvent evt) {
        try {
            int MAX = 100;
            JDialog frame = new JDialog();
            frame.setLocationRelativeTo(null);
            frame.setUndecorated(true);
            JProgressBar pb = new JProgressBar();
            pb.setMinimum(0);
            pb.setMaximum(100);
            pb.setStringPainted(true);
            pb.setBackground(Color.GREEN);
            frame.setLayout(new FlowLayout());
            frame.setAlwaysOnTop(true);
            frame.getContentPane().add(pb);
            pb.setSize(400, 300);
            frame.pack();
            frame.setVisible(true);
            boolean currentValue = false;
            pb.setValue(0);
            MarqueNFC marqueNF = MarqueNFC.fetchOrStore(this.dlSales);
            ArrayList<TaxeLine> allTaxes = new ArrayList<TaxeLine>();
            allTaxes.clear();
            pb.setValue(8);
            pb.setString("calcul du chiffre d'affaires ...");
            double caNet = this.dlSales.getCA(this.caisse.getDateOpen());
            List<UserCaisseInfo> users = this.dlSales.getCAbyUser();
            List<PaymentLine> payments = this.dlSales.loadPayment(this.caisse.getDateOpen(), new Date());
            List<TaxeLine> taxes = this.dlSales.getTaxeByDate();
            double caCanceled = this.dlSales.getCACanceled();
            Integer m_iSales = this.dlSales.getNbOrder();
            pb.setValue(28);
            pb.setString("Traitement de fond de caisse ...");
            Journal.writeToJET(new Event(170, "Traitement de fond de caisse", this.m_App.getAppUserView().getUser().getId(), "fon de caisse", new Date().getTime(), ""));
            pb.setValue(38);
            pb.setString("Fermiture de caisse ...");
            this.dlSales.closeCaisseWithoutCloture(this.caisse, null, "j", null, this.m_App.getAppUserView().getUser().getId());
            PrinterHelper printer = new PrinterHelper();
            printer.printSummary(this.m_PaymentsCaisse, this.caisse, null);
            printer = new PrinterHelper();
            pb.setValue(78);
            pb.setString("Preparation des Rapports financiers ...");
            Decreaser decreaser = new Decreaser(this.dlSales, "", "Rapport fermeture", null, 0);
            printer.printCloseCaisse(m_iSales, caNet, caCanceled, 0.0, payments, allTaxes, users, this.caisse, marqueNF, decreaser);
            pb.setValue(100);
            pb.setString("Fin de Fermiture ...");
            frame.dispose();
        }
        catch (BasicException ex) {
            LogToFile.log("severe", null, ex);
        }
        catch (IOException ex) {
            LogToFile.log("severe", null, ex);
        }
        this.m_App.closeAppView();
    }
}

