/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.forms;

import com.openbravo.basic.BasicException;
import com.openbravo.dao.DataLogicItems;
import com.openbravo.dao.DataLogicSales;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.notify.NPosition;
import com.openbravo.pos.notify.NotifyType;
import com.openbravo.pos.notify.NotifyWindow;
import com.openbravo.pos.sales.DateLabelFormatter;
import com.openbravo.pos.util.DateUtils;
import com.openbravo.pos.util.LogToFile;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdatepicker.DateModel;
import org.jdatepicker.impl.JDatePanelImpl;
import org.jdatepicker.impl.JDatePickerImpl;
import org.jdatepicker.impl.UtilDateModel;

public class JDateVidange
extends JDialog {
    private double discountReturn;
    private Object[] result;
    private double total;
    private String type;
    private String currency;
    private Date selectedDate;
    private DataLogicSales dlSales;
    private DataLogicItems dlItems;
    Component parent;
    private Calendar mCalendar = Calendar.getInstance();
    private boolean resetCaisse;
    private JLabel firstLabel;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JLabel labelMessage;
    private JButton m_jButtonOK;
    private JPanel panelDate;

    private JDateVidange(Frame parent, boolean modal) {
        super(parent, modal);
        this.parent = parent;
        this.result = new Object[3];
    }

    private JDateVidange(Dialog parent, boolean modal) {
        super(parent, modal);
        this.parent = parent;
        this.result = new Object[3];
    }

    private Object[] init(DataLogicSales dlSales, boolean resetCaisse, DataLogicItems dlItems) throws BasicException {
        this.initComponents();
        this.setResizable(false);
        this.dlSales = dlSales;
        this.dlItems = dlItems;
        this.mCalendar.add(5, -1);
        this.selectedDate = this.mCalendar.getTime();
        DateUtils.setTimeToEndofDay(this.selectedDate);
        this.setTitle("La purge de la caisse ");
        this.getRootPane().setDefaultButton(this.m_jButtonOK);
        UtilDateModel model = new UtilDateModel();
        Properties p = new Properties();
        p.put("text.today", "Aujourd'hui");
        p.put("text.month", "Mois");
        p.put("text.year", "Ann\u00e9e");
        JDatePanelImpl datePanel = new JDatePanelImpl((DateModel)model, p);
        final JDatePickerImpl datePicker = new JDatePickerImpl(datePanel, (JFormattedTextField.AbstractFormatter)new DateLabelFormatter());
        datePicker.setTextEditable(false);
        datePicker.getModel().setSelected(true);
        datePicker.getModel().setDate(this.selectedDate.getYear() + 1900, this.selectedDate.getMonth(), this.selectedDate.getDate());
        datePicker.getModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent ce) {
                JDateVidange.this.selectedDate = (Date)datePicker.getModel().getValue();
            }
        });
        datePicker.setPreferredSize(new Dimension(300, 30));
        this.panelDate.removeAll();
        this.panelDate.add((Component)datePicker);
        this.panelDate.revalidate();
        this.panelDate.repaint();
        this.result[0] = null;
        this.result[1] = false;
        this.resetCaisse = resetCaisse;
        this.setVisible(true);
        return this.result;
    }

    private static Window getWindow(Component parent) {
        if (parent == null) {
            return new JFrame();
        }
        if (parent instanceof Frame || parent instanceof Dialog) {
            return (Window)parent;
        }
        return JDateVidange.getWindow(parent.getParent());
    }

    public static Object[] showMessage(Component parent, DataLogicSales dlSales, boolean resetCaisse, DataLogicItems dlItems) throws BasicException, IOException {
        Window window = JDateVidange.getWindow(parent);
        JDateVidange myMsg = window instanceof Frame ? new JDateVidange((Frame)window, true) : new JDateVidange((Dialog)window, true);
        myMsg.setPreferredSize(new Dimension(1000, 500));
        myMsg.setIconImage(ImageIO.read(parent.getClass().getClassLoader().getResourceAsStream("com/openbravo/images/favicon.png")));
        return myMsg.init(dlSales, resetCaisse, dlItems);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.firstLabel = new JLabel();
        this.jPanel1 = new JPanel();
        this.m_jButtonOK = new JButton();
        this.panelDate = new JPanel();
        this.labelMessage = new JLabel();
        this.jLabel1.setText("jLabel1");
        this.setDefaultCloseOperation(2);
        this.setType(Window.Type.POPUP);
        this.firstLabel.setFont(new Font("Tahoma", 1, 12));
        this.firstLabel.setHorizontalAlignment(0);
        this.firstLabel.setText("Choisir la date ");
        this.firstLabel.setPreferredSize(new Dimension(34, 40));
        this.getContentPane().add((Component)this.firstLabel, "First");
        this.jPanel1.setPreferredSize(new Dimension(156, 60));
        this.m_jButtonOK.setBackground(new Color(3, 201, 169));
        this.m_jButtonOK.setFont(AppLocal.FONT_ARIAL_BOLD_14);
        this.m_jButtonOK.setForeground(new Color(255, 255, 255));
        this.m_jButtonOK.setText("Valider");
        this.m_jButtonOK.setBorderPainted(false);
        this.m_jButtonOK.setFocusPainted(false);
        this.m_jButtonOK.setFocusable(false);
        this.m_jButtonOK.setMargin(new Insets(8, 16, 8, 16));
        this.m_jButtonOK.setPreferredSize(new Dimension(300, 44));
        this.m_jButtonOK.setRequestFocusEnabled(false);
        this.m_jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDateVidange.this.m_jButtonOKActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.m_jButtonOK);
        this.getContentPane().add((Component)this.jPanel1, "Last");
        this.labelMessage.setFont(new Font("Tahoma", 0, 12));
        this.labelMessage.setHorizontalAlignment(0);
        this.panelDate.add(this.labelMessage);
        this.getContentPane().add((Component)this.panelDate, "Center");
        this.setSize(new Dimension(358, 229));
        this.setLocationRelativeTo(null);
    }

    private void m_jButtonOKActionPerformed(ActionEvent evt) {
        Date dateToday = new Date();
        if (!(this.selectedDate == null || this.selectedDate.after(dateToday) || this.selectedDate.getMonth() == dateToday.getMonth() && this.selectedDate.getYear() == dateToday.getYear())) {
            if (!this.dlItems.isClotured("m", this.selectedDate)) {
                new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Veuillez red\u00e9marrer le logiciel pour cloturer le mois pr\u00e9c\u00e9dent.", 1500, NPosition.BOTTOM_RIGHT);
            } else {
                this.firstLabel.setText("");
                this.m_jButtonOK.setEnabled(false);
                this.labelMessage.setText("<html>Cet op\u00e9ration peut prendre plusieurs minutes ! <br/>en cours de PURGE ...</html>");
                this.labelMessage.setHorizontalAlignment(0);
                this.panelDate.removeAll();
                this.panelDate.add(this.labelMessage);
                this.panelDate.revalidate();
                this.panelDate.repaint();
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (JDateVidange.this.resetCaisse) {
                                JDateVidange.this.dlSales.resetCaisse(JDateVidange.this.selectedDate);
                            } else {
                                JDateVidange.this.dlSales.vidangerCaisse(JDateVidange.this.selectedDate);
                            }
                            AppLocal.dlSystem.reclaimUnusedSpace();
                            JDateVidange.this.dispose();
                            new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, "la purge de la caisse a \u00e9t\u00e9 fait avec succ\u00e8s.", 4000, NPosition.CENTER);
                        }
                        catch (Exception ex) {
                            JDateVidange.this.dispose();
                            LogToFile.log("severe", ex.getMessage(), ex);
                            new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Une erreur est servenu.", 4000, NPosition.CENTER);
                        }
                    }
                }).start();
            }
        } else {
            new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Merci de choisir une date du Mois pr\u00e9c\u00e9dent.", 1500, NPosition.BOTTOM_RIGHT);
        }
    }
}

