/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.forms;

import com.openbravo.basic.BasicException;
import com.openbravo.controllers.CloseCaisseController;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.ticket.PaymentLine;
import com.openbravo.pos.util.AppVarUtils;
import com.openbravo.pos.util.LogToFile;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javax.imageio.ImageIO;
import javax.swing.JDialog;
import javax.swing.JFrame;

public class JClose
extends JDialog {
    Component parent;
    CloseCaisseController controller;
    private double width;
    private double height;

    private JClose(Frame parent, boolean modal) {
        super(parent, modal);
        this.parent = parent;
        this.setLocationRelativeTo(parent);
    }

    private JClose(Dialog parent, boolean modal) {
        super(parent, modal);
        this.parent = parent;
        this.setLocationRelativeTo(parent);
    }

    private void initAndShowGUI(final double turnover_cash, final List<PaymentLine> payments, final double course, final boolean write_fondCaisse) {
        final JFXPanel fxPanel = new JFXPanel();
        fxPanel.setSize(new Dimension((int)this.width, (int)this.height));
        this.getContentPane().add((Component)fxPanel, "Center");
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    System.out.println("+++++++++ step 3 close *************");
                    JClose.this.initFX(fxPanel, turnover_cash, payments, course, write_fondCaisse);
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            }
        });
    }

    private void initFX(JFXPanel fxPanel, double turnover_cash, List<PaymentLine> payments, double course, boolean write_fondCaisse) throws IOException, BasicException, URISyntaxException {
        String fxmlFile = "/fxml/close_caisse.fxml";
        FXMLLoader loader = new FXMLLoader(this.getClass().getResource(fxmlFile));
        Parent rootNode = (Parent)loader.load();
        this.controller = (CloseCaisseController)loader.getController();
        Scene scenePop = new Scene(rootNode, this.width, this.height);
        scenePop.getStylesheets().add((Object)"/styles/styles.css");
        this.controller.init(turnover_cash, payments, course, this, write_fondCaisse, false);
        fxPanel.setScene(scenePop);
    }

    private Object[] init(double turnover_cash, List<PaymentLine> payments, double course, boolean write_fondCaisse) throws BasicException {
        this.initComponents();
        this.width = AppVarUtils.getScreenDimension().getWidth() * 0.95;
        this.height = 680.0;
        this.setTitle(AppLocal.getIntString("Label.cash.fund.close"));
        this.setSize(new Dimension((int)this.width, (int)this.height));
        System.out.println("+++++++++ step 0 close *************");
        this.initAndShowGUI(turnover_cash, payments, course, write_fondCaisse);
        this.setLocationRelativeTo(null);
        this.setVisible(true);
        return this.controller.getResult();
    }

    private static Window getWindow(Component parent) {
        if (parent == null) {
            return new JFrame();
        }
        if (parent instanceof Frame || parent instanceof Dialog) {
            return (Window)parent;
        }
        return JClose.getWindow(parent.getParent());
    }

    public static Object[] showMessage(Component parent, double turnover_cash, List<PaymentLine> payments, double course, boolean write_fondCaisse) throws BasicException, IOException {
        System.out.println("++++++++++++ parent showMessage: " + parent);
        Window window = JClose.getWindow(parent);
        JClose myMsg = window instanceof Frame ? new JClose((Frame)window, true) : new JClose((Dialog)window, true);
        double width = AppVarUtils.getScreenDimension().getWidth() * 0.95;
        double height = 680.0;
        myMsg.setPreferredSize(new Dimension((int)width, (int)height));
        myMsg.setIconImage(ImageIO.read(parent.getClass().getClassLoader().getResourceAsStream("com/openbravo/images/favicon.png")));
        return myMsg.init(turnover_cash, payments, course, write_fondCaisse);
    }

    private void initComponents() {
        this.setDefaultCloseOperation(2);
        this.setType(Window.Type.POPUP);
        this.setSize(new Dimension(700, 639));
        this.setLocationRelativeTo(null);
    }
}

