/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.forms;

import com.openbravo.basic.BasicException;
import com.openbravo.pos.forms.AppProperties;
import com.openbravo.pos.forms.DriverWrapper;
import com.openbravo.pos.util.LogToFile;
import com.procaisse.db.connection.Session;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.swing.JOptionPane;

public class AppViewConnection {
    private AppViewConnection() {
    }

    public static Session createSession(AppProperties props) throws BasicException {
        try {
            if (AppViewConnection.isJavaWebStart()) {
                Class.forName(props.getProperty("db.driver"), true, Thread.currentThread().getContextClassLoader());
            } else {
                URLClassLoader cloader = new URLClassLoader(new URL[]{new File(props.getProperty("db.driverlib")).toURI().toURL()});
                DriverManager.registerDriver(new DriverWrapper((Driver)Class.forName(props.getProperty("db.driver"), true, cloader).newInstance()));
            }
            return new Session(props.getProperty("db.URL"), "APP", "protactilepa42");
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, "echec de connexion \u00e0 la base de donn\u00e9es");
            LogToFile.log("severe", ex.getMessage(), ex);
            return null;
        }
    }

    private static boolean isJavaWebStart() {
        try {
            Class.forName("javax.jnlp.ServiceManager");
            return true;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    public static void shutDown(String db_uri) {
        try {
            DriverManager.getConnection("jdbc:derby:" + db_uri + ";user=APP;password=protactilepa42;shutdown=true");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

