/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.forms;

import com.openbravo.pos.forms.AppConfig;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.util.StringUtils;
import java.lang.invoke.CallSite;
import java.lang.reflect.Field;
import java.util.ArrayList;

public class AppPropertyConstantLoader {
    private static AppPropertyConstantLoader instance = new AppPropertyConstantLoader();

    public static AppPropertyConstantLoader getInstance() {
        return instance;
    }

    public void load() throws Exception {
        this.load(AppConfig.getInstance());
    }

    public void load(AppConfig config) throws Exception {
        Field[] declaredFields;
        ArrayList<CallSite> errors = new ArrayList<CallSite>();
        for (Field field : declaredFields = AppLocal.class.getDeclaredFields()) {
            String key = this.getPropertyName(field.getName());
            String propertyValue = config.getProperty(key);
            if (StringUtils.isNotEmpty(propertyValue)) {
                String typeName;
                Object value = null;
                switch (typeName = field.getType().getName()) {
                    case "java.lang.String": {
                        value = propertyValue;
                        break;
                    }
                    case "java.lang.Integer": {
                        value = Integer.parseInt(propertyValue);
                        break;
                    }
                    case "java.lang.Boolean": {
                        value = "yes".equalsIgnoreCase(propertyValue);
                        break;
                    }
                    default: {
                        value = propertyValue;
                    }
                }
                field.set(null, value);
                continue;
            }
            String str = "----> field='" + field.getName() + "' - (key, propertyValue) = (" + key + ", '" + propertyValue + "')";
            System.err.println(str);
            errors.add((CallSite)((Object)str));
        }
        AppLocal.isCorrectlyLoaded = errors.isEmpty();
    }

    private String getPropertyName(String fieldName) {
        String s = fieldName.replaceAll("_", ".");
        return s.toLowerCase();
    }
}

