/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.forms;

import com.openbravo.AppConstants;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.AppProperties;
import com.openbravo.pos.util.AppVarUtils;
import com.openbravo.pos.util.ColorUtils;
import com.openbravo.pos.util.Event;
import com.openbravo.pos.util.Journal;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.pos.util.SignatureGenerator;
import com.openbravo.pos.util.StringUtils;
import com.openbravo.pos.util.SystemUtils;
import com.procaisse.db.connection.firebase.FireBaseInstance;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.file.Paths;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.comtel2000.keyboard.control.DefaultLayer;
import org.comtel2000.keyboard.robot.IRobot;
import org.comtel2000.swing.control.KeyBoardWindowBuilder;
import org.comtel2000.swing.robot.AWTRobotHandler;

public class AppConfig
implements AppProperties {
    private static Log logger = LogFactory.getFactory().getInstance(AppConfig.class);
    private static AppConfig instance = null;
    private static Lock lock = new ReentrantLock();
    private Properties configProperties;
    private File configfile;
    private AppVarUtils appVars;
    FireBaseInstance mFireBaseInstance;

    public static AppConfig getInstance() {
        return AppConfig.getInstance(true, AppConfig.getDefaultConfig());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AppConfig getInstance(boolean forceReload, File defaultConfig) {
        if (instance == null || forceReload) {
            Lock lock = AppConfig.lock;
            synchronized (lock) {
                if (instance == null || forceReload) {
                    instance = new AppConfig(defaultConfig, false);
                    instance.load();
                }
            }
        }
        return instance;
    }

    public AppConfig(File configfile, boolean load) {
        this.configfile = configfile;
        this.configProperties = new Properties();
    }

    private static File getDefaultConfig() {
        return new File(new File(SystemUtils.SYS_USER_HOME), "procaisse.properties");
    }

    @Override
    public String getProperty(String sKey) {
        String value = this.configProperties.getProperty(sKey);
        return value == null ? "" : value.trim();
    }

    @Override
    public String getHost() {
        return this.getProperty("machine.hostname");
    }

    @Override
    public File getConfigFile() {
        return this.configfile;
    }

    public void setProperty(String sKey, String sValue) {
        block18: {
            if (this.appVars == null) {
                this.appVars = new AppVarUtils();
            }
            String previousValue = this.configProperties.getProperty(sKey);
            if (sValue == null) {
                this.configProperties.remove(sKey);
            } else {
                this.configProperties.setProperty(sKey, sValue);
            }
            if (previousValue == null && sValue != null) {
                try {
                    if (AppLocal.user != null) {
                        Journal.writeToJET(new Event(300, Journal.JET_DESC_MODIF_ALL_PARAMS, AppLocal.user.getId(), AppVarUtils.propertiesDescription.get(sKey) != null ? AppVarUtils.propertiesDescription.get(sKey) : sKey, new Date().getTime(), sValue.replace(",", "-")));
                        break block18;
                    }
                    Journal.writeToJET(new Event(300, Journal.JET_DESC_MODIF_ALL_PARAMS, " ", AppVarUtils.propertiesDescription.get(sKey) != null ? AppVarUtils.propertiesDescription.get(sKey) : sKey, new Date().getTime(), sValue.replace(",", "-")));
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            } else if (sValue != null && !previousValue.equals(sValue)) {
                try {
                    if (AppLocal.user != null) {
                        Journal.writeToJET(new Event(300, Journal.JET_DESC_MODIF_ALL_PARAMS, AppLocal.user.getId(), AppVarUtils.propertiesDescription.get(sKey) != null ? AppVarUtils.propertiesDescription.get(sKey) : sKey, new Date().getTime(), (previousValue + "=>" + sValue).replace(",", "-")));
                        break block18;
                    }
                    Journal.writeToJET(new Event(300, Journal.JET_DESC_MODIF_ALL_PARAMS, " ", AppVarUtils.propertiesDescription.get(sKey) != null ? AppVarUtils.propertiesDescription.get(sKey) : sKey, new Date().getTime(), (previousValue + "=>" + sValue).replace(",", "-")));
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            } else if (previousValue != null && sValue == null) {
                try {
                    if (AppLocal.user != null) {
                        Journal.writeToJET(new Event(300, Journal.JET_DESC_MODIF_ALL_PARAMS, AppLocal.user.getId(), AppVarUtils.propertiesDescription.get(sKey) != null ? AppVarUtils.propertiesDescription.get(sKey) : sKey, new Date().getTime(), (previousValue + "=>").replace(",", "-")));
                    } else {
                        Journal.writeToJET(new Event(300, Journal.JET_DESC_MODIF_ALL_PARAMS, " ", AppVarUtils.propertiesDescription.get(sKey) != null ? AppVarUtils.propertiesDescription.get(sKey) : sKey, new Date().getTime(), (previousValue + "=>").replace(",", "-")));
                    }
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            }
        }
    }

    public boolean delete() {
        this.loadDefaultPropertyValues();
        return this.configfile.delete();
    }

    public void load(InputStream file) {
        try {
            Properties oldProperties = new Properties();
            if (this.configfile.exists()) {
                FileInputStream in = new FileInputStream(this.configfile);
                oldProperties.load(in);
                ((InputStream)in).close();
            }
            this.configProperties.load(file);
            this.configProperties.setProperty("db.engine", oldProperties.getProperty("db.engine"));
            this.configProperties.setProperty("db.driverlib", oldProperties.getProperty("db.driverlib"));
            this.configProperties.setProperty("db.driver", oldProperties.getProperty("db.driver"));
            this.configProperties.setProperty("db.URL", oldProperties.getProperty("db.URL"));
            this.configProperties.setProperty("machine.token", oldProperties.getProperty("machine.token"));
            this.configProperties.setProperty("model.caisse", oldProperties.getProperty("model.caisse"));
            this.configProperties.setProperty("ip.master", oldProperties.getProperty("ip.master"));
            this.configProperties.setProperty("mode.display", oldProperties.getProperty("mode.display"));
            this.configProperties.setProperty("machine.hostname", oldProperties.getProperty("machine.hostname"));
            this.configProperties.setProperty("message.welcome", oldProperties.getProperty("message.welcome"));
            this.configProperties.setProperty("machine.display", oldProperties.getProperty("machine.display"));
            this.configProperties.setProperty("machine.scale", oldProperties.getProperty("machine.scale"));
            this.configProperties.setProperty("machine.scanner", oldProperties.getProperty("machine.scanner"));
            this.configProperties.setProperty("machine.scale", oldProperties.getProperty("machine.scale"));
            this.configProperties.setProperty("name.borne", oldProperties.getProperty("name.borne"));
            this.configProperties.setProperty("bipper.auto.port", oldProperties.getProperty("bipper.auto.port"));
            this.configProperties.setProperty("units.balance.port", oldProperties.getProperty("units.balance.port"));
            this.configProperties.setProperty("allo.resto", oldProperties.getProperty("allo.resto"));
            this.configProperties.setProperty("online.enabled", oldProperties.getProperty("online.enabled"));
            this.configProperties.setProperty("gestion.stock", oldProperties.getProperty("gestion.stock"));
            this.configProperties.setProperty("finger.print", oldProperties.getProperty("finger.print"));
            this.configProperties.setProperty("dallas.integrated", oldProperties.getProperty("dallas.integrated"));
            this.configProperties.setProperty("module.bornes", oldProperties.getProperty("module.bornes"));
            this.configProperties.setProperty("module.tabletto", oldProperties.getProperty("module.tabletto"));
            this.configProperties.setProperty("module.course", oldProperties.getProperty("module.course"));
            this.configProperties.setProperty("module.qoodos", oldProperties.getProperty("module.qoodos"));
            this.configProperties.setProperty("module.glory", oldProperties.getProperty("module.glory"));
            this.configProperties.setProperty("module.glory.ip", oldProperties.getProperty("module.glory.ip"));
            this.configProperties.setProperty("module.glory.login", oldProperties.getProperty("module.glory.login"));
            this.configProperties.setProperty("module.glory.password", oldProperties.getProperty("module.glory.password"));
            this.configProperties.setProperty("credit.employee", oldProperties.getProperty("credit.employee"));
            this.configProperties.setProperty("day.recharge", oldProperties.getProperty("day.recharge"));
            this.configProperties.setProperty("send.kitchen", oldProperties.getProperty("send.kitchen"));
            this.configProperties.setProperty("hide.stock", oldProperties.getProperty("hide.stock"));
            this.configProperties.setProperty("loyalty.card", oldProperties.getProperty("loyalty.card"));
            this.configProperties.setProperty("module.platform", oldProperties.getProperty("module.platform"));
            this.configProperties.setProperty("id.database.download", oldProperties.getProperty("id.database.download"));
            this.configProperties.setProperty("hide.name.categories.web", oldProperties.getProperty("hide.name.categories.web"));
            this.configProperties.setProperty("hide.name.sub.categories.web", oldProperties.getProperty("hide.name.sub.categories.web"));
            this.configProperties.setProperty("hide.name.products.web", oldProperties.getProperty("hide.name.products.web"));
            this.configProperties.setProperty("hide.name.options.web", oldProperties.getProperty("hide.name.options.web"));
            this.configProperties.setProperty("online.order.host.name", oldProperties.getProperty("online.order.host.name"));
            this.configProperties.setProperty("payment.cb.tpe", oldProperties.getProperty("payment.cb.tpe"));
            String tpe_protocol = oldProperties.getProperty("payment.cb.tpe.protocol");
            this.configProperties.setProperty("payment.cb.tpe.protocol", tpe_protocol == null || tpe_protocol.isEmpty() ? "" : tpe_protocol);
            this.configProperties.setProperty("payment.cb.tpe.port", oldProperties.getProperty("payment.cb.tpe.port"));
            String id_marchant = oldProperties.getProperty("payment.cb.tpe.idMerchant");
            this.configProperties.setProperty("payment.cb.tpe.idMerchant", id_marchant == null || id_marchant.isEmpty() ? "" : id_marchant);
            this.configProperties.setProperty("id.site.orders", oldProperties.getProperty("id.site.orders"));
            this.configProperties.setProperty("ftp.account.configured", oldProperties.getProperty("ftp.account.configured"));
            this.configProperties.setProperty("module.cashlogy", oldProperties.getProperty("module.cashlogy"));
            this.configProperties.setProperty("module.cashlogy.ip", oldProperties.getProperty("module.cashlogy.ip"));
            this.configProperties.setProperty("module.cashlogy.login", oldProperties.getProperty("module.cashlogy.login"));
            this.configProperties.setProperty("module.cashlogy.password", oldProperties.getProperty("module.cashlogy.password"));
            this.configProperties.setProperty("cashlogy.print.dual.screen", oldProperties.getProperty("cashlogy.print.dual.screen"));
            this.configProperties.setProperty("cashlogy.position.x", oldProperties.getProperty("cashlogy.position.x"));
            this.configProperties.setProperty("cashlogy.position.y", oldProperties.getProperty("cashlogy.position.y"));
            this.configProperties.setProperty("display.accept.icon.cashlogy", oldProperties.getProperty("display.accept.icon.cashlogy"));
            this.configProperties.setProperty("cashlogy.accept.encaisse.partial", oldProperties.getProperty("cashlogy.accept.encaisse.partial"));
            this.configProperties.setProperty("cashlogy.screen.infront", oldProperties.getProperty("cashlogy.screen.infront"));
            this.configProperties.setProperty("cashlogy.display.centimes.windows", oldProperties.getProperty("cashlogy.display.centimes.windows"));
            this.configProperties.setProperty("cashlogy.display.encaisse.icon", oldProperties.getProperty("cashlogy.display.encaisse.icon"));
            file.close();
        }
        catch (IOException ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    private void load() {
        this.loadDefaultPropertyValues();
        try {
            boolean isModifed = false;
            if (this.configfile.exists()) {
                FileInputStream in = new FileInputStream(this.configfile);
                this.configProperties.load(in);
                ((InputStream)in).close();
                if (!this.configProperties.containsKey("machine.token")) {
                    if (AppLocal.token != null && !AppLocal.token.isEmpty()) {
                        this.configProperties.setProperty("machine.token", AppLocal.token);
                    } else {
                        this.configProperties.setProperty("machine.token", StringUtils.getToken());
                    }
                    isModifed = true;
                }
                if (!this.configProperties.containsKey("licence.type")) {
                    this.configProperties.setProperty("licence.type", "restauration");
                    isModifed = true;
                }
                if (!this.configProperties.containsKey("message.welcome")) {
                    this.configProperties.setProperty("message.welcome", "Bienvenue");
                    isModifed = true;
                }
                if (isModifed) {
                    this.save();
                }
                logger.info((Object)("URL Derby apr\u00e8s sauvegarde: " + this.configProperties.getProperty("db.URL")));
            }
        }
        catch (IOException e) {
            this.loadDefaultPropertyValues();
            try {
                if (AppLocal.token != null && !AppLocal.token.isEmpty()) {
                    this.configProperties.setProperty("machine.token", AppLocal.token);
                } else {
                    this.configProperties.setProperty("machine.token", StringUtils.getToken());
                }
                this.save();
                Journal.writeToJET(new Event(999, Journal.JET_EDITOR_FUNCTION, "", Journal.JET_DESCRIPTION, new Date().getTime(), "Restauration des param\u00e8tres par d\u00e9faut"));
            }
            catch (Exception ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
    }

    public void save() {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(this.configfile);
            this.configProperties.store(out, "Procaisse. Configuration file.");
            SignatureGenerator.getGenerator();
            SignatureGenerator.encryptFileWithAES(this.configfile, new File(AppVarUtils.PROCAISSE_PROPERTIES_ENCRYPTED));
        }
        catch (IOException ioe) {
            LogToFile.log("sever", "Unable to save property file of Procaisse named '<application Property file name>'. Raison : " + ioe.getMessage(), ioe);
        }
        finally {
            if (out != null) {
                try {
                    ((OutputStream)out).close();
                }
                catch (IOException ex) {
                    Logger.getLogger(AppConfig.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    private void loadDefaultPropertyValues() {
        this.configProperties = new Properties();
        Set<AppConstants.OrderProperty> defaultValueForMandatoryProps = AppConstants.getDefaultValueForMandatoryProps();
        for (AppConstants.OrderProperty orderProperty : defaultValueForMandatoryProps) {
            this.configProperties.put(orderProperty.getKey(), orderProperty.getValue());
        }
    }

    public void initAppLocal() {
        String slang = this.getProperty("user.language");
        String scountry = this.getProperty("user.country");
        String svariant = this.getProperty("user.variant");
        if (slang != null && !slang.equals("") && scountry != null && svariant != null) {
            Locale.setDefault(new Locale(slang, scountry, svariant));
        }
        AppLocal.window = KeyBoardWindowBuilder.create().initLocale(Locale.FRENCH).addIRobot((IRobot)new AWTRobotHandler()).layer(DefaultLayer.NUMBLOCK).build();
        AppLocal.DIMENSION_FIXED = this.getStringPropertyWithDefaultValue("dimension.fixed", "largeur");
        System.out.println("++++++++++++ AppLocal.token 2 ************** : " + AppLocal.token);
        AppLocal.lat = this.getStringProperty("address.lat");
        AppLocal.lon = this.getStringProperty("address.lon");
        AppLocal.radius = this.getStringProperty("address.radius");
        AppLocal.addressResto = this.getStringProperty("address.resto");
        AppLocal.bloc_bipper = this.getBooleanProperty("bloc.bip");
        AppLocal.is_call_center = this.getStringProperty("call.center");
        AppLocal.color_borne = this.getStringPropertyWithDefaultValue("color.borne", "255, 255, 255");
        AppLocal.bg_options = this.getStringPropertyWithDefaultValue("color.options", "black");
        AppLocal.db_engine = this.getStringProperty("db.engine");
        AppLocal.db_url = this.getStringProperty("db.URL");
        AppLocal.DB_CLASSNAME = this.getStringProperty("db.driver");
        AppLocal.modeOrder = this.getStringProperty("default.modeOrder");
        AppLocal.disting_option = this.getBooleanProperty("disting.option");
        AppLocal.footer = this.getStringProperty("footer.restaurant");
        AppLocal.currency = this.getStringProperty("format.currency");
        AppLocal.gestion_stock = this.getStringProperty("gestion.stock");
        AppLocal.header = this.getStringProperty("header.restaurant");
        AppLocal.dateStart = this.getIntegerPropertyWithDefaultValue("horaire.debut", 0);
        AppLocal.dateEnd = this.getIntegerPropertyWithDefaultValue("horaire.fin", 0);
        AppLocal.ip_label = this.getStringProperty("ip.label");
        AppLocal.IP_MASTER = this.getStringProperty("ip.master");
        AppLocal.hostname_kitchen_db = this.getStringProperty("kitchendb.hostname");
        AppLocal.name_kitchen_db = this.getStringPropertyWithDefaultValue("kitchendb.name", "db_procaisse");
        AppLocal.password_kitchen_db = this.getStringPropertyWithDefaultValue("kitchendb.password", "momtazpa42");
        AppLocal.port_kitchen_db = this.getStringProperty("kitchendb.port");
        AppLocal.user_kitchen_db = this.getStringPropertyWithDefaultValue("kitchendb.user", "procaisse");
        AppLocal.LABEL_AUTOCUTTER = this.getBooleanProperty("label.autocutter");
        AppLocal.LABEL_PRINTINGREDIENT = this.getBooleanProperty("label.printIngredient");
        AppLocal.LABEL_PRINTINGREDIENTEXCLUS = this.getBooleanProperty("label.printIngredientExclus");
        AppLocal.LABEL_PRINTNOTE = this.getBooleanProperty("label.printnote");
        AppLocal.MACHINE_DISPLAY = this.getStringProperty("machine.display");
        AppLocal.source_order = this.getStringProperty("machine.hostname");
        AppLocal.MACHINE_PRINTER = this.getStringProperty("machine.printer");
        AppLocal.MACHINE_PRINTER_2 = this.getStringProperty("machine.printer.2");
        AppLocal.MACHINE_PRINTER_3 = this.getStringProperty("machine.printer.3");
        AppLocal.MACHINE_PRINTER_4 = this.getStringProperty("machine.printer.4");
        AppLocal.MACHINE_PRINTER_5 = this.getStringProperty("machine.printer.5");
        AppLocal.MACHINE_PRINTER_6 = this.getStringProperty("machine.printer.6");
        AppLocal.MACHINE_PRINTERNAME = this.getStringProperty("machine.printername");
        AppLocal.MACHINE_SCALE = this.getStringProperty("machine.scale");
        AppLocal.MACHINE_SCANNER = this.getStringProperty("machine.scanner");
        AppLocal.MACHINE_SCREENMODE = this.getStringProperty("machine.screenmode");
        AppLocal.MACHINE_TICKETSBAG = this.getStringProperty("machine.ticketsbag");
        AppLocal.MACHINE_UNIQUEINSTANCE = this.getStringProperty("machine.uniqueinstance");
        AppLocal.MAIN_PATH = this.getStringProperty("main.path");
        AppLocal.messageWelcome = this.getStringProperty("message.welcome");
        AppLocal.MODE_DISPLAY = this.getStringProperty("mode.display");
        AppLocal.MODEL_CAISSE = this.getStringPropertyWithDefaultValue("model.caisse", "Standalone");
        AppLocal.model_label = this.getStringProperty("model.label");
        AppLocal.qoodos = this.getBooleanProperty("module.qoodos");
        AppLocal.name_borne = this.getStringProperty("name.borne");
        AppLocal.ORDER_TABLE = this.getBooleanProperty("order.table");
        AppLocal.PAPER_RECEIPT_HEIGHT = this.getStringProperty("paper.receipt.height");
        AppLocal.PAPER_RECEIPT_MEDIASIZENAME = this.getStringProperty("paper.receipt.mediasizename");
        AppLocal.PAPER_RECEIPT_WIDTH = this.getStringProperty("paper.receipt.width");
        AppLocal.PAPER_RECEIPT_X = this.getStringProperty("paper.receipt.x");
        AppLocal.PAPER_RECEIPT_Y = this.getStringProperty("paper.receipt.y");
        AppLocal.PAPER_STANDARD_HEIGHT = this.getStringProperty("paper.standard.height");
        AppLocal.PAPER_STANDARD_MEDIASIZENAME = this.getStringProperty("paper.standard.mediasizename");
        AppLocal.PAPER_STANDARD_WIDTH = this.getStringProperty("paper.standard.width");
        AppLocal.PAPER_STANDARD_X = this.getStringProperty("paper.standard.x");
        AppLocal.PAPER_STANDARD_Y = this.getStringProperty("paper.standard.y");
        AppLocal.PAYMENT_COMMERCEID = this.getStringProperty("payment.commerceid");
        AppLocal.PAYMENT_COMMERCE_PASSWORD = this.getStringProperty("payment.commercepassword");
        AppLocal.PAYMENT_GATEWAY = this.getStringProperty("payment.gateway");
        AppLocal.PAYMENT_MAGCARD_READER = this.getStringProperty("payment.magcardreader");
        AppLocal.PAYMENT_TEST_MODE = this.getStringProperty("payment.testmode");
        AppLocal.phoneRestaurant = this.getStringProperty("phone.restaurant");
        AppLocal.pic_ticket = this.getStringProperty("pic.ticket");
        AppLocal.print_avoir = this.getBooleanAndDefaultProperty("print.avoir");
        AppLocal.printFreeOption = this.getBooleanProperty("print.freeOption");
        AppLocal.REMOTE_SYNC = this.getStringProperty("remote.sync");
        AppLocal.SCREEN_RECEIPT_COLUMNS = this.getStringProperty("screen.receipt.columns");
        AppLocal.shift_option = this.getBooleanProperty("shift.option");
        AppLocal.size_product = this.getIntegerPropertyWithDefaultValue("size.product", 1);
        AppLocal.size_supplement = this.getIntegerPropertyWithDefaultValue("size.supplement", 1);
        AppLocal.SWING_DEFAULTLAF = this.getStringProperty("swing.defaultlaf");
        AppLocal.text_later = this.getStringPropertyWithDefaultValue("text.later", "PLUS TARD");
        AppLocal.timeSlide = this.getIntegerProperty("time.slide");
        AppLocal.type_borne = this.getStringProperty("type.borne");
        AppLocal.call_center_type_caisse = this.getStringProperty("type.caisse");
        AppLocal.USER_COUNTRY = this.getStringProperty("user.country");
        AppLocal.USER_LANGUAGE = this.getStringProperty("user.language");
        AppLocal.USER_VARIANT = this.getStringProperty("user.variant");
        AppLocal.IS_STATS_ONLINE_ENABLED = this.getBooleanProperty("stats.online");
        AppLocal.autoCutter = this.getProperty("label.autocutter") != null && "yes".equals(this.getProperty("label.autocutter"));
        AppLocal.displayTable = this.getProperty("order.table");
        AppLocal.logo_main = this.getProperty("main.path");
        AppLocal.master_address = this.getProperty("ip.master");
        AppLocal.modeCaisse = this.getProperty("mode.display");
        AppLocal.modelCaisse = this.getProperty("model.caisse");
        AppLocal.printIngredientAtLabel = this.getProperty("label.printIngredient") != null && "yes".equals(this.getProperty("label.printIngredient"));
        AppLocal.printIngredientExclus = this.getProperty("label.printIngredientExclus") != null && "yes".equals(this.getProperty("label.printIngredientExclus"));
        AppLocal.printNote = this.getProperty("label.printnote") != null && "yes".equals(this.getProperty("label.printnote"));
        Color lightColor = ColorUtils.ColorLuminance(ColorUtils.getColorByString(StringUtils.isEmpty(AppLocal.color_borne) ? "0,0,255" : AppLocal.color_borne));
        AppLocal.color_light_borne = this.getStringPropertyWithDefaultValue("color_light.borne", ColorUtils.getColorText(lightColor));
        AppLocal.ADD_ID_CAISSE = this.getBooleanProperty("identifiant.caisse");
        AppLocal.host_name = this.getStringProperty("machine.hostname");
        AppLocal.MANDATORY_COUVERT = this.getBooleanProperty("mandatory.couvert");
        AppLocal.PRINT_RECAP = this.getBooleanProperty("print.ticketCuisine");
        AppLocal.INVENTORY_MANAGEMENT = this.getBooleanProperty("gestion.stock");
        AppLocal.HIDE_STOCK = this.getBooleanAndDefaultProperty("hide.stock");
        AppLocal.DALLAS_INTEGRATED = this.getProperty("dallas.integrated") != null && this.getProperty("dallas.integrated").equals("yes");
        AppLocal.PREPARE_ORDER = this.getBooleanProperty("master.payment");
        AppLocal.PRODUCT_SIZE1 = this.getProperty("product.size1");
        AppLocal.PRODUCT_SIZE2 = this.getProperty("product.size2");
        AppLocal.PRODUCT_SIZE3 = this.getProperty("product.size3");
        AppLocal.SCAN_QR = this.getBooleanProperty("scan.qr");
        AppLocal.ORDER_ONLINE_ENABLED = this.getBooleanProperty("online.enabled");
        AppLocal.ID_ONLINE_SERVER = this.getProperty("online.id");
        AppLocal.DEACTIVE_PLAN = this.getBooleanAndDefaultProperty("deactive.plan");
        AppLocal.SHOW_IMAGE_CATEGORY = this.getBooleanProperty("image.category");
        AppLocal.SOURCE_ORDER_TAKE_AWAY = this.getBooleanProperty("source.order");
        AppLocal.PAYMENT_SEPARE = this.getBooleanProperty("payment.separe");
        AppLocal.DISPLAY_NUM_ORDER = this.getBooleanAndDefaultProperty("display.numberOrder");
        AppLocal.DISPLAY_NAME_SERVER = this.getBooleanProperty("display.nameServeur");
        AppLocal.HIDE_TYPE_ORDER = this.getBooleanAndDefaultProperty("cache.typeOrder");
        AppLocal.MODULE_COURSE = this.getProperty("module.course") != null && "yes".equals(this.getProperty("module.course"));
        AppLocal.FOND_CAISSE = this.getBooleanAndDefaultProperty("show.fondCaisse");
        AppLocal.SHOW_PLAN_TABLE = this.getBooleanAndDefaultProperty("plan.table");
        AppLocal.SHOW_SELECT_CUSTOMER = this.getBooleanAndDefaultProperty("select.customer");
        AppLocal.SHOW_FACTURE = this.getBooleanAndDefaultProperty("button.facture");
        AppLocal.DISPLAY_TIME_ENABLED = this.getBooleanProperty("display.time");
        AppLocal.GLORY_ENABLED = this.getProperty("module.glory") != null && "yes".equals(this.getProperty("module.glory"));
        AppLocal.CB_DRAWER = this.getBooleanProperty("cb.drawer");
        AppLocal.PRINT_FOND = this.getBooleanAndDefaultProperty("print.fondNoir");
        AppLocal.SEPARATE_OPTION = this.getBooleanAndDefaultProperty("separate.option");
        AppLocal.DEACTIVE_QUANTITY = this.getBooleanProperty("deactive.quantity");
        AppLocal.BALANCE_CONNECTED = this.getProperty("units.balance") != null && "yes".equals(this.getProperty("units.balance"));
        AppLocal.UNIT_BALANCE_PORT = this.getProperty("units.balance.port");
        AppLocal.BIPPER_CONNECTED = this.getProperty("bipper.auto") != null && "yes".equals(this.getProperty("bipper.auto"));
        AppLocal.BIPPER_AUTO_PORT = this.getProperty("bipper.auto.port");
        AppLocal.KITCHEN_COMPOSITE = this.getProperty("kitchen.composite") != null && this.getProperty("kitchen.composite").equals("yes");
        AppLocal.HOSTNAME_DB = this.getProperty("kitchendb.hostname");
        AppLocal.TYPE_DISPLAY = this.getProperty("machine.display");
        AppLocal.ISRENDMONNAIE = this.getBooleanAndDefaultProperty("ticket.rendMonnaie");
        AppLocal.OPEN_DRAWER = this.getBooleanProperty("open.drawer");
        AppLocal.MODE_CASH = this.getBooleanAndDefaultProperty("payment.cash");
        AppLocal.MODE_CB = this.getBooleanAndDefaultProperty("payment.cb");
        AppLocal.TPE_CONNECTED = this.getProperty("payment.cb.tpe") != null && "yes".equals(this.getProperty("payment.cb.tpe"));
        AppLocal.PORT_TPE = this.getProperty("payment.cb.tpe.port");
        AppLocal.MODE_TR = this.getBooleanAndDefaultProperty("payment.ticketResto");
        AppLocal.MODE_CHEQUE = this.getBooleanProperty("payment.cheque");
        AppLocal.MODE_FREE = this.getBooleanAndDefaultProperty("payment.free");
        AppLocal.MANDATORY_TABLE = this.getBooleanProperty("mandatory.table");
        AppLocal.BIPPER_AUTO_PREFIX = this.getProperty("bipper.auto.prefix");
        AppLocal.DISCOUNT_SUR_PLACE = this.getProperty("discount.sp");
        AppLocal.DISCOUNT_TAKE_AWAY = this.getProperty("discount.emp");
        AppLocal.DISCOUNT_LIVRAISON = this.getProperty("discount.lv");
        AppLocal.DISCOUNT_BAR = this.getProperty("discount.bar");
        AppLocal.DISCOUNT_TERRASE = this.getProperty("discount.terasse");
        AppLocal.DISCOUNT_HAPPY_HOUR = this.getProperty("discount.happyHour");
        AppLocal.ORDER_BAR = this.getBooleanProperty("order.bar");
        AppLocal.ORDER_TERASSE = this.getBooleanProperty("order.terasse");
        AppLocal.ORDER_HAPPYHOUR = this.getBooleanProperty("order.happyHour");
        AppLocal.GROUPE_OPTION = this.getBooleanAndDefaultProperty("option.groupe");
        AppLocal.MODE_DEBIT = this.getBooleanProperty("payment.debit");
        AppLocal.FILTER_NUMBER = this.getProperty("filter.number");
        AppLocal.CLE_DALLAS = this.getBooleanProperty("finger.print");
        AppLocal.MODE_CASHDRO = this.getBooleanProperty("payment.cashDro");
        AppLocal.TICKET_CALLBACK_LIMITED = this.getBooleanProperty("rappelTicket.limited");
        AppLocal.TICKET_CALLBACK_COUNT = this.getProperty("rappelTicket.limited.count");
        AppLocal.POSITION_PRICE = this.getProperty("position.price");
        AppLocal.LATERAL_BAR = this.getBooleanProperty("lateral.bar");
        AppLocal.HIDE_BACKGROUND_PRICE = this.getBooleanProperty("hide.bg.price");
        AppLocal.FIRST_INGREDIENTS = this.getBooleanProperty("first.ingredient");
        AppLocal.HIDE_NAME_PRODUCTS = this.getBooleanProperty("hide.name.products");
        AppLocal.HIDE_NAME_CATEGORIES = this.getBooleanProperty("hide.name.categories");
        AppLocal.HIDE_FOOTER_BORNE = this.getBooleanProperty("hide.footer.home");
        AppLocal.VIDEO_BORNE = this.getProperty("video.borne");
        AppLocal.TYPE_MEDIA_HOME = this.getProperty("type.media.home");
        AppLocal.LOGO_BORNE = this.getProperty("logo.borne");
        AppLocal.PAYMENT_BORNE = this.getBooleanAndDefaultProperty("payment.borne");
        AppLocal.ORDER_SP = this.getProperty("order.sp") == null || this.getProperty("order.sp").isEmpty() || "yes".equals(this.getProperty("order.sp"));
        AppLocal.ORDER_TAKE_AWAY = this.getProperty("order.emp") == null || this.getProperty("order.emp").isEmpty() || "yes".equals(this.getProperty("order.emp"));
        AppLocal.AUTO_CLOSE = this.getBooleanAndDefaultProperty("auto.close");
        AppLocal.TIMEOUT_INACTIVITY = this.getStringPropertyWithDefaultValue("timeout.inactivity", "20 min");
        AppLocal.EMAIL_SYNTHESE = this.getBooleanProperty("email.synthese");
        AppLocal.PRINT_AVOIR_UNIT = this.getStringPropertyWithDefaultValue("print.avoir.unit", "Mois");
        AppLocal.PRINT_AVOIR_DELAY = this.getIntegerPropertyWithDefaultValue("print.avoir.delai", 1);
        AppLocal.TOTAL_RECAP = this.getBooleanProperty("total.recap");
        AppLocal.ADD_CUSTOMER_NAME = this.getBooleanProperty("add.customer.name");
        AppLocal.WRITE_FOND_CAISSE = this.getBooleanAndDefaultProperty("write.fondCaisse");
        AppLocal.CALCUL_FOND_CAISSE = this.getBooleanProperty("cacul.fondCaisse");
        AppLocal.CREDIT_EMPLOYEE = this.getBooleanProperty("credit.employee");
        AppLocal.DAY_RECHARGE = this.getIntegerProperty("day.recharge", 1);
        AppLocal.AUTO_CLOSE_BORNE = this.getBooleanAndDefaultProperty("auto.close.borne");
        AppLocal.SEND_KITCHEN = this.getBooleanProperty("send.kitchen");
        AppLocal.SAVE_ORDER_SLAVE = this.getBooleanProperty("save.order.slave");
        AppLocal.SCAN_BARCODE_ORDER = this.getBooleanProperty("scan.barcode.order");
        AppLocal.PRINTED_CODE = this.getStringPropertyWithDefaultValue("printed.code", "QRCode");
        AppLocal.LOYALTY_CARD = this.getBooleanProperty("loyalty.card");
        AppLocal.MIN_SOLDE_LOYALTY_CARD = this.getDoubleProperty("min.solde.loyalty.card", 0.0);
        AppLocal.NUMBER_USER_LOYALTY_CARD = this.getIntegerProperty("number.use.loyalty.card", 1);
        AppLocal.CHECK_NUMBER_USER_LOYALTY_CARD = this.getBooleanProperty("check.number.use.loyalty.card");
        AppLocal.MODULE_TABLETTO = this.getBooleanProperty("module.tabletto");
        AppLocal.PRINT_INGREDIENT_KITCHEN = this.getBooleanProperty("print.ingredient.kitchen");
        AppLocal.TEXT_COLOR_BORNE = this.getStringPropertyWithDefaultValue("fond.color.borne", "0, 0, 0");
        AppLocal.PRINT_NUM_ORDER = this.getBooleanProperty("print.num.order");
        AppLocal.MODULE_UBER_EATS = this.getBooleanProperty("module.uber.eats");
        AppLocal.MODULE_DELIVERO = this.getBooleanProperty("module.delivero");
        AppLocal.PRINT_LABEL_TAKE_AWAY = this.getBooleanProperty("print.label.take.away");
        AppLocal.TEXT_COLOR_ITEMS = this.getStringPropertyWithDefaultValue("text.color.items", "0, 0, 0");
        AppLocal.BG_COLOR_ITEMS = this.getStringPropertyWithDefaultValue("bg.color.items", AppLocal.color_borne);
        AppLocal.HIDE_NAME_SUB_CATEGORIES = this.getBooleanProperty("hide.name.sub.categories");
        AppLocal.SUIVI_ONLINE_ORDER = this.getBooleanProperty("suivi.online.order");
        AppLocal.BACKGROUND_TYPE_ORDER_BORNE = this.getProperty("background.type.order.borne");
        AppLocal.BACKGROUND_AT_SPOT_ORDER_BORNE = this.getProperty("background.atspot.order.borne");
        AppLocal.BACKGROUND_TAKE_AWAY_ORDER_BORNE = this.getProperty("background.takeaway.order.borne");
        AppLocal.HIDE_SUB_CATEGORIES = this.getBooleanProperty("hide.sub.categories");
        AppLocal.TEXT_COLOR_BASKET = this.getStringPropertyWithDefaultValue("text.color.basket", AppLocal.TEXT_COLOR_BORNE);
        AppLocal.COLOR_TYPE_ORDER = this.getStringPropertyWithDefaultValue("color.type.order", AppLocal.TEXT_COLOR_BORNE);
        AppLocal.HIDE_MESSAGE_TYPE_ORDER = this.getBooleanProperty("hide.message.type.order");
        AppLocal.IMAGE_HEADER_BORNE = this.getProperty("image.header.borne");
        AppLocal.ONLINE_ORDER_HOST_NAME = this.getProperty("online.order.host.name");
        AppLocal.NUMBER_PRINT_Z = this.getIntegerProperty("number.print.z", 1);
        AppLocal.TEXT_COLOR_NAME_CATEGORY = this.getStringPropertyWithDefaultValue("text.color.name.category", AppLocal.TEXT_COLOR_BORNE);
        AppLocal.ID_DATABASE_DOWNLOAD = this.getProperty("id.database.download");
        AppLocal.IMAGES_TYPE_ORDER_TRANSPARENT = this.getBooleanProperty("images.type.order.transparent");
        AppLocal.MODULE_PLATFORM = this.getBooleanProperty("module.platform");
        AppLocal.SHOW_INFO_PLATFORM = this.getBooleanAndDefaultProperty("show.info.platform");
        AppLocal.PRODUCT_SIZE_JUNIOR = this.getStringPropertyWithDefaultValue("product.size.junior", "junior");
        AppLocal.PRODUCT_SIZE_SENIOR = this.getStringPropertyWithDefaultValue("product.size.senior", "senior");
        AppLocal.PRODUCT_SIZE_MEGA = this.getStringPropertyWithDefaultValue("product.size.mega", "mega");
        AppLocal.PRODUCT_SIZE_JUNIOR_ENABLED = this.getBooleanAndDefaultProperty("product.junior.enabled");
        AppLocal.PRODUCT_SIZE_SENIOR_ENABLED = this.getBooleanAndDefaultProperty("product.senior.enabled");
        AppLocal.PRODUCT_SIZE_MEGA_ENABLED = this.getBooleanAndDefaultProperty("product.mega.enabled");
        AppLocal.PRODUCT_SIZE1_ENABLED = this.getBooleanProperty("product.size1.enabled", AppLocal.PRODUCT_SIZE1 != null && !AppLocal.PRODUCT_SIZE1.isEmpty());
        AppLocal.PRODUCT_SIZE2_ENABLED = this.getBooleanProperty("product.size2.enabled", AppLocal.PRODUCT_SIZE2 != null && !AppLocal.PRODUCT_SIZE2.isEmpty());
        AppLocal.PRODUCT_SIZE3_ENABLED = this.getBooleanProperty("product.size3.enabled", AppLocal.PRODUCT_SIZE3 != null && !AppLocal.PRODUCT_SIZE3.isEmpty());
        AppLocal.HIDE_NAME_CATEGORIES_WEB = this.getBooleanProperty("hide.name.categories.web");
        AppLocal.HIDE_NAME_SUB_CATEGORIES_WEB = this.getBooleanProperty("hide.name.sub.categories.web");
        AppLocal.HIDE_NAME_PRODUCTS_WEB = this.getBooleanProperty("hide.name.products.web");
        AppLocal.HIDE_NAME_OPTIONS_WEB = this.getBooleanProperty("hide.name.options.web");
        AppLocal.SEND_NOPAID_ORDER_TOKITCHEN = this.getBooleanProperty("send.nopaid.order");
        AppLocal.HIDE_BUTTON_UPDATED_TICKET = this.getBooleanProperty("hide.button.updated.tickets");
        AppLocal.SAVE_SHARED_ORDERS = this.getBooleanProperty("shared.orders");
        String[] patterns = this.getStringPropertyWithDefaultValue("format.double", "#0.00").replace(".", ",").split(",");
        AppLocal.FORMAT_DOUBLE_PLACES = patterns.length > 1 ? patterns[1].length() : 2;
        AppLocal.FONT_FAMILY_CATEGORIES = this.getStringPropertyWithDefaultValue("font.family.categories", "Segoe UI Semibold");
        AppLocal.FONT_FAMILY_PRODUCTS = this.getStringPropertyWithDefaultValue("font.family.products", "Lucida Sans");
        AppLocal.FONT_FAMILY_OPTIONS = this.getStringPropertyWithDefaultValue("font.family.options", "Lucida Sans");
        AppLocal.CATALOG_BACKGROUND = this.getProperty("catalog.background");
        AppLocal.PRODUCT_SIZE1_DESCRIPTION = this.getProperty("product.size1.description");
        AppLocal.PRODUCT_SIZE2_DESCRIPTION = this.getProperty("product.size2.description");
        AppLocal.PRODUCT_SIZE3_DESCRIPTION = this.getProperty("product.size3.description");
        AppLocal.PRODUCT_SIZE4_DESCRIPTION = this.getProperty("product.size4.description");
        AppLocal.PRODUCT_SIZE5_DESCRIPTION = this.getProperty("product.size5.description");
        AppLocal.PRODUCT_SIZE6_DESCRIPTION = this.getProperty("product.size6.description");
        AppLocal.BACKGROUND_SUMMARY_ORDER = this.getProperty("background.summary.order.borne");
        AppLocal.PROMO_BASKET = this.getBooleanProperty("promo.basket");
        AppLocal.MIN_PRICE_ORDER_PROMO_BASKET = this.getDoublePropertyWithDefaultValue("min.price.order.promo.basket", 20.0);
        AppLocal.PRICE_PROMO_BASKET = this.getDoublePropertyWithDefaultValue("price.promo.basket", 1.0);
        AppLocal.BACKGROUND_SUMMARY_ORDER_PROMO = this.getProperty("background.summary.order.borne.promo");
        AppLocal.MIN_PRICE_ORDER_PROMO_BASKET_TEXT = this.getProperty("min.price.order.promo.basket");
        AppLocal.HIDE_BACKGROUND_PRODUCTS = this.getBooleanProperty("hide.background.products");
        AppLocal.SHOW_DESCRIPTION = this.getBooleanProperty("show.description");
        AppLocal.PRINT_DESCRIPTION = this.getBooleanProperty("print.description");
        AppLocal.SHOW_IMAGE_OPTIONS = this.getBooleanProperty("show.image.option");
        AppLocal.PRINT_TICKET_Z_GLOBAL = this.getBooleanProperty("print.ticket.z.gloabl");
        AppLocal.SHOW_IMAGE_PRODUCTS = this.getBooleanProperty("show.image.product");
        AppLocal.NUMBER_DIGIT_OF_PRODUCT_PRICE = this.getIntegerPropertyWithDefaultValue("number.digit.product.price", 5);
        AppLocal.ADD_HOUR_TO_NUMBER_ORDER = this.getBooleanProperty("add.hour.to.number.order");
        AppLocal.TEXT_COLOR_PRICE = this.getStringPropertyWithDefaultValue("text.color.price", AppLocal.TEXT_COLOR_BORNE);
        AppLocal.HIDE_NAME_APP = this.getBooleanProperty("hide.name.app");
        AppLocal.ONLY_TAKE_AWAY_BORNE = this.getBooleanProperty("only.take.away.borne");
        AppLocal.ID_SITE_ORDERS = this.getStringPropertyWithDefaultValue("id.site.orders", AppLocal.ID_DATABASE_DOWNLOAD);
        AppLocal.PAYMENT_ONLY_BY_CB = this.getBooleanProperty("payment.only.by.cb");
        AppLocal.SOUND_NOTIFICATION = this.getBooleanProperty("sound.notification");
        AppLocal.HIDE_INGREDIENTS_BORNE = this.getBooleanProperty("hide.ingredients.borne");
        AppLocal.HIDE_SUB_PRODUCT_INGREDIENT_BORNE = this.getBooleanProperty("hide.sub.product.ingredients.borne");
        AppLocal.VALID_WITHOUT_PRINT = this.getBooleanProperty("valid.without.print");
        AppLocal.PENDING_DELIVERY_ORDERS = this.getBooleanProperty("pending.delivery.ordersS");
        AppLocal.RATE_UBEREAT = this.getDoublePropertyWithDefaultValue("rate.ubereat", 30.0);
        AppLocal.NUMBER_PRINT_DELIVERY = this.getIntegerPropertyWithDefaultValue("number.print.delivery", 1);
        AppLocal.SOUND_NOTIFICATION_ONLINE_ORDER = this.getBooleanProperty("sound.notification.online.order");
        AppLocal.PRINT_RECAP_DELIVERY = this.getBooleanProperty("print.recapitulatif.delivery");
        AppLocal.PRODUCT_SIZE4_ENABLED = this.getBooleanProperty("product.size4.enabled", AppLocal.PRODUCT_SIZE4 != null && !AppLocal.PRODUCT_SIZE4.isEmpty());
        AppLocal.PRODUCT_SIZE5_ENABLED = this.getBooleanProperty("product.size5.enabled", AppLocal.PRODUCT_SIZE5 != null && !AppLocal.PRODUCT_SIZE5.isEmpty());
        AppLocal.PRODUCT_SIZE6_ENABLED = this.getBooleanProperty("product.size6.enabled", AppLocal.PRODUCT_SIZE6 != null && !AppLocal.PRODUCT_SIZE6.isEmpty());
        AppLocal.PRODUCT_SIZE7_ENABLED = this.getBooleanProperty("product.size7.enabled", AppLocal.PRODUCT_SIZE7 != null && !AppLocal.PRODUCT_SIZE7.isEmpty());
        AppLocal.PRODUCT_SIZE4 = this.getProperty("product.size4");
        AppLocal.PRODUCT_SIZE5 = this.getProperty("product.size5");
        AppLocal.PRODUCT_SIZE6 = this.getProperty("product.size6");
        AppLocal.PRODUCT_SIZE7 = this.getProperty("product.size7");
        AppLocal.PRODUCT_SIZE7_DESCRIPTION = this.getProperty("product.size7.description");
        AppLocal.PRODUCT_SIZE8_DESCRIPTION = this.getProperty("product.size8.description");
        AppLocal.PRODUCT_SIZE9_DESCRIPTION = this.getProperty("product.size9.description");
        AppLocal.PRODUCT_SIZE10_DESCRIPTION = this.getProperty("product.size10.description");
        AppLocal.TICKET_SITE1 = this.getStringProperty("ticket.site1");
        AppLocal.TICKET_SITE2 = this.getStringProperty("ticket.site2");
        AppLocal.TICKET_SITE3 = this.getStringProperty("ticket.site3");
        AppLocal.DESCRIPTION_TICKET_SITE1 = this.getStringProperty("description.ticket.site1");
        AppLocal.DESCRIPTION_TICKET_SITE2 = this.getStringProperty("description.ticket.site2");
        AppLocal.DESCRIPTION_TICKET_SITE3 = this.getStringProperty("description.ticket.site3");
        AppLocal.SEND_SMS = this.getBooleanProperty("send.sms");
        AppLocal.SMS_API_KEY = this.getStringProperty("sms.api.key");
        AppLocal.SMS_API_SECRET = this.getStringProperty("sms.api.secret");
        AppLocal.RESTAURANT_NAME = this.getStringProperty("restaurant.name");
        AppLocal.TRACKING_DELETED_LINES_ORDER = this.getBooleanProperty("tracking.deleted.lines.order");
        AppLocal.ADD_DELIVERY_DATE = this.getBooleanProperty("add.delivery.date");
        AppLocal.TABLETTO_ORDERS_ENABLED = this.getBooleanAndDefaultProperty("tabletto.orders.enabled");
        AppLocal.BORNE_ORDERS_ENABLED = this.getBooleanAndDefaultProperty("borne.orders.enabled");
        AppLocal.AT_SPOT_ORDERS_ENABLED = this.getBooleanAndDefaultProperty("at.spot.orders.enabled");
        AppLocal.TAKE_AWAY_ORDERS_ENABLED = this.getBooleanAndDefaultProperty("take.away.orders.enabled");
        AppLocal.DELIVERY_ORDERS_ENABLED = this.getBooleanAndDefaultProperty("delivery.orders.enabled");
        AppLocal.CHECK_INTERNET = this.getBooleanProperty("check.internet");
        AppLocal.IMAGE_VALID_ORDER_COUNTER = this.getProperty("background.valid.borne.order");
        AppLocal.COLOR_FLESHE_PRODUCTS = this.getStringPropertyWithDefaultValue("color.fleche.products", "Noir");
        AppLocal.DRIVE_ORDERS_ENABLED = this.getBooleanAndDefaultProperty("drive.orders.enabled");
        AppLocal.MODULE_DRIVE = this.getBooleanProperty("module.drive");
        AppLocal.MODE_TWINT = this.getBooleanAndDefaultProperty("payment.twint");
        AppLocal.PREFIX_PHONE = this.getStringPropertyWithDefaultValue("prefix.phone", "33");
        AppLocal.APPLY_UBER_RATE = this.getBooleanAndDefaultProperty("apply.uber.rate");
        AppLocal.SHOW_NAME_GROUPE_OPTION_IN_TCIKET = this.getBooleanProperty("show.gOption.ticket.kitchen");
        AppLocal.FRANCHISE_ID = this.getProperty("franchise.id");
        AppLocal.MODE_FRANCHISE = this.getBooleanProperty("mode.franchise");
        AppLocal.CUSTOMER_LOYALTY = this.getBooleanProperty("customer.loyalty");
        AppLocal.IMAGE_LOYALTY = this.getProperty("image.loyalty");
        AppLocal.AUTO_ACCEPT_ONLINE_ORDER = this.getBooleanProperty("auto.accept.online.order");
        AppLocal.VERSION_CANADA = this.getBooleanProperty("version.canada");
        AppLocal.APP_LANGUAGE_DEFAULT = this.getStringPropertyWithDefaultValue("app.language", "fr");
        System.out.println("+++++++++++++++++ APP_LANGUAGE appConfig " + AppLocal.APP_LANGUAGE + "        date " + new Date());
        AppLocal.loadLanguages();
        AppLocal.KITCHEN_TICKET_BY_PRODUCT = this.getBooleanProperty("kitchen.ticket.by.product");
        AppLocal.BLACK_BACKGROUND_NUM_ORDER = this.getBooleanProperty("black.background.num.order");
        AppLocal.UBER_DEV_MODE = this.getBooleanProperty("uber.dev.mode");
        AppLocal.APP_LANGUAGE = this.getStringPropertyWithDefaultValue("app.language", "fr");
        AppLocal.APP_LANGUAGE_DEFAULT = this.getStringPropertyWithDefaultValue("app.language", "fr");
        this.setCodeLanguage();
        AppLocal.OPENING_MODE = this.getBooleanProperty("opening.mode");
        AppLocal.KITCHEN_TICKET_BY_PRODUCT = this.getBooleanProperty("kitchen.ticket.by.product");
        AppLocal.BLACK_BACKGROUND_NUM_ORDER = this.getBooleanProperty("black.background.num.order");
        AppLocal.UBER_DEV_MODE = this.getBooleanProperty("uber.dev.mode");
        AppLocal.MODE_CHEQUE_VACANCES = this.getBooleanAndDefaultProperty("payment.cheque.vacances");
        String archivDirectoryString = (AppLocal.IS_APP_PORTABLE != false ? Paths.get(".", new String[0]).toAbsolutePath().normalize().toString() : SystemUtils.SYS_USER_HOME) + File.separator + "procaisse-properties";
        AppLocal.EMPLACEMENT_ARCHIVE = this.getStringPropertyWithDefaultValue("emplacement.archive", archivDirectoryString);
        AppLocal.CUSTOMER_LOYALTY_ID = this.getStringPropertyWithDefaultValue("customer.loyalty.id", AppLocal.FRANCHISE_ID);
        AppLocal.PRODUCT_KITCHEN_BOLD = this.getBooleanProperty("product.kitchen.bold");
        AppLocal.PROMO_CODE_BORNE = this.getBooleanAndDefaultProperty("promo.code.borne");
        AppLocal.PRINT_LABEL_PRODUCT_WITH_EXCLUDED_INFREDIENT = this.getBooleanProperty("print.product.with.excluded.ingredients");
        AppLocal.ADD_TARIFF = this.getBooleanProperty("add.tarif");
        String name_tarif = this.getStringPropertyWithDefaultValue("tariff", "Tarif 1");
        HashMap<String, Integer> mapTariff = new HashMap<String, Integer>();
        mapTariff.put("Tarif 1", 1);
        mapTariff.put("Tarif 2", 2);
        mapTariff.put("Tarif 3", 3);
        AppLocal.TARIFF = mapTariff.get(name_tarif) != null ? (Integer)mapTariff.get(name_tarif) : 1;
        System.out.println("++++++++  AppLocal.TARIFF : " + AppLocal.TARIFF);
        AppLocal.CLICK_COLLECT_V3 = this.getBooleanProperty("click.collect.v3");
        AppLocal.HIDE_DESCRIPTION_PRODUCT_IN_TICKET = this.getBooleanProperty("hide.description.product.in.ticket");
        AppLocal.MODULE_DELIVERY = this.getBooleanProperty("module.delivery");
        AppLocal.HIDE_ORDERS = this.getBooleanAndDefaultProperty("hide.orders");
        AppLocal.HIDE_BACKGROUND_CAGNOTTE = this.getBooleanProperty("hide.background.cagnotte");
        AppLocal.TEXT_COLOR_CATEGORIES = this.getStringPropertyWithDefaultValue("text.color.categories", AppLocal.TEXT_COLOR_ITEMS);
        AppLocal.OTTER_DEV_MODE = this.getBooleanProperty("otter.dev.mode");
        AppLocal.MODULE_OTTER = this.getBooleanProperty("module.otter");
        AppLocal.MODULE_RUSHOUR = this.getBooleanProperty("module.rushour");
        AppLocal.BACKGROUND_TAGS_BORNE = this.getProperty("background.tags.borne");
        AppLocal.SHOW_TAGS_IN_BORNE = this.getBooleanProperty("show.tags.in.borne");
        AppLocal.NEPTING_AUTOMATE = this.getBooleanProperty("nepting.automate");
        AppLocal.MODE_DEV_NEPTING = this.getBooleanProperty("mode.dev.nepting");
        AppLocal.TERMINAL_TYPE_NEPTING = this.getStringPropertyWithDefaultValue("terminal.type.nepting", "attended");
        AppLocal.USE_TPE_IN_UPDATE_PAYMENT = this.getBooleanAndDefaultProperty("use.tpe.in.update.payment");
        AppLocal.AUTO_ACCEPT_OTTER_ORDER = this.getBooleanProperty("auto.accept.otter.order");
        AppLocal.AUTO_ACCEPT_RUSHOUR_ORDER = this.getBooleanProperty("auto.accept.rushour.order");
        AppLocal.ADD_EASEL_NUMBER = this.getBooleanProperty("add.easel.number");
        AppLocal.RESEACH_UBER_PRODUCT_BY_NAME = this.getBooleanProperty("research.uber.product.by.name");
        AppLocal.DELIVEROO_DEV_MODE = this.getBooleanProperty("deliveroo.dev.mode");
        AppLocal.CALL_CUSTOMER_BY_SMS = this.getBooleanProperty("call.customer.by.sms");
        AppLocal.SMS_PREFIX = this.getStringPropertyWithDefaultValue("api.sms.prefix", "33");
        AppLocal.MODULE_MEV = this.getBooleanProperty("module.mev");
        AppLocal.ADDRESS_IP_MEV = this.getStringProperty("address.ip.mev");
        AppLocal.CLICK_COLLECT_V5 = this.getBooleanProperty("click.collect.v5");
        AppLocal.MODULE_DISHOP = this.getBooleanProperty("module.dishop");
        AppLocal.AUTO_PRINT_DISHOP = this.getBooleanProperty("auto.print.dishop");
        AppLocal.DISHOP_PRINTER = this.getIntegerPropertyWithDefaultValue("dishop.printer", 1);
        AppLocal.DISABLE_PENDING_ORDERS = this.getBooleanProperty("disable.pending.orders");
        AppLocal.LABEL_SIZE_FIRST = this.getBooleanProperty("label.size.first");
        AppLocal.SIEGE_SIRET = this.getStringPropertyWithDefaultValue("siret.siege", "");
        AppLocal.AUTO_ACCEPT_DELIVEROO_ORDERS = this.getBooleanProperty("auto.accept.deliveroo.order");
        AppLocal.HIDE_TAGS_IN_CATALOG = this.getBooleanProperty("hide.tags.in.catolog");
        AppLocal.HIDE_TOTAL_BORNE_CB = this.getBooleanProperty("hide.total.borne.cb");
        AppLocal.ORDER_TAKE_AWAY_PHONE = this.getBooleanProperty("order.take.away.phone");
        AppLocal.UPPERCASE_KITCHEN_TICKET = this.getBooleanAndDefaultProperty("upper.case.kitchen.ticket");
        AppLocal.CASHLOGY_ENABLED = this.getProperty("module.cashlogy") != null && "yes".equals(this.getProperty("module.cashlogy"));
        AppLocal.MODULE_CASHLOGY_LOGIN = this.getStringPropertyWithDefaultValue("module.cashlogy.login", "");
        AppLocal.MODULE_CASHLOGY_PASSWORD = this.getStringPropertyWithDefaultValue("module.cashlogy.password", "");
        AppLocal.PRINTING_DUAL_SCREEN = this.getStringPropertyWithDefaultValue("cashlogy.print.dual.screen", "0");
        AppLocal.X_POSITION_DUAL_SCREEN = this.getStringPropertyWithDefaultValue("cashlogy.position.x", "0");
        AppLocal.Y_POSITION_DUAL_SCREEN = this.getStringPropertyWithDefaultValue("cashlogy.position.y", "0");
        AppLocal.DISPLAY_ACCEPT_ICON = this.getStringPropertyWithDefaultValue("display.accept.icon.cashlogy", "0");
        AppLocal.PARTIAL_ENCAISSE_ACCEPTED = this.getStringPropertyWithDefaultValue("cashlogy.accept.encaisse.partial", "0");
        AppLocal.SCREEN_IN_FRONT = this.getStringPropertyWithDefaultValue("cashlogy.screen.infront", "0");
        AppLocal.DISPLAY_CENTIMES_WINDOWS = this.getStringPropertyWithDefaultValue("cashlogy.display.centimes.windows", "0");
        AppLocal.DISPLAY_ENCAISSE_BUTTON = this.getStringPropertyWithDefaultValue("cashlogy.display.encaisse.icon", "0");
        AppLocal.MODULE_CASHLOGY_IP = this.getStringPropertyWithDefaultValue("module.cashlogy.ip", "localhost");
        AppLocal.MAP_SIZE_DESCRIPTIONS = new HashMap();
        AppLocal.MAP_SIZE_DESCRIPTIONS.put("junior", AppLocal.PRODUCT_SIZE1_DESCRIPTION);
        AppLocal.MAP_SIZE_DESCRIPTIONS.put("senior", AppLocal.PRODUCT_SIZE2_DESCRIPTION);
        AppLocal.MAP_SIZE_DESCRIPTIONS.put("mega", AppLocal.PRODUCT_SIZE3_DESCRIPTION);
        AppLocal.MAP_SIZE_DESCRIPTIONS.put("size1", AppLocal.PRODUCT_SIZE4_DESCRIPTION);
        AppLocal.MAP_SIZE_DESCRIPTIONS.put("size2", AppLocal.PRODUCT_SIZE5_DESCRIPTION);
        AppLocal.MAP_SIZE_DESCRIPTIONS.put("size3", AppLocal.PRODUCT_SIZE6_DESCRIPTION);
        AppLocal.MAP_SIZE_DESCRIPTIONS.put("size4", AppLocal.PRODUCT_SIZE7_DESCRIPTION);
        AppLocal.MAP_SIZE_DESCRIPTIONS.put("size5", AppLocal.PRODUCT_SIZE8_DESCRIPTION);
        AppLocal.MAP_SIZE_DESCRIPTIONS.put("size6", AppLocal.PRODUCT_SIZE9_DESCRIPTION);
        AppLocal.MAP_SIZE_DESCRIPTIONS.put("size7", AppLocal.PRODUCT_SIZE10_DESCRIPTION);
        AppLocal.MAP_LABEL_SIZE = new HashMap();
        AppLocal.MAP_LABEL_SIZE.put("junior", AppLocal.PRODUCT_SIZE_JUNIOR);
        AppLocal.MAP_LABEL_SIZE.put("senior", AppLocal.PRODUCT_SIZE_SENIOR);
        AppLocal.MAP_LABEL_SIZE.put("mega", AppLocal.PRODUCT_SIZE_MEGA);
        AppLocal.MAP_LABEL_SIZE.put("size1", AppLocal.PRODUCT_SIZE1);
        AppLocal.MAP_LABEL_SIZE.put("size2", AppLocal.PRODUCT_SIZE2);
        AppLocal.MAP_LABEL_SIZE.put("size3", AppLocal.PRODUCT_SIZE3);
        AppLocal.MAP_LABEL_SIZE.put("size4", AppLocal.PRODUCT_SIZE4);
        AppLocal.MAP_LABEL_SIZE.put("size5", AppLocal.PRODUCT_SIZE5);
        AppLocal.MAP_LABEL_SIZE.put("size6", AppLocal.PRODUCT_SIZE6);
        AppLocal.MAP_LABEL_SIZE.put("size7", AppLocal.PRODUCT_SIZE7);
        AppLocal.GENERATE_ID_GLOBAL_ITEMS = this.getBooleanProperty("generate.id.global.items");
        AppLocal.DISHOP_INTEGRATION = this.getStringPropertyWithDefaultValue("dishop.integration", "dishop light");
        AppLocal.PROMOTION_BY_LINE_ORDER = this.getBooleanProperty("promotion.by.line.order") != false && (AppLocal.modeCaisse == null || AppLocal.modeCaisse.equalsIgnoreCase("Caisse"));
        AppLocal.CONTINUITY_MODE_MEV = this.getBooleanProperty("continuity.mode.mev");
        AppLocal.ADD_TYPE_ORDER_TO_KITCHEN_TICKET_FOOTER = this.getBooleanProperty("add.type.order.to.kitchen.ticket.footer");
        AppLocal.DOWNLOAD_TVA_ITEMS = this.getBooleanAndDefaultProperty("download.tva.items");
        AppLocal.ADD_NEW_LINE_SCREEN = this.getBooleanProperty("add.new.line.screen");
        AppLocal.MEV_PORT = this.getStringPropertyWithDefaultValue("mev.port", "COM1");
        AppLocal.MEV_TYPE_CONNECTION = this.getStringPropertyWithDefaultValue("mev.type.connection", "tcp_ip_connection");
        AppLocal.MODULE_CLOVER = this.getBooleanProperty("module.clover");
        AppLocal.CONNECT_CASH_DRAWER = this.getBooleanProperty("connect.cash.drawer");
        AppLocal.DRAWER_PORT = this.getStringPropertyWithDefaultValue("drawer.port", "COM1");
        AppLocal.CLOVER_DEV_MODE = this.getBooleanProperty("clover.dev.mode");
        AppLocal.ID_MERCHANT_CLOVER = this.getStringProperty("id.merchant.clover");
        AppLocal.MEV_TPS = this.getStringProperty("mev.tps");
        AppLocal.MEV_TVQ = this.getStringProperty("mev.tvq");
        AppLocal.DELEGATE_PRINT_TICKET_MEV = this.getBooleanProperty("delegate.print.ticket.mev");
        AppLocal.LOGO_DELIVEROO = this.getProperty("logo.deliveroo");
        AppLocal.BACKGROUND_AT_SPOT_EN_ORDER_BORNE = this.getProperty("background.atspot.en.order.borne");
        AppLocal.BACKGROUND_TAKE_AWAY_EN_ORDER_BORNE = this.getProperty("background.takeaway.en.order.borne");
        AppLocal.BACKGROUND_AT_SPOT_ES_ORDER_BORNE = this.getProperty("background.atspot.es.order.borne");
        AppLocal.BACKGROUND_TAKE_AWAY_ES_ORDER_BORNE = this.getProperty("background.takeaway.es.order.borne");
        AppLocal.BACKGROUND_AT_SPOT_AR_ORDER_BORNE = this.getProperty("background.atspot.ar.order.borne");
        AppLocal.BACKGROUND_TAKE_AWAY_AR_ORDER_BORNE = this.getProperty("background.takeaway.ar.order.borne");
        AppLocal.FORMAT_INTEGER = this.getProperty("format.integer");
        AppLocal.FORMAT_CURRENCY = this.getProperty("format.currency");
        String modelSmsByDefault = AppLocal.SEND_SMS ? "NEXMO" : "SMSMODE";
        AppLocal.MODEL_SMS = this.getStringPropertyWithDefaultValue("model.sms", modelSmsByDefault);
        AppLocal.HIDE_BUTTON_CASH_CAISSE = this.getBooleanProperty("hide.button.cash.caisse");
        AppLocal.HIDE_BUTTON_CB_CAISSE = this.getBooleanProperty("hide.button.cb.caisse");
        AppLocal.AUTO_ACCEPT_ONLINE_ORDER_NOT_PAID = this.getBooleanProperty("auto.accept.online.order.not.paid");
        AppLocal.AUTO_ACCEPT_UBEREAT_ORDER = this.getBooleanProperty("accept.ubereat.order");
        AppLocal.SYNCHRO_PARAM_FIREBASE = this.getBooleanProperty("synchro.param.firebase");
        AppLocal.IMAGE_LOYALTY = this.getProperty("image.loyalty");
        AppLocal.MODULE_MULTI_TVA = this.getBooleanProperty("module.multi.tva");
        AppLocal.BACKGROUND_MOMENT_FR = this.getProperty("background.moment.fr.borne");
        AppLocal.BACKGROUND_MOMENT_AR = this.getProperty("background.moment.ar.borne");
        AppLocal.BACKGROUND_MOMENT_EN = this.getProperty("background.moment.en.borne");
        AppLocal.BACKGROUND_MOMENT_ES = this.getProperty("background.moment.es.borne");
        AppLocal.ADD_GROUPED_PRODUCT_TO_PRINTED_RECAP = this.getBooleanProperty("add.grouped.product.to.printed.recap");
        AppLocal.MODULE_TVA_GLOBAL = this.getBooleanProperty("module.tva.global", AppLocal.MODULE_MEV);
        AppLocal.PAYMENT_TYPE_CB_TPE_PORT = this.getStringProperty("payment.cb.tpe.port");
        AppLocal.PRODUCT_MOMENT_ADVANCED = this.getBooleanProperty("product.moment.advanced");
        AppLocal.PRINT_TEXT_DISHOP_IN_TICKETS = this.getBooleanProperty("print.text.dishop.in.tickets");
        AppLocal.FTP_CONFIG_VALUE = this.getBooleanProperty("ftp.account.configured", false);
        AppLocal.COLOR_SELECTED_CATEGORY = this.getStringPropertyWithDefaultValue("color.selected.category", AppLocal.color_borne);
        AppLocal.BG_COLOR_PRICE = this.getStringPropertyWithDefaultValue("bg.color.price", AppLocal.color_borne);
        AppLocal.BG_COLOR_IMAGE_PRODUCT = this.getStringPropertyWithDefaultValue("bg.color.image.product", "255, 255, 255");
        AppLocal.BG_COLOR_TEXT_SUB_CATEGORIES = this.getStringPropertyWithDefaultValue("bg.color.text.sub.categories", AppLocal.BG_COLOR_ITEMS);
        AppLocal.BG_COLOR_IMAGE_SUB_CATEGORIES = this.getStringPropertyWithDefaultValue("bg.color.image.sub.categories", AppLocal.BG_COLOR_IMAGE_PRODUCT);
        AppLocal.TEXT_COLOR_SUB_CATEGORIES = this.getStringPropertyWithDefaultValue("text.color.sub.categories", AppLocal.TEXT_COLOR_ITEMS);
        AppLocal.TEXT_COLOR_TOTAL_ORDER = this.getStringPropertyWithDefaultValue("text.color.total.order", AppLocal.COLOR_TYPE_ORDER);
        AppLocal.BG_COLOR_CODE_PROMO = this.getStringPropertyWithDefaultValue("bg.color.code.promo", "116, 185, 255");
        AppLocal.BG_COLOR_BUTTON_VALIDATION = this.getStringPropertyWithDefaultValue("bg.color.button.validation", "12, 168, 89");
        AppLocal.BG_COLOR_TYPE_PAYMENT = this.getStringPropertyWithDefaultValue("bg.color.type.payment", AppLocal.color_borne);
        AppLocal.ICON_CB = this.getProperty("icon.cb");
        AppLocal.ICON_COUNTER = this.getProperty("icon.counter");
        AppLocal.BG_COLOR_BUTTON_CANCEL = this.getStringPropertyWithDefaultValue("bg.color.button.cancel", "255, 255, 255");
        AppLocal.TEXT_COLOR_BUTTON_CANCEL = this.getStringPropertyWithDefaultValue("text.color.button.cancel", AppLocal.TEXT_COLOR_BORNE);
        AppLocal.ICON_NEXT = this.getProperty("icon.next");
        AppLocal.ICON_PREVIOUS = this.getProperty("icon.previous");
        AppLocal.DOWNLOAD_ONLINE_JSON_ITEMS = this.getBooleanProperty("download.online.json.items");
        AppLocal.HIDE_BACKGROUND_NAME_PRODUCTS = this.getBooleanProperty("hide.background.name.products", AppLocal.HIDE_BACKGROUND_PRODUCTS);
        AppLocal.HIDE_BACKGROUND_IMAGE_SUB_CATEGORIES = this.getBooleanProperty("hide.background.image.sub.categories", AppLocal.HIDE_BACKGROUND_PRODUCTS);
        AppLocal.HIDE_BACKGROUND_NAME_SUB_CATEGORIES = this.getBooleanProperty("hide.background.name.sub.categories", AppLocal.HIDE_BACKGROUND_PRODUCTS);
        AppLocal.BACKGROUND_TYPE_PAYMENT_FR = this.getProperty("background.type.payment.fr");
        AppLocal.BACKGROUND_TYPE_PAYMENT_AR = this.getProperty("background.type.payment.ar");
        AppLocal.BACKGROUND_TYPE_PAYMENT_EN = this.getProperty("background.type.payment.en");
        AppLocal.BACKGROUND_TYPE_PAYMENT_ES = this.getProperty("background.type.payment.es");
        AppLocal.CATALOG_BACKGROUND_FR = this.getProperty("catalog.background.fr");
        AppLocal.CATALOG_BACKGROUND_AR = this.getProperty("catalog.background.ar");
        AppLocal.CATALOG_BACKGROUND_EN = this.getProperty("catalog.background.en");
        AppLocal.CATALOG_BACKGROUND_ES = this.getProperty("catalog.background.es");
        AppLocal.IMAGE_INSERT_CARD = this.getProperty("image.insert.card");
        AppLocal.IMAGE_INSERT_CARD_FR = this.getProperty("image.insert.card.fr");
        AppLocal.IMAGE_INSERT_CARD_AR = this.getProperty("image.insert.card.ar");
        AppLocal.IMAGE_INSERT_CARD_EN = this.getProperty("image.insert.card.en");
        AppLocal.IMAGE_INSERT_CARD_ES = this.getProperty("image.insert.card.es");
        AppLocal.IMAGE_VALID_ORDER_COUNTER_FR = this.getProperty("image.valid.order.counter.fr");
        AppLocal.IMAGE_VALID_ORDER_COUNTER_AR = this.getProperty("image.valid.order.counter.ar");
        AppLocal.IMAGE_VALID_ORDER_COUNTER_EN = this.getProperty("image.valid.order.counter.en");
        AppLocal.IMAGE_VALID_ORDER_COUNTER_ES = this.getProperty("image.valid.order.counter.es");
        AppLocal.IMAGE_VALID_ORDER_CB = this.getProperty("image.valid.order.cb");
        AppLocal.IMAGE_VALID_ORDER_CB_FR = this.getProperty("image.valid.order.cb.fr");
        AppLocal.IMAGE_VALID_ORDER_CB_AR = this.getProperty("image.valid.order.cb.ar");
        AppLocal.IMAGE_VALID_ORDER_CB_EN = this.getProperty("image.valid.order.cb.en");
        AppLocal.IMAGE_VALID_ORDER_CB_ES = this.getProperty("image.valid.order.cb.es");
        AppLocal.IMAGE_VALID_ORDER_CB_ES = this.getProperty("image.valid.order.cb.es");
        AppLocal.SIZE_TEXT_NUMBER_ORDER_CB = this.getIntegerPropertyWithDefaultValue("size.text.number.order.cb", 80);
        AppLocal.COLOR_TEXT_NUMBER_ORDER_CB = this.getStringPropertyWithDefaultValue("color.text.number.order.cb", "0, 0, 0");
        AppLocal.BACKGROUND_SELF_CHECKOUT = this.getProperty("background.self.checkout");
        AppLocal.PRINT_RECAP_TYPE_ITEMS = this.getStringPropertyWithDefaultValue("print.recap.type.items", "all_products");
        AppLocal.PRINT_RECAP_STANDALONE = this.getBooleanProperty("print.recap.standalone");
        AppLocal.PRINT_ARABIC = this.getBooleanProperty("print.arabic");
        AppLocal.PRINT_ENCODING = this.getStringPropertyWithDefaultValue("print.encoding", "iso-8859-6");
        AppLocal.PRINT_CODE_PAGE = this.getIntegerPropertyWithDefaultValue("print.code.page", 63);
        AppLocal.PRINT_RTL = this.getBooleanProperty("print.rtl");
        AppLocal.CMI_TPE_PAYMENT = this.getProperty("payment.cb.tpe.protocol").equals("Cmi");
        AppLocal.POS_DEFAULT_PAYMENT = this.getStringPropertyWithDefaultValue("pos.default.payment", "Espece");
        AppLocal.DEACTIVE_POP_UP_OPTIONS = this.getBooleanProperty("deactive.pop.up.options");
        AppLocal.ADD_CUSTOMER_INFO_TO_TICKET = this.getBooleanProperty("add.customer.info.to.ticket");
        AppLocal.PRINT_TICKET_PENDING = this.getBooleanProperty("pending.ticket");
        AppLocal.PRINT_CANCELED_ORDERS_ON_Z = this.getBooleanAndDefaultProperty("print.canceled.orders.on.z");
        AppLocal.PRINT_LOG_PANIER_ON_Z = this.getBooleanAndDefaultProperty("print.log.panier.on.z");
        AppLocal.PRINT_Z_BORNE_ON_TRACKING_ORDERS_POS = this.getBooleanAndDefaultProperty("print.z.borne.on.tracking.ordetrs.pos");
        AppLocal.PRODUCT_SIZE1_QUANTITY = this.getProperty("product.size1.quantity");
        AppLocal.PRODUCT_SIZE2_QUANTITY = this.getProperty("product.size2.quantity");
        AppLocal.PRODUCT_SIZE3_QUANTITY = this.getProperty("product.size3.quantity");
        AppLocal.PRODUCT_SIZE4_QUANTITY = this.getProperty("product.size4.quantity");
        AppLocal.PRODUCT_SIZE5_QUANTITY = this.getProperty("product.size5.quantity");
        AppLocal.PRODUCT_SIZE6_QUANTITY = this.getProperty("product.size6.quantity");
        AppLocal.PRODUCT_SIZE7_QUANTITY = this.getProperty("product.size7.quantity");
        AppLocal.PRODUCT_SIZE8_QUANTITY = this.getProperty("product.size8.quantity");
        AppLocal.PRODUCT_SIZE9_QUANTITY = this.getProperty("product.size9.quantity");
        AppLocal.PRODUCT_SIZE10_QUANTITY = this.getProperty("product.size10.quantity");
        AppLocal.MAP_SIZE_QUANTITY = new HashMap();
        AppLocal.MAP_SIZE_QUANTITY.put("junior", AppLocal.PRODUCT_SIZE1_QUANTITY);
        AppLocal.MAP_SIZE_QUANTITY.put("senior", AppLocal.PRODUCT_SIZE2_QUANTITY);
        AppLocal.MAP_SIZE_QUANTITY.put("mega", AppLocal.PRODUCT_SIZE3_QUANTITY);
        AppLocal.MAP_SIZE_QUANTITY.put("size1", AppLocal.PRODUCT_SIZE4_QUANTITY);
        AppLocal.MAP_SIZE_QUANTITY.put("size2", AppLocal.PRODUCT_SIZE5_QUANTITY);
        AppLocal.MAP_SIZE_QUANTITY.put("size3", AppLocal.PRODUCT_SIZE6_QUANTITY);
        AppLocal.MAP_SIZE_QUANTITY.put("size4", AppLocal.PRODUCT_SIZE7_QUANTITY);
        AppLocal.MAP_SIZE_QUANTITY.put("size5", AppLocal.PRODUCT_SIZE8_QUANTITY);
        AppLocal.MAP_SIZE_QUANTITY.put("size6", AppLocal.PRODUCT_SIZE9_QUANTITY);
        AppLocal.MAP_SIZE_QUANTITY.put("size7", AppLocal.PRODUCT_SIZE10_QUANTITY);
        AppLocal.PRINT_DETAIL_CANCELED_ORDERS_ON_Z = this.getBooleanAndDefaultProperty("print.detail.canceled.orders.on.z");
        AppLocal.ADD_NAME_CUSTOMER_AFTER_ORDER_BORNE = this.getBooleanProperty("add.name.customer.after.order.borne");
        AppLocal.TAG_1 = this.getBooleanProperty("tag.1");
        AppLocal.TAG_2 = this.getBooleanProperty("tag.2");
        AppLocal.LIMIT_TAGS_TO_SHOW = this.getBooleanProperty("limit.tags.to.show");
        String textNumbers = this.getProperty("tags.to.show");
        AppLocal.TAGS = AppLocal.LIMIT_TAGS_TO_SHOW ? StringUtils.getListIntegerFromString(textNumbers, ",") : null;
        AppLocal.MODE_BANK_TRANSFER = this.getBooleanProperty("payment.bank.transfer");
        AppLocal.MODE_CB_TR = this.getBooleanProperty("payment.carte.ticket.resto");
        AppLocal.CHOOSE_RESTITUTION_TYPE = this.getBooleanAndDefaultProperty("choose.restitution.type");
        AppLocal.ADD_INFOS_ORDER_TO_KITCHEN_TICKET_FOOTER = this.getBooleanProperty("add.infos.order.to.kitchen.ticket.footer");
        AppLocal.SCAN_MORE_THAN_KIOSK_ORDER = this.getBooleanProperty("scan.more.than.kiosk.order");
        AppLocal.USE_NEW_POP_UP_OPTIONS = this.getBooleanProperty("use.new.pop.up.options");
        AppLocal.SHOW_POP_UP_CHOOSE_DESIGN_OPTIONS = this.getBooleanAndDefaultProperty("show.pop.up.choose.design.options");
        AppLocal.BORNE_IN_MAINTENANCE = this.getBooleanProperty("borne.in.maintenance");
        AppLocal.MODULE_AVOMARK = this.getBooleanProperty("module.avomark");
        AppLocal.ADD_GROUPED_PRODUCT_BY_ZONE_TO_PRINTED_RECAP = this.getBooleanProperty("add.grouped.products.by.zone.ticket.recap");
        AppLocal.ADD_GROUPED_PRODUCT_BY_ZONE_TO_KITCHEN_TICKET = this.getBooleanProperty("add.grouped.products.by.zone.kitchen.ticket");
        AppLocal.ADD_GROUPED_PRODUCT_BY_ZONE_TO_LABEL = this.getBooleanProperty("add.grouped.products.by.zone.to.label");
        AppLocal.show_nutri_values = this.getBooleanProperty("show.nutri_values");
        AppLocal.show_allergens = this.getBooleanProperty("show.allergens");
        AppLocal.BACKGROUND_ITEMS_LATER = this.getProperty("background.items.later");
        AppLocal.ALLOW_CASH_ONLY_SELF_CHECKOUT = this.getBooleanProperty("allow.cash.only.self.checkout");
        AppLocal.SHOW_ONSEAT_BORNE_WITH_CLOSE_OVERLAY = this.getBooleanProperty("borne.show.onseat.with.close.label");
        AppLocal.SEND_MONTHLY_REPORT = this.getBooleanProperty("send.monthly.report");
        AppLocal.AUTO_CUTTER_TICKET = this.getBooleanAndDefaultProperty("auto.cutter.ticket");
        AppLocal.PRINT_TICKET_UBER_EATS = this.getBooleanAndDefaultProperty("print.ticket.uber.eats");
        AppLocal.PRINT_TICKET_DELIVEROO = this.getBooleanAndDefaultProperty("print.ticket.deliveroo");
        AppLocal.HIDE_DRIVE_SCREEN_VOICE_MESSAGE_PANE = this.getBooleanProperty("hide.drive.screen.voice.message");
        AppLocal.DRIVE_BASKET_BANNER_IMG = this.getStringPropertyWithDefaultValue("drive.basket.banner.img", null);
        AppLocal.BIP_ONSITE = this.getBooleanProperty("bip.onsite", this.getBooleanProperty("mandatory.bip"));
        AppLocal.BIP_TAKEAWAY = this.getBooleanProperty("bip.takeaway", this.getBooleanProperty("mandatory.bip"));
        AppLocal.HIDE_BUTTON_COMPTOIRE = this.getBooleanProperty("hide.button.comptoire");
        AppLocal.PRINT_UPDATED_RECAP_TICKET = this.getBooleanProperty("print.updated.recap.ticket");
        AppLocal.SHOW_DRIVE_BASKET_ONLY_BY_CLICK = this.getBooleanProperty("show.drive.basket.only.by.click");
        AppLocal.BIP_TAKEAWAY_PHONE = this.getBooleanProperty("bip.takeaway.phone", this.getBooleanProperty("mandatory.bip"));
        AppLocal.MODULE_NIGHT_TARIFF = this.getBooleanProperty("module.night.tariff");
        AppLocal.HOUR_START_NIGHT_TARIFF = this.getProperty("hour.start.night.tariff");
        AppLocal.HOUR_END_NIGHT_TARIFF = this.getProperty("hour.end.night.tariff");
        AppLocal.PERCENTAGE_NIGHT_TARIFF = this.getIntegerProperty("percentage.night.tariff");
        AppLocal.COLOR_BANNER_PROMO = this.getStringPropertyWithDefaultValue("color.banner.promo", "Vert");
        AppLocal.PRINT_TOTAL_ON_KIOSK_QR_TICKET = this.getBooleanProperty("print.total.on.kiosk.qr.ticket");
    }

    public Integer getIntegerProperty(String key) {
        String value = this.getProperty(key);
        return value == null || value.isEmpty() ? 0 : Integer.parseInt(value);
    }

    public Integer getIntegerProperty(String key, int default_value) {
        String value = this.getProperty(key);
        return value == null || value.isEmpty() ? default_value : Integer.parseInt(value);
    }

    public Integer getIntegerPropertyWithDefaultValue(String key, int defaultValue) {
        String value = this.getProperty(key);
        if (value == null || value.isEmpty()) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    public Boolean getBooleanProperty(String key) {
        String value = this.getProperty(key);
        return value == null || value.isEmpty() || !value.equalsIgnoreCase("yes") ? Boolean.FALSE : Boolean.TRUE;
    }

    public Boolean getBooleanAndDefaultProperty(String key) {
        String value = this.getProperty(key);
        return value == null || value.isEmpty() || value.equalsIgnoreCase("yes") ? Boolean.TRUE : Boolean.FALSE;
    }

    public String getStringProperty(String key) {
        return this.getStringPropertyWithDefaultValue(key, "");
    }

    public String getStringPropertyWithDefaultValue(String key, String defaultValue) {
        String value = this.getProperty(key);
        return value == null || value.isEmpty() ? defaultValue : value;
    }

    public void setConfigProperties(Properties configProperties) {
        this.configProperties = configProperties;
    }

    public Double getDoubleProperty(String key, double default_value) {
        String value = this.getProperty(key);
        return value == null || value.isEmpty() ? default_value : Double.parseDouble(value);
    }

    public Boolean getBooleanProperty(String key, boolean defaultValue) {
        String value = this.getProperty(key);
        return value == null || value.isEmpty() ? defaultValue : (!value.equalsIgnoreCase("yes") ? Boolean.FALSE : Boolean.TRUE);
    }

    public Double getDoublePropertyWithDefaultValue(String key, double defaultValue) {
        String value = this.getProperty(key);
        return value == null || value.isEmpty() ? defaultValue : Double.parseDouble(value);
    }

    public void initInfoPromoBasket() {
        AppLocal.PROMO_BASKET = this.getBooleanProperty("promo.basket");
        AppLocal.MIN_PRICE_ORDER_PROMO_BASKET = this.getDoublePropertyWithDefaultValue("min.price.order.promo.basket", 20.0);
        AppLocal.PRICE_PROMO_BASKET = this.getDoublePropertyWithDefaultValue("price.promo.basket", 1.0);
        AppLocal.MIN_PRICE_ORDER_PROMO_BASKET_TEXT = this.getProperty("min.price.order.promo.basket");
    }

    public void initInfoProductSize() {
        AppLocal.PRODUCT_SIZE_JUNIOR = this.getStringPropertyWithDefaultValue("product.size.junior", "junior");
        AppLocal.PRODUCT_SIZE_SENIOR = this.getStringPropertyWithDefaultValue("product.size.senior", "senior");
        AppLocal.PRODUCT_SIZE_MEGA = this.getStringPropertyWithDefaultValue("product.size.mega", "mega");
        AppLocal.PRODUCT_SIZE1 = this.getProperty("product.size1");
        AppLocal.PRODUCT_SIZE2 = this.getProperty("product.size2");
        AppLocal.PRODUCT_SIZE3 = this.getProperty("product.size3");
        AppLocal.PRODUCT_SIZE4 = this.getProperty("product.size4");
        AppLocal.PRODUCT_SIZE5 = this.getProperty("product.size5");
        AppLocal.PRODUCT_SIZE6 = this.getProperty("product.size6");
        AppLocal.PRODUCT_SIZE7 = this.getProperty("product.size7");
        AppLocal.PRODUCT_SIZE_JUNIOR_ENABLED = this.getBooleanAndDefaultProperty("product.junior.enabled");
        AppLocal.PRODUCT_SIZE_SENIOR_ENABLED = this.getBooleanAndDefaultProperty("product.senior.enabled");
        AppLocal.PRODUCT_SIZE_MEGA_ENABLED = this.getBooleanAndDefaultProperty("product.mega.enabled");
        AppLocal.PRODUCT_SIZE1_ENABLED = this.getBooleanAndDefaultProperty("product.size1.enabled");
        AppLocal.PRODUCT_SIZE2_ENABLED = this.getBooleanAndDefaultProperty("product.size2.enabled");
        AppLocal.PRODUCT_SIZE3_ENABLED = this.getBooleanAndDefaultProperty("product.size3.enabled");
        AppLocal.PRODUCT_SIZE4_ENABLED = this.getBooleanAndDefaultProperty("product.size4.enabled");
        AppLocal.PRODUCT_SIZE5_ENABLED = this.getBooleanAndDefaultProperty("product.size5.enabled");
        AppLocal.PRODUCT_SIZE6_ENABLED = this.getBooleanAndDefaultProperty("product.size6.enabled");
        AppLocal.PRODUCT_SIZE7_ENABLED = this.getBooleanAndDefaultProperty("product.size7.enabled");
        AppLocal.PRODUCT_SIZE1_DESCRIPTION = this.getProperty("product.size1.description");
        AppLocal.PRODUCT_SIZE2_DESCRIPTION = this.getProperty("product.size2.description");
        AppLocal.PRODUCT_SIZE3_DESCRIPTION = this.getProperty("product.size3.description");
        AppLocal.PRODUCT_SIZE4_DESCRIPTION = this.getProperty("product.size4.description");
        AppLocal.PRODUCT_SIZE5_DESCRIPTION = this.getProperty("product.size5.description");
        AppLocal.PRODUCT_SIZE6_DESCRIPTION = this.getProperty("product.size6.description");
        AppLocal.PRODUCT_SIZE7_DESCRIPTION = this.getProperty("product.size7.description");
        AppLocal.PRODUCT_SIZE8_DESCRIPTION = this.getProperty("product.size8.description");
        AppLocal.PRODUCT_SIZE9_DESCRIPTION = this.getProperty("product.size9.description");
        AppLocal.PRODUCT_SIZE10_DESCRIPTION = this.getProperty("product.size10.description");
    }

    public void setPropertyPaymentBorne(boolean payment_enabled) {
        this.configProperties.setProperty("payment.borne", payment_enabled ? "yes" : "no");
        AppLocal.PAYMENT_BORNE = this.getBooleanAndDefaultProperty("payment.borne");
        System.out.println("AppLocal.PAYMENT_BORNE : " + AppLocal.PAYMENT_BORNE);
        this.save();
    }

    public void setPropertyOnseatOrder(boolean enabled) {
        this.configProperties.setProperty("only.take.away.borne", enabled ? "no" : "yes");
        AppLocal.ONLY_TAKE_AWAY_BORNE = this.getBooleanAndDefaultProperty("only.take.away.borne");
        System.out.println("AppLocal.ONLY_TAKE_AWAY_BORNE : " + AppLocal.ONLY_TAKE_AWAY_BORNE);
        this.save();
    }

    public void setPropertyInMaintenance(boolean activated) {
        this.configProperties.setProperty("borne.in.maintenance", activated ? "yes" : "no");
        AppLocal.BORNE_IN_MAINTENANCE = this.getBooleanAndDefaultProperty("borne.in.maintenance");
        System.out.println("AppLocal.BORNE_IN_MAINTENANCE : " + AppLocal.BORNE_IN_MAINTENANCE);
        this.save();
    }

    public void initInfoSettingBorne() {
        AppLocal.CATALOG_BACKGROUND = this.getProperty("catalog.background");
        AppLocal.BACKGROUND_SUMMARY_ORDER = this.getProperty("background.summary.order.borne");
        AppLocal.BACKGROUND_TYPE_ORDER_BORNE = this.getProperty("background.type.order.borne");
        AppLocal.BACKGROUND_AT_SPOT_ORDER_BORNE = this.getProperty("background.atspot.order.borne");
        AppLocal.BACKGROUND_AT_SPOT_AR_ORDER_BORNE = this.getProperty("background.atspot.ar.order.borne");
        AppLocal.BACKGROUND_AT_SPOT_EN_ORDER_BORNE = this.getProperty("background.atspot.en.order.borne");
        AppLocal.BACKGROUND_AT_SPOT_ES_ORDER_BORNE = this.getProperty("background.atspot.es.order.borne");
        AppLocal.BACKGROUND_TAKE_AWAY_ORDER_BORNE = this.getProperty("background.takeaway.order.borne");
        AppLocal.BACKGROUND_TAKE_AWAY_AR_ORDER_BORNE = this.getProperty("background.takeaway.ar.order.borne");
        AppLocal.BACKGROUND_TAKE_AWAY_EN_ORDER_BORNE = this.getProperty("background.takeaway.en.order.borne");
        AppLocal.BACKGROUND_TAKE_AWAY_ES_ORDER_BORNE = this.getProperty("background.takeaway.es.order.borne");
        AppLocal.VIDEO_BORNE = this.getProperty("video.borne");
        AppLocal.TYPE_MEDIA_HOME = this.getProperty("type.media.home");
        AppLocal.LOGO_BORNE = this.getProperty("logo.borne");
        AppLocal.color_borne = this.getStringProperty("color.borne");
        AppLocal.TEXT_COLOR_BORNE = this.getStringPropertyWithDefaultValue("fond.color.borne", "0, 0, 0");
        AppLocal.TEXT_COLOR_BASKET = this.getStringPropertyWithDefaultValue("text.color.basket", AppLocal.TEXT_COLOR_BORNE);
        AppLocal.TEXT_COLOR_PRICE = this.getStringPropertyWithDefaultValue("text.color.price", AppLocal.TEXT_COLOR_BORNE);
        Color lightColor = ColorUtils.ColorLuminance(ColorUtils.getColorByString(StringUtils.isEmpty(AppLocal.color_borne) ? "0,0,255" : AppLocal.color_borne));
        AppLocal.color_light_borne = this.getStringPropertyWithDefaultValue("color_light.borne", ColorUtils.getColorText(lightColor));
        AppLocal.TEXT_COLOR_NAME_CATEGORY = this.getStringPropertyWithDefaultValue("text.color.name.category", AppLocal.TEXT_COLOR_BORNE);
        AppLocal.COLOR_TYPE_ORDER = this.getStringPropertyWithDefaultValue("color.type.order", AppLocal.TEXT_COLOR_BORNE);
        AppLocal.TEXT_COLOR_ITEMS = this.getStringPropertyWithDefaultValue("text.color.items", "0, 0, 0");
        AppLocal.BG_COLOR_ITEMS = this.getStringPropertyWithDefaultValue("bg.color.items", AppLocal.color_borne);
        AppLocal.HIDE_NAME_CATEGORIES = this.getBooleanProperty("hide.name.categories");
        AppLocal.POSITION_PRICE = this.getProperty("position.price");
        AppLocal.DIMENSION_FIXED = this.getStringPropertyWithDefaultValue("dimension.fixed", "largeur");
        AppLocal.HIDE_NAME_CATEGORIES = this.getBooleanProperty("hide.name.categories");
        AppLocal.HIDE_NAME_SUB_CATEGORIES = this.getBooleanProperty("hide.name.sub.categories");
        AppLocal.HIDE_NAME_PRODUCTS = this.getBooleanProperty("hide.name.products");
        AppLocal.HIDE_MESSAGE_TYPE_ORDER = this.getBooleanProperty("hide.message.type.order");
        AppLocal.FIRST_INGREDIENTS = this.getBooleanProperty("first.ingredient");
        AppLocal.HIDE_FOOTER_BORNE = this.getBooleanProperty("hide.footer.home");
        AppLocal.LATERAL_BAR = this.getBooleanProperty("lateral.bar");
        AppLocal.type_borne = this.getProperty("type.borne");
        AppLocal.PRINT_DESCRIPTION = this.getBooleanProperty("print.description");
        AppLocal.SHOW_DESCRIPTION = this.getBooleanProperty("show.description");
        AppLocal.HIDE_BACKGROUND_PRODUCTS = this.getBooleanProperty("hide.background.products");
        AppLocal.HIDE_INGREDIENTS_BORNE = this.getBooleanProperty("hide.ingredients.borne");
        AppLocal.HIDE_SUB_PRODUCT_INGREDIENT_BORNE = this.getBooleanProperty("hide.sub.product.ingredients.borne");
        AppLocal.TEXT_COLOR_CATEGORIES = this.getStringPropertyWithDefaultValue("text.color.categories", AppLocal.TEXT_COLOR_ITEMS);
        AppLocal.IMAGES_TYPE_ORDER_TRANSPARENT = this.getBooleanProperty("images.type.order.transparent");
        AppLocal.COLOR_SELECTED_CATEGORY = this.getStringPropertyWithDefaultValue("color.selected.category", AppLocal.color_borne);
        AppLocal.BG_COLOR_PRICE = this.getStringPropertyWithDefaultValue("bg.color.price", AppLocal.color_borne);
        AppLocal.BG_COLOR_IMAGE_PRODUCT = this.getStringPropertyWithDefaultValue("bg.color.image.product", "255, 255, 255");
        AppLocal.BG_COLOR_TEXT_SUB_CATEGORIES = this.getStringPropertyWithDefaultValue("bg.color.text.sub.categories", AppLocal.BG_COLOR_ITEMS);
        AppLocal.BG_COLOR_IMAGE_SUB_CATEGORIES = this.getStringPropertyWithDefaultValue("bg.color.image.sub.categories", AppLocal.BG_COLOR_IMAGE_PRODUCT);
        AppLocal.TEXT_COLOR_SUB_CATEGORIES = this.getStringPropertyWithDefaultValue("text.color.sub.categories", AppLocal.TEXT_COLOR_ITEMS);
        AppLocal.TEXT_COLOR_TOTAL_ORDER = this.getStringPropertyWithDefaultValue("text.color.total.order", AppLocal.COLOR_TYPE_ORDER);
        AppLocal.BG_COLOR_CODE_PROMO = this.getStringPropertyWithDefaultValue("bg.color.code.promo", "116, 185, 255");
        AppLocal.BG_COLOR_BUTTON_VALIDATION = this.getStringPropertyWithDefaultValue("bg.color.button.validation", "12, 168, 89");
        AppLocal.BG_COLOR_TYPE_PAYMENT = this.getStringPropertyWithDefaultValue("bg.color.type.payment", AppLocal.color_borne);
        AppLocal.ICON_CB = this.getProperty("icon.cb");
        AppLocal.ICON_COUNTER = this.getProperty("icon.counter");
        AppLocal.BG_COLOR_BUTTON_CANCEL = this.getStringPropertyWithDefaultValue("bg.color.button.cancel", "255, 255, 255");
        AppLocal.TEXT_COLOR_BUTTON_CANCEL = this.getStringPropertyWithDefaultValue("text.color.button.cancel", AppLocal.TEXT_COLOR_BORNE);
        AppLocal.ICON_NEXT = this.getProperty("icon.next");
        AppLocal.ICON_PREVIOUS = this.getProperty("icon.previous");
        AppLocal.HIDE_BACKGROUND_NAME_PRODUCTS = this.getBooleanProperty("hide.background.name.products", AppLocal.HIDE_BACKGROUND_PRODUCTS);
        AppLocal.HIDE_BACKGROUND_IMAGE_SUB_CATEGORIES = this.getBooleanProperty("hide.background.image.sub.categories", AppLocal.HIDE_BACKGROUND_PRODUCTS);
        AppLocal.HIDE_BACKGROUND_NAME_SUB_CATEGORIES = this.getBooleanProperty("hide.background.name.sub.categories", AppLocal.HIDE_BACKGROUND_PRODUCTS);
        AppLocal.BACKGROUND_MOMENT_FR = this.getProperty("background.moment.fr.borne");
        AppLocal.BACKGROUND_MOMENT_AR = this.getProperty("background.moment.ar.borne");
        AppLocal.BACKGROUND_MOMENT_EN = this.getProperty("background.moment.en.borne");
        AppLocal.BACKGROUND_MOMENT_ES = this.getProperty("background.moment.es.borne");
        AppLocal.PRODUCT_MOMENT_ADVANCED = this.getBooleanProperty("product.moment.advanced");
        AppLocal.BACKGROUND_TYPE_PAYMENT_FR = this.getProperty("background.type.payment.fr");
        AppLocal.BACKGROUND_TYPE_PAYMENT_AR = this.getProperty("background.type.payment.ar");
        AppLocal.BACKGROUND_TYPE_PAYMENT_EN = this.getProperty("background.type.payment.en");
        AppLocal.BACKGROUND_TYPE_PAYMENT_ES = this.getProperty("background.type.payment.es");
        AppLocal.CATALOG_BACKGROUND_FR = this.getProperty("catalog.background.fr");
        AppLocal.CATALOG_BACKGROUND_AR = this.getProperty("catalog.background.ar");
        AppLocal.CATALOG_BACKGROUND_EN = this.getProperty("catalog.background.en");
        AppLocal.CATALOG_BACKGROUND_ES = this.getProperty("catalog.background.es");
        AppLocal.IMAGE_INSERT_CARD = this.getProperty("image.insert.card");
        AppLocal.IMAGE_INSERT_CARD_FR = this.getProperty("image.insert.card.fr");
        AppLocal.IMAGE_INSERT_CARD_AR = this.getProperty("image.insert.card.ar");
        AppLocal.IMAGE_INSERT_CARD_EN = this.getProperty("image.insert.card.en");
        AppLocal.IMAGE_INSERT_CARD_ES = this.getProperty("image.insert.card.es");
        AppLocal.IMAGE_VALID_ORDER_COUNTER = this.getProperty("background.valid.borne.order");
        AppLocal.IMAGE_VALID_ORDER_COUNTER_FR = this.getProperty("image.valid.order.counter.fr");
        AppLocal.IMAGE_VALID_ORDER_COUNTER_AR = this.getProperty("image.valid.order.counter.ar");
        AppLocal.IMAGE_VALID_ORDER_COUNTER_EN = this.getProperty("image.valid.order.counter.en");
        AppLocal.IMAGE_VALID_ORDER_COUNTER_ES = this.getProperty("image.valid.order.counter.es");
        AppLocal.IMAGE_VALID_ORDER_CB = this.getProperty("image.valid.order.cb");
        AppLocal.IMAGE_VALID_ORDER_CB_FR = this.getProperty("image.valid.order.cb.fr");
        AppLocal.IMAGE_VALID_ORDER_CB_AR = this.getProperty("image.valid.order.cb.ar");
        AppLocal.IMAGE_VALID_ORDER_CB_EN = this.getProperty("image.valid.order.cb.en");
        AppLocal.IMAGE_VALID_ORDER_CB_ES = this.getProperty("image.valid.order.cb.es");
        AppLocal.SIZE_TEXT_NUMBER_ORDER_CB = this.getIntegerPropertyWithDefaultValue("size.text.number.order.cb", 80);
        AppLocal.COLOR_TEXT_NUMBER_ORDER_CB = this.getStringPropertyWithDefaultValue("color.text.number.order.cb", "0, 0, 0");
        AppLocal.BACKGROUND_ITEMS_LATER = this.getProperty("background.items.later");
    }

    public void initFirebase() {
        System.out.println("******************** initFirebase() *****************");
        if (this.isNetworkConnected()) {
            System.out.println("initFirebase : network");
            this.mFireBaseInstance = FireBaseInstance.getInstance();
            AppLocal.fireApp = this.mFireBaseInstance.getFireApp();
            AppLocal.firedb = this.mFireBaseInstance.getFirestoredb();
        }
    }

    public boolean isNetworkConnected() {
        return this.isNetworkConnected("www.google.com", 80, 5000);
    }

    public boolean isNetworkConnected(String host, Integer port, Integer timeOutInMilliSec) {
        try {
            Socket socket = new Socket();
            socket.connect(new InetSocketAddress(host, (int)port), timeOutInMilliSec);
            return true;
        }
        catch (Exception ex) {
            LogToFile.log("severe", null, ex);
            return false;
        }
    }

    public void initInfoMediaCaisse() {
        AppLocal.color_borne = this.getStringProperty("color.borne");
        AppLocal.LOGO_BORNE = this.getProperty("logo.borne");
    }

    public Boolean getBooleanAndDefault(String key) {
        String value = this.getProperty(key);
        return value.equalsIgnoreCase("1") ? Boolean.TRUE : Boolean.FALSE;
    }

    private void setCodeLanguage() {
        String language_code = null;
        HashMap<String, String> nameLanguages = new HashMap<String, String>();
        nameLanguages.put("spanish", "es");
        nameLanguages.put("french", "fr");
        nameLanguages.put("english", "en");
        nameLanguages.put("arabic", "ar");
        nameLanguages.put("french_canada", "fr-CA");
        if (nameLanguages.containsKey(AppLocal.APP_LANGUAGE_DEFAULT)) {
            AppLocal.APP_LANGUAGE_DEFAULT = language_code = (String)nameLanguages.get(AppLocal.APP_LANGUAGE_DEFAULT);
            AppLocal.APP_LANGUAGE = language_code;
        }
    }

    public void initTariff() {
        String name_tarif = this.getStringPropertyWithDefaultValue("tariff", "Tarif 1");
        System.out.println("+++++++++ name_tarif ************: " + name_tarif);
        HashMap<String, Integer> mapTariff = new HashMap<String, Integer>();
        mapTariff.put("Tarif 1", 1);
        mapTariff.put("Tarif 2", 2);
        mapTariff.put("Tarif 3", 3);
        AppLocal.TARIFF = mapTariff.get(name_tarif) != null ? (Integer)mapTariff.get(name_tarif) : 1;
    }
}

