/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.epm;

import com.openbravo.basic.BasicException;
import com.openbravo.data.loader.QBFBuilder;
import com.openbravo.data.loader.SerializerRead;
import com.openbravo.data.loader.SerializerReadDate;
import com.openbravo.data.loader.SerializerReadString;
import com.openbravo.data.loader.SerializerWrite;
import com.openbravo.data.loader.SerializerWriteBasic;
import com.openbravo.data.loader.SerializerWriteString;
import com.openbravo.format.Formats;
import com.openbravo.pos.epm.Break;
import com.openbravo.pos.epm.BreaksInfo;
import com.openbravo.pos.epm.EmployeeInfo;
import com.openbravo.pos.epm.EmployeeInfoExt;
import com.openbravo.pos.epm.LeavesInfo;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.BeanFactoryDataSingle;
import com.procaisse.db.connection.Session;
import com.procaisse.db.metadata.DataRead;
import com.procaisse.db.metadata.Datas;
import com.procaisse.db.metadata.TableDefinition;
import com.procaisse.db.sql.PreparedSentence;
import com.procaisse.db.sql.SentenceExec;
import com.procaisse.db.sql.SentenceFind;
import com.procaisse.db.sql.SentenceList;
import com.procaisse.db.sql.StaticSentence;
import java.util.Date;
import java.util.List;
import java.util.UUID;

public class DataLogicPresenceManagement
extends BeanFactoryDataSingle {
    protected Session s;
    private SentenceExec m_checkin;
    private SentenceExec m_checkout;
    private SentenceFind m_checkdate;
    private SentenceList m_breaksvisible;
    private SentenceExec m_startbreak;
    private SentenceExec m_endbreak;
    private SentenceFind m_isonbreak;
    private SentenceFind m_isonleave;
    private SentenceFind m_shiftid;
    private SentenceFind m_lastcheckin;
    private SentenceFind m_lastcheckout;
    private SentenceFind m_startbreaktime;
    private SentenceFind m_lastbreakid;
    private SentenceFind m_breakname;
    private SerializerRead breakread;
    private TableDefinition tbreaks;
    private TableDefinition tleaves;

    @Override
    public void init(Session s) {
        this.s = s;
        this.breakread = new SerializerRead(){

            @Override
            public Object readValues(DataRead dr) throws BasicException {
                return new Break(dr.getString(1), dr.getString(2), dr.getString(3), dr.getBoolean(4));
            }
        };
        this.tbreaks = new TableDefinition(s, "BREAKS", new String[]{"ID", "NAME", "NOTES", "VISIBLE"}, new String[]{"ID", AppLocal.getIntString("label.epm.employee"), AppLocal.getIntString("label.epm.notes"), "VISIBLE"}, new Datas[]{Datas.STRING, Datas.STRING, Datas.STRING, Datas.BOOLEAN}, new Formats[]{Formats.STRING, Formats.STRING, Formats.STRING, Formats.BOOLEAN}, new int[]{0});
        this.tleaves = new TableDefinition(s, "LEAVES", new String[]{"ID", "PPLID", "NAME", "STARTDATE", "ENDDATE", "NOTES"}, new String[]{"ID", AppLocal.getIntString("label.epm.employee.id"), AppLocal.getIntString("label.epm.employee"), AppLocal.getIntString("Label.StartDate"), AppLocal.getIntString("Label.EndDate"), AppLocal.getIntString("label.notes")}, new Datas[]{Datas.STRING, Datas.STRING, Datas.STRING, Datas.TIMESTAMP, Datas.TIMESTAMP, Datas.STRING}, new Formats[]{Formats.STRING, Formats.STRING, Formats.STRING, Formats.TIMESTAMP, Formats.TIMESTAMP, Formats.STRING}, new int[]{0});
        this.m_breaksvisible = new StaticSentence(s, "SELECT ID, NAME, NOTES, VISIBLE FROM BREAKS WHERE VISIBLE = " + s.DB.TRUE(), null, this.breakread);
        this.m_checkin = new PreparedSentence(s, "INSERT INTO SHIFTS(ID, STARTSHIFT, PPLID) VALUES (?, ?, ?)", new SerializerWriteBasic(Datas.STRING, Datas.TIMESTAMP, Datas.STRING));
        this.m_checkout = new StaticSentence(s, "UPDATE SHIFTS SET ENDSHIFT = ? WHERE ENDSHIFT IS NULL AND PPLID = ?", (SerializerWrite)new SerializerWriteBasic(Datas.TIMESTAMP, Datas.STRING));
        this.m_checkdate = new StaticSentence(s, "SELECT COUNT(*) FROM SHIFTS WHERE ENDSHIFT IS NULL AND PPLID = ?", SerializerWriteString.INSTANCE, SerializerReadString.INSTANCE);
        this.m_startbreak = new PreparedSentence(s, "INSERT INTO SHIFT_BREAKS(ID, SHIFTID, BREAKID, STARTTIME) VALUES (?, ?, ?, ?)", new SerializerWriteBasic(Datas.STRING, Datas.STRING, Datas.STRING, Datas.TIMESTAMP));
        this.m_endbreak = new StaticSentence(s, "UPDATE SHIFT_BREAKS SET ENDTIME = ? WHERE ENDTIME IS NULL AND SHIFTID = ?", (SerializerWrite)new SerializerWriteBasic(Datas.TIMESTAMP, Datas.STRING));
        this.m_isonbreak = new StaticSentence(s, "SELECT COUNT(*) FROM SHIFT_BREAKS WHERE ENDTIME IS NULL", SerializerWriteString.INSTANCE, SerializerReadString.INSTANCE);
        this.m_shiftid = new StaticSentence(s, "SELECT ID FROM SHIFTS WHERE ENDSHIFT IS NULL AND PPLID = ?", SerializerWriteString.INSTANCE, SerializerReadString.INSTANCE);
        this.m_isonleave = new StaticSentence(s, "SELECT COUNT(*) FROM LEAVES WHERE STARTDATE < ? AND ENDDATE > ? AND PPLID = ?", (SerializerWrite)new SerializerWriteBasic(Datas.TIMESTAMP, Datas.TIMESTAMP, Datas.STRING), SerializerReadString.INSTANCE);
        this.m_lastcheckin = new StaticSentence(s, "SELECT STARTSHIFT FROM SHIFTS WHERE ENDSHIFT IS NULL AND PPLID = ?", SerializerWriteString.INSTANCE, SerializerReadDate.INSTANCE);
        this.m_lastcheckout = new StaticSentence(s, "SELECT MAX(ENDSHIFT) FROM SHIFTS WHERE PPLID = ?", SerializerWriteString.INSTANCE, SerializerReadDate.INSTANCE);
        this.m_startbreaktime = new StaticSentence(s, "SELECT STARTTIME FROM SHIFT_BREAKS WHERE ENDTIME IS NULL AND SHIFTID = ?", SerializerWriteString.INSTANCE, SerializerReadDate.INSTANCE);
        this.m_lastbreakid = new StaticSentence(s, "SELECT BREAKID FROM SHIFT_BREAKS WHERE ENDTIME IS NULL AND SHIFTID = ?", SerializerWriteString.INSTANCE, SerializerReadString.INSTANCE);
        this.m_breakname = new StaticSentence(s, "SELECT NAME FROM BREAKS WHERE ID = ?", SerializerWriteString.INSTANCE, SerializerReadString.INSTANCE);
    }

    public final SentenceList getBreaksList() {
        return new StaticSentence(this.s, "SELECT ID, NAME FROM BREAKS ORDER BY NAME", null, new SerializerRead(){

            @Override
            public Object readValues(DataRead dr) throws BasicException {
                return new BreaksInfo(dr.getString(1), dr.getString(2));
            }
        });
    }

    public final SentenceList getLeavesList() {
        return new StaticSentence(this.s, "SELECT ID, PPLID, NAME, STARTDATE, ENDDATE, NOTES FROM LEAVES ORDER BY NAME", null, new SerializerRead(){

            @Override
            public Object readValues(DataRead dr) throws BasicException {
                return new LeavesInfo(dr.getString(1), dr.getString(2), dr.getString(3), dr.getString(4), dr.getString(5), dr.getString(6));
            }
        });
    }

    public final List listBreaksVisible() throws BasicException {
        return this.m_breaksvisible.list();
    }

    public final void CheckIn(String user) throws BasicException {
        Object[] value = new Object[]{UUID.randomUUID().toString(), new Date(), user};
        this.m_checkin.exec(value);
    }

    public final void CheckOut(String user) throws BasicException {
        Object[] value = new Object[]{new Date(), user};
        this.m_checkout.exec(value);
    }

    public final boolean IsCheckedIn(String user) throws BasicException {
        String Data2 = (String)this.m_checkdate.find((Object)user);
        return !Data2.equals("0");
    }

    public final void StartBreak(String UserID, String BreakID) throws BasicException {
        String ShiftID = this.GetShiftID(UserID);
        Object[] value = new Object[]{UUID.randomUUID().toString(), ShiftID, BreakID, new Date()};
        this.m_startbreak.exec(value);
    }

    public final void EndBreak(String UserID) throws BasicException {
        String ShiftID = this.GetShiftID(UserID);
        Object[] value = new Object[]{new Date(), ShiftID};
        this.m_endbreak.exec(value);
    }

    public final boolean IsOnBreak(String user) throws BasicException {
        String ShiftID = this.GetShiftID(user);
        String Data2 = (String)this.m_isonbreak.find((Object)ShiftID);
        return !Data2.equals("0");
    }

    public final String GetShiftID(String user) throws BasicException {
        return (String)this.m_shiftid.find((Object)user);
    }

    public final Date GetLastCheckIn(String user) throws BasicException {
        return (Date)this.m_lastcheckin.find((Object)user);
    }

    public final Date GetLastCheckOut(String user) throws BasicException {
        return (Date)this.m_lastcheckout.find((Object)user);
    }

    public final Date GetStartBreakTime(String ShiftID) throws BasicException {
        return (Date)this.m_startbreaktime.find((Object)ShiftID);
    }

    public final String GetLastBreakID(String ShiftID) throws BasicException {
        return (String)this.m_lastbreakid.find((Object)ShiftID);
    }

    public final String GetLastBreakName(String ShiftID) throws BasicException {
        String BreakID = this.GetLastBreakID(ShiftID);
        return (String)this.m_breakname.find((Object)BreakID);
    }

    public final Object[] GetLastBreak(String user) throws BasicException {
        String ShiftID = this.GetShiftID(user);
        Date StartBreakTime = this.GetStartBreakTime(ShiftID);
        String BreakName = this.GetLastBreakName(ShiftID);
        return new Object[]{BreakName, StartBreakTime};
    }

    public final boolean IsOnLeave(String user) throws BasicException {
        Object[] value = new Object[]{new Date(), new Date(), user};
        String Data2 = (String)this.m_isonleave.find(value);
        return !Data2.equals("0");
    }

    public SentenceList getEmployeeList() {
        return new StaticSentence(this.s, new QBFBuilder("SELECT ID, NAME FROM PEOPLE WHERE ROLE != '0' AND VISIBLE = " + this.s.DB.TRUE() + " AND ?(QBF_FILTER) ORDER BY NAME", new String[]{"NAME"}), (SerializerWrite)new SerializerWriteBasic(Datas.OBJECT, Datas.STRING), new SerializerRead(){

            @Override
            public Object readValues(DataRead dr) throws BasicException {
                EmployeeInfo c = new EmployeeInfo(dr.getString(1));
                c.setName(dr.getString(2));
                return c;
            }
        });
    }

    public void BlockEmployee(String user) throws BasicException {
        boolean isOnBreak = this.IsOnBreak(user);
        if (isOnBreak) {
            this.EndBreak(user);
        }
        this.CheckOut(user);
    }

    TableDefinition getTableBreaks() {
        return this.tbreaks;
    }

    TableDefinition getTableLeaves() {
        return this.tleaves;
    }

    public EmployeeInfoExt loadEmployeeExt(String id) throws BasicException {
        return (EmployeeInfoExt)new PreparedSentence(this.s, "SELECT ID, NAME FROM PEOPLE WHERE ID = ?", SerializerWriteString.INSTANCE, new EmployeeExtRead()).find((Object)id);
    }

    protected static class EmployeeExtRead
    implements SerializerRead {
        protected EmployeeExtRead() {
        }

        @Override
        public Object readValues(DataRead dr) throws BasicException {
            EmployeeInfoExt c = new EmployeeInfoExt(dr.getString(1));
            c.setName(dr.getString(2));
            return c;
        }
    }
}

