/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.customers.exports;

import com.openbravo.pos.customers.exports.BaseExport;
import com.openbravo.pos.notify.NPosition;
import com.openbravo.pos.notify.NotifyType;
import com.openbravo.pos.notify.NotifyWindow;
import com.openbravo.pos.util.DateUtils;
import com.openbravo.pos.util.SystemUtils;
import fr.protactile.procaisse.dao.entities.CustomerInfo;
import fr.protactile.procaisse.dao.entities.DebitCustomerInfo;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExportDebitsCustomerExcel
extends BaseExport {
    private Sheet selectedSheet = null;
    private XSSFWorkbook mWorkbook = null;
    private int line;
    private HashMap<Integer, XSSFRow> rows;
    private boolean showDetailTurnover;
    private boolean showPeriode;
    private String[] headerTitles;
    private List<DebitCustomerInfo> debits;
    private CustomerInfo mCustomerInfo;
    private final SimpleDateFormat dateFormatter = DateUtils.formatterDayMonthYear;
    private final SimpleDateFormat timeFormatter = DateUtils.timeFormatter;

    public ExportDebitsCustomerExcel() {
        this.rows = new HashMap();
        this.headerTitles = new String[]{"Numero", "Total", "Date", "Heure", "Pay\u00e9", "Transfert"};
    }

    private void generateHeader() {
        int firstRow = this.line;
        int lastRow = this.line + 1;
        CellRangeAddress titleCARegion = new CellRangeAddress(firstRow, lastRow, 0, 5);
        this.selectedSheet.addMergedRegion(titleCARegion);
        XSSFFont titleCAFont = this.mWorkbook.createFont();
        titleCAFont.setFontName("Arial");
        titleCAFont.setFontHeightInPoints((short)20);
        titleCAFont.setColor(IndexedColors.BLACK.index);
        titleCAFont.setBold(true);
        XSSFCellStyle titleCAStyle = this.mWorkbook.createCellStyle();
        titleCAStyle.setFont((Font)titleCAFont);
        titleCAStyle.setAlignment(HorizontalAlignment.CENTER);
        XSSFRow titleCARow = this.addRow(this.line);
        Cell titleCACell = titleCARow.createCell(0);
        String title = "Les transactions de " + this.mCustomerInfo.getName();
        titleCACell.setCellValue(title);
        titleCACell.setCellStyle((CellStyle)titleCAStyle);
        ++this.line;
        ++this.line;
        XSSFCellStyle headerStyle = this.mWorkbook.createCellStyle();
        headerStyle.setBorderTop(BorderStyle.MEDIUM);
        headerStyle.setBorderBottom(BorderStyle.MEDIUM);
        headerStyle.setBorderLeft(BorderStyle.MEDIUM);
        headerStyle.setBorderRight(BorderStyle.MEDIUM);
        headerStyle.setAlignment(HorizontalAlignment.CENTER);
        XSSFFont font = this.mWorkbook.createFont();
        font.setFontName("Arial");
        font.setFontHeightInPoints((short)9);
        font.setBold(true);
        headerStyle.setFont((Font)font);
        XSSFRow header = this.addRow(this.line);
        for (int i = 0; i < this.headerTitles.length; ++i) {
            String headerTitle = this.headerTitles[i];
            Cell headerCell = header.createCell(i);
            headerCell.setCellValue(headerTitle);
            headerCell.setCellStyle((CellStyle)headerStyle);
        }
        ++this.line;
    }

    public Sheet createSheet(String sheetName, XSSFWorkbook mWorkbook) {
        return mWorkbook != null ? mWorkbook.createSheet(sheetName) : null;
    }

    private XSSFRow addRow(int index) {
        XSSFRow row = null;
        if (index < 0) {
            index = 0;
        }
        if (this.selectedSheet != null) {
            row = (XSSFRow)this.selectedSheet.createRow(index);
            row.setHeight((short)500);
            this.rows.put(index, row);
        }
        return row;
    }

    private Cell addCell(Row row, int index, String value, CellType cellType, CellStyle rowStyle) {
        if (row != null) {
            Cell cell = row.createCell(index);
            cell.setCellValue(value);
            cell.setCellType(cellType);
            cell.setCellStyle(rowStyle);
            return cell;
        }
        return null;
    }

    private String writeOnDisk(XSSFWorkbook mWorkbook) throws FileNotFoundException, IOException, InvalidFormatException, GeneralSecurityException {
        String fileLocation = "";
        File f = null;
        if (this.pathOutput != null) {
            fileLocation = this.pathOutput;
        } else {
            File currDir = new File(".");
            String path = currDir.getAbsolutePath();
            fileLocation = path.substring(0, path.length() - 1);
        }
        f = this.getFileName() == null ? new File(fileLocation, "temp.xlsx") : new File(fileLocation, this.getFileName());
        try (FileOutputStream outputStream = new FileOutputStream(f);){
            mWorkbook.write((OutputStream)outputStream);
            mWorkbook.close();
            outputStream.close();
        }
        return f.getAbsolutePath();
    }

    @Override
    public String export() {
        String $return_path = null;
        boolean isCanceled = false;
        while (this.pathOutput == null) {
            int dialogResult;
            super.selectPathOutPut();
            if (this.pathOutput != null || (dialogResult = JOptionPane.showConfirmDialog(null, "Voulez vous vraiment annuler l'op\u00e9ration d'export debits en Excel ?", "Warning", 0)) != 0) continue;
            isCanceled = true;
            break;
        }
        if (isCanceled) {
            return "canceled";
        }
        String sheet_name = this.mCustomerInfo.getName() + "_" + this.mCustomerInfo.getPhone();
        this.mWorkbook = new XSSFWorkbook();
        this.selectedSheet = this.createSheet(sheet_name, this.mWorkbook);
        this.selectedSheet.setDisplayGridlines(false);
        this.selectedSheet.setColumnWidth(0, 4500);
        this.selectedSheet.setColumnWidth(1, 4500);
        for (int i = 2; i < 10; ++i) {
            this.selectedSheet.setColumnWidth(i, 3500);
        }
        this.setItems();
        try {
            $return_path = this.writeOnDisk(this.mWorkbook);
            this.pathOutput = null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Logger.getLogger(ExportDebitsCustomerExcel.class.getName()).log(Level.SEVERE, null, ex);
            new NotifyWindow(NotifyType.WARNING_NOTIFICATION, "Une erreur est survenue lors de la cr\u00e9ation du fichier sur votre disque !", 1500, NPosition.BOTTOM_RIGHT);
        }
        return $return_path;
    }

    public void setTemporaryDirectoryOutput() {
        String directory = System.getProperty("java.io.tmpdir");
        if (directory == null || directory.isEmpty()) {
            directory = SystemUtils.SYS_USER_HOME;
        }
        this.pathOutput = directory;
    }

    private void setItems() {
        if (this.debits != null) {
            this.generateHeader();
            XSSFCellStyle rowStyle = this.mWorkbook.createCellStyle();
            rowStyle.setBorderTop(BorderStyle.MEDIUM);
            rowStyle.setBorderBottom(BorderStyle.MEDIUM);
            rowStyle.setBorderLeft(BorderStyle.MEDIUM);
            rowStyle.setBorderRight(BorderStyle.MEDIUM);
            rowStyle.setAlignment(HorizontalAlignment.CENTER);
            XSSFFont rowFont = this.mWorkbook.createFont();
            rowFont.setFontName("Arial");
            rowFont.setFontHeightInPoints((short)9);
            rowFont.setBold(true);
            rowStyle.setFont((Font)rowFont);
            for (DebitCustomerInfo rowItem : this.debits) {
                XSSFRow row = this.addRow(this.line);
                String paid = rowItem.isPaid() != false ? "Oui" : "Non";
                this.addCell((Row)row, 0, String.valueOf(rowItem.getNumOrder()), CellType.STRING, (CellStyle)rowStyle);
                this.addCell((Row)row, 1, String.valueOf(rowItem.getAmount()), CellType.STRING, (CellStyle)rowStyle);
                this.addCell((Row)row, 2, this.dateFormatter.format(rowItem.getDatePayment()), CellType.STRING, (CellStyle)rowStyle);
                this.addCell((Row)row, 3, this.timeFormatter.format(rowItem.getDatePayment()), CellType.STRING, (CellStyle)rowStyle);
                this.addCell((Row)row, 4, paid, CellType.STRING, (CellStyle)rowStyle);
                this.addCell((Row)row, 5, rowItem.getTransferNumber(), CellType.STRING, (CellStyle)rowStyle);
                ++this.line;
            }
        }
    }

    private XSSFRow getRow(int index) {
        if (this.rows.get(index) != null) {
            return this.rows.get(index);
        }
        XSSFRow row = this.addRow(index);
        return row;
    }

    public List<DebitCustomerInfo> getDebits() {
        return this.debits;
    }

    public void setDebits(List<DebitCustomerInfo> debits) {
        this.debits = debits;
    }

    public CustomerInfo getmCustomerInfo() {
        return this.mCustomerInfo;
    }

    public void setmCustomerInfo(CustomerInfo mCustomerInfo) {
        this.mCustomerInfo = mCustomerInfo;
    }
}

