/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.customers;

import com.openbravo.basic.BasicException;
import com.openbravo.data.loader.QBFCompareEnum;
import com.openbravo.data.user.EditorCreator;
import com.openbravo.data.user.ListProvider;
import com.openbravo.editor.JEditorKeys;
import com.openbravo.editor.JEditorString;
import com.openbravo.pos.customers.CustomerInfo;
import com.openbravo.pos.customers.CustomerRenderer;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.util.LogToFile;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class JCustomerFinder
extends JDialog
implements EditorCreator {
    private CustomerInfo selectedCustomer;
    private ListProvider lpr;
    private JLabel jLblEmail;
    private JLabel jLblName;
    private JLabel jLblPhone;
    private JLabel jLblPostal;
    private JLabel jLblSearchKey;
    private JLabel jLblTaxID;
    private JList jListCustomers;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JScrollPane jScrollPane1;
    private JButton jcmdCancel;
    private JButton jcmdExecute;
    private JButton jcmdOK;
    private JButton jcmdReset;
    private JEditorKeys m_jKeys;
    private JEditorString m_jtxtEmail;
    private JEditorString m_jtxtName;
    private JEditorString m_jtxtPhone;
    private JEditorString m_jtxtPostal;
    private JEditorString m_jtxtSearchKey;
    private JEditorString m_jtxtTaxID;

    private JCustomerFinder(Frame parent, boolean modal) {
        super(parent, modal);
    }

    private JCustomerFinder(Dialog parent, boolean modal) {
        super(parent, modal);
    }

    public static JCustomerFinder getCustomerFinder(Component parent) {
        Window window = JCustomerFinder.getWindow(parent);
        JCustomerFinder myMsg = window instanceof Frame ? new JCustomerFinder((Frame)window, true) : new JCustomerFinder((Dialog)window, true);
        myMsg.init();
        myMsg.applyComponentOrientation(parent.getComponentOrientation());
        return myMsg;
    }

    public CustomerInfo getSelectedCustomer() {
        return this.selectedCustomer;
    }

    private void init() {
        this.initComponents();
        this.jScrollPane1.getVerticalScrollBar().setPreferredSize(new Dimension(35, 35));
        this.m_jtxtTaxID.addEditorKeys(this.m_jKeys);
        this.m_jtxtSearchKey.addEditorKeys(this.m_jKeys);
        this.m_jtxtName.addEditorKeys(this.m_jKeys);
        this.m_jtxtPostal.addEditorKeys(this.m_jKeys);
        this.m_jtxtPhone.addEditorKeys(this.m_jKeys);
        this.m_jtxtEmail.addEditorKeys(this.m_jKeys);
        this.m_jtxtTaxID.reset();
        this.m_jtxtSearchKey.reset();
        this.m_jtxtName.reset();
        this.m_jtxtPostal.reset();
        this.m_jtxtPhone.reset();
        this.m_jtxtEmail.reset();
        this.m_jtxtTaxID.activate();
        this.jListCustomers.setCellRenderer(new CustomerRenderer());
        this.getRootPane().setDefaultButton(this.jcmdOK);
        this.selectedCustomer = null;
    }

    public void search(CustomerInfo customer) {
        if (customer == null || customer.getName() == null || customer.getName().equals("")) {
            this.m_jtxtTaxID.reset();
            this.m_jtxtSearchKey.reset();
            this.m_jtxtName.reset();
            this.m_jtxtPostal.reset();
            this.m_jtxtPhone.reset();
            this.m_jtxtEmail.reset();
            this.m_jtxtTaxID.activate();
            this.cleanSearch();
        } else {
            this.m_jtxtTaxID.setText(customer.getTaxid());
            this.m_jtxtName.setText(customer.getName());
            this.m_jtxtPhone.setText(customer.getPhone());
            this.m_jtxtTaxID.activate();
            this.executeSearch();
        }
    }

    private void cleanSearch() {
        this.jListCustomers.setModel(new MyListData(new ArrayList()));
    }

    public void executeSearch() {
        try {
            this.jListCustomers.setModel(new MyListData(this.lpr.loadData()));
            if (this.jListCustomers.getModel().getSize() > 0) {
                this.jListCustomers.setSelectedIndex(0);
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    @Override
    public Object createValue() throws BasicException {
        Object[] afilter = new Object[12];
        if (this.m_jtxtTaxID.getText() == null || this.m_jtxtTaxID.getText().equals("")) {
            afilter[0] = QBFCompareEnum.COMP_NONE;
            afilter[1] = null;
        } else {
            afilter[0] = QBFCompareEnum.COMP_RE;
            afilter[1] = "%" + this.m_jtxtTaxID.getText() + "%";
        }
        if (this.m_jtxtSearchKey.getText() == null || this.m_jtxtSearchKey.getText().equals("")) {
            afilter[2] = QBFCompareEnum.COMP_NONE;
            afilter[3] = null;
        } else {
            afilter[2] = QBFCompareEnum.COMP_RE;
            afilter[3] = "%" + this.m_jtxtSearchKey.getText() + "%";
        }
        if (this.m_jtxtName.getText() == null || this.m_jtxtName.getText().equals("")) {
            afilter[4] = QBFCompareEnum.COMP_NONE;
            afilter[5] = null;
        } else {
            afilter[4] = QBFCompareEnum.COMP_RE;
            afilter[5] = "%" + this.m_jtxtName.getText() + "%";
        }
        if (this.m_jtxtPostal.getText() == null || this.m_jtxtPostal.getText().equals("")) {
            afilter[6] = QBFCompareEnum.COMP_NONE;
            afilter[7] = null;
        } else {
            afilter[6] = QBFCompareEnum.COMP_RE;
            afilter[7] = "%" + this.m_jtxtPostal.getText() + "%";
        }
        if (this.m_jtxtPhone.getText() == null || this.m_jtxtPhone.getText().equals("")) {
            afilter[8] = QBFCompareEnum.COMP_NONE;
            afilter[9] = null;
        } else {
            afilter[8] = QBFCompareEnum.COMP_RE;
            afilter[9] = "%" + this.m_jtxtPhone.getText() + "%";
        }
        if (this.m_jtxtEmail.getText() == null || this.m_jtxtEmail.getText().equals("")) {
            afilter[10] = QBFCompareEnum.COMP_NONE;
            afilter[11] = null;
        } else {
            afilter[10] = QBFCompareEnum.COMP_RE;
            afilter[11] = "%" + this.m_jtxtEmail.getText() + "%";
        }
        return afilter;
    }

    private static Window getWindow(Component parent) {
        if (parent == null) {
            return new JFrame();
        }
        if (parent instanceof Frame || parent instanceof Dialog) {
            return (Window)parent;
        }
        return JCustomerFinder.getWindow(parent.getParent());
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.m_jKeys = new JEditorKeys();
        this.jPanel3 = new JPanel();
        this.jPanel5 = new JPanel();
        this.jPanel7 = new JPanel();
        this.jLblTaxID = new JLabel();
        this.m_jtxtTaxID = new JEditorString();
        this.jLblSearchKey = new JLabel();
        this.m_jtxtSearchKey = new JEditorString();
        this.jLblPostal = new JLabel();
        this.m_jtxtPostal = new JEditorString();
        this.jLblName = new JLabel();
        this.m_jtxtName = new JEditorString();
        this.jLblPhone = new JLabel();
        this.jLblEmail = new JLabel();
        this.m_jtxtEmail = new JEditorString();
        this.m_jtxtPhone = new JEditorString();
        this.jPanel6 = new JPanel();
        this.jcmdReset = new JButton();
        this.jcmdExecute = new JButton();
        this.jPanel4 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jListCustomers = new JList();
        this.jPanel8 = new JPanel();
        this.jPanel1 = new JPanel();
        this.jcmdCancel = new JButton();
        this.jcmdOK = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle(AppLocal.getIntString("form.customertitle"));
        this.setCursor(new Cursor(0));
        this.jPanel2.setCursor(new Cursor(0));
        this.jPanel2.setLayout(new BorderLayout());
        this.jPanel2.add((Component)this.m_jKeys, "North");
        this.getContentPane().add((Component)this.jPanel2, "After");
        this.jPanel3.setLayout(new BorderLayout());
        this.jPanel5.setLayout(new BorderLayout());
        this.jLblTaxID.setFont(AppLocal.FONT_ARIAL_PLAIN_12);
        this.jLblTaxID.setText(AppLocal.getIntString("label.taxid"));
        this.jLblTaxID.setMaximumSize(new Dimension(120, 25));
        this.jLblTaxID.setMinimumSize(new Dimension(120, 25));
        this.jLblTaxID.setPreferredSize(new Dimension(120, 25));
        this.m_jtxtTaxID.setFont(AppLocal.FONT_ARIAL_PLAIN_12);
        this.m_jtxtTaxID.setPreferredSize(new Dimension(220, 25));
        this.jLblSearchKey.setFont(AppLocal.FONT_ARIAL_PLAIN_12);
        this.jLblSearchKey.setText(AppLocal.getIntString("label.searchkey"));
        this.jLblSearchKey.setMaximumSize(new Dimension(120, 25));
        this.jLblSearchKey.setMinimumSize(new Dimension(120, 25));
        this.jLblSearchKey.setPreferredSize(new Dimension(120, 25));
        this.m_jtxtSearchKey.setFont(AppLocal.FONT_ARIAL_PLAIN_12);
        this.m_jtxtSearchKey.setPreferredSize(new Dimension(220, 25));
        this.jLblPostal.setFont(AppLocal.FONT_ARIAL_PLAIN_12);
        this.jLblPostal.setText("Postal");
        this.jLblPostal.setMaximumSize(new Dimension(120, 25));
        this.jLblPostal.setMinimumSize(new Dimension(120, 25));
        this.jLblPostal.setPreferredSize(new Dimension(120, 25));
        this.m_jtxtPostal.setFont(AppLocal.FONT_ARIAL_PLAIN_12);
        this.m_jtxtPostal.setPreferredSize(new Dimension(220, 25));
        this.jLblName.setFont(AppLocal.FONT_ARIAL_PLAIN_12);
        this.jLblName.setText(AppLocal.getIntString("label.prodname"));
        this.jLblName.setMaximumSize(new Dimension(120, 25));
        this.jLblName.setMinimumSize(new Dimension(120, 25));
        this.jLblName.setPreferredSize(new Dimension(120, 25));
        this.m_jtxtName.setFont(AppLocal.FONT_ARIAL_PLAIN_12);
        this.m_jtxtName.setPreferredSize(new Dimension(220, 25));
        this.jLblPhone.setFont(AppLocal.FONT_ARIAL_PLAIN_12);
        ResourceBundle bundle = ResourceBundle.getBundle("pos_messages");
        this.jLblPhone.setText(bundle.getString("label.phone"));
        this.jLblPhone.setMaximumSize(new Dimension(120, 25));
        this.jLblPhone.setPreferredSize(new Dimension(120, 25));
        this.jLblEmail.setFont(AppLocal.FONT_ARIAL_PLAIN_12);
        this.jLblEmail.setText(bundle.getString("label.companyemail"));
        this.jLblEmail.setMaximumSize(new Dimension(120, 25));
        this.jLblEmail.setMinimumSize(new Dimension(120, 25));
        this.jLblEmail.setPreferredSize(new Dimension(120, 25));
        this.m_jtxtEmail.setFont(AppLocal.FONT_ARIAL_PLAIN_12);
        this.m_jtxtEmail.setPreferredSize(new Dimension(220, 25));
        this.m_jtxtPhone.setFont(AppLocal.FONT_ARIAL_PLAIN_12);
        this.m_jtxtPhone.setPreferredSize(new Dimension(220, 25));
        this.jcmdReset.setFont(AppLocal.FONT_ARIAL_PLAIN_12);
        this.jcmdReset.setIcon(new ImageIcon(this.getClass().getResource("/com/openbravo/images/reload.png")));
        this.jcmdReset.setText(bundle.getString("button.reset"));
        this.jcmdReset.setToolTipText("Clear Filter");
        this.jcmdReset.setActionCommand("Reset ");
        this.jcmdReset.setFocusable(false);
        this.jcmdReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JCustomerFinder.this.jcmdResetActionPerformed(evt);
            }
        });
        this.jPanel6.add(this.jcmdReset);
        this.jcmdReset.getAccessibleContext().setAccessibleDescription("");
        this.jcmdExecute.setFont(AppLocal.FONT_ARIAL_PLAIN_12);
        this.jcmdExecute.setIcon(new ImageIcon(this.getClass().getResource("/com/openbravo/images/ok.png")));
        this.jcmdExecute.setText(AppLocal.getIntString("button.executefilter"));
        this.jcmdExecute.setToolTipText("Execute Filter");
        this.jcmdExecute.setFocusPainted(false);
        this.jcmdExecute.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JCustomerFinder.this.jcmdExecuteActionPerformed(evt);
            }
        });
        this.jPanel6.add(this.jcmdExecute);
        this.jcmdExecute.getAccessibleContext().setAccessibleDescription("");
        GroupLayout jPanel7Layout = new GroupLayout(this.jPanel7);
        this.jPanel7.setLayout(jPanel7Layout);
        jPanel7Layout.setHorizontalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel6, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(jPanel7Layout.createSequentialGroup().addContainerGap().addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLblPostal, -2, -1, -2).addComponent(this.jLblTaxID, -2, -1, -2).addComponent(this.jLblSearchKey, -2, -1, -2).addComponent(this.jLblPhone, -1, -1, -2).addComponent(this.jLblName, -1, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.m_jtxtSearchKey, -2, -1, -2).addComponent(this.m_jtxtTaxID, -2, -1, -2).addComponent(this.m_jtxtPostal, -2, -1, -2).addComponent(this.m_jtxtName, -2, -1, -2).addComponent(this.m_jtxtPhone, -2, -1, -2))).addGroup(jPanel7Layout.createSequentialGroup().addComponent(this.jLblEmail, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.m_jtxtEmail, -2, -1, -2))).addGap(0, 35, Short.MAX_VALUE))).addContainerGap()));
        jPanel7Layout.setVerticalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addGap(11, 11, 11).addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.m_jtxtTaxID, -1, -1, Short.MAX_VALUE).addComponent(this.jLblTaxID, -1, -1, Short.MAX_VALUE)).addGap(6, 6, 6).addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLblSearchKey, -2, -1, -2).addComponent(this.m_jtxtSearchKey, -2, -1, -2)).addGap(6, 6, 6).addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLblPostal, -2, -1, -2).addComponent(this.m_jtxtPostal, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.m_jtxtName, -2, -1, -2).addComponent(this.jLblName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLblPhone, -2, -1, -2).addComponent(this.m_jtxtPhone, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLblEmail, -2, -1, -2).addComponent(this.m_jtxtEmail, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel6, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.m_jtxtName.getAccessibleContext().setAccessibleName("");
        this.jPanel5.add((Component)this.jPanel7, "Center");
        this.jPanel3.add((Component)this.jPanel5, "First");
        this.jPanel4.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.jPanel4.setLayout(new BorderLayout());
        this.jListCustomers.setFont(AppLocal.FONT_ARIAL_PLAIN_12);
        this.jListCustomers.setFocusable(false);
        this.jListCustomers.setRequestFocusEnabled(false);
        this.jListCustomers.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JCustomerFinder.this.jListCustomersMouseClicked(evt);
            }
        });
        this.jListCustomers.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                JCustomerFinder.this.jListCustomersValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jListCustomers);
        this.jPanel4.add((Component)this.jScrollPane1, "Center");
        this.jPanel3.add((Component)this.jPanel4, "Center");
        this.jPanel8.setLayout(new BorderLayout());
        this.jcmdCancel.setFont(AppLocal.FONT_ARIAL_PLAIN_12);
        this.jcmdCancel.setIcon(new ImageIcon(this.getClass().getResource("/com/openbravo/images/cancel.png")));
        this.jcmdCancel.setText(AppLocal.getIntString("Button.Cancel"));
        this.jcmdCancel.setFocusPainted(false);
        this.jcmdCancel.setFocusable(false);
        this.jcmdCancel.setMargin(new Insets(8, 16, 8, 16));
        this.jcmdCancel.setRequestFocusEnabled(false);
        this.jcmdCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JCustomerFinder.this.jcmdCancelActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jcmdCancel);
        this.jcmdOK.setIcon(new ImageIcon(this.getClass().getResource("/com/openbravo/images/ok.png")));
        this.jcmdOK.setText(AppLocal.getIntString("Button.OK"));
        this.jcmdOK.setEnabled(false);
        this.jcmdOK.setFocusPainted(false);
        this.jcmdOK.setFocusable(false);
        this.jcmdOK.setMargin(new Insets(8, 16, 8, 16));
        this.jcmdOK.setMaximumSize(new Dimension(103, 44));
        this.jcmdOK.setMinimumSize(new Dimension(103, 44));
        this.jcmdOK.setPreferredSize(new Dimension(103, 44));
        this.jcmdOK.setRequestFocusEnabled(false);
        this.jcmdOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JCustomerFinder.this.jcmdOKActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jcmdOK);
        this.jPanel8.add((Component)this.jPanel1, "After");
        this.jPanel3.add((Component)this.jPanel8, "South");
        this.getContentPane().add((Component)this.jPanel3, "Center");
        this.setSize(new Dimension(613, 497));
        this.setLocationRelativeTo(null);
    }

    private void jcmdOKActionPerformed(ActionEvent evt) {
        this.selectedCustomer = (CustomerInfo)this.jListCustomers.getSelectedValue();
        this.dispose();
    }

    private void jcmdCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jcmdExecuteActionPerformed(ActionEvent evt) {
        this.executeSearch();
    }

    private void jListCustomersValueChanged(ListSelectionEvent evt) {
        this.jcmdOK.setEnabled(this.jListCustomers.getSelectedValue() != null);
    }

    private void jListCustomersMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            this.selectedCustomer = (CustomerInfo)this.jListCustomers.getSelectedValue();
            this.dispose();
        }
    }

    private void jcmdResetActionPerformed(ActionEvent evt) {
        this.m_jtxtTaxID.reset();
        this.m_jtxtSearchKey.reset();
        this.m_jtxtName.reset();
        this.m_jtxtPostal.reset();
        this.m_jtxtPhone.reset();
        this.m_jtxtEmail.reset();
        this.m_jtxtTaxID.activate();
        this.cleanSearch();
    }

    private static class MyListData
    extends AbstractListModel {
        private final List m_data;

        public MyListData(List data) {
            this.m_data = data;
        }

        @Override
        public Object getElementAt(int index) {
            return this.m_data.get(index);
        }

        @Override
        public int getSize() {
            return this.m_data.size();
        }
    }
}

