/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.config;

import com.openbravo.basic.BasicException;
import com.openbravo.beans.JFlowPanel;
import com.openbravo.dao.DataLogicSales;
import com.openbravo.data.gui.JMessageDialog;
import com.openbravo.data.gui.MessageInf;
import com.openbravo.pos.config.JPanelConfigDatabase;
import com.openbravo.pos.config.PanelConfig;
import com.openbravo.pos.forms.AppConfig;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.AppProperties;
import com.openbravo.pos.forms.AppView;
import com.openbravo.pos.forms.JPanelView;
import com.openbravo.pos.ticket.PrinterInfo;
import com.openbravo.pos.ticket.TaxInfo;
import com.openbravo.pos.util.Event;
import com.openbravo.pos.util.Journal;
import com.openbravo.pos.util.LogToFile;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class JPanelConfigurationStart
extends JPanel
implements JPanelView {
    private List<PanelConfig> m_panelconfig;
    private AppConfig config;
    private AppView oApp;
    protected DataLogicSales dlSales;
    private List<PrinterInfo> printers;
    private List<PrinterInfo> printersDB;
    private JFlowPanel jPanelPrinters;
    protected List<TaxInfo> taxes;
    private JPanel jPanelDatabase;
    private JPanel jPanelPrincipal;
    private JPanel jPanelValidate;
    private JButton jbtnExit;
    private JButton jbtnRestore;
    private JButton jbtnSave;

    public JPanelConfigurationStart(AppView oApp) {
        this.initComponents();
        if (oApp != null) {
            this.jbtnExit.setVisible(false);
        }
        this.config = AppConfig.getInstance(true, oApp.getProperties().getConfigFile());
        this.m_panelconfig = new ArrayList<PanelConfig>();
        JPanelConfigDatabase panel = new JPanelConfigDatabase(true);
        this.m_panelconfig.add(panel);
        this.jPanelDatabase.add(panel.getConfigComponent());
        this.jbtnRestore.setVisible(false);
    }

    public JPanelConfigurationStart(AppProperties props) {
        this.initComponents();
        this.config = AppConfig.getInstance(true, props.getConfigFile());
        this.m_panelconfig = new ArrayList<PanelConfig>();
        JPanelConfigDatabase panel = new JPanelConfigDatabase(true);
        this.m_panelconfig.add(panel);
        this.jPanelDatabase.add(panel.getConfigComponent());
        this.jbtnRestore.setVisible(false);
    }

    private void restoreProperties() {
        if (this.config.delete()) {
            this.loadProperties();
        } else {
            JMessageDialog.showMessage(this, new MessageInf(-33554432, AppLocal.getIntString("message.cannotdeleteconfig")));
        }
    }

    private void loadProperties() {
        this.config = AppConfig.getInstance(true, this.config.getConfigFile());
        for (PanelConfig c : this.m_panelconfig) {
            c.loadProperties(this.config);
        }
    }

    private void saveProperties() {
        for (PanelConfig c : this.m_panelconfig) {
            c.saveProperties(this.config);
        }
        try {
            this.config.save();
            JOptionPane.showMessageDialog(new JFrame(), AppLocal.getIntString("message.restartchanges"), AppLocal.getIntString("message.title"), 1);
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
            JMessageDialog.showMessage(new JFrame(), new MessageInf(-33554432, AppLocal.getIntString("message.cannotsaveconfig"), ex));
        }
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public String getTitle() {
        return AppLocal.getIntString("Menu.Configuration");
    }

    @Override
    public void activate() throws BasicException {
        this.loadProperties();
    }

    @Override
    public boolean deactivate() {
        boolean haschanged = false;
        for (PanelConfig c : this.m_panelconfig) {
            if (!c.hasChanged()) continue;
            haschanged = true;
        }
        if (haschanged) {
            int res = JOptionPane.showConfirmDialog(new JFrame(), AppLocal.getIntString("message.wannasave"), AppLocal.getIntString("title.editor"), 1, 3);
            if (res == 0) {
                this.saveProperties();
                return true;
            }
            return res == 1;
        }
        return true;
    }

    private void initComponents() {
        this.jPanelValidate = new JPanel();
        this.jbtnRestore = new JButton();
        this.jbtnExit = new JButton();
        this.jbtnSave = new JButton();
        this.jPanelPrincipal = new JPanel();
        this.jPanelDatabase = new JPanel();
        this.setFont(AppLocal.FONT_ARIAL_PLAIN_12);
        this.setMinimumSize(new Dimension(0, 0));
        this.setPreferredSize(new Dimension(750, 500));
        this.setLayout(new BorderLayout());
        this.jbtnRestore.setFont(AppLocal.FONT_ARIAL_PLAIN_12);
        this.jbtnRestore.setText(AppLocal.getIntString("Button.Factory"));
        this.jbtnRestore.setMaximumSize(new Dimension(103, 33));
        this.jbtnRestore.setMinimumSize(new Dimension(103, 33));
        this.jbtnRestore.setPreferredSize(new Dimension(150, 33));
        this.jbtnRestore.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelConfigurationStart.this.jbtnRestoreActionPerformed(evt);
            }
        });
        this.jPanelValidate.add(this.jbtnRestore);
        this.jbtnExit.setFont(AppLocal.FONT_ARIAL_PLAIN_12);
        this.jbtnExit.setText(AppLocal.getIntString("Button.Exit"));
        this.jbtnExit.setMaximumSize(new Dimension(70, 33));
        this.jbtnExit.setMinimumSize(new Dimension(70, 33));
        this.jbtnExit.setPreferredSize(new Dimension(150, 33));
        this.jbtnExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelConfigurationStart.this.jbtnExitActionPerformed(evt);
            }
        });
        this.jPanelValidate.add(this.jbtnExit);
        this.jbtnSave.setFont(AppLocal.FONT_ARIAL_PLAIN_12);
        this.jbtnSave.setText(AppLocal.getIntString("Button.Save"));
        this.jbtnSave.setMaximumSize(new Dimension(70, 33));
        this.jbtnSave.setMinimumSize(new Dimension(70, 33));
        this.jbtnSave.setPreferredSize(new Dimension(150, 33));
        this.jbtnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelConfigurationStart.this.jbtnSaveActionPerformed(evt);
            }
        });
        this.jPanelValidate.add(this.jbtnSave);
        this.add((Component)this.jPanelValidate, "South");
        this.jPanelPrincipal.setLayout(new BorderLayout());
        this.jPanelDatabase.setFont(AppLocal.FONT_ARIAL_PLAIN_12);
        this.jPanelDatabase.setPreferredSize(new Dimension(0, 400));
        this.jPanelDatabase.setLayout(new BoxLayout(this.jPanelDatabase, 2));
        this.jPanelPrincipal.add((Component)this.jPanelDatabase, "Center");
        this.add((Component)this.jPanelPrincipal, "Center");
    }

    private void jbtnRestoreActionPerformed(ActionEvent evt) {
        if (JOptionPane.showConfirmDialog(new JFrame(), AppLocal.getIntString("message.configfactory"), AppLocal.getIntString("message.title"), 0, 3) == 0) {
            this.restoreProperties();
        }
    }

    private void jbtnSaveActionPerformed(ActionEvent evt) {
        this.saveProperties();
    }

    private void jbtnExitActionPerformed(ActionEvent evt) {
        try {
            Journal.writeToJET(new Event(40, "Arret de l'application", AppLocal.user != null ? AppLocal.user.getId() : "", "", new Date().getTime(), ""));
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        this.deactivate();
    }
}

