/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.config;

import com.openbravo.basic.BasicException;
import com.openbravo.beans.JFlowPanel;
import com.openbravo.components.PromptText;
import com.openbravo.dao.DataLogicSales;
import com.openbravo.dao.DataLogicSystem;
import com.openbravo.data.gui.JMessageDialog;
import com.openbravo.data.gui.MessageInf;
import com.openbravo.pos.config.JPanelBorne;
import com.openbravo.pos.config.JPanelConfigArchive;
import com.openbravo.pos.config.JPanelConfigBack;
import com.openbravo.pos.config.JPanelConfigDatabase;
import com.openbravo.pos.config.JPanelConfigGeneral;
import com.openbravo.pos.config.JPanelConfigLicence;
import com.openbravo.pos.config.JPanelConfigLocale;
import com.openbravo.pos.config.JPanelConfigModules;
import com.openbravo.pos.config.JPanelConfigParams;
import com.openbravo.pos.config.JPanelConfigPeripheral;
import com.openbravo.pos.config.JPanelMultiLangue;
import com.openbravo.pos.config.JPanelTicketSetup;
import com.openbravo.pos.config.PanelConfig;
import com.openbravo.pos.forms.AppConfig;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.AppView;
import com.openbravo.pos.forms.JPanelView;
import com.openbravo.pos.notify.NPosition;
import com.openbravo.pos.notify.NotifyType;
import com.openbravo.pos.notify.NotifyWindow;
import com.openbravo.pos.printer.PrinterHelper;
import com.openbravo.pos.ticket.PrinterInfo;
import com.openbravo.pos.ticket.TaxInfo;
import com.openbravo.pos.util.LogToFile;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

public class JPanelConfiguration
extends JPanel
implements JPanelView {
    private List<PanelConfig> m_panelconfig;
    private JPanelConfigLicence licenseKeyGUI;
    private JPanelConfigParams paramsPanel;
    private AppConfig config;
    private AppView oApp;
    protected DataLogicSales dlSales;
    protected DataLogicSystem dlSystem;
    private List<PrinterInfo> printers;
    private List<PrinterInfo> printersDB;
    private JFlowPanel jPanelPrinters;
    protected List<TaxInfo> taxes;
    private String currentPanelString = "";
    JPanelConfigBack jPanelConfigBack;
    private List<String> listBaudRate = new ArrayList<String>();
    private boolean first_load;
    private JButton Borne;
    private JButton jBtnArchives;
    private JButton jBtnBack;
    private JButton jBtnDB;
    private JButton jBtnGeneral;
    private JButton jBtnLicence;
    private JButton jBtnLocal;
    private JButton jBtnParams;
    private JButton jBtnPrint;
    private JButton jBtnTicket;
    private JButton jBtnperipheral;
    private JPanel jPanelArchives;
    private JPanel jPanelBack;
    private JPanel jPanelBorne;
    private JPanel jPanelDatabase;
    private JPanel jPanelGeneral;
    private JPanel jPanelImpression;
    private JPanel jPanelLeft;
    private JPanel jPanelLicence;
    private JPanel jPanelLocale;
    private JPanel jPanelModules;
    private JPanel jPanelMultiLangue;
    private JPanel jPanelParams;
    private JPanel jPanelPeripheral;
    private JPanel jPanelPrincipal;
    private JPanel jPanelRight;
    private JPanel jPanelTicketSetup;
    private JPanel jPanelValidate;
    private JScrollPane jScrollPaneImpression;
    private JButton jValider;
    private JButton jbtnSave;
    private JButton modules;
    private JButton multilangue;
    private PanelConfig panelGeneral;
    private PanelConfig panelLocale;
    private PanelConfig panelBorne;
    private PanelConfig panelModules;
    private PanelConfig panelDataBase;
    private PanelConfig panelTicketSetup;
    private PanelConfig panelPeripheral;
    private PanelConfig panelArchives;
    private PanelConfig panelMultiLangue;

    public JPanelConfiguration(AppView oApp) {
        this.initComponents();
        this.oApp = oApp;
        this.dlSales = (DataLogicSales)oApp.getBean("com.openbravo.dao.DataLogicSales");
        this.dlSystem = (DataLogicSystem)oApp.getBean("com.openbravo.dao.DataLogicSystem");
        this.config = AppConfig.getInstance(true, oApp.getProperties().getConfigFile());
        this.first_load = true;
        this.m_panelconfig = new ArrayList<PanelConfig>();
        this.jPanelPrinters = new JFlowPanel();
        this.jScrollPaneImpression.getViewport().setView(null);
        this.listBaudRate = new ArrayList<String>();
        this.listBaudRate.add("1200");
        this.listBaudRate.add("2400");
        this.listBaudRate.add("4800");
        this.listBaudRate.add("9600");
        this.listBaudRate.add("19200");
        this.listBaudRate.add("38400");
        this.listBaudRate.add("57600");
        this.listBaudRate.add("115200");
        this.listBaudRate.add("128000");
        try {
            this.printersDB = this.dlSales.getPrinters();
            this.printers = this.printersDB;
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void loadPrinters() {
        System.out.println("++++++++++++++++ load printers");
        this.jPanelPrinters.removeAll();
        for (final PrinterInfo printer : this.printers) {
            if (AppLocal.modelCaisse != null && AppLocal.modelCaisse.equals("Esclave") && !this.oApp.getAppUserView().getUser().hasRoleMainetance() && printer.getId() != 1) break;
            JPanel panelPrinter = new JPanel();
            panelPrinter.setLayout(new FlowLayout());
            panelPrinter.setPreferredSize(new Dimension(200, 350));
            JPanel panelHeader = new JPanel();
            panelHeader.setLayout(new BorderLayout());
            panelHeader.setPreferredSize(new Dimension(180, 32));
            if (printer.getId() != 1) {
                JButton btnDelete = new JButton();
                btnDelete.setIcon(new ImageIcon(this.getClass().getResource("/com/openbravo/images/iconDelete.png")));
                btnDelete.setPreferredSize(new Dimension(31, 31));
                btnDelete.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        int dialogButton = 0;
                        int dialogResult = JOptionPane.showConfirmDialog(new JFrame(), "vous voulez vraiment supprimer cet imprimante ?", "Warning", dialogButton);
                        if (dialogResult == 0) {
                            if (printer.getId() != -1) {
                                try {
                                    JPanelConfiguration.this.dlSales.deletePrinter(printer.getId());
                                }
                                catch (Exception ex) {
                                    LogToFile.log("severe", ex.getMessage(), ex);
                                }
                            }
                            JPanelConfiguration.this.printers.remove(printer);
                            JPanelConfiguration.this.loadPrinters();
                            new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, "inmprimante supprim\u00e9.", 1500, NPosition.CENTER);
                        }
                    }
                });
                panelHeader.add((Component)btnDelete, "After");
            }
            panelPrinter.add(panelHeader);
            JLabel labelName = new JLabel();
            final JComboBox<String> jListTypes = new JComboBox<String>();
            final JComboBox<String> listModels = new JComboBox<String>();
            final JComboBox<String> jListNamePrinter = new JComboBox<String>();
            final JComboBox<String> jListNamePort = new JComboBox<String>();
            final JComboBox<String> jBand_rate = new JComboBox<String>();
            this.loadJList(printer, jListTypes, listModels, jBand_rate, jListNamePort);
            final PromptText jAddressIP = new PromptText("Adresse IP", "address ip", printer);
            final PromptText jTicket_with = new PromptText("larguer ticket", "ticket with", printer);
            final PromptText jTicket_num = new PromptText("nombre ticket", "ticket num", printer);
            labelName.setHorizontalAlignment(0);
            labelName.setPreferredSize(new Dimension(150, 40));
            jBand_rate.setEditable(true);
            jBand_rate.setPreferredSize(new Dimension(150, 40));
            jTicket_with.getDocument().putProperty("vkType", 1);
            jTicket_num.getDocument().putProperty("vkType", 1);
            jListTypes.setPreferredSize(new Dimension(150, 40));
            jListNamePrinter.setPreferredSize(new Dimension(150, 40));
            jListNamePort.setPreferredSize(new Dimension(150, 40));
            listModels.setPreferredSize(new Dimension(150, 40));
            labelName.setText(printer.getName());
            if (printer.getIp() != null) {
                jAddressIP.setText(printer.getIp());
            } else {
                jAddressIP.setText("Adresse IP");
                jAddressIP.setForeground(Color.GRAY);
            }
            if ((printer.getModel() == null || printer.getModel().isEmpty()) && !printer.getTypePrinter().equals("label")) {
                listModels.setSelectedItem("X printer");
            } else {
                listModels.setSelectedItem(printer.getModel());
            }
            String model = (String)listModels.getSelectedItem();
            this.setWithPrinter(printer, jTicket_with, model);
            jTicket_num.setText(String.valueOf(printer.getNumber()));
            try {
                PrintService[] printServices;
                for (PrintService printerWindows : printServices = PrintServiceLookup.lookupPrintServices(null, null)) {
                    jListNamePrinter.addItem(printerWindows.getName());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            jListNamePrinter.setSelectedItem(printer.getNamePrinter());
            jListTypes.setSelectedItem(printer.getType());
            jListNamePort.setSelectedItem(printer.getPort());
            jBand_rate.setSelectedItem(printer.getBand_rate());
            jListTypes.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String type = (String)jListTypes.getSelectedItem();
                    printer.setType(type);
                    JPanelConfiguration.this.setTypePrinter(printer.getType(), jListTypes, jBand_rate, jListNamePort, jListNamePrinter, jAddressIP, jTicket_with, jTicket_num);
                }
            });
            jListNamePrinter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String namePrinter = (String)jListNamePrinter.getSelectedItem();
                    printer.setNamePrinter(namePrinter);
                }
            });
            jBand_rate.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    String baud_rate = (String)jBand_rate.getSelectedItem();
                    printer.setBand_rate(baud_rate);
                }
            });
            jListNamePort.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    String port = (String)jListNamePort.getSelectedItem();
                    printer.setPort(port);
                }
            });
            listModels.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    String model = (String)listModels.getSelectedItem();
                    printer.setModel(model);
                    if (!printer.getTypePrinter().equals("label")) {
                        JPanelConfiguration.this.setWithPrinter(printer, jTicket_with, model);
                    }
                }
            });
            panelPrinter.add(labelName);
            panelPrinter.add(jListTypes);
            panelPrinter.add(jListNamePrinter);
            panelPrinter.add(jListNamePort);
            panelPrinter.add(jAddressIP);
            panelPrinter.add(listModels);
            panelPrinter.add(jBand_rate);
            panelPrinter.add(jTicket_with);
            panelPrinter.add(jTicket_num);
            if (!printer.getTypePrinter().equals("label")) {
                JButton buttonTest = new JButton("Tester");
                buttonTest.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        PrinterHelper helper = new PrinterHelper();
                        helper.testPrinter(printer, null);
                    }
                });
                panelPrinter.add(buttonTest);
            }
            this.setTypePrinter(printer.getType(), jListTypes, jBand_rate, jListNamePort, jListNamePrinter, jAddressIP, jTicket_with, jTicket_num);
            LineBorder line = new LineBorder(Color.BLACK);
            EmptyBorder margin = new EmptyBorder(5, 15, 5, 15);
            CompoundBorder compound = new CompoundBorder(line, margin);
            panelPrinter.setBorder(compound);
            this.jPanelPrinters.add(panelPrinter);
        }
        if (AppLocal.modelCaisse == null || !AppLocal.modelCaisse.equals("Esclave") || this.oApp.getAppUserView().getUser().hasRoleMainetance()) {
            JPanel panelAddPrinter = this.addPanelAddPrinter();
            this.jPanelPrinters.add(panelAddPrinter);
        }
        this.jPanelPrinters.revalidate();
        this.jPanelPrinters.repaint();
        this.jScrollPaneImpression.getViewport().setView(this.jPanelPrinters);
    }

    private void restoreProperties() {
        if (this.config.delete()) {
            this.loadProperties();
        } else {
            new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Impossible de supprimer le fichier de configuration.", 1500, NPosition.CENTER);
        }
    }

    private int indexBaudrate(String baudrate) {
        int index = -1;
        int i = 0;
        for (String chaine : this.listBaudRate) {
            if (baudrate.equals(chaine)) {
                index = i;
                break;
            }
            ++i;
        }
        return index;
    }

    private void loadProperties() {
        for (PanelConfig c : this.m_panelconfig) {
            c.loadProperties(this.config);
        }
    }

    private void saveProperties() {
        for (PanelConfig c : this.m_panelconfig) {
            c.saveProperties(this.config);
        }
        try {
            this.config.save();
            JOptionPane.showMessageDialog(new JFrame(), "La configuration a \u00e9t\u00e9 sauvegard\u00e9. Les modifications prendront effet apr\u00e8s le red\u00e9marrage de l'application.", "Messages de caisse", 1);
            this.loadPaneRight(false);
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
            JMessageDialog.showMessage(new JFrame(), new MessageInf(-33554432, "Impossible de sauvegarder la configuration.", ex));
        }
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public String getTitle() {
        return "Configuration";
    }

    @Override
    public void activate() throws BasicException {
        try {
            System.out.println("+++++++++ AppLocal.RELOAD_PROPERTIES_AFTER_SYNCH : " + AppLocal.RELOAD_PROPERTIES_AFTER_SYNCH);
            System.out.println("+++++++++++++ first_load : " + this.first_load);
            if (!AppLocal.RELOAD_PROPERTIES_AFTER_SYNCH && !this.first_load) {
                System.out.println("++++++++++++ relaod params");
                this.config = AppConfig.getInstance(true, this.oApp.getProperties().getConfigFile());
                AppLocal.RELOAD_PROPERTIES_AFTER_SYNCH = true;
            }
            this.first_load = false;
            this.initConfigPanels();
            this.loadProperties();
            this.loadPaneRight(true);
            this.jValider.setVisible(false);
            this.jbtnSave.setVisible(true);
            for (PanelConfig c : this.m_panelconfig) {
                c.activate();
            }
            this.loadPrinters();
        }
        catch (IOException ex) {
            Logger.getLogger(JPanelConfiguration.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public boolean deactivate() {
        boolean haschanged = false;
        for (PanelConfig c : this.m_panelconfig) {
            if (!c.hasChanged()) continue;
            haschanged = true;
        }
        if (haschanged) {
            int res = JOptionPane.showConfirmDialog(new JFrame(), "Voulez vous sauvegarder les modifications avant de sortir?", "Message de l'\u00e9diteur", 1, 3);
            if (res == 0) {
                this.saveProperties();
                return true;
            }
            return res == 1;
        }
        return true;
    }

    private void initComponents() {
        this.jPanelLeft = new JPanel();
        this.jBtnDB = new JButton();
        this.jBtnGeneral = new JButton();
        this.jBtnLocal = new JButton();
        this.jBtnperipheral = new JButton();
        this.jBtnTicket = new JButton();
        this.jBtnPrint = new JButton();
        this.jBtnLicence = new JButton();
        this.jBtnBack = new JButton();
        this.jBtnArchives = new JButton();
        this.jBtnParams = new JButton();
        this.modules = new JButton();
        this.Borne = new JButton();
        this.multilangue = new JButton();
        this.jPanelRight = new JPanel();
        this.jPanelPrincipal = new JPanel();
        this.jPanelDatabase = new JPanel();
        this.jPanelGeneral = new JPanel();
        this.jPanelLocale = new JPanel();
        this.jPanelPeripheral = new JPanel();
        this.jPanelTicketSetup = new JPanel();
        this.jPanelImpression = new JPanel();
        this.jScrollPaneImpression = new JScrollPane();
        this.jPanelLicence = new JPanel();
        this.jPanelArchives = new JPanel();
        this.jPanelBack = new JPanel();
        this.jPanelParams = new JPanel();
        this.jPanelModules = new JPanel();
        this.jPanelBorne = new JPanel();
        this.jPanelMultiLangue = new JPanel();
        this.jPanelValidate = new JPanel();
        this.jbtnSave = new JButton();
        this.jValider = new JButton();
        this.setFont(new Font("Arial", 0, 12));
        this.setMinimumSize(new Dimension(0, 0));
        this.setPreferredSize(new Dimension(750, 500));
        this.setLayout(new BorderLayout());
        this.jPanelLeft.setPreferredSize(new Dimension(150, 500));
        this.jPanelLeft.setLayout(new GridLayout(0, 1, 3, 3));
        this.jBtnDB.setBackground(new Color(129, 207, 224));
        this.jBtnDB.setText("Base de donn\u00e9es");
        this.jBtnDB.setFocusPainted(false);
        this.jBtnDB.setPreferredSize(new Dimension(150, 40));
        this.jBtnDB.setRequestFocusEnabled(false);
        this.jBtnDB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelConfiguration.this.jBtnDBActionPerformed(evt);
            }
        });
        this.jPanelLeft.add(this.jBtnDB);
        this.jBtnGeneral.setBackground(new Color(129, 207, 224));
        this.jBtnGeneral.setText("General");
        this.jBtnGeneral.setFocusPainted(false);
        this.jBtnGeneral.setPreferredSize(new Dimension(150, 40));
        this.jBtnGeneral.setRequestFocusEnabled(false);
        this.jBtnGeneral.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelConfiguration.this.jBtnGeneralActionPerformed(evt);
            }
        });
        this.jPanelLeft.add(this.jBtnGeneral);
        this.jBtnLocal.setBackground(new Color(129, 207, 224));
        this.jBtnLocal.setText("Local");
        this.jBtnLocal.setFocusPainted(false);
        this.jBtnLocal.setPreferredSize(new Dimension(150, 40));
        this.jBtnLocal.setRequestFocusEnabled(false);
        this.jBtnLocal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelConfiguration.this.jBtnLocalActionPerformed(evt);
            }
        });
        this.jPanelLeft.add(this.jBtnLocal);
        this.jBtnperipheral.setBackground(new Color(129, 207, 224));
        this.jBtnperipheral.setText("P\u00e9riph\u00e9rique");
        this.jBtnperipheral.setFocusPainted(false);
        this.jBtnperipheral.setPreferredSize(new Dimension(150, 70));
        this.jBtnperipheral.setRequestFocusEnabled(false);
        this.jBtnperipheral.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelConfiguration.this.jBtnperipheralActionPerformed(evt);
            }
        });
        this.jPanelLeft.add(this.jBtnperipheral);
        this.jBtnTicket.setBackground(new Color(129, 207, 224));
        this.jBtnTicket.setText("Configuration Ticket");
        this.jBtnTicket.setFocusPainted(false);
        this.jBtnTicket.setPreferredSize(new Dimension(150, 40));
        this.jBtnTicket.setRequestFocusEnabled(false);
        this.jBtnTicket.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelConfiguration.this.jBtnTicketActionPerformed(evt);
            }
        });
        this.jPanelLeft.add(this.jBtnTicket);
        this.jBtnPrint.setBackground(new Color(129, 207, 224));
        this.jBtnPrint.setText("Impression");
        this.jBtnPrint.setFocusPainted(false);
        this.jBtnPrint.setPreferredSize(new Dimension(150, 40));
        this.jBtnPrint.setRequestFocusEnabled(false);
        this.jBtnPrint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelConfiguration.this.jBtnPrintActionPerformed(evt);
            }
        });
        this.jPanelLeft.add(this.jBtnPrint);
        this.jBtnLicence.setBackground(new Color(129, 207, 224));
        this.jBtnLicence.setText("Licence");
        this.jBtnLicence.setFocusPainted(false);
        this.jBtnLicence.setPreferredSize(new Dimension(150, 40));
        this.jBtnLicence.setRequestFocusEnabled(false);
        this.jBtnLicence.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelConfiguration.this.jBtnLicenceActionPerformed(evt);
            }
        });
        this.jPanelLeft.add(this.jBtnLicence);
        this.jBtnBack.setBackground(new Color(129, 207, 224));
        this.jBtnBack.setText("Backup");
        this.jBtnBack.setFocusPainted(false);
        this.jBtnBack.setPreferredSize(new Dimension(150, 40));
        this.jBtnBack.setRequestFocusEnabled(false);
        this.jBtnBack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelConfiguration.this.jBtnBackActionPerformed(evt);
            }
        });
        this.jPanelLeft.add(this.jBtnBack);
        this.jBtnArchives.setBackground(new Color(129, 207, 224));
        this.jBtnArchives.setText("Archives");
        this.jBtnArchives.setFocusPainted(false);
        this.jBtnArchives.setPreferredSize(new Dimension(150, 40));
        this.jBtnArchives.setRequestFocusEnabled(false);
        this.jBtnArchives.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelConfiguration.this.jBtnArchivesActionPerformed(evt);
            }
        });
        this.jPanelLeft.add(this.jBtnArchives);
        this.jBtnParams.setBackground(new Color(129, 207, 224));
        this.jBtnParams.setText("Param\u00e8tre avanc\u00e9");
        this.jBtnParams.setFocusPainted(false);
        this.jBtnParams.setPreferredSize(new Dimension(150, 40));
        this.jBtnParams.setRequestFocusEnabled(false);
        this.jBtnParams.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelConfiguration.this.jBtnParamsActionPerformed(evt);
            }
        });
        this.jPanelLeft.add(this.jBtnParams);
        this.modules.setBackground(new Color(129, 207, 224));
        this.modules.setText("Modules");
        this.modules.setFocusPainted(false);
        this.modules.setPreferredSize(new Dimension(150, 40));
        this.modules.setRequestFocusEnabled(false);
        this.modules.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelConfiguration.this.modulesActionPerformed(evt);
            }
        });
        this.jPanelLeft.add(this.modules);
        this.Borne.setBackground(new Color(129, 207, 224));
        this.Borne.setText("Borne");
        this.Borne.setFocusPainted(false);
        this.Borne.setPreferredSize(new Dimension(150, 40));
        this.Borne.setRequestFocusEnabled(false);
        this.Borne.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelConfiguration.this.BorneActionPerformed(evt);
            }
        });
        this.jPanelLeft.add(this.Borne);
        this.multilangue.setBackground(new Color(129, 207, 224));
        this.multilangue.setText("Images borne");
        this.multilangue.setFocusPainted(false);
        this.multilangue.setPreferredSize(new Dimension(150, 40));
        this.multilangue.setRequestFocusEnabled(false);
        this.multilangue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelConfiguration.this.multilangueActionPerformed(evt);
            }
        });
        this.jPanelLeft.add(this.multilangue);
        this.add((Component)this.jPanelLeft, "Before");
        this.jPanelRight.setLayout(new BorderLayout());
        this.jPanelPrincipal.setLayout(new BorderLayout());
        this.jPanelDatabase.setFont(new Font("Arial", 0, 12));
        this.jPanelDatabase.setPreferredSize(new Dimension(0, 400));
        this.jPanelDatabase.setLayout(new BoxLayout(this.jPanelDatabase, 2));
        this.jPanelPrincipal.add((Component)this.jPanelDatabase, "Center");
        this.jPanelGeneral.setFont(new Font("Arial", 0, 12));
        this.jPanelGeneral.setPreferredSize(new Dimension(0, 400));
        this.jPanelGeneral.setLayout(new BoxLayout(this.jPanelGeneral, 2));
        this.jPanelPrincipal.add((Component)this.jPanelGeneral, "Center");
        this.jPanelLocale.setFont(new Font("Arial", 0, 12));
        this.jPanelLocale.setPreferredSize(new Dimension(730, 400));
        this.jPanelLocale.setLayout(new BoxLayout(this.jPanelLocale, 2));
        this.jPanelPrincipal.add((Component)this.jPanelLocale, "Center");
        this.jPanelPeripheral.setFont(new Font("Arial", 0, 12));
        this.jPanelPeripheral.setPreferredSize(new Dimension(0, 400));
        this.jPanelPeripheral.setLayout(new BoxLayout(this.jPanelPeripheral, 2));
        this.jPanelPrincipal.add((Component)this.jPanelPeripheral, "Center");
        this.jPanelTicketSetup.setFont(new Font("Arial", 0, 12));
        this.jPanelTicketSetup.setPreferredSize(new Dimension(0, 400));
        this.jPanelTicketSetup.setLayout(new BoxLayout(this.jPanelTicketSetup, 2));
        this.jPanelPrincipal.add((Component)this.jPanelTicketSetup, "Center");
        this.jPanelImpression.setLayout(new BorderLayout());
        this.jPanelImpression.add((Component)this.jScrollPaneImpression, "Center");
        this.jPanelPrincipal.add((Component)this.jPanelImpression, "Center");
        this.jPanelLicence.setLayout(new BoxLayout(this.jPanelLicence, 2));
        this.jPanelPrincipal.add((Component)this.jPanelLicence, "Center");
        this.jPanelArchives.setLayout(new BoxLayout(this.jPanelArchives, 2));
        this.jPanelPrincipal.add((Component)this.jPanelArchives, "Center");
        this.jPanelBack.setLayout(new BoxLayout(this.jPanelBack, 2));
        this.jPanelPrincipal.add((Component)this.jPanelBack, "Center");
        this.jPanelParams.setLayout(new BoxLayout(this.jPanelParams, 2));
        this.jPanelPrincipal.add((Component)this.jPanelParams, "Center");
        this.jPanelModules.setLayout(new BoxLayout(this.jPanelModules, 2));
        this.jPanelPrincipal.add((Component)this.jPanelModules, "Center");
        this.jPanelBorne.setLayout(new BoxLayout(this.jPanelBorne, 2));
        this.jPanelPrincipal.add((Component)this.jPanelBorne, "Center");
        this.jPanelMultiLangue.setLayout(new BoxLayout(this.jPanelMultiLangue, 2));
        this.jPanelPrincipal.add((Component)this.jPanelMultiLangue, "Center");
        this.jPanelRight.add((Component)this.jPanelPrincipal, "Center");
        this.jbtnSave.setBackground(new Color(54, 215, 183));
        this.jbtnSave.setFont(new Font("Arial", 0, 12));
        this.jbtnSave.setText("Sauvegarder");
        this.jbtnSave.setFocusPainted(false);
        this.jbtnSave.setMaximumSize(new Dimension(70, 33));
        this.jbtnSave.setMinimumSize(new Dimension(70, 33));
        this.jbtnSave.setPreferredSize(new Dimension(200, 40));
        this.jbtnSave.setRequestFocusEnabled(false);
        this.jbtnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelConfiguration.this.jbtnSaveActionPerformed(evt);
            }
        });
        this.jPanelValidate.add(this.jbtnSave);
        this.jValider.setBackground(new Color(54, 215, 183));
        this.jValider.setText("Enregistrer les imprimantes");
        this.jValider.setFocusPainted(false);
        this.jValider.setPreferredSize(new Dimension(200, 40));
        this.jValider.setRequestFocusEnabled(false);
        this.jValider.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelConfiguration.this.jValiderActionPerformed(evt);
            }
        });
        this.jPanelValidate.add(this.jValider);
        this.jPanelRight.add((Component)this.jPanelValidate, "South");
        this.add((Component)this.jPanelRight, "Center");
    }

    private void jbtnSaveActionPerformed(ActionEvent evt) {
        if (this.currentPanelString.equals("jPanelBack")) {
            this.jPanelConfigBack.saveConfigBack();
        } else {
            this.saveProperties();
        }
    }

    private void jValiderActionPerformed(ActionEvent evt) {
        try {
            AppLocal.impression_management = true;
            for (PrinterInfo printer : this.printers) {
                printer.setWith(printer.getWidth_tmp());
            }
            this.dlSales.setPrinters(this.printers);
            this.printersDB = this.dlSales.getPrinters();
            AppLocal.printerCaisse = this.dlSales.getPrinterByID(1);
            this.printers = this.printersDB;
            this.loadPrinters();
            new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, "les informations d'impression sont enregistr\u00e9es.", 1500, NPosition.CENTER);
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
            ex.printStackTrace();
            new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Une erreur est servenue.", 1500, NPosition.CENTER);
        }
    }

    private void jBtnDBActionPerformed(ActionEvent evt) {
        this.loadPaneDataBase();
    }

    private void jBtnGeneralActionPerformed(ActionEvent evt) {
        this.loadPaneGeneral();
    }

    private void jBtnLocalActionPerformed(ActionEvent evt) {
        this.jPanelPrincipal.removeAll();
        this.currentPanelString = "jPanelLocale";
        this.jPanelPrincipal.add((Component)this.jPanelLocale, "Center");
        this.jPanelDatabase.setVisible(false);
        this.jPanelGeneral.setVisible(false);
        this.jPanelLocale.setVisible(true);
        this.jPanelPeripheral.setVisible(false);
        this.jPanelTicketSetup.setVisible(false);
        this.jPanelImpression.setVisible(false);
        this.jPanelLicence.setVisible(false);
        this.jPanelArchives.setVisible(false);
        this.jPanelBack.setVisible(false);
        this.jPanelParams.setVisible(false);
        this.jPanelModules.setVisible(false);
        this.jPanelBorne.setVisible(false);
        this.jPanelMultiLangue.setVisible(false);
        this.jPanelPrincipal.revalidate();
        this.jPanelPrincipal.repaint();
        this.jBtnDB.setBackground(new Color(129, 207, 224));
        this.jBtnGeneral.setBackground(new Color(129, 207, 224));
        this.jBtnLocal.setBackground(new Color(89, 171, 227));
        this.jBtnperipheral.setBackground(new Color(129, 207, 224));
        this.jBtnTicket.setBackground(new Color(129, 207, 224));
        this.jBtnPrint.setBackground(new Color(129, 207, 224));
        this.jBtnLicence.setBackground(new Color(129, 207, 224));
        this.jBtnArchives.setBackground(new Color(129, 207, 224));
        this.jPanelBack.setBackground(new Color(129, 207, 224));
        this.jBtnParams.setBackground(new Color(129, 207, 224));
        this.modules.setBackground(new Color(129, 207, 224));
        this.Borne.setBackground(new Color(129, 207, 224));
        this.multilangue.setBackground(new Color(129, 207, 224));
        this.jValider.setVisible(false);
        this.jbtnSave.setVisible(true);
        this.jBtnBack.setBackground(new Color(129, 207, 224));
    }

    private void jBtnperipheralActionPerformed(ActionEvent evt) {
        this.loadPanePeripheral();
    }

    private void jBtnTicketActionPerformed(ActionEvent evt) {
        this.jPanelPrincipal.removeAll();
        this.currentPanelString = "jPanelTicketSetup";
        this.jPanelPrincipal.add((Component)this.jPanelTicketSetup, "Center");
        this.jPanelDatabase.setVisible(false);
        this.jPanelGeneral.setVisible(false);
        this.jPanelLocale.setVisible(false);
        this.jPanelPeripheral.setVisible(false);
        this.jPanelTicketSetup.setVisible(true);
        this.jPanelImpression.setVisible(false);
        this.jPanelLicence.setVisible(false);
        this.jPanelArchives.setVisible(false);
        this.jPanelBack.setVisible(false);
        this.jPanelParams.setVisible(false);
        this.jPanelModules.setVisible(false);
        this.jPanelBorne.setVisible(false);
        this.jPanelMultiLangue.setVisible(false);
        this.jPanelPrincipal.revalidate();
        this.jPanelPrincipal.repaint();
        this.jBtnDB.setBackground(new Color(129, 207, 224));
        this.jBtnGeneral.setBackground(new Color(129, 207, 224));
        this.jBtnLocal.setBackground(new Color(129, 207, 224));
        this.jBtnperipheral.setBackground(new Color(129, 207, 224));
        this.jBtnTicket.setBackground(new Color(89, 171, 227));
        this.jBtnPrint.setBackground(new Color(129, 207, 224));
        this.jBtnLicence.setBackground(new Color(129, 207, 224));
        this.jBtnArchives.setBackground(new Color(129, 207, 224));
        this.jPanelBack.setBackground(new Color(129, 207, 224));
        this.jBtnParams.setBackground(new Color(129, 207, 224));
        this.modules.setBackground(new Color(129, 207, 224));
        this.Borne.setBackground(new Color(129, 207, 224));
        this.multilangue.setBackground(new Color(129, 207, 224));
        this.jValider.setVisible(false);
        this.jbtnSave.setVisible(true);
        this.jBtnBack.setBackground(new Color(129, 207, 224));
    }

    private void jBtnPrintActionPerformed(ActionEvent evt) {
        this.jPanelPrincipal.removeAll();
        this.currentPanelString = "jPanelImpression";
        this.jPanelPrincipal.add((Component)this.jPanelImpression, "Center");
        this.jPanelDatabase.setVisible(false);
        this.jPanelGeneral.setVisible(false);
        this.jPanelLocale.setVisible(false);
        this.jPanelPeripheral.setVisible(false);
        this.jPanelTicketSetup.setVisible(false);
        this.jPanelImpression.setVisible(true);
        this.jPanelLicence.setVisible(false);
        this.jPanelArchives.setVisible(false);
        this.jPanelBack.setVisible(false);
        this.jPanelParams.setVisible(false);
        this.jPanelModules.setVisible(false);
        this.jPanelBorne.setVisible(false);
        this.jPanelMultiLangue.setVisible(false);
        this.jPanelPrincipal.revalidate();
        this.jPanelPrincipal.repaint();
        this.jBtnDB.setBackground(new Color(129, 207, 224));
        this.jBtnGeneral.setBackground(new Color(129, 207, 224));
        this.jBtnLocal.setBackground(new Color(129, 207, 224));
        this.jBtnperipheral.setBackground(new Color(129, 207, 224));
        this.jBtnTicket.setBackground(new Color(129, 207, 224));
        this.jBtnPrint.setBackground(new Color(89, 171, 227));
        this.jBtnLicence.setBackground(new Color(129, 207, 224));
        this.jBtnArchives.setBackground(new Color(129, 207, 224));
        this.jPanelBack.setBackground(new Color(129, 207, 224));
        this.jBtnParams.setBackground(new Color(129, 207, 224));
        this.modules.setBackground(new Color(129, 207, 224));
        this.Borne.setBackground(new Color(129, 207, 224));
        this.multilangue.setBackground(new Color(129, 207, 224));
        this.jValider.setVisible(true);
        this.jbtnSave.setVisible(false);
        this.jBtnBack.setBackground(new Color(129, 207, 224));
    }

    private void jBtnLicenceActionPerformed(ActionEvent evt) {
        this.jPanelPrincipal.removeAll();
        this.currentPanelString = "jPanelLicence";
        try {
            this.licenseKeyGUI = new JPanelConfigLicence(this.dlSales);
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        this.jPanelLicence = this.licenseKeyGUI;
        this.jPanelPrincipal.add((Component)this.jPanelLicence, "Center");
        this.jPanelDatabase.setVisible(false);
        this.jPanelGeneral.setVisible(false);
        this.jPanelLocale.setVisible(false);
        this.jPanelPeripheral.setVisible(false);
        this.jPanelTicketSetup.setVisible(false);
        this.jPanelImpression.setVisible(false);
        this.jPanelLicence.setVisible(true);
        this.jPanelArchives.setVisible(false);
        this.jPanelBack.setVisible(false);
        this.jPanelParams.setVisible(false);
        this.jPanelModules.setVisible(false);
        this.jPanelBorne.setVisible(false);
        this.jPanelMultiLangue.setVisible(false);
        this.jPanelPrincipal.revalidate();
        this.jPanelPrincipal.repaint();
        this.jBtnDB.setBackground(new Color(129, 207, 224));
        this.jBtnGeneral.setBackground(new Color(129, 207, 224));
        this.jBtnLocal.setBackground(new Color(129, 207, 224));
        this.jBtnperipheral.setBackground(new Color(129, 207, 224));
        this.jBtnTicket.setBackground(new Color(129, 207, 224));
        this.jBtnPrint.setBackground(new Color(129, 207, 224));
        this.jBtnLicence.setBackground(new Color(89, 171, 227));
        this.jBtnArchives.setBackground(new Color(129, 207, 224));
        this.jPanelBack.setBackground(new Color(129, 207, 224));
        this.jBtnParams.setBackground(new Color(129, 207, 224));
        this.modules.setBackground(new Color(129, 207, 224));
        this.Borne.setBackground(new Color(129, 207, 224));
        this.multilangue.setBackground(new Color(129, 207, 224));
        this.jValider.setVisible(false);
        this.jbtnSave.setVisible(true);
        this.jBtnBack.setBackground(new Color(129, 207, 224));
    }

    private void jBtnArchivesActionPerformed(ActionEvent evt) {
        this.jPanelPrincipal.removeAll();
        this.jPanelPrincipal.add((Component)this.jPanelArchives, "Center");
        this.jPanelDatabase.setVisible(false);
        this.jPanelGeneral.setVisible(false);
        this.jPanelLocale.setVisible(false);
        this.jPanelPeripheral.setVisible(false);
        this.jPanelTicketSetup.setVisible(false);
        this.jPanelImpression.setVisible(false);
        this.jPanelLicence.setVisible(false);
        this.jPanelArchives.setVisible(true);
        this.jPanelBack.setVisible(false);
        this.jPanelParams.setVisible(false);
        this.jPanelModules.setVisible(false);
        this.jPanelBorne.setVisible(false);
        this.jPanelMultiLangue.setVisible(false);
        this.jPanelPrincipal.revalidate();
        this.jPanelPrincipal.repaint();
        this.jBtnDB.setBackground(new Color(129, 207, 224));
        this.jBtnGeneral.setBackground(new Color(129, 207, 224));
        this.jBtnLocal.setBackground(new Color(129, 207, 224));
        this.jBtnperipheral.setBackground(new Color(129, 207, 224));
        this.jBtnTicket.setBackground(new Color(129, 207, 224));
        this.jBtnPrint.setBackground(new Color(129, 207, 224));
        this.jBtnLicence.setBackground(new Color(129, 207, 224));
        this.jBtnArchives.setBackground(new Color(89, 171, 227));
        this.jBtnBack.setBackground(new Color(129, 207, 224));
        this.jBtnParams.setBackground(new Color(129, 207, 224));
        this.modules.setBackground(new Color(129, 207, 224));
        this.Borne.setBackground(new Color(129, 207, 224));
        this.multilangue.setBackground(new Color(129, 207, 224));
        this.jValider.setVisible(false);
        this.jbtnSave.setVisible(true);
        this.jBtnBack.setBackground(new Color(129, 207, 224));
    }

    private void jBtnBackActionPerformed(ActionEvent evt) {
        this.jPanelPrincipal.removeAll();
        this.currentPanelString = "jPanelBack";
        this.jPanelPrincipal.add((Component)this.jPanelBack, "Center");
        this.jPanelDatabase.setVisible(false);
        this.jPanelGeneral.setVisible(false);
        this.jPanelLocale.setVisible(false);
        this.jPanelPeripheral.setVisible(false);
        this.jPanelTicketSetup.setVisible(false);
        this.jPanelImpression.setVisible(false);
        this.jPanelLicence.setVisible(false);
        this.jPanelArchives.setVisible(false);
        this.jPanelBack.setVisible(true);
        this.jPanelParams.setVisible(false);
        this.jPanelModules.setVisible(false);
        this.jPanelBorne.setVisible(false);
        this.jPanelMultiLangue.setVisible(false);
        this.jPanelPrincipal.revalidate();
        this.jPanelPrincipal.repaint();
        this.jBtnDB.setBackground(new Color(129, 207, 224));
        this.jBtnGeneral.setBackground(new Color(129, 207, 224));
        this.jBtnLocal.setBackground(new Color(129, 207, 224));
        this.jBtnperipheral.setBackground(new Color(129, 207, 224));
        this.jBtnTicket.setBackground(new Color(129, 207, 224));
        this.jBtnPrint.setBackground(new Color(129, 207, 224));
        this.jBtnLicence.setBackground(new Color(129, 207, 224));
        this.jBtnArchives.setBackground(new Color(129, 207, 224));
        this.jBtnBack.setBackground(new Color(89, 171, 227));
        this.jBtnParams.setBackground(new Color(129, 207, 224));
        this.modules.setBackground(new Color(129, 207, 224));
        this.Borne.setBackground(new Color(129, 207, 224));
        this.multilangue.setBackground(new Color(129, 207, 224));
        this.jValider.setVisible(false);
        this.jbtnSave.setVisible(true);
    }

    private void jBtnParamsActionPerformed(ActionEvent evt) {
        this.jPanelPrincipal.removeAll();
        this.currentPanelString = "jPanelParams";
        this.jPanelPrincipal.add((Component)this.jPanelParams, "Center");
        this.jPanelDatabase.setVisible(false);
        this.jPanelGeneral.setVisible(false);
        this.jPanelLocale.setVisible(false);
        this.jPanelPeripheral.setVisible(false);
        this.jPanelTicketSetup.setVisible(false);
        this.jPanelImpression.setVisible(false);
        this.jPanelLicence.setVisible(false);
        this.jPanelArchives.setVisible(false);
        this.jPanelBack.setVisible(false);
        this.jPanelParams.setVisible(true);
        this.jPanelModules.setVisible(false);
        this.jPanelBorne.setVisible(false);
        this.jPanelMultiLangue.setVisible(false);
        this.jPanelPrincipal.revalidate();
        this.jPanelPrincipal.repaint();
        this.jBtnDB.setBackground(new Color(129, 207, 224));
        this.jBtnGeneral.setBackground(new Color(129, 207, 224));
        this.jBtnLocal.setBackground(new Color(129, 207, 224));
        this.jBtnperipheral.setBackground(new Color(129, 207, 224));
        this.jBtnTicket.setBackground(new Color(129, 207, 224));
        this.jBtnPrint.setBackground(new Color(129, 207, 224));
        this.jBtnLicence.setBackground(new Color(129, 207, 224));
        this.jBtnArchives.setBackground(new Color(129, 207, 224));
        this.jBtnBack.setBackground(new Color(129, 207, 224));
        this.jBtnParams.setBackground(new Color(89, 171, 227));
        this.modules.setBackground(new Color(129, 207, 224));
        this.Borne.setBackground(new Color(129, 207, 224));
        this.multilangue.setBackground(new Color(129, 207, 224));
        this.jValider.setVisible(false);
        this.jbtnSave.setVisible(true);
        this.paramsPanel.disapearUserParams();
    }

    private void modulesActionPerformed(ActionEvent evt) {
        this.jPanelPrincipal.removeAll();
        this.currentPanelString = "jPanelModules";
        this.jPanelPrincipal.add((Component)this.jPanelModules, "Center");
        this.jPanelDatabase.setVisible(false);
        this.jPanelGeneral.setVisible(false);
        this.jPanelLocale.setVisible(false);
        this.jPanelPeripheral.setVisible(false);
        this.jPanelTicketSetup.setVisible(false);
        this.jPanelImpression.setVisible(false);
        this.jPanelLicence.setVisible(false);
        this.jPanelArchives.setVisible(false);
        this.jPanelBack.setVisible(false);
        this.jPanelParams.setVisible(false);
        this.jPanelModules.setVisible(true);
        this.jPanelBorne.setVisible(false);
        this.jPanelMultiLangue.setVisible(false);
        this.jPanelPrincipal.revalidate();
        this.jPanelPrincipal.repaint();
        this.jBtnDB.setBackground(new Color(129, 207, 224));
        this.jBtnGeneral.setBackground(new Color(129, 207, 224));
        this.jBtnLocal.setBackground(new Color(129, 207, 224));
        this.jBtnperipheral.setBackground(new Color(129, 207, 224));
        this.jBtnTicket.setBackground(new Color(129, 207, 224));
        this.jBtnPrint.setBackground(new Color(129, 207, 224));
        this.jBtnLicence.setBackground(new Color(129, 207, 224));
        this.jBtnArchives.setBackground(new Color(129, 207, 224));
        this.jBtnBack.setBackground(new Color(129, 207, 224));
        this.jBtnParams.setBackground(new Color(129, 207, 224));
        this.modules.setBackground(new Color(89, 171, 227));
        this.Borne.setBackground(new Color(129, 207, 224));
        this.multilangue.setBackground(new Color(129, 207, 224));
        this.jValider.setVisible(false);
        this.jbtnSave.setVisible(true);
    }

    private void BorneActionPerformed(ActionEvent evt) {
        this.jPanelPrincipal.removeAll();
        this.currentPanelString = "jPanelBorne";
        this.jPanelPrincipal.add((Component)this.jPanelBorne, "Center");
        this.jPanelDatabase.setVisible(false);
        this.jPanelGeneral.setVisible(false);
        this.jPanelLocale.setVisible(false);
        this.jPanelPeripheral.setVisible(false);
        this.jPanelTicketSetup.setVisible(false);
        this.jPanelImpression.setVisible(false);
        this.jPanelLicence.setVisible(false);
        this.jPanelArchives.setVisible(false);
        this.jPanelBack.setVisible(false);
        this.jPanelParams.setVisible(false);
        this.jPanelModules.setVisible(false);
        this.jPanelBorne.setVisible(true);
        this.jPanelMultiLangue.setVisible(false);
        this.jPanelPrincipal.revalidate();
        this.jPanelPrincipal.repaint();
        this.jBtnDB.setBackground(new Color(129, 207, 224));
        this.jBtnGeneral.setBackground(new Color(129, 207, 224));
        this.jBtnLocal.setBackground(new Color(129, 207, 224));
        this.jBtnperipheral.setBackground(new Color(129, 207, 224));
        this.jBtnTicket.setBackground(new Color(129, 207, 224));
        this.jBtnPrint.setBackground(new Color(129, 207, 224));
        this.jBtnLicence.setBackground(new Color(129, 207, 224));
        this.jBtnArchives.setBackground(new Color(129, 207, 224));
        this.jBtnBack.setBackground(new Color(129, 207, 224));
        this.jBtnParams.setBackground(new Color(129, 207, 224));
        this.modules.setBackground(new Color(129, 207, 224));
        this.Borne.setBackground(new Color(89, 171, 227));
        this.multilangue.setBackground(new Color(129, 207, 224));
        this.jValider.setVisible(false);
        this.jbtnSave.setVisible(true);
    }

    private void multilangueActionPerformed(ActionEvent evt) {
        this.jPanelPrincipal.removeAll();
        this.currentPanelString = "jPanelMultiLangue";
        this.jPanelPrincipal.add((Component)this.jPanelMultiLangue, "Center");
        this.jPanelDatabase.setVisible(false);
        this.jPanelGeneral.setVisible(false);
        this.jPanelLocale.setVisible(false);
        this.jPanelPeripheral.setVisible(false);
        this.jPanelTicketSetup.setVisible(false);
        this.jPanelImpression.setVisible(false);
        this.jPanelLicence.setVisible(false);
        this.jPanelArchives.setVisible(false);
        this.jPanelBack.setVisible(false);
        this.jPanelParams.setVisible(false);
        this.jPanelModules.setVisible(false);
        this.jPanelBorne.setVisible(false);
        this.jPanelMultiLangue.setVisible(true);
        this.jPanelPrincipal.revalidate();
        this.jPanelPrincipal.repaint();
        this.jBtnDB.setBackground(new Color(129, 207, 224));
        this.jBtnGeneral.setBackground(new Color(129, 207, 224));
        this.jBtnLocal.setBackground(new Color(129, 207, 224));
        this.jBtnperipheral.setBackground(new Color(129, 207, 224));
        this.jBtnTicket.setBackground(new Color(129, 207, 224));
        this.jBtnPrint.setBackground(new Color(129, 207, 224));
        this.jBtnLicence.setBackground(new Color(129, 207, 224));
        this.jBtnArchives.setBackground(new Color(129, 207, 224));
        this.jBtnBack.setBackground(new Color(129, 207, 224));
        this.jBtnParams.setBackground(new Color(129, 207, 224));
        this.modules.setBackground(new Color(129, 207, 224));
        this.Borne.setBackground(new Color(129, 207, 224));
        this.multilangue.setBackground(new Color(89, 171, 227));
        this.jValider.setVisible(false);
        this.jbtnSave.setVisible(true);
    }

    private void loadPaneRight(boolean first_call) {
        boolean grid_layout = true;
        if (this.oApp.getAppUserView().getUser().hasRoleMainetance()) {
            if (first_call) {
                this.loadPaneDataBase();
            }
            this.jPanelLeft.removeAll();
            this.jPanelLeft.add(this.jBtnDB);
            this.jPanelLeft.add(this.jBtnGeneral);
            this.jPanelLeft.add(this.jBtnLocal);
            this.jPanelLeft.add(this.jBtnperipheral);
            this.jPanelLeft.add(this.jBtnTicket);
            this.jPanelLeft.add(this.jBtnPrint);
            this.jPanelLeft.add(this.jBtnLicence);
            this.jPanelLeft.add(this.jBtnBack);
            this.jPanelLeft.add(this.jBtnArchives);
            this.jPanelLeft.add(this.jBtnParams);
            this.jPanelLeft.add(this.modules);
            this.jPanelLeft.add(this.Borne);
            this.jPanelLeft.add(this.multilangue);
            this.jPanelLeft.revalidate();
            this.jPanelLeft.repaint();
        } else {
            if (first_call) {
                this.loadPaneGeneral();
            }
            this.jPanelLeft.removeAll();
            if (AppLocal.modelCaisse != null && AppLocal.modelCaisse.equals("Esclave")) {
                grid_layout = false;
                this.jPanelLeft.add(this.jBtnGeneral);
                this.jPanelLeft.add(this.jBtnperipheral);
                this.jPanelLeft.add(this.jBtnPrint);
                this.jPanelLeft.add(this.jBtnBack);
            } else {
                this.jPanelLeft.add(this.jBtnGeneral);
                this.jPanelLeft.add(this.jBtnperipheral);
                this.jPanelLeft.add(this.jBtnTicket);
                this.jPanelLeft.add(this.jBtnPrint);
                this.jPanelLeft.add(this.jBtnLicence);
                this.jPanelLeft.add(this.jBtnBack);
                this.jPanelLeft.add(this.jBtnArchives);
                this.jPanelLeft.add(this.jBtnParams);
                this.jPanelLeft.add(this.Borne);
                this.jPanelLeft.add(this.multilangue);
            }
            this.jPanelLeft.revalidate();
            this.jPanelLeft.repaint();
        }
        if (grid_layout) {
            this.jPanelLeft.setLayout(new GridLayout(0, 1, 3, 3));
        } else {
            this.jPanelLeft.setLayout(new FlowLayout());
        }
    }

    private void loadPaneDataBase() {
        this.jPanelPrincipal.removeAll();
        this.currentPanelString = "jPanelDatabase";
        this.jPanelPrincipal.add((Component)this.jPanelDatabase, "Center");
        this.jPanelDatabase.setVisible(true);
        this.jPanelGeneral.setVisible(false);
        this.jPanelLocale.setVisible(false);
        this.jPanelPeripheral.setVisible(false);
        this.jPanelTicketSetup.setVisible(false);
        this.jPanelImpression.setVisible(false);
        this.jPanelLicence.setVisible(false);
        this.jPanelArchives.setVisible(false);
        this.jPanelBack.setVisible(false);
        this.jPanelParams.setVisible(false);
        this.jPanelModules.setVisible(false);
        this.jPanelBorne.setVisible(false);
        this.jPanelPrincipal.revalidate();
        this.jPanelPrincipal.repaint();
        this.jBtnDB.setBackground(new Color(89, 171, 227));
        this.jBtnGeneral.setBackground(new Color(129, 207, 224));
        this.jBtnLocal.setBackground(new Color(129, 207, 224));
        this.jBtnperipheral.setBackground(new Color(129, 207, 224));
        this.jBtnTicket.setBackground(new Color(129, 207, 224));
        this.jBtnPrint.setBackground(new Color(129, 207, 224));
        this.jBtnLicence.setBackground(new Color(129, 207, 224));
        this.jBtnArchives.setBackground(new Color(129, 207, 224));
        this.jPanelBack.setBackground(new Color(129, 207, 224));
        this.jBtnParams.setBackground(new Color(129, 207, 224));
        this.modules.setBackground(new Color(129, 207, 224));
        this.Borne.setBackground(new Color(129, 207, 224));
        this.jValider.setVisible(false);
        this.jbtnSave.setVisible(true);
        this.jBtnBack.setBackground(new Color(129, 207, 224));
    }

    private void loadPanePeripheral() {
        this.jPanelPrincipal.removeAll();
        this.currentPanelString = "jPanelPeripheral";
        this.jPanelPrincipal.add((Component)this.jPanelPeripheral, "Center");
        this.jPanelDatabase.setVisible(false);
        this.jPanelGeneral.setVisible(false);
        this.jPanelLocale.setVisible(false);
        this.jPanelPeripheral.setVisible(true);
        this.jPanelTicketSetup.setVisible(false);
        this.jPanelImpression.setVisible(false);
        this.jPanelLicence.setVisible(false);
        this.jPanelArchives.setVisible(false);
        this.jPanelBack.setVisible(false);
        this.jPanelParams.setVisible(false);
        this.jPanelModules.setVisible(false);
        this.jPanelBorne.setVisible(false);
        this.jPanelPrincipal.revalidate();
        this.jPanelPrincipal.repaint();
        this.jBtnDB.setBackground(new Color(129, 207, 224));
        this.jBtnGeneral.setBackground(new Color(129, 207, 224));
        this.jBtnLocal.setBackground(new Color(129, 207, 224));
        this.jBtnperipheral.setBackground(new Color(89, 171, 227));
        this.jBtnTicket.setBackground(new Color(129, 207, 224));
        this.jBtnPrint.setBackground(new Color(129, 207, 224));
        this.jBtnLicence.setBackground(new Color(129, 207, 224));
        this.jBtnArchives.setBackground(new Color(129, 207, 224));
        this.jPanelBack.setBackground(new Color(129, 207, 224));
        this.jBtnParams.setBackground(new Color(129, 207, 224));
        this.modules.setBackground(new Color(129, 207, 224));
        this.Borne.setBackground(new Color(129, 207, 224));
        this.jValider.setVisible(false);
        this.jbtnSave.setVisible(true);
        this.jBtnBack.setBackground(new Color(129, 207, 224));
    }

    private int getWithPrinter(String model) {
        if (model != null) {
            switch (model) {
                case "X printer": {
                    return 48;
                }
                case "Aures": {
                    return 41;
                }
                case "Oxhoo": {
                    return 41;
                }
            }
            return 48;
        }
        return 0;
    }

    private void setWithPrinter(PrinterInfo printer, JTextField jTicket_with, String model) {
        if (printer.getWith() != 0) {
            jTicket_with.setText(String.valueOf(printer.getWith()));
            jTicket_with.setForeground(Color.BLACK);
            printer.setWidth_tmp(printer.getWith());
        } else if (model == null || model.equals("autre")) {
            jTicket_with.setText("larguer ticket");
            jTicket_with.setForeground(Color.GRAY);
            printer.setWidth_tmp(0);
        } else {
            int largeur = this.getWithPrinter(model);
            jTicket_with.setText(String.valueOf(largeur));
            jTicket_with.setForeground(Color.BLACK);
            printer.setWidth_tmp(largeur);
        }
    }

    private void loadJList(PrinterInfo printer, JComboBox<String> jListTypes, JComboBox<String> listModels, JComboBox<String> jBand_rate, JComboBox<String> jListNamePort) {
        if (printer.getTypePrinter().equals("label")) {
            listModels.addItem("SLCS(Bixolon)");
            listModels.addItem("EPL(Zebra)");
            listModels.addItem("Normal");
        } else {
            listModels.addItem("X printer");
            listModels.addItem("Aures");
            listModels.addItem("Oxhoo");
            listModels.addItem("autre");
        }
        jListTypes.addItem("USB");
        jListTypes.addItem("R\u00e9seau");
        jListTypes.addItem("Serial");
        jBand_rate.addItem("1200");
        jBand_rate.addItem("2400");
        jBand_rate.addItem("4800");
        jBand_rate.addItem("9600");
        jBand_rate.addItem("19200");
        jBand_rate.addItem("38400");
        jBand_rate.addItem("57600");
        jBand_rate.addItem("115200");
        jBand_rate.addItem("128000");
        jListNamePort.addItem("COM1");
        jListNamePort.addItem("COM2");
        jListNamePort.addItem("COM3");
        jListNamePort.addItem("COM4");
        jListNamePort.addItem("COM5");
        jListNamePort.addItem("COM6");
        jListNamePort.addItem("COM7");
        jListNamePort.addItem("COM8");
        jListNamePort.addItem("LPT1");
        jListNamePort.addItem("/dev/ttyS0");
        jListNamePort.addItem("/dev/ttyS1");
        jListNamePort.addItem("/dev/ttyS2");
        jListNamePort.addItem("/dev/ttyS3");
        jListNamePort.addItem("/dev/ttyS4");
        jListNamePort.addItem("/dev/ttyS5");
    }

    private void setTypePrinter(String type_printer, JComboBox<String> jListTypes, JComboBox<String> jBand_rate, JComboBox<String> jListNamePort, JComboBox<String> jListNamePrinter, JTextField jAddressIP, JTextField jTicket_with, JTextField jTicket_num) {
        if (type_printer != null) {
            switch (type_printer) {
                case "USB": {
                    jListTypes.setSelectedItem("USB");
                    jAddressIP.setVisible(false);
                    jBand_rate.setVisible(false);
                    jTicket_with.setVisible(true);
                    jTicket_num.setVisible(true);
                    jListNamePort.setVisible(false);
                    jListNamePrinter.setVisible(true);
                    break;
                }
                case "R\u00e9seau": {
                    jListNamePrinter.setVisible(false);
                    jBand_rate.setVisible(false);
                    jAddressIP.setVisible(true);
                    jTicket_with.setVisible(true);
                    jTicket_num.setVisible(true);
                    jListNamePort.setVisible(false);
                    jListNamePrinter.setVisible(false);
                    break;
                }
                case "Serial": {
                    jListNamePrinter.setVisible(false);
                    jAddressIP.setVisible(false);
                    jTicket_with.setVisible(true);
                    jTicket_num.setVisible(true);
                    jListTypes.setVisible(true);
                    jListNamePort.setVisible(true);
                    jBand_rate.setVisible(true);
                }
            }
        } else {
            jListTypes.setSelectedItem("USB");
            jAddressIP.setVisible(false);
            jBand_rate.setVisible(false);
            jTicket_with.setVisible(true);
            jTicket_num.setVisible(true);
            jListNamePort.setVisible(false);
            jListNamePrinter.setVisible(true);
            jListNamePrinter.setSelectedItem(null);
        }
    }

    private JPanel addPanelAddPrinter() {
        JPanel panelAddPrinter = new JPanel();
        panelAddPrinter.setLayout(new FlowLayout());
        panelAddPrinter.setPreferredSize(new Dimension(200, 350));
        JLabel labelimage = new JLabel();
        labelimage.setPreferredSize(new Dimension(100, 80));
        labelimage.setIcon(new ImageIcon(this.getClass().getResource("/com/openbravo/images/addPrinter.png")));
        labelimage.setHorizontalAlignment(0);
        JButton btn = new JButton();
        btn.setText("<html><body align='center' >Imprimante<br>pr\u00e9paration</body></html>");
        btn.setHorizontalAlignment(0);
        btn.setPreferredSize(new Dimension(150, 50));
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int numberPrinter = 1;
                for (PrinterInfo printerTmp : JPanelConfiguration.this.printers) {
                    if (!"kitchen".equals(printerTmp.getTypePrinter()) || !printerTmp.getName().contains("preparation")) continue;
                    ++numberPrinter;
                }
                PrinterInfo printer = new PrinterInfo(-1, "imprimante preparation" + numberPrinter, null, null, null, 0, 1, "kitchen", null, null, null);
                JPanelConfiguration.this.printers.add(printer);
                JPanelConfiguration.this.loadPrinters();
            }
        });
        JButton btnLabel = new JButton();
        btnLabel.setText("<html><body align='center'>Imprimante<br>\u00e9tiquette</body></html>");
        btnLabel.setHorizontalAlignment(0);
        btnLabel.setPreferredSize(new Dimension(150, 50));
        btnLabel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int numberPrinter = 1;
                for (PrinterInfo printerTmp : JPanelConfiguration.this.printers) {
                    if (!"label".equals(printerTmp.getTypePrinter())) continue;
                    ++numberPrinter;
                }
                PrinterInfo printer = new PrinterInfo(-1, "imprimante etiquette" + numberPrinter, null, null, null, 47, 1, "label", null, null, null);
                JPanelConfiguration.this.printers.add(printer);
                JPanelConfiguration.this.loadPrinters();
            }
        });
        panelAddPrinter.add(labelimage);
        panelAddPrinter.add(btn);
        panelAddPrinter.add(btnLabel);
        if (!this.config.getBooleanProperty("kitchen.composite").booleanValue()) {
            JButton btnEcranSuivi = new JButton();
            btnEcranSuivi.setText("Ecran de suivi");
            btnEcranSuivi.setHorizontalAlignment(0);
            btnEcranSuivi.setPreferredSize(new Dimension(150, 40));
            btnEcranSuivi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int numberPrinter = 1;
                    for (PrinterInfo printerTmp : JPanelConfiguration.this.printers) {
                        if (!"ecranSuivi".equals(printerTmp.getTypePrinter()) || !printerTmp.getName().contains("Ecran Suivi")) continue;
                        ++numberPrinter;
                    }
                    PrinterInfo printer = new PrinterInfo(-1, "Ecran Suivi" + numberPrinter, null, null, null, 40, 1, "ecranSuivi", null, null, null);
                    JPanelConfiguration.this.printers.add(printer);
                    AppLocal.printerEcranSuivi = printer;
                    JPanelConfiguration.this.loadPrinters();
                }
            });
            panelAddPrinter.add(btnEcranSuivi);
        }
        LineBorder line = new LineBorder(Color.BLACK);
        EmptyBorder margin = new EmptyBorder(5, 15, 5, 15);
        CompoundBorder compound = new CompoundBorder(line, margin);
        panelAddPrinter.setBorder(compound);
        return panelAddPrinter;
    }

    private void initConfigPanels() throws IOException, BasicException {
        Object panel = null;
        this.m_panelconfig.clear();
        if (AppLocal.modelCaisse != null && AppLocal.modelCaisse.equals("Esclave") && !this.oApp.getAppUserView().getUser().hasRoleMainetance()) {
            System.out.println("+++++++++++++ add pane manager slave");
            if (this.panelGeneral == null) {
                this.panelGeneral = new JPanelConfigGeneral(this.dlSales);
                this.jPanelGeneral.add(this.panelGeneral.getConfigComponent());
            }
            this.m_panelconfig.add(this.panelGeneral);
            if (this.panelPeripheral == null) {
                this.panelPeripheral = new JPanelConfigPeripheral(this.dlSales, this.oApp);
                this.jPanelPeripheral.add(this.panelPeripheral.getConfigComponent());
            }
            this.m_panelconfig.add(this.panelPeripheral);
            if (this.jPanelConfigBack == null) {
                this.jPanelConfigBack = new JPanelConfigBack(this.oApp);
                this.jPanelBack.add(this.jPanelConfigBack.getConfigComponent());
            }
            this.m_panelconfig.add(this.jPanelConfigBack);
        } else {
            System.out.println("+++++++++++++ add pane manager/ user admin");
            if (this.panelDataBase == null) {
                this.panelDataBase = new JPanelConfigDatabase(false);
                this.jPanelDatabase.add(this.panelDataBase.getConfigComponent());
            }
            this.m_panelconfig.add(this.panelDataBase);
            if (this.panelGeneral == null) {
                this.panelGeneral = new JPanelConfigGeneral(this.dlSales);
                this.jPanelGeneral.add(this.panelGeneral.getConfigComponent());
            }
            this.m_panelconfig.add(this.panelGeneral);
            if (this.panelLocale == null) {
                this.panelLocale = new JPanelConfigLocale(this.dlSales);
                this.jPanelLocale.add(this.panelLocale.getConfigComponent());
            }
            this.m_panelconfig.add(this.panelLocale);
            if (this.panelPeripheral == null) {
                this.panelPeripheral = new JPanelConfigPeripheral(this.dlSales, this.oApp);
                this.jPanelPeripheral.add(this.panelPeripheral.getConfigComponent());
            }
            this.m_panelconfig.add(this.panelPeripheral);
            if (this.panelTicketSetup == null) {
                this.panelTicketSetup = new JPanelTicketSetup(this.dlSales);
                this.jPanelTicketSetup.add(this.panelTicketSetup.getConfigComponent());
            }
            this.m_panelconfig.add(this.panelTicketSetup);
            if (this.licenseKeyGUI == null) {
                this.licenseKeyGUI = new JPanelConfigLicence();
                this.jPanelLicence.add(this.licenseKeyGUI.getConfigComponent());
            }
            if (this.jPanelConfigBack == null) {
                this.jPanelConfigBack = new JPanelConfigBack(this.oApp);
                this.jPanelBack.add(this.jPanelConfigBack.getConfigComponent());
            }
            this.m_panelconfig.add(this.jPanelConfigBack);
            if (this.paramsPanel == null) {
                this.paramsPanel = new JPanelConfigParams(this.dlSales);
                this.jPanelParams.add(this.paramsPanel.getConfigComponent());
            }
            this.m_panelconfig.add(this.paramsPanel);
            if (this.panelModules == null) {
                this.panelModules = new JPanelConfigModules(this.dlSystem, this.dlSales);
                this.jPanelModules.add(this.panelModules.getConfigComponent());
            }
            this.m_panelconfig.add(this.panelModules);
            if (this.panelBorne == null) {
                this.panelBorne = new JPanelBorne(this.dlSales);
                this.jPanelBorne.add(this.panelBorne.getConfigComponent());
            }
            this.m_panelconfig.add(this.panelBorne);
            if (this.panelArchives == null) {
                this.panelArchives = new JPanelConfigArchive(this.dlSales);
                this.jPanelArchives.add(this.panelArchives.getConfigComponent());
            }
            this.m_panelconfig.add(this.panelArchives);
            if (this.panelMultiLangue == null) {
                this.panelMultiLangue = new JPanelMultiLangue(this.dlSales);
                this.jPanelMultiLangue.add(this.panelMultiLangue.getConfigComponent());
            }
            this.m_panelconfig.add(this.panelMultiLangue);
        }
    }

    private void loadPaneGeneral() {
        this.jPanelPrincipal.removeAll();
        this.currentPanelString = "jPanelGeneral";
        this.jPanelPrincipal.add((Component)this.jPanelGeneral, "Center");
        this.jPanelDatabase.setVisible(false);
        this.jPanelGeneral.setVisible(true);
        this.jPanelLocale.setVisible(false);
        this.jPanelPeripheral.setVisible(false);
        this.jPanelTicketSetup.setVisible(false);
        this.jPanelImpression.setVisible(false);
        this.jPanelLicence.setVisible(false);
        this.jPanelArchives.setVisible(false);
        this.jPanelBack.setVisible(false);
        this.jPanelParams.setVisible(false);
        this.jPanelModules.setVisible(false);
        this.jPanelBorne.setVisible(false);
        this.jPanelMultiLangue.setVisible(false);
        this.jPanelPrincipal.revalidate();
        this.jPanelPrincipal.repaint();
        this.jBtnDB.setBackground(new Color(129, 207, 224));
        this.jBtnGeneral.setBackground(new Color(89, 171, 227));
        this.jBtnLocal.setBackground(new Color(129, 207, 224));
        this.jBtnperipheral.setBackground(new Color(129, 207, 224));
        this.jBtnTicket.setBackground(new Color(129, 207, 224));
        this.jBtnPrint.setBackground(new Color(129, 207, 224));
        this.jBtnLicence.setBackground(new Color(129, 207, 224));
        this.jBtnArchives.setBackground(new Color(129, 207, 224));
        this.jPanelBack.setBackground(new Color(129, 207, 224));
        this.jBtnParams.setBackground(new Color(129, 207, 224));
        this.modules.setBackground(new Color(129, 207, 224));
        this.Borne.setBackground(new Color(129, 207, 224));
        this.multilangue.setBackground(new Color(129, 207, 224));
        this.jValider.setVisible(false);
        this.jbtnSave.setVisible(true);
        this.jBtnBack.setBackground(new Color(129, 207, 224));
    }
}

