/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.config;

import com.openbravo.data.user.DirtyManager;
import com.openbravo.pos.config.PanelConfig;
import com.openbravo.pos.forms.AppConfig;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class JPanelConfigSystem
extends JPanel
implements PanelConfig {
    private final Font FONT_ARIAL_PLAIN_12 = new Font("Arial", 0, 12);
    private final Font FONT_ARIAL_PLAIN_14 = new Font("Arial", 0, 14);
    private final String[] DEFAULT_COLOR_LIST = new String[]{"black", "blue", "grey", "green", "orange", "red", "white", "yellow"};
    private final Dimension defaultDimension = new Dimension(0, 25);
    private final Dimension minimumSize = new Dimension(0, 0);
    private DirtyManager dirty = new DirtyManager();
    private JCheckBox jCheckPrice00;
    private JCheckBox jCloseCashbtn;
    private JComboBox jCustomerColour;
    private JLabel jLabelCustomerTextColour;
    private JLabel jLabelInactiveTime;
    private JLabel jLabelServerTextColour;
    private JLabel jLabelTableNameTextColour;
    private JLabel jLabelTimedMessage;
    private JCheckBox jMarineOpt;
    private JCheckBox jMoveAMountBoxToTop;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JComboBox jTableNameColour;
    private JCheckBox jTaxIncluded;
    private JTextField jTextAutoLogoffTime;
    private JComboBox jWaiterColour;
    private JCheckBox jchkAutoLogoff;
    private JCheckBox jchkAutoLogoffToTables;
    private JCheckBox jchkShowCustomerDetails;
    private JCheckBox jchkShowWaiterDetails;
    private JCheckBox jchkTextOverlay;

    protected JPanelConfigSystem() {
        this.initComponents();
        this.jTextAutoLogoffTime.getDocument().addDocumentListener(this.dirty);
        this.jMarineOpt.addActionListener(this.dirty);
        this.jchkTextOverlay.addActionListener(this.dirty);
        this.jchkAutoLogoff.addActionListener(this.dirty);
        this.jchkAutoLogoffToTables.addActionListener(this.dirty);
        this.jchkShowCustomerDetails.addActionListener(this.dirty);
        this.jchkShowWaiterDetails.addActionListener(this.dirty);
        this.jCustomerColour.addActionListener(this.dirty);
        this.jWaiterColour.addActionListener(this.dirty);
        this.jTableNameColour.addActionListener(this.dirty);
        this.jTaxIncluded.addActionListener(this.dirty);
        this.jCheckPrice00.addActionListener(this.dirty);
        this.jMoveAMountBoxToTop.addActionListener(this.dirty);
        this.jCloseCashbtn.addActionListener(this.dirty);
    }

    @Override
    public boolean hasChanged() {
        return this.dirty.isDirty();
    }

    @Override
    public Component getConfigComponent() {
        return this;
    }

    @Override
    public void loadProperties(AppConfig config) {
        String timerCheck = config.getProperty("till.autotimer");
        if (timerCheck == null) {
            config.setProperty("till.autotimer", "100");
        }
        this.jTextAutoLogoffTime.setText(config.getProperty("till.autotimer").toString());
        this.jMarineOpt.setSelected(Boolean.valueOf(config.getProperty("till.marineoption")));
        this.jchkShowCustomerDetails.setSelected(Boolean.valueOf(config.getProperty("table.showcustomerdetails")));
        this.jchkShowWaiterDetails.setSelected(Boolean.valueOf(config.getProperty("table.showwaiterdetails")));
        this.jchkTextOverlay.setSelected(Boolean.valueOf(config.getProperty("payments.textoverlay")));
        this.jchkAutoLogoff.setSelected(Boolean.valueOf(config.getProperty("till.autoLogoff")));
        this.jchkAutoLogoffToTables.setSelected(Boolean.valueOf(config.getProperty("till.autoLogoffrestaurant")));
        this.jTaxIncluded.setSelected(Boolean.valueOf(config.getProperty("till.taxincluded")));
        this.jCheckPrice00.setSelected(Boolean.valueOf(config.getProperty("till.pricewith00")));
        this.jMoveAMountBoxToTop.setSelected(Boolean.valueOf(config.getProperty("till.amountattop")));
        this.jCloseCashbtn.setSelected(Boolean.valueOf(config.getProperty("screen.600800")));
        if (config.getProperty("table.customercolour") == null) {
            this.jCustomerColour.setSelectedItem("blue");
        } else {
            this.jCustomerColour.setSelectedItem(config.getProperty("table.customercolour"));
        }
        if (config.getProperty("table.waitercolour") == null) {
            this.jWaiterColour.setSelectedItem("red");
        } else {
            this.jWaiterColour.setSelectedItem(config.getProperty("table.waitercolour"));
        }
        if (config.getProperty("table.tablecolour") == null) {
            this.jTableNameColour.setSelectedItem("black");
        } else {
            this.jTableNameColour.setSelectedItem(config.getProperty("table.tablecolour"));
        }
        if (this.jchkAutoLogoff.isSelected()) {
            this.jchkAutoLogoffToTables.setVisible(true);
            this.jLabelInactiveTime.setVisible(true);
            this.jLabelTimedMessage.setVisible(true);
            this.jTextAutoLogoffTime.setVisible(true);
        } else {
            this.jchkAutoLogoffToTables.setVisible(false);
            this.jLabelInactiveTime.setVisible(false);
            this.jLabelTimedMessage.setVisible(false);
            this.jTextAutoLogoffTime.setVisible(false);
        }
        this.dirty.setDirty(false);
    }

    @Override
    public void saveProperties(AppConfig config) {
        config.setProperty("till.autotimer", this.jTextAutoLogoffTime.getText());
        config.setProperty("till.marineoption", Boolean.toString(this.jMarineOpt.isSelected()));
        config.setProperty("table.showcustomerdetails", Boolean.toString(this.jchkShowCustomerDetails.isSelected()));
        config.setProperty("table.showwaiterdetails", Boolean.toString(this.jchkShowWaiterDetails.isSelected()));
        config.setProperty("payments.textoverlay", Boolean.toString(this.jchkTextOverlay.isSelected()));
        config.setProperty("till.autoLogoff", Boolean.toString(this.jchkAutoLogoff.isSelected()));
        config.setProperty("till.autoLogoffrestaurant", Boolean.toString(this.jchkAutoLogoffToTables.isSelected()));
        config.setProperty("table.customercolour", this.jCustomerColour.getSelectedItem().toString());
        config.setProperty("table.waitercolour", this.jWaiterColour.getSelectedItem().toString());
        config.setProperty("table.tablecolour", this.jTableNameColour.getSelectedItem().toString());
        config.setProperty("till.taxincluded", Boolean.toString(this.jTaxIncluded.isSelected()));
        config.setProperty("till.pricewith00", Boolean.toString(this.jCheckPrice00.isSelected()));
        config.setProperty("till.amountattop", Boolean.toString(this.jMoveAMountBoxToTop.isSelected()));
        config.setProperty("screen.600800", Boolean.toString(this.jCloseCashbtn.isSelected()));
        this.dirty.setDirty(false);
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.jchkAutoLogoff = new JCheckBox();
        this.jchkAutoLogoffToTables = new JCheckBox();
        this.jTextAutoLogoffTime = new JTextField();
        this.jLabelInactiveTime = new JLabel();
        this.jLabelTimedMessage = new JLabel();
        this.jPanel3 = new JPanel();
        this.jchkShowCustomerDetails = new JCheckBox();
        this.jchkShowWaiterDetails = new JCheckBox();
        this.jLabelCustomerTextColour = new JLabel();
        this.jCustomerColour = new JComboBox();
        this.jLabelServerTextColour = new JLabel();
        this.jWaiterColour = new JComboBox();
        this.jLabelTableNameTextColour = new JLabel();
        this.jTableNameColour = new JComboBox();
        this.jPanel4 = new JPanel();
        this.jMarineOpt = new JCheckBox();
        this.jCloseCashbtn = new JCheckBox();
        this.jCheckPrice00 = new JCheckBox();
        this.jchkTextOverlay = new JCheckBox();
        this.jTaxIncluded = new JCheckBox();
        this.jMoveAMountBoxToTop = new JCheckBox();
        this.setPreferredSize(new Dimension(650, 450));
        ResourceBundle bundle = ResourceBundle.getBundle("pos_messages");
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), bundle.getString("label.autologoffpanel"), 0, 0, new Font("Arial", 1, 12), new Color(102, 102, 102)));
        this.jPanel2.setLayout(null);
        this.jchkAutoLogoff.setFont(this.FONT_ARIAL_PLAIN_12);
        this.jchkAutoLogoff.setText(bundle.getString("label.autologonoff"));
        this.jchkAutoLogoff.setMaximumSize(new Dimension(0, 25));
        this.jchkAutoLogoff.setMinimumSize(new Dimension(0, 0));
        this.jchkAutoLogoff.setPreferredSize(new Dimension(0, 25));
        this.jchkAutoLogoff.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelConfigSystem.this.jchkAutoLogoffActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.jchkAutoLogoff);
        this.jchkAutoLogoff.setBounds(10, 20, 190, 25);
        this.jchkAutoLogoffToTables.setFont(new Font("Arial", 0, 12));
        this.jchkAutoLogoffToTables.setText(bundle.getString("label.autoloffrestaurant"));
        this.jchkAutoLogoffToTables.setMaximumSize(new Dimension(0, 25));
        this.jchkAutoLogoffToTables.setMinimumSize(new Dimension(0, 0));
        this.jchkAutoLogoffToTables.setPreferredSize(new Dimension(0, 25));
        this.jPanel2.add(this.jchkAutoLogoffToTables);
        this.jchkAutoLogoffToTables.setBounds(200, 20, 260, 25);
        this.jTextAutoLogoffTime.setFont(new Font("Arial", 0, 12));
        this.jTextAutoLogoffTime.setText("0");
        this.jTextAutoLogoffTime.setMaximumSize(new Dimension(0, 25));
        this.jTextAutoLogoffTime.setMinimumSize(new Dimension(0, 0));
        this.jTextAutoLogoffTime.setPreferredSize(new Dimension(0, 25));
        this.jPanel2.add(this.jTextAutoLogoffTime);
        this.jTextAutoLogoffTime.setBounds(200, 50, 50, 25);
        this.jLabelInactiveTime.setFont(new Font("Arial", 0, 12));
        this.jLabelInactiveTime.setText(bundle.getString("label.autolofftime"));
        this.jLabelInactiveTime.setMaximumSize(new Dimension(0, 25));
        this.jLabelInactiveTime.setMinimumSize(new Dimension(0, 0));
        this.jLabelInactiveTime.setPreferredSize(new Dimension(0, 25));
        this.jPanel2.add(this.jLabelInactiveTime);
        this.jLabelInactiveTime.setBounds(30, 50, 170, 25);
        this.jLabelTimedMessage.setFont(new Font("Arial", 0, 12));
        this.jLabelTimedMessage.setText(bundle.getString("label.autologoffzero"));
        this.jLabelTimedMessage.setMaximumSize(new Dimension(0, 25));
        this.jLabelTimedMessage.setMinimumSize(new Dimension(0, 0));
        this.jLabelTimedMessage.setPreferredSize(new Dimension(0, 25));
        this.jPanel2.add(this.jLabelTimedMessage);
        this.jLabelTimedMessage.setBounds(260, 50, 190, 25);
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), bundle.getString("label.tabledisplayoptions"), 0, 0, new Font("Arial", 1, 12), new Color(102, 102, 102)));
        this.jPanel3.setLayout(null);
        this.jchkShowCustomerDetails.setFont(new Font("Arial", 0, 12));
        this.jchkShowCustomerDetails.setText(bundle.getString("label.tableshowcustomerdetails"));
        this.jchkShowCustomerDetails.setMaximumSize(new Dimension(0, 25));
        this.jchkShowCustomerDetails.setMinimumSize(new Dimension(0, 0));
        this.jchkShowCustomerDetails.setPreferredSize(new Dimension(0, 25));
        this.jPanel3.add(this.jchkShowCustomerDetails);
        this.jchkShowCustomerDetails.setBounds(10, 20, 220, 25);
        this.jchkShowWaiterDetails.setFont(new Font("Arial", 0, 12));
        this.jchkShowWaiterDetails.setText(bundle.getString("label.tableshowwaiterdetails"));
        this.jchkShowWaiterDetails.setMaximumSize(new Dimension(0, 25));
        this.jchkShowWaiterDetails.setMinimumSize(new Dimension(0, 0));
        this.jchkShowWaiterDetails.setPreferredSize(new Dimension(0, 25));
        this.jPanel3.add(this.jchkShowWaiterDetails);
        this.jchkShowWaiterDetails.setBounds(10, 60, 220, 23);
        this.jLabelCustomerTextColour.setFont(new Font("Arial", 0, 12));
        this.jLabelCustomerTextColour.setText(bundle.getString("label.textcolourcustomer"));
        this.jLabelCustomerTextColour.setMaximumSize(new Dimension(0, 25));
        this.jLabelCustomerTextColour.setMinimumSize(new Dimension(0, 0));
        this.jLabelCustomerTextColour.setPreferredSize(new Dimension(0, 25));
        this.jPanel3.add(this.jLabelCustomerTextColour);
        this.jLabelCustomerTextColour.setBounds(240, 20, 130, 25);
        this.jCustomerColour.setFont(new Font("Arial", 0, 14));
        this.jCustomerColour.setModel(new DefaultComboBoxModel<String>(new String[]{"black", "blue", "grey", "green", "orange", "red", "white", "yellow"}));
        this.jCustomerColour.setMaximumSize(new Dimension(0, 25));
        this.jCustomerColour.setMinimumSize(new Dimension(0, 0));
        this.jCustomerColour.setPreferredSize(new Dimension(0, 25));
        this.jCustomerColour.setSelectedItem("blue");
        this.jCustomerColour.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelConfigSystem.this.jCustomerColourActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.jCustomerColour);
        this.jCustomerColour.setBounds(380, 20, 200, 30);
        this.jLabelServerTextColour.setFont(new Font("Arial", 0, 12));
        this.jLabelServerTextColour.setText(bundle.getString("label.textcolourwaiter"));
        this.jLabelServerTextColour.setMaximumSize(new Dimension(0, 25));
        this.jLabelServerTextColour.setMinimumSize(new Dimension(0, 0));
        this.jLabelServerTextColour.setPreferredSize(new Dimension(0, 25));
        this.jPanel3.add(this.jLabelServerTextColour);
        this.jLabelServerTextColour.setBounds(240, 60, 130, 25);
        this.jWaiterColour.setFont(this.FONT_ARIAL_PLAIN_14);
        this.jWaiterColour.setModel(new DefaultComboBoxModel<String>(new String[]{"black", "blue", "grey", "green", "orange", "red", "white", "yellow"}));
        this.jWaiterColour.setMaximumSize(new Dimension(0, 25));
        this.jWaiterColour.setMinimumSize(new Dimension(0, 0));
        this.jWaiterColour.setPreferredSize(new Dimension(0, 25));
        this.jPanel3.add(this.jWaiterColour);
        this.jWaiterColour.setBounds(380, 60, 200, 30);
        this.jLabelTableNameTextColour.setFont(new Font("Arial", 0, 12));
        this.jLabelTableNameTextColour.setText(bundle.getString("label.textclourtablename"));
        this.jLabelTableNameTextColour.setMaximumSize(new Dimension(0, 25));
        this.jLabelTableNameTextColour.setMinimumSize(new Dimension(0, 0));
        this.jLabelTableNameTextColour.setPreferredSize(new Dimension(0, 25));
        this.jPanel3.add(this.jLabelTableNameTextColour);
        this.jLabelTableNameTextColour.setBounds(240, 100, 130, 30);
        this.jTableNameColour.setFont(new Font("Arial", 0, 14));
        this.jTableNameColour.setModel(new DefaultComboBoxModel<String>(new String[]{"black", "blue", "grey", "green", "orange", "red", "white", "yellow"}));
        this.jTableNameColour.setMaximumSize(new Dimension(0, 25));
        this.jTableNameColour.setMinimumSize(new Dimension(0, 0));
        this.jTableNameColour.setPreferredSize(new Dimension(0, 25));
        this.jPanel3.add(this.jTableNameColour);
        this.jTableNameColour.setBounds(380, 100, 200, 30);
        this.jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), bundle.getString("label.general"), 0, 0, new Font("Arial", 1, 12), new Color(102, 102, 102)));
        this.jPanel4.setLayout(null);
        this.jMarineOpt.setFont(new Font("Arial", 0, 12));
        this.jMarineOpt.setText(bundle.getString("label.marine"));
        this.jMarineOpt.setMaximumSize(new Dimension(0, 25));
        this.jMarineOpt.setMinimumSize(new Dimension(0, 0));
        this.jMarineOpt.setPreferredSize(new Dimension(180, 30));
        this.jPanel4.add(this.jMarineOpt);
        this.jMarineOpt.setBounds(10, 20, 180, 30);
        this.jCloseCashbtn.setFont(new Font("Arial", 0, 12));
        this.jCloseCashbtn.setText(bundle.getString("message.systemclosecash"));
        this.jCloseCashbtn.setHorizontalAlignment(2);
        this.jCloseCashbtn.setMaximumSize(new Dimension(0, 25));
        this.jCloseCashbtn.setMinimumSize(new Dimension(0, 0));
        this.jCloseCashbtn.setPreferredSize(new Dimension(180, 30));
        this.jPanel4.add(this.jCloseCashbtn);
        this.jCloseCashbtn.setBounds(210, 20, 180, 30);
        this.jCheckPrice00.setFont(new Font("Arial", 0, 12));
        this.jCheckPrice00.setText(bundle.getString("label.pricewith00"));
        this.jCheckPrice00.setToolTipText("");
        this.jCheckPrice00.setMaximumSize(new Dimension(0, 25));
        this.jCheckPrice00.setMinimumSize(new Dimension(0, 0));
        this.jCheckPrice00.setPreferredSize(new Dimension(180, 30));
        this.jCheckPrice00.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelConfigSystem.this.jCheckPrice00ActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.jCheckPrice00);
        this.jCheckPrice00.setBounds(410, 20, 180, 30);
        this.jchkTextOverlay.setFont(this.FONT_ARIAL_PLAIN_12);
        this.jchkTextOverlay.setText(bundle.getString("label.currencybutton"));
        this.jchkTextOverlay.setHorizontalAlignment(2);
        this.jchkTextOverlay.setMaximumSize(new Dimension(0, 25));
        this.jchkTextOverlay.setMinimumSize(new Dimension(0, 0));
        this.jchkTextOverlay.setPreferredSize(new Dimension(180, 30));
        this.jPanel4.add(this.jchkTextOverlay);
        this.jchkTextOverlay.setBounds(10, 50, 180, 30);
        this.jTaxIncluded.setFont(new Font("Arial", 0, 12));
        this.jTaxIncluded.setText(bundle.getString("label.taxincluded"));
        this.jTaxIncluded.setMaximumSize(new Dimension(0, 25));
        this.jTaxIncluded.setMinimumSize(new Dimension(0, 0));
        this.jTaxIncluded.setPreferredSize(new Dimension(180, 30));
        this.jPanel4.add(this.jTaxIncluded);
        this.jTaxIncluded.setBounds(210, 50, 180, 30);
        this.jMoveAMountBoxToTop.setFont(new Font("Arial", 0, 12));
        this.jMoveAMountBoxToTop.setText(bundle.getString("label.inputamount"));
        this.jMoveAMountBoxToTop.setMaximumSize(new Dimension(0, 25));
        this.jMoveAMountBoxToTop.setMinimumSize(new Dimension(0, 0));
        this.jMoveAMountBoxToTop.setPreferredSize(new Dimension(180, 30));
        this.jPanel4.add(this.jMoveAMountBoxToTop);
        this.jMoveAMountBoxToTop.setBounds(410, 50, 180, 30);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, -2, 600, -2).addComponent(this.jPanel3, -2, 600, -2).addComponent(this.jPanel4, -2, 600, -2))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel2, -2, 90, -2).addGap(0, 0, 0).addComponent(this.jPanel3, -2, 140, -2).addGap(0, 0, 0).addComponent(this.jPanel4, -2, 90, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void jchkAutoLogoffActionPerformed(ActionEvent evt) {
        if (this.jchkAutoLogoff.isSelected()) {
            this.jchkAutoLogoffToTables.setVisible(true);
            this.jLabelInactiveTime.setVisible(true);
            this.jLabelTimedMessage.setVisible(true);
            this.jTextAutoLogoffTime.setVisible(true);
        } else {
            this.jchkAutoLogoffToTables.setVisible(false);
            this.jLabelInactiveTime.setVisible(false);
            this.jLabelTimedMessage.setVisible(false);
            this.jTextAutoLogoffTime.setVisible(false);
        }
    }

    private void jCheckPrice00ActionPerformed(ActionEvent evt) {
    }

    private void jCustomerColourActionPerformed(ActionEvent evt) {
    }

    @Override
    public void activate() {
    }
}

