/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.config;

import com.openbravo.beans.JFlowPanel;
import com.openbravo.dao.DataLogicSales;
import com.openbravo.data.loader.LocalRes;
import com.openbravo.data.user.DirtyManager;
import com.openbravo.pos.config.PanelConfig;
import com.openbravo.pos.config.ParametersConfig;
import com.openbravo.pos.config.ParametersPrinter;
import com.openbravo.pos.forms.AppConfig;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.AppView;
import com.openbravo.pos.notify.NPosition;
import com.openbravo.pos.notify.NotifyType;
import com.openbravo.pos.notify.NotifyWindow;
import com.openbravo.pos.ticket.PhotoDispaly;
import com.openbravo.pos.util.FilerUtils;
import com.openbravo.pos.util.ImagesUtils;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.pos.util.ReportUtils;
import com.openbravo.pos.util.StringParser;
import fr.protactile.procaisse.tpeCB.TPECBConcert;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javafx.application.Platform;
import javafx.stage.FileChooser;
import javax.imageio.ImageIO;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.io.FileUtils;

public class JPanelConfigPeripheral
extends JPanel
implements PanelConfig {
    private DirtyManager dirty = new DirtyManager();
    private ParametersConfig printer1printerparams;
    private ParametersConfig printer2printerparams;
    private ParametersConfig printer3printerparams;
    private ParametersConfig printer4printerparams;
    private ParametersConfig printer5printerparams;
    private ParametersConfig printer6printerparams;
    private DataLogicSales dlSales;
    private JFlowPanel jPanelPhotos;
    private List<PhotoDispaly> photos;
    private static File m_fCurrentDirectory = null;
    private FilerUtils m_FilerUtils = FilerUtils.getInstance();
    private AppView m_App;
    private int MAX_SIZE_FILE = 0x200000;
    private String driveBasketBanner;
    private ImagesUtils imageutils = new ImagesUtils();
    private JButton btnUpdateDriveBasketBanner;
    private JCheckBox hideDriveVoiceMessagePane;
    private JButton jButton1;
    private JLabel jLabel1;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel30;
    private JLabel jLabelAfficheur;
    private JLabel jLabelDriveBasketBanner;
    private JLabel jLabelMessage;
    private JLabel jLabelTimer;
    private JPanel jPanel13;
    private JPanel jPanel16;
    private JPanel jPanel17;
    private JPanel jPanel19;
    private JPanel jPanel20;
    private JPanel jPanel24;
    private JPanel jPanelAfficheur;
    private JPanel jPanelBasketButtonMainPane;
    private JPanel jPanelDriveBannerMainPane;
    private JPanel jPanelExistImage8;
    private JPanel jPanelImage10;
    private JPanel jPanelImages;
    private JPanel jPanelMessage;
    private JPanel jPanelScale;
    private JPanel jPanelScanner;
    private JPanel jPanelScanner3;
    private JPanel jPanelTimer;
    private JPanel jPanelVoiceMessageMainPane;
    private JPanel jPanelcnDisplay;
    private JPanel jPanelserialDisplay;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPhotos;
    private JComboBox jcboConnDisplay;
    private JComboBox jcboMachineDisplay;
    private JComboBox jcboMachineScale;
    private JComboBox jcboMachineScanner;
    private JComboBox jcboSerialDisplay;
    private JComboBox jcboSerialScale;
    private JComboBox jcboSerialScanner;
    private JLabel jlblConnDisplay;
    private JLabel jlblDisplayPort;
    private JLabel jlblPrinterPort4;
    private JLabel jlblPrinterPort5;
    private JSpinner jtimeSlide;
    private JPanel m_jScaleParams;
    private JPanel m_jScannerParams;
    private JTextArea messageWelcome;
    private JCheckBox showDriveBasketOnlyByClick;

    public JPanelConfigPeripheral(DataLogicSales dlSales, AppView m_App) {
        this.m_App = m_App;
        this.initComponents();
        this.jPanelScale.setVisible(false);
        this.jPanelScanner.setVisible(false);
        this.dlSales = dlSales;
        this.jPanelPhotos = new JFlowPanel();
        this.jScrollPhotos.getViewport().setView(null);
        String[] printernames = ReportUtils.getPrintNames();
        this.jcboMachineDisplay.addActionListener(this.dirty);
        this.jcboConnDisplay.addActionListener(this.dirty);
        this.jcboSerialDisplay.addActionListener(this.dirty);
        this.printer1printerparams = new ParametersPrinter(printernames);
        this.printer1printerparams.addDirtyManager(this.dirty);
        this.printer2printerparams = new ParametersPrinter(printernames);
        this.printer2printerparams.addDirtyManager(this.dirty);
        this.printer3printerparams = new ParametersPrinter(printernames);
        this.printer3printerparams.addDirtyManager(this.dirty);
        this.printer4printerparams = new ParametersPrinter(printernames);
        this.printer4printerparams.addDirtyManager(this.dirty);
        this.printer5printerparams = new ParametersPrinter(printernames);
        this.printer5printerparams.addDirtyManager(this.dirty);
        this.printer6printerparams = new ParametersPrinter(printernames);
        this.printer6printerparams.addDirtyManager(this.dirty);
        this.jcboMachineScale.addActionListener(this.dirty);
        this.jcboSerialScale.addActionListener(this.dirty);
        this.jcboMachineScanner.addActionListener(this.dirty);
        this.jcboSerialScanner.addActionListener(this.dirty);
        this.jcboMachineDisplay.addItem("aucune");
        this.jcboMachineDisplay.addItem("afficheur VFD");
        this.jcboMachineDisplay.addItem("Double \u00e9cran");
        this.jcboMachineDisplay.addItem("Drive");
        this.jcboConnDisplay.addItem("serial");
        this.jcboConnDisplay.addItem("file");
        this.jcboSerialDisplay.addItem("COM1");
        this.jcboSerialDisplay.addItem("COM2");
        this.jcboSerialDisplay.addItem("COM3");
        this.jcboSerialDisplay.addItem("COM4");
        this.jcboSerialDisplay.addItem("COM5");
        this.jcboSerialDisplay.addItem("COM6");
        this.jcboSerialDisplay.addItem("COM7");
        this.jcboSerialDisplay.addItem("COM8");
        this.jcboSerialDisplay.addItem("LPT1");
        this.jcboSerialDisplay.addItem("/dev/ttyS0");
        this.jcboSerialDisplay.addItem("/dev/ttyS1");
        this.jcboSerialDisplay.addItem("/dev/ttyS2");
        this.jcboSerialDisplay.addItem("/dev/ttyS3");
        this.jcboSerialDisplay.addItem("/dev/ttyS4");
        this.jcboSerialDisplay.addItem("/dev/ttyS5");
        this.jcboMachineScale.addItem("Not defined");
        this.jcboMachineScale.addItem("screen");
        this.jcboMachineScale.addItem("casiopd1");
        this.jcboMachineScale.addItem("caspdII");
        this.jcboMachineScale.addItem("dialog1");
        this.jcboMachineScale.addItem("samsungesp");
        this.jcboSerialScale.addItem("COM1");
        this.jcboSerialScale.addItem("COM2");
        this.jcboSerialScale.addItem("COM3");
        this.jcboSerialScale.addItem("COM4");
        this.jcboSerialScale.addItem("COM5");
        this.jcboSerialScale.addItem("COM6");
        this.jcboSerialScale.addItem("COM7");
        this.jcboSerialScale.addItem("COM8");
        this.jcboSerialScale.addItem("/dev/ttyS0");
        this.jcboSerialScale.addItem("/dev/ttyS1");
        this.jcboSerialScale.addItem("/dev/ttyS2");
        this.jcboSerialScale.addItem("/dev/ttyS3");
        this.jcboSerialScale.addItem("/dev/ttyS4");
        this.jcboSerialScale.addItem("/dev/ttyS5");
        this.jcboMachineScanner.addItem("Not defined");
        this.jcboMachineScanner.addItem("scanpal2");
        this.jcboSerialScanner.addItem("COM1");
        this.jcboSerialScanner.addItem("COM2");
        this.jcboSerialScanner.addItem("COM3");
        this.jcboSerialScanner.addItem("COM4");
        this.jcboSerialScanner.addItem("COM5");
        this.jcboSerialScanner.addItem("COM6");
        this.jcboSerialScanner.addItem("COM7");
        this.jcboSerialScanner.addItem("COM8");
        this.jcboSerialScanner.addItem("/dev/ttyS0");
        this.jcboSerialScanner.addItem("/dev/ttyS1");
        this.jcboSerialScanner.addItem("/dev/ttyS2");
        this.jcboSerialScanner.addItem("/dev/ttyS3");
        this.jcboSerialScanner.addItem("/dev/ttyS4");
        this.jcboSerialScanner.addItem("/dev/ttyS5");
        try {
            this.photos = dlSales.getAllPhoto();
            this.load();
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void load() throws IOException {
        this.jPanelPhotos.removeAll();
        for (final PhotoDispaly photo : this.photos) {
            JPanel panelPhoto = new JPanel();
            panelPhoto.setLayout(new FlowLayout());
            panelPhoto.setPreferredSize(new Dimension(100, 86));
            JPanel panelFoooter = new JPanel();
            panelFoooter.setLayout(new BorderLayout());
            panelFoooter.setPreferredSize(new Dimension(100, 22));
            JButton btnDelete = new JButton();
            btnDelete.setIcon(new ImageIcon(this.getClass().getResource("/com/openbravo/images/deletePhoto.png")));
            btnDelete.setPreferredSize(new Dimension(31, 31));
            btnDelete.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    int dialogButton = 0;
                    int dialogResult = JOptionPane.showConfirmDialog(new JFrame(), "vous voulez vraiment supprimer cet image ?", "Warning", dialogButton);
                    if (dialogResult == 0) {
                        try {
                            JPanelConfigPeripheral.this.dlSales.deletePhoto(photo.getId());
                            JPanelConfigPeripheral.this.photos = JPanelConfigPeripheral.this.dlSales.getAllPhoto();
                            JPanelConfigPeripheral.this.load();
                        }
                        catch (Exception ex) {
                            LogToFile.log("severe", ex.getMessage(), ex);
                        }
                        new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, "image supprim\u00e9.", 1500, NPosition.CENTER);
                    }
                }
            });
            panelFoooter.add((Component)btnDelete, "Center");
            try {
                JLabel labelImage = new JLabel();
                File image = this.m_FilerUtils.getFileFullPath("images/photosDisplay/" + photo.getPath());
                if (!image.exists()) continue;
                labelImage.setHorizontalAlignment(0);
                labelImage.setPreferredSize(new Dimension(100, 60));
                BufferedImage img = ImageIO.read(image);
                if (img == null) continue;
                Image newImg = img.getScaledInstance(100, 60, 4);
                ImageIcon newImc = new ImageIcon(newImg);
                labelImage.setIcon(newImc);
                panelPhoto.add(labelImage);
                panelPhoto.add(panelFoooter);
                this.jPanelPhotos.add(panelPhoto);
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
        JPanel panelAddPhoto = new JPanel();
        panelAddPhoto.setLayout(new FlowLayout());
        panelAddPhoto.setPreferredSize(new Dimension(150, 86));
        JButton btn = new JButton();
        btn.setText("Choisir Image");
        btn.setHorizontalAlignment(0);
        btn.setPreferredSize(new Dimension(140, 50));
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PhotoDispaly newPhoto = new PhotoDispaly();
                JFileChooser fc = new JFileChooser(m_fCurrentDirectory);
                fc.addChoosableFileFilter(FilerUtils.PICTURE_FILE_FILTER);
                fc.setAcceptAllFileFilterUsed(true);
                if (fc.showOpenDialog(new JFrame()) == 0) {
                    try {
                        String path = fc.getSelectedFile().getAbsolutePath().toString();
                        String name = fc.getSelectedFile().getName();
                        String ext = name.substring(name.lastIndexOf(".") + 1);
                        if (path != null) {
                            File directory = JPanelConfigPeripheral.this.m_FilerUtils.getFileFullPath("images/photosDisplay");
                            FileUtils.forceMkdir((File)directory);
                            String url = directory.getPath();
                            File dest = new File(url + "/image" + JPanelConfigPeripheral.this.photos.size() + "." + ext);
                            if (!dest.exists()) {
                                dest.createNewFile();
                            }
                            FileUtils.copyFile((File)new File(path), (File)dest);
                            newPhoto.setPath("image" + JPanelConfigPeripheral.this.photos.size() + "." + ext);
                            JPanelConfigPeripheral.this.dlSales.addPhoto(newPhoto);
                            JPanelConfigPeripheral.this.photos = JPanelConfigPeripheral.this.dlSales.getAllPhoto();
                            JPanelConfigPeripheral.this.load();
                        }
                    }
                    catch (Exception ex) {
                        LogToFile.log("severe", ex.getMessage(), ex);
                    }
                }
            }
        });
        panelAddPhoto.add((Component)btn, "Center");
        this.jPanelPhotos.add(panelAddPhoto);
        this.jPanelPhotos.revalidate();
        this.jPanelPhotos.repaint();
        this.jScrollPhotos.getViewport().setView(this.jPanelPhotos);
    }

    @Override
    public boolean hasChanged() {
        return this.dirty.isDirty();
    }

    @Override
    public Component getConfigComponent() {
        return this;
    }

    @Override
    public void loadProperties(AppConfig config) {
        String sparam;
        StringParser p = new StringParser(config.getProperty("machine.display"));
        switch (sparam = this.unifySerialInterface(p.nextToken(':'))) {
            case "epson": {
                this.jcboMachineDisplay.setSelectedIndex(1);
                this.jcboConnDisplay.setSelectedItem(this.unifySerialInterface(p.nextToken(',')));
                this.jcboSerialDisplay.setSelectedItem(p.nextToken(','));
                break;
            }
            default: {
                if ("window".equals(sparam)) {
                    this.jcboMachineDisplay.setSelectedIndex(2);
                    break;
                }
                if ("window_drive".equals(sparam)) {
                    this.jcboMachineDisplay.setSelectedIndex(3);
                    break;
                }
                this.jcboMachineDisplay.setSelectedItem(sparam);
            }
        }
        p = new StringParser(config.getProperty("machine.scale"));
        sparam = p.nextToken(':');
        this.jcboMachineScale.setSelectedItem(sparam);
        if ("casiopd1".equals(sparam) || "caspdII".equals(sparam) || "dialog1".equals(sparam) || "samsungesp".equals(sparam)) {
            this.jcboSerialScale.setSelectedItem(p.nextToken(','));
        }
        this.hideDriveVoiceMessagePane.setSelected(config.getBooleanProperty("hide.drive.screen.voice.message"));
        this.driveBasketBanner = config.getProperty("drive.basket.banner.img");
        if (this.driveBasketBanner != null && !this.driveBasketBanner.isEmpty()) {
            try {
                this.loadDriveBasketBanner();
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
        this.showDriveBasketOnlyByClick.setSelected(config.getBooleanProperty("show.drive.basket.only.by.click"));
        p = new StringParser(config.getProperty("machine.scanner"));
        sparam = p.nextToken(':');
        this.jcboMachineScanner.setSelectedItem(sparam);
        if ("scanpal2".equals(sparam)) {
            this.jcboSerialScanner.setSelectedItem(p.nextToken(','));
        }
        this.messageWelcome.setText(config.getProperty("message.welcome"));
        String timeSlide = config.getStringPropertyWithDefaultValue("time.slide", "0");
        this.jtimeSlide.setValue(Integer.parseInt(timeSlide == null ? "0" : timeSlide));
        this.dirty.setDirty(false);
    }

    @Override
    public void saveProperties(AppConfig config) {
        String sMachineDisplay;
        config.setProperty("message.welcome", this.messageWelcome.getText());
        switch (sMachineDisplay = this.comboValue(this.jcboMachineDisplay.getSelectedItem())) {
            case "afficheur VFD": {
                config.setProperty("machine.display", "epson:" + this.comboValue(this.jcboConnDisplay.getSelectedItem()) + "," + this.comboValue(this.jcboSerialDisplay.getSelectedItem()));
                break;
            }
            case "Double \u00e9cran": {
                config.setProperty("machine.display", "window");
                break;
            }
            case "Drive": {
                config.setProperty("machine.display", "window_drive");
                break;
            }
            default: {
                config.setProperty("machine.display", sMachineDisplay);
            }
        }
        String sMachineScale = this.comboValue(this.jcboMachineScale.getSelectedItem());
        if ("casiopd1".equals(sMachineScale) || "caspdII".equals(sMachineScale) || "dialog1".equals(sMachineScale) || "samsungesp".equals(sMachineScale)) {
            config.setProperty("machine.scale", sMachineScale + ":" + this.comboValue(this.jcboSerialScale.getSelectedItem()));
        } else {
            config.setProperty("machine.scale", sMachineScale);
        }
        String sMachineScanner = this.comboValue(this.jcboMachineScanner.getSelectedItem());
        if ("scanpal2".equals(sMachineScanner)) {
            config.setProperty("machine.scanner", sMachineScanner + ":" + this.comboValue(this.jcboSerialScanner.getSelectedItem()));
        } else {
            config.setProperty("machine.scanner", sMachineScanner);
        }
        config.setProperty("time.slide", this.jtimeSlide.getValue().toString());
        if (sMachineDisplay.equals("Drive")) {
            config.setProperty("hide.drive.screen.voice.message", this.hideDriveVoiceMessagePane.isSelected() ? "yes" : "no");
            config.setProperty("drive.basket.banner.img", this.driveBasketBanner);
            config.setProperty("show.drive.basket.only.by.click", this.showDriveBasketOnlyByClick.isSelected() ? "yes" : "no");
        }
        this.dirty.setDirty(false);
    }

    private String unifySerialInterface(String sparam) {
        return "rxtx".equals(sparam) ? "serial" : sparam;
    }

    private String comboValue(Object value) {
        return value == null ? "" : value.toString();
    }

    @Override
    public void activate() {
    }

    private void initComponents() {
        this.jPanel13 = new JPanel();
        this.jPanelAfficheur = new JPanel();
        this.jLabelAfficheur = new JLabel();
        this.jcboMachineDisplay = new JComboBox();
        this.jPanelcnDisplay = new JPanel();
        this.jlblConnDisplay = new JLabel();
        this.jcboConnDisplay = new JComboBox();
        this.jPanelserialDisplay = new JPanel();
        this.jlblDisplayPort = new JLabel();
        this.jcboSerialDisplay = new JComboBox();
        this.jButton1 = new JButton();
        this.jPanelMessage = new JPanel();
        this.jLabelMessage = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.messageWelcome = new JTextArea();
        this.jPanelTimer = new JPanel();
        this.jLabelTimer = new JLabel();
        this.jtimeSlide = new JSpinner();
        this.jPanelImages = new JPanel();
        this.jLabel1 = new JLabel();
        this.jScrollPhotos = new JScrollPane();
        this.jPanelScale = new JPanel();
        this.jLabel12 = new JLabel();
        this.jcboMachineScale = new JComboBox();
        this.m_jScaleParams = new JPanel();
        this.jPanel16 = new JPanel();
        this.jPanel17 = new JPanel();
        this.jlblPrinterPort4 = new JLabel();
        this.jcboSerialScale = new JComboBox();
        this.jPanelScanner = new JPanel();
        this.jLabel13 = new JLabel();
        this.jcboMachineScanner = new JComboBox();
        this.m_jScannerParams = new JPanel();
        this.jPanel19 = new JPanel();
        this.jlblPrinterPort5 = new JLabel();
        this.jcboSerialScanner = new JComboBox();
        this.jPanel24 = new JPanel();
        this.jPanelBasketButtonMainPane = new JPanel();
        this.showDriveBasketOnlyByClick = new JCheckBox();
        this.jPanelVoiceMessageMainPane = new JPanel();
        this.hideDriveVoiceMessagePane = new JCheckBox();
        this.jPanelScanner3 = new JPanel();
        this.jPanelDriveBannerMainPane = new JPanel();
        this.jPanel20 = new JPanel();
        this.jLabel30 = new JLabel();
        this.jPanelImage10 = new JPanel();
        this.jPanelExistImage8 = new JPanel();
        this.jLabelDriveBasketBanner = new JLabel();
        this.btnUpdateDriveBasketBanner = new JButton();
        this.setFont(new Font("Arial", 0, 12));
        this.setMinimumSize(new Dimension(800, 43));
        this.setPreferredSize(new Dimension(700, 400));
        this.setLayout(new BorderLayout());
        this.jPanel13.setPreferredSize(new Dimension(700, 400));
        this.jPanelAfficheur.setPreferredSize(new Dimension(900, 40));
        this.jPanelAfficheur.setLayout(new FlowLayout(0));
        this.jLabelAfficheur.setFont(new Font("Arial", 0, 12));
        this.jLabelAfficheur.setText("Afficheur client");
        this.jLabelAfficheur.setPreferredSize(new Dimension(200, 25));
        this.jPanelAfficheur.add(this.jLabelAfficheur);
        this.jcboMachineDisplay.setFont(new Font("Arial", 0, 14));
        this.jcboMachineDisplay.setCursor(new Cursor(0));
        this.jcboMachineDisplay.setPreferredSize(new Dimension(300, 30));
        this.jcboMachineDisplay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelConfigPeripheral.this.jcboMachineDisplayActionPerformed(evt);
            }
        });
        this.jPanelAfficheur.add(this.jcboMachineDisplay);
        this.jPanel13.add(this.jPanelAfficheur);
        this.jPanelcnDisplay.setPreferredSize(new Dimension(900, 40));
        this.jPanelcnDisplay.setLayout(new FlowLayout(0));
        this.jlblConnDisplay.setFont(new Font("Arial", 0, 12));
        this.jlblConnDisplay.setText("Mode");
        this.jlblConnDisplay.setPreferredSize(new Dimension(200, 25));
        this.jPanelcnDisplay.add(this.jlblConnDisplay);
        this.jcboConnDisplay.setFont(new Font("Arial", 0, 12));
        this.jcboConnDisplay.setPreferredSize(new Dimension(300, 30));
        this.jcboConnDisplay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelConfigPeripheral.this.jcboConnDisplayActionPerformed(evt);
            }
        });
        this.jPanelcnDisplay.add(this.jcboConnDisplay);
        this.jPanel13.add(this.jPanelcnDisplay);
        this.jPanelserialDisplay.setPreferredSize(new Dimension(900, 40));
        this.jPanelserialDisplay.setLayout(new FlowLayout(0));
        this.jlblDisplayPort.setFont(new Font("Arial", 0, 12));
        this.jlblDisplayPort.setText("Port");
        this.jlblDisplayPort.setPreferredSize(new Dimension(200, 25));
        this.jPanelserialDisplay.add(this.jlblDisplayPort);
        this.jcboSerialDisplay.setEditable(true);
        this.jcboSerialDisplay.setFont(new Font("Arial", 0, 12));
        this.jcboSerialDisplay.setPreferredSize(new Dimension(300, 30));
        this.jPanelserialDisplay.add(this.jcboSerialDisplay);
        this.jButton1.setText("tester");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelConfigPeripheral.this.jButton1ActionPerformed(evt);
            }
        });
        this.jPanelserialDisplay.add(this.jButton1);
        this.jPanel13.add(this.jPanelserialDisplay);
        this.jPanelMessage.setPreferredSize(new Dimension(900, 50));
        this.jPanelMessage.setLayout(new FlowLayout(0));
        this.jLabelMessage.setFont(new Font("Tahoma", 0, 12));
        this.jLabelMessage.setText("Message Afficheur Client");
        this.jLabelMessage.setPreferredSize(new Dimension(200, 30));
        this.jPanelMessage.add(this.jLabelMessage);
        this.jScrollPane1.setPreferredSize(new Dimension(300, 38));
        this.messageWelcome.setColumns(20);
        this.messageWelcome.setRows(5);
        this.jScrollPane1.setViewportView(this.messageWelcome);
        this.jPanelMessage.add(this.jScrollPane1);
        this.jPanel13.add(this.jPanelMessage);
        this.jPanelTimer.setPreferredSize(new Dimension(900, 40));
        this.jPanelTimer.setLayout(new FlowLayout(0));
        this.jLabelTimer.setFont(new Font("Tahoma", 0, 12));
        this.jLabelTimer.setText("Temps de slide");
        this.jLabelTimer.setPreferredSize(new Dimension(200, 30));
        this.jPanelTimer.add(this.jLabelTimer);
        this.jtimeSlide.setModel(new SpinnerNumberModel());
        this.jtimeSlide.setCursor(new Cursor(0));
        this.jtimeSlide.setPreferredSize(new Dimension(300, 30));
        this.jPanelTimer.add(this.jtimeSlide);
        this.jPanel13.add(this.jPanelTimer);
        this.jPanelImages.setPreferredSize(new Dimension(900, 100));
        this.jPanelImages.setLayout(new FlowLayout(0));
        this.jLabel1.setPreferredSize(new Dimension(200, 30));
        this.jPanelImages.add(this.jLabel1);
        this.jScrollPhotos.setPreferredSize(new Dimension(590, 95));
        this.jPanelImages.add(this.jScrollPhotos);
        this.jPanel13.add(this.jPanelImages);
        this.jPanelScale.setPreferredSize(new Dimension(900, 40));
        this.jPanelScale.setLayout(new FlowLayout(0));
        this.jLabel12.setFont(new Font("Arial", 0, 12));
        this.jLabel12.setText("Balance");
        this.jLabel12.setPreferredSize(new Dimension(200, 30));
        this.jPanelScale.add(this.jLabel12);
        this.jcboMachineScale.setFont(new Font("Arial", 0, 14));
        this.jcboMachineScale.setCursor(new Cursor(0));
        this.jcboMachineScale.setPreferredSize(new Dimension(300, 30));
        this.jcboMachineScale.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelConfigPeripheral.this.jcboMachineScaleActionPerformed(evt);
            }
        });
        this.jPanelScale.add(this.jcboMachineScale);
        this.m_jScaleParams.setPreferredSize(new Dimension(200, 25));
        this.m_jScaleParams.setLayout(new CardLayout());
        this.m_jScaleParams.add((Component)this.jPanel16, "empty");
        this.jlblPrinterPort4.setFont(new Font("Arial", 0, 12));
        this.jlblPrinterPort4.setText(AppLocal.getIntString("label.machineprinterport"));
        this.jlblPrinterPort4.setPreferredSize(new Dimension(50, 25));
        this.jcboSerialScale.setEditable(true);
        this.jcboSerialScale.setFont(new Font("Arial", 0, 12));
        this.jcboSerialScale.setPreferredSize(new Dimension(100, 23));
        GroupLayout jPanel17Layout = new GroupLayout(this.jPanel17);
        this.jPanel17.setLayout(jPanel17Layout);
        jPanel17Layout.setHorizontalGroup(jPanel17Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel17Layout.createSequentialGroup().addContainerGap().addComponent(this.jlblPrinterPort4, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jcboSerialScale, -2, -1, -2).addContainerGap(32, Short.MAX_VALUE)));
        jPanel17Layout.setVerticalGroup(jPanel17Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel17Layout.createSequentialGroup().addGroup(jPanel17Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jcboSerialScale, -2, -1, -2).addComponent(this.jlblPrinterPort4, -2, -1, -2)).addGap(0, 0, 0)));
        this.m_jScaleParams.add((Component)this.jPanel17, "comm");
        this.jPanelScale.add(this.m_jScaleParams);
        this.jPanel13.add(this.jPanelScale);
        this.jPanelScanner.setPreferredSize(new Dimension(900, 40));
        this.jPanelScanner.setLayout(new FlowLayout(0));
        this.jLabel13.setFont(new Font("Arial", 0, 12));
        this.jLabel13.setText("Scanner");
        this.jLabel13.setPreferredSize(new Dimension(200, 30));
        this.jPanelScanner.add(this.jLabel13);
        this.jcboMachineScanner.setFont(new Font("Arial", 0, 14));
        this.jcboMachineScanner.setCursor(new Cursor(0));
        this.jcboMachineScanner.setPreferredSize(new Dimension(300, 30));
        this.jcboMachineScanner.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelConfigPeripheral.this.jcboMachineScannerActionPerformed(evt);
            }
        });
        this.jPanelScanner.add(this.jcboMachineScanner);
        this.m_jScannerParams.setPreferredSize(new Dimension(200, 25));
        this.m_jScannerParams.setLayout(new CardLayout());
        this.jlblPrinterPort5.setFont(new Font("Arial", 0, 12));
        this.jlblPrinterPort5.setText(AppLocal.getIntString("label.machineprinterport"));
        this.jlblPrinterPort5.setPreferredSize(new Dimension(50, 25));
        this.jcboSerialScanner.setEditable(true);
        this.jcboSerialScanner.setFont(new Font("Arial", 0, 12));
        this.jcboSerialScanner.setPreferredSize(new Dimension(100, 23));
        GroupLayout jPanel19Layout = new GroupLayout(this.jPanel19);
        this.jPanel19.setLayout(jPanel19Layout);
        jPanel19Layout.setHorizontalGroup(jPanel19Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel19Layout.createSequentialGroup().addContainerGap().addComponent(this.jlblPrinterPort5, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jcboSerialScanner, -2, 90, -2).addContainerGap(42, Short.MAX_VALUE)));
        jPanel19Layout.setVerticalGroup(jPanel19Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel19Layout.createSequentialGroup().addGroup(jPanel19Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jcboSerialScanner, -2, -1, -2).addComponent(this.jlblPrinterPort5, -2, -1, -2)).addGap(0, 0, 0)));
        this.m_jScannerParams.add((Component)this.jPanel19, "comm");
        this.m_jScannerParams.add((Component)this.jPanel24, "empty");
        this.jPanelScanner.add(this.m_jScannerParams);
        this.jPanel13.add(this.jPanelScanner);
        this.jPanelBasketButtonMainPane.setPreferredSize(new Dimension(900, 40));
        this.jPanelBasketButtonMainPane.setLayout(new FlowLayout(0));
        this.showDriveBasketOnlyByClick.setText("Afficher le panier drive uniquement avec le bouton \"AFFICHER PANIER DRIVE\"");
        this.showDriveBasketOnlyByClick.setMaximumSize(new Dimension(500, 20));
        this.showDriveBasketOnlyByClick.setMinimumSize(new Dimension(500, 20));
        this.showDriveBasketOnlyByClick.setPreferredSize(new Dimension(500, 30));
        this.showDriveBasketOnlyByClick.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelConfigPeripheral.this.showDriveBasketOnlyByClickActionPerformed(evt);
            }
        });
        this.jPanelBasketButtonMainPane.add(this.showDriveBasketOnlyByClick);
        this.jPanel13.add(this.jPanelBasketButtonMainPane);
        this.jPanelVoiceMessageMainPane.setPreferredSize(new Dimension(900, 40));
        this.jPanelVoiceMessageMainPane.setLayout(new FlowLayout(0));
        this.hideDriveVoiceMessagePane.setText("Cacher la banni\u00e8re \"Parler pour commander\" sur l'\u00e9cran Drive");
        this.hideDriveVoiceMessagePane.setMaximumSize(new Dimension(400, 20));
        this.hideDriveVoiceMessagePane.setMinimumSize(new Dimension(400, 20));
        this.hideDriveVoiceMessagePane.setPreferredSize(new Dimension(400, 30));
        this.jPanelVoiceMessageMainPane.add(this.hideDriveVoiceMessagePane);
        this.jPanel13.add(this.jPanelVoiceMessageMainPane);
        this.jPanelScanner3.setPreferredSize(new Dimension(900, 160));
        this.jPanelScanner3.setLayout(new FlowLayout(0));
        this.jPanelDriveBannerMainPane.setPreferredSize(new Dimension(900, 160));
        this.jPanelDriveBannerMainPane.setLayout(new FlowLayout(0));
        this.jPanel20.setPreferredSize(new Dimension(210, 160));
        this.jLabel30.setText("Banni\u00e8re de panier Drive");
        this.jLabel30.setPreferredSize(new Dimension(200, 30));
        this.jPanel20.add(this.jLabel30);
        this.jPanelDriveBannerMainPane.add(this.jPanel20);
        this.jPanelImage10.setPreferredSize(new Dimension(400, 150));
        this.jPanelImage10.setLayout(new BorderLayout());
        this.jPanelExistImage8.setLayout(new BorderLayout());
        this.jPanelExistImage8.add((Component)this.jLabelDriveBasketBanner, "Center");
        this.btnUpdateDriveBasketBanner.setBackground(new Color(129, 207, 224));
        this.btnUpdateDriveBasketBanner.setText("Choisir une image");
        this.btnUpdateDriveBasketBanner.setBorderPainted(false);
        this.btnUpdateDriveBasketBanner.setFocusPainted(false);
        this.btnUpdateDriveBasketBanner.setPreferredSize(new Dimension(73, 40));
        this.btnUpdateDriveBasketBanner.setRequestFocusEnabled(false);
        this.btnUpdateDriveBasketBanner.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelConfigPeripheral.this.btnUpdateDriveBasketBannerActionPerformed(evt);
            }
        });
        this.jPanelExistImage8.add((Component)this.btnUpdateDriveBasketBanner, "Last");
        this.jPanelImage10.add((Component)this.jPanelExistImage8, "Center");
        this.jPanelDriveBannerMainPane.add(this.jPanelImage10);
        this.jPanelScanner3.add(this.jPanelDriveBannerMainPane);
        this.jPanel13.add(this.jPanelScanner3);
        this.add((Component)this.jPanel13, "Center");
    }

    private void jcboMachineScannerActionPerformed(ActionEvent evt) {
        CardLayout cl = (CardLayout)this.m_jScannerParams.getLayout();
        if ("scanpal2".equals(this.jcboMachineScanner.getSelectedItem())) {
            cl.show(this.m_jScannerParams, "comm");
        } else {
            cl.show(this.m_jScannerParams, "empty");
        }
    }

    private void jcboMachineScaleActionPerformed(ActionEvent evt) {
        CardLayout cl = (CardLayout)this.m_jScaleParams.getLayout();
        if ("casiopd1".equals(this.jcboMachineScale.getSelectedItem()) || "caspdII".equals(this.jcboMachineScale.getSelectedItem()) || "dialog1".equals(this.jcboMachineScale.getSelectedItem()) || "samsungesp".equals(this.jcboMachineScale.getSelectedItem())) {
            cl.show(this.m_jScaleParams, "comm");
        } else {
            cl.show(this.m_jScaleParams, "empty");
        }
    }

    private void jcboMachineDisplayActionPerformed(ActionEvent evt) {
        String machine_display;
        switch (machine_display = (String)this.jcboMachineDisplay.getSelectedItem()) {
            case "afficheur VFD": {
                this.jPanelcnDisplay.setVisible(true);
                this.jPanelserialDisplay.setVisible(true);
                this.jPanelMessage.setVisible(true);
                this.jPanelTimer.setVisible(false);
                this.jPanelImages.setVisible(false);
                this.jPanelDriveBannerMainPane.setVisible(false);
                this.jPanelVoiceMessageMainPane.setVisible(false);
                this.jPanelBasketButtonMainPane.setVisible(false);
                break;
            }
            case "Double \u00e9cran": {
                this.jPanelcnDisplay.setVisible(false);
                this.jPanelserialDisplay.setVisible(false);
                this.jPanelMessage.setVisible(false);
                this.jPanelTimer.setVisible(true);
                this.jPanelImages.setVisible(true);
                this.jPanelDriveBannerMainPane.setVisible(false);
                this.jPanelVoiceMessageMainPane.setVisible(false);
                this.jPanelBasketButtonMainPane.setVisible(false);
                break;
            }
            case "Drive": {
                this.jPanelcnDisplay.setVisible(false);
                this.jPanelserialDisplay.setVisible(false);
                this.jPanelMessage.setVisible(false);
                this.jPanelTimer.setVisible(false);
                this.jPanelImages.setVisible(true);
                this.jPanelDriveBannerMainPane.setVisible(true);
                this.jPanelVoiceMessageMainPane.setVisible(true);
                this.jPanelBasketButtonMainPane.setVisible(true);
                break;
            }
            default: {
                this.jPanelcnDisplay.setVisible(false);
                this.jPanelserialDisplay.setVisible(false);
                this.jPanelMessage.setVisible(false);
                this.jPanelTimer.setVisible(false);
                this.jPanelImages.setVisible(false);
                this.jPanelDriveBannerMainPane.setVisible(false);
                this.jPanelVoiceMessageMainPane.setVisible(false);
                this.jPanelBasketButtonMainPane.setVisible(false);
            }
        }
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < JPanelConfigPeripheral.this.jcboSerialDisplay.getItemCount(); ++i) {
                    try {
                        String port = (String)JPanelConfigPeripheral.this.jcboSerialDisplay.getItemAt(i);
                        TPECBConcert tpe = new TPECBConcert(port);
                        tpe.sendMessageJserialComm(JPanelConfigPeripheral.this.messageWelcome.getText().isEmpty() ? "Bienvenue " + port : JPanelConfigPeripheral.this.messageWelcome.getText() + " " + port);
                        JPanelConfigPeripheral.this.jcboSerialDisplay.setSelectedIndex(i);
                        continue;
                    }
                    catch (Exception ex) {
                        new NotifyWindow(Color.CYAN, "le port " + JPanelConfigPeripheral.this.jcboSerialDisplay.getItemAt(i) + " n'est pas le port connct\u00e9 a l afficheur client", 1500, NPosition.TOP_RIGHT);
                    }
                }
            }
        }).start();
    }

    private void jcboConnDisplayActionPerformed(ActionEvent evt) {
    }

    private void showDriveBasketOnlyByClickActionPerformed(ActionEvent evt) {
    }

    private void btnUpdateDriveBasketBannerActionPerformed(ActionEvent evt) {
        this.addDriveBasketBanner();
    }

    public void addDriveBasketBanner() {
        Platform.runLater(() -> {
            FileChooser fc = new FileChooser();
            FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter(LocalRes.getIntString("label.imagefiles"), new String[]{"*.png", "*.gif", "*.jpg", "*.jpeg", "*.bmp"});
            fc.getExtensionFilters().add((Object)extFilter);
            System.out.println("+++++++++= m_fCurrentDirectory : " + m_fCurrentDirectory);
            fc.setInitialDirectory(m_fCurrentDirectory);
            File file = fc.showOpenDialog(null);
            if (file != null) {
                if (file.length() <= (long)this.MAX_SIZE_FILE) {
                    try {
                        String path = file.getAbsolutePath().toString();
                        String name = file.getName();
                        String ext = name.substring(name.lastIndexOf(".") + 1);
                        if (path != null) {
                            File directory = new File(new File(System.getProperty("user.home")), "images/logos");
                            FileUtils.forceMkdir((File)directory);
                            String url = directory.getPath();
                            this.driveBasketBanner = "drive_basket_banner." + ext;
                            File dest = new File(url + "/" + this.driveBasketBanner);
                            if (!dest.exists()) {
                                dest.createNewFile();
                            }
                            FileUtils.copyFile((File)new File(path), (File)dest);
                            m_fCurrentDirectory = file.getParentFile();
                            this.imageutils.resizeImage(new File(url + "/" + this.driveBasketBanner), "256");
                            this.loadDriveBasketBanner();
                        }
                    }
                    catch (IOException iOException) {}
                } else {
                    new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Votre fichier est trop lourd (> 500KO).", 1500, NPosition.BOTTOM_RIGHT);
                }
            }
        });
    }

    private void loadDriveBasketBanner() {
        try {
            String resized_path = null;
            if (this.driveBasketBanner != null) {
                String name = this.driveBasketBanner.replaceFirst("[.][^.]+$", "");
                String ext = this.driveBasketBanner.substring(this.driveBasketBanner.lastIndexOf(".") + 1);
                resized_path = name + "_256px." + ext;
            }
            File image = null;
            if (resized_path != null) {
                image = this.m_FilerUtils.getFileFullPath("images/logos/" + resized_path);
            }
            if (image == null && this.driveBasketBanner != null) {
                image = this.m_FilerUtils.getFileFullPath("images/logos/" + this.driveBasketBanner);
            }
            if (image != null && image.exists()) {
                System.out.println("Image cest :" + image.getAbsolutePath());
                BufferedImage img = ImageIO.read(image);
                if (img != null) {
                    Image newImg = img.getScaledInstance(200, 70, 4);
                    ImageIcon newImc = new ImageIcon(newImg);
                    this.jLabelDriveBasketBanner.setIcon(newImc);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static class ExtensionsFilter
    extends FileFilter {
        private String message;
        private String[] extensions;

        public ExtensionsFilter(String message, String ... extensions) {
            this.message = message;
            this.extensions = extensions;
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String sFileName = f.getName();
            int ipos = sFileName.lastIndexOf(46);
            if (ipos >= 0) {
                String sExt = sFileName.substring(ipos + 1);
                for (String s : this.extensions) {
                    if (!s.equalsIgnoreCase(sExt)) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public String getDescription() {
            return this.message;
        }
    }
}

