/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.config;

import com.google.maps.model.LatLng;
import com.openbravo.dao.DataLogicSales;
import com.openbravo.data.user.DirtyManager;
import com.openbravo.pos.config.LocaleComparator;
import com.openbravo.pos.config.PanelConfig;
import com.openbravo.pos.forms.AppConfig;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.notify.NPosition;
import com.openbravo.pos.notify.NotifyType;
import com.openbravo.pos.notify.NotifyWindow;
import com.openbravo.pos.ticket.MarqueNFC;
import com.openbravo.pos.util.FilerUtils;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.pos.util.SystemUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.imageio.ImageIO;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.apache.commons.io.FileUtils;
import se.walkercrou.places.AddressFinderHelper;

public class JPanelConfigLocale
extends JPanel
implements PanelConfig {
    private final DirtyManager dirty = new DirtyManager();
    private static final String DEFAULT_VALUE = "(Default)";
    private static File m_fCurrentDirectory = null;
    private String newPhoto;
    protected String m_addressResto;
    protected LatLng m_latLng;
    protected DataLogicSales dlSales;
    private JButton btnAddImage;
    private JButton btnUpdateImage;
    private JButton jButtonGeolocalization;
    private JLabel jLabel1;
    private JLabel jLabel11;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JLabel jLabelImage;
    private JPanel jPanel1;
    private JPanel jPanel10;
    private JPanel jPanel11;
    private JPanel jPanel12;
    private JPanel jPanel13;
    private JPanel jPanel14;
    private JPanel jPanel15;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JPanel jPanel9;
    private JPanel jPanelAddImage;
    private JPanel jPanelExistImage;
    private JPanel jPanelImage;
    private JScrollPane jScrollPane1;
    private JTextArea jadress;
    private JComboBox jcboCurrency;
    private JComboBox jcboDate;
    private JComboBox jcboDatetime;
    private JComboBox jcboDouble;
    private JComboBox jcboInteger;
    private JComboBox jcboLocale;
    private JComboBox jcboPercent;
    private JComboBox jcboTime;
    private JLabel nothing;
    private JTextField radiusText;

    public JPanelConfigLocale(DataLogicSales dlSales) {
        this.dlSales = dlSales;
        this.initComponents();
        this.jcboLocale.addActionListener(this.dirty);
        this.jcboInteger.addActionListener(this.dirty);
        this.jcboDouble.addActionListener(this.dirty);
        this.jcboCurrency.addActionListener(this.dirty);
        this.jcboPercent.addActionListener(this.dirty);
        this.jcboDate.addActionListener(this.dirty);
        this.jcboTime.addActionListener(this.dirty);
        this.jcboDatetime.addActionListener(this.dirty);
        ArrayList<Locale> availablelocales = new ArrayList<Locale>();
        availablelocales.addAll(Arrays.asList(Locale.getAvailableLocales()));
        this.addLocale(availablelocales, new Locale("eu", "ES", ""));
        this.addLocale(availablelocales, new Locale("gl", "ES", ""));
        Collections.sort(availablelocales, new LocaleComparator());
        this.jcboLocale.addItem(new LocaleInfo(null));
        for (Locale l : availablelocales) {
            this.jcboLocale.addItem(new LocaleInfo(l));
        }
        this.jcboInteger.addItem(DEFAULT_VALUE);
        this.jcboInteger.addItem("#0");
        this.jcboInteger.addItem("#,##0");
        this.jcboDouble.addItem("#0.00");
        this.jcboDouble.addItem("#0.0");
        this.jcboDouble.addItem("#,##0.#");
        this.jcboCurrency.addItem("#0.00 \u20ac");
        this.jcboCurrency.addItem("#0.00 DH");
        this.jcboCurrency.addItem("#0.00 CHF");
        this.jcboCurrency.addItem("\u00a4 #0.00");
        this.jcboCurrency.addItem("'$' #,##0.00");
        this.jcboPercent.addItem(DEFAULT_VALUE);
        this.jcboPercent.addItem("#,##0.##%");
        this.jcboDate.addItem(DEFAULT_VALUE);
        this.jcboTime.addItem(DEFAULT_VALUE);
        this.jcboDatetime.addItem(DEFAULT_VALUE);
        this.nothing.setText("");
    }

    private void addLocale(List<Locale> ll, Locale l) {
        if (!ll.contains(l)) {
            ll.add(l);
        }
    }

    @Override
    public boolean hasChanged() {
        return this.dirty.isDirty();
    }

    @Override
    public Component getConfigComponent() {
        return this;
    }

    @Override
    public void loadProperties(AppConfig config) {
        String slang = config.getProperty("user.language");
        String scountry = config.getProperty("user.country");
        String svariant = config.getProperty("user.variant");
        if (!(slang == null || slang.equals("") || scountry == null || scountry.isEmpty() || svariant == null || svariant.isEmpty())) {
            Locale currentlocale = new Locale(slang, scountry, svariant);
            for (int i = 0; i < this.jcboLocale.getItemCount(); ++i) {
                LocaleInfo l = (LocaleInfo)this.jcboLocale.getItemAt(i);
                if (!currentlocale.equals(l.getLocale())) continue;
                this.jcboLocale.setSelectedIndex(i);
                break;
            }
        } else {
            this.jcboLocale.setSelectedIndex(0);
        }
        this.jcboInteger.setSelectedItem(this.writeWithDefault(config.getProperty("format.integer")));
        this.jcboDouble.setSelectedItem(this.writeWithDefault(config.getProperty("format.double")));
        this.jcboCurrency.setSelectedItem(this.writeWithDefault(config.getProperty("format.currency")));
        this.jcboPercent.setSelectedItem(this.writeWithDefault(config.getProperty("format.percent")));
        this.jcboDate.setSelectedItem(this.writeWithDefault(config.getProperty("format.date")));
        this.jcboTime.setSelectedItem(this.writeWithDefault(config.getProperty("format.time")));
        this.jcboDatetime.setSelectedItem(this.writeWithDefault(config.getProperty("format.datetime")));
        this.newPhoto = config.getProperty("main.path");
        if (this.newPhoto != null && !this.newPhoto.isEmpty()) {
            try {
                this.loadImage();
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        } else {
            this.loadPanelAdd();
        }
        this.radiusText.setText(config.getProperty("address.radius"));
        MarqueNFC m_marqueNFC = null;
        this.m_addressResto = config.getProperty("address.resto");
        String m_lat = config.getProperty("address.lat");
        String m_lng = config.getProperty("address.lon");
        try {
            if (this.dlSales != null) {
                m_marqueNFC = this.dlSales.getMarqueNF();
            }
            if (m_lat != null && m_lng != null && !m_lat.isEmpty() && !m_lng.isEmpty()) {
                this.m_latLng = new LatLng(Double.parseDouble(m_lat), Double.parseDouble(m_lng));
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        if (m_marqueNFC != null) {
            if (this.m_addressResto == null || this.m_addressResto != null && this.m_addressResto.isEmpty()) {
                String m_addressTemp = m_marqueNFC.getAdresse1() + " " + m_marqueNFC.getEmail() + " " + m_marqueNFC.getZipCode() + " " + m_marqueNFC.getCity() + " " + m_marqueNFC.getCountry();
                this.jadress.setText(m_addressTemp);
            } else {
                this.jadress.setText(this.m_addressResto);
            }
        } else {
            this.jadress.setText(this.m_addressResto);
        }
        this.dirty.setDirty(false);
    }

    @Override
    public void saveProperties(AppConfig config) {
        Locale l = ((LocaleInfo)this.jcboLocale.getSelectedItem()).getLocale();
        if (l == null) {
            config.setProperty("user.language", "");
            config.setProperty("user.country", "");
            config.setProperty("user.variant", "");
        } else {
            config.setProperty("user.language", l.getLanguage());
            config.setProperty("user.country", l.getCountry());
            config.setProperty("user.variant", l.getVariant());
        }
        config.setProperty("format.integer", this.readWithDefault(this.jcboInteger.getSelectedItem()));
        config.setProperty("format.double", this.readWithDefault(this.jcboDouble.getSelectedItem()));
        config.setProperty("format.currency", this.readWithDefault(this.jcboCurrency.getSelectedItem()));
        config.setProperty("format.percent", this.readWithDefault(this.jcboPercent.getSelectedItem()));
        config.setProperty("format.date", this.readWithDefault(this.jcboDate.getSelectedItem()));
        config.setProperty("format.time", this.readWithDefault(this.jcboTime.getSelectedItem()));
        config.setProperty("format.datetime", this.readWithDefault(this.jcboDatetime.getSelectedItem()));
        if (this.newPhoto == null) {
            this.newPhoto = "";
        }
        config.setProperty("main.path", this.newPhoto);
        config.setProperty("address.radius", this.radiusText.getText());
        this.m_addressResto = this.jadress.getText();
        config.setProperty("address.resto", this.m_addressResto);
        AppLocal.addressResto = this.m_addressResto;
        if (this.m_latLng == null && this.m_addressResto != null && !this.m_addressResto.isEmpty()) {
            this.m_latLng = AddressFinderHelper.localizationAddressResto(this.m_addressResto);
            if (this.m_latLng != null) {
                config.setProperty("address.lat", String.valueOf(this.m_latLng.lat));
                config.setProperty("address.lon", String.valueOf(this.m_latLng.lng));
            }
        } else if (this.m_latLng != null) {
            config.setProperty("address.lat", String.valueOf(this.m_latLng.lat));
            config.setProperty("address.lon", String.valueOf(this.m_latLng.lng));
        }
        this.dirty.setDirty(false);
    }

    private String readWithDefault(Object value) {
        if (DEFAULT_VALUE.equals(value)) {
            return "";
        }
        return value.toString();
    }

    private Object writeWithDefault(String value) {
        if (value == null || value.equals("") || value.equals(DEFAULT_VALUE)) {
            return DEFAULT_VALUE;
        }
        return value;
    }

    @Override
    public void activate() {
    }

    private void addImage() {
        JFileChooser fc = new JFileChooser(m_fCurrentDirectory);
        fc.addChoosableFileFilter(FilerUtils.PICTURE_FILE_FILTER);
        fc.setAcceptAllFileFilterUsed(true);
        if (fc.showOpenDialog(new JFrame()) == 0) {
            try {
                String path = fc.getSelectedFile().getAbsolutePath().toString();
                String name = fc.getSelectedFile().getName();
                String ext = name.substring(name.lastIndexOf(".") + 1);
                if (path != null) {
                    File directory = new File(new File(SystemUtils.SYS_USER_HOME), "images/logos");
                    FileUtils.forceMkdir((File)directory);
                    String url = directory.getPath();
                    File dest = new File(url + "/logo_main." + ext);
                    if (!dest.exists()) {
                        dest.createNewFile();
                    }
                    FileUtils.copyFile((File)new File(path), (File)dest);
                    this.newPhoto = "logo_main." + ext;
                    this.loadImage();
                }
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
    }

    private void loadImage() throws IOException {
        File image = new File(new File(SystemUtils.SYS_USER_HOME), "images/logos/" + this.newPhoto);
        if (image.exists()) {
            BufferedImage img = ImageIO.read(image);
            Image newImg = img.getScaledInstance(400, 110, 4);
            ImageIcon newImc = new ImageIcon(newImg);
            this.jLabelImage.setIcon(newImc);
            this.jPanelImage.removeAll();
            this.jPanelImage.add((Component)this.jPanelExistImage, "Center");
            this.jPanelAddImage.setVisible(false);
            this.jPanelExistImage.setVisible(true);
            this.jPanelImage.revalidate();
            this.jPanelImage.repaint();
        } else {
            this.loadPanelAdd();
        }
    }

    private void loadPanelAdd() {
        this.jPanelImage.removeAll();
        this.jPanelImage.add((Component)this.jPanelAddImage, "Center");
        this.jPanelAddImage.setVisible(true);
        this.jPanelExistImage.setVisible(false);
        this.jPanelImage.revalidate();
        this.jPanelImage.repaint();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jLabel5 = new JLabel();
        this.jcboLocale = new JComboBox();
        this.jPanel3 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jcboInteger = new JComboBox();
        this.jPanel4 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jcboDouble = new JComboBox();
        this.jPanel6 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jcboCurrency = new JComboBox();
        this.jPanel7 = new JPanel();
        this.jLabel4 = new JLabel();
        this.jcboPercent = new JComboBox();
        this.jPanel8 = new JPanel();
        this.jLabel6 = new JLabel();
        this.jcboDate = new JComboBox();
        this.jPanel9 = new JPanel();
        this.jLabel7 = new JLabel();
        this.jcboTime = new JComboBox();
        this.jPanel10 = new JPanel();
        this.jLabel8 = new JLabel();
        this.jcboDatetime = new JComboBox();
        this.jPanel15 = new JPanel();
        this.jLabel11 = new JLabel();
        this.radiusText = new JTextField();
        this.jPanel13 = new JPanel();
        this.jLabel9 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jadress = new JTextArea();
        this.jPanel14 = new JPanel();
        this.nothing = new JLabel();
        this.jButtonGeolocalization = new JButton();
        this.jPanel5 = new JPanel();
        this.jPanelImage = new JPanel();
        this.jPanelAddImage = new JPanel();
        this.jPanel11 = new JPanel();
        this.btnAddImage = new JButton();
        this.jPanel12 = new JPanel();
        this.jPanelExistImage = new JPanel();
        this.jLabelImage = new JLabel();
        this.btnUpdateImage = new JButton();
        this.setMinimumSize(new Dimension(0, 0));
        this.setPreferredSize(new Dimension(650, 450));
        this.setLayout(new BorderLayout());
        this.jPanel1.setPreferredSize(new Dimension(600, 400));
        this.jPanel1.setLayout(new FlowLayout(2));
        this.jPanel2.setPreferredSize(new Dimension(560, 40));
        this.jPanel2.setLayout(new FlowLayout(2));
        this.jLabel5.setFont(new Font("Arial", 0, 12));
        this.jLabel5.setText("Locale");
        this.jLabel5.setPreferredSize(new Dimension(150, 30));
        this.jPanel2.add(this.jLabel5);
        this.jcboLocale.setFont(new Font("Arial", 0, 14));
        this.jcboLocale.setPreferredSize(new Dimension(300, 30));
        this.jcboLocale.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelConfigLocale.this.jcboLocaleActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.jcboLocale);
        this.jPanel1.add(this.jPanel2);
        this.jPanel3.setPreferredSize(new Dimension(560, 40));
        this.jPanel3.setLayout(new FlowLayout(2));
        this.jLabel1.setFont(new Font("Arial", 0, 12));
        this.jLabel1.setText("Integer");
        this.jLabel1.setPreferredSize(new Dimension(150, 30));
        this.jPanel3.add(this.jLabel1);
        this.jcboInteger.setEditable(true);
        this.jcboInteger.setFont(new Font("Arial", 0, 14));
        this.jcboInteger.setPreferredSize(new Dimension(300, 30));
        this.jPanel3.add(this.jcboInteger);
        this.jPanel1.add(this.jPanel3);
        this.jPanel4.setPreferredSize(new Dimension(560, 40));
        this.jPanel4.setLayout(new FlowLayout(2));
        this.jLabel2.setFont(new Font("Arial", 0, 12));
        this.jLabel2.setText("Double");
        this.jLabel2.setPreferredSize(new Dimension(150, 30));
        this.jPanel4.add(this.jLabel2);
        this.jcboDouble.setEditable(true);
        this.jcboDouble.setFont(new Font("Arial", 0, 14));
        this.jcboDouble.setPreferredSize(new Dimension(300, 30));
        this.jPanel4.add(this.jcboDouble);
        this.jPanel1.add(this.jPanel4);
        this.jPanel6.setPreferredSize(new Dimension(560, 40));
        this.jPanel6.setLayout(new FlowLayout(2));
        this.jLabel3.setFont(new Font("Arial", 0, 12));
        this.jLabel3.setText("Currency");
        this.jLabel3.setPreferredSize(new Dimension(150, 30));
        this.jPanel6.add(this.jLabel3);
        this.jcboCurrency.setEditable(true);
        this.jcboCurrency.setFont(new Font("Arial", 0, 14));
        this.jcboCurrency.setPreferredSize(new Dimension(300, 30));
        this.jPanel6.add(this.jcboCurrency);
        this.jPanel1.add(this.jPanel6);
        this.jPanel7.setPreferredSize(new Dimension(560, 40));
        this.jPanel7.setLayout(new FlowLayout(2));
        this.jLabel4.setFont(new Font("Arial", 0, 12));
        this.jLabel4.setText("Percent");
        this.jLabel4.setPreferredSize(new Dimension(150, 30));
        this.jPanel7.add(this.jLabel4);
        this.jcboPercent.setEditable(true);
        this.jcboPercent.setFont(new Font("Arial", 0, 14));
        this.jcboPercent.setPreferredSize(new Dimension(300, 30));
        this.jPanel7.add(this.jcboPercent);
        this.jPanel1.add(this.jPanel7);
        this.jPanel8.setPreferredSize(new Dimension(560, 40));
        this.jPanel8.setLayout(new FlowLayout(2));
        this.jLabel6.setFont(new Font("Arial", 0, 12));
        this.jLabel6.setText("Date");
        this.jLabel6.setPreferredSize(new Dimension(150, 30));
        this.jPanel8.add(this.jLabel6);
        this.jcboDate.setEditable(true);
        this.jcboDate.setFont(new Font("Arial", 0, 14));
        this.jcboDate.setPreferredSize(new Dimension(300, 30));
        this.jPanel8.add(this.jcboDate);
        this.jPanel1.add(this.jPanel8);
        this.jPanel9.setPreferredSize(new Dimension(560, 40));
        this.jPanel9.setLayout(new FlowLayout(2));
        this.jLabel7.setFont(new Font("Arial", 0, 12));
        this.jLabel7.setText("Time");
        this.jLabel7.setPreferredSize(new Dimension(150, 30));
        this.jPanel9.add(this.jLabel7);
        this.jcboTime.setEditable(true);
        this.jcboTime.setFont(new Font("Arial", 0, 14));
        this.jcboTime.setPreferredSize(new Dimension(300, 30));
        this.jPanel9.add(this.jcboTime);
        this.jPanel1.add(this.jPanel9);
        this.jPanel10.setPreferredSize(new Dimension(560, 40));
        this.jPanel10.setLayout(new FlowLayout(2));
        this.jLabel8.setFont(new Font("Arial", 0, 12));
        this.jLabel8.setPreferredSize(new Dimension(150, 30));
        this.jPanel10.add(this.jLabel8);
        this.jcboDatetime.setEditable(true);
        this.jcboDatetime.setFont(new Font("Arial", 0, 14));
        this.jcboDatetime.setPreferredSize(new Dimension(300, 30));
        this.jPanel10.add(this.jcboDatetime);
        this.jPanel1.add(this.jPanel10);
        this.jPanel15.setAutoscrolls(true);
        this.jPanel15.setMinimumSize(new Dimension(200, 33));
        this.jPanel15.setPreferredSize(new Dimension(560, 40));
        this.jPanel15.setLayout(new FlowLayout(2));
        this.jLabel11.setFont(new Font("Tahoma", 0, 12));
        this.jLabel11.setText("Radius");
        this.jLabel11.setPreferredSize(new Dimension(150, 30));
        this.jPanel15.add(this.jLabel11);
        this.radiusText.setPreferredSize(new Dimension(300, 30));
        this.jPanel15.add(this.radiusText);
        this.jPanel1.add(this.jPanel15);
        this.jPanel13.setAutoscrolls(true);
        this.jPanel13.setMinimumSize(new Dimension(200, 33));
        this.jPanel13.setPreferredSize(new Dimension(560, 60));
        this.jPanel13.setLayout(new FlowLayout(2));
        this.jLabel9.setFont(new Font("Tahoma", 0, 12));
        this.jLabel9.setText("Adresse du point de vente");
        this.jLabel9.setPreferredSize(new Dimension(150, 30));
        this.jPanel13.add(this.jLabel9);
        this.jadress.setRows(3);
        this.jadress.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.jadress.setMinimumSize(new Dimension(128, 23));
        this.jadress.setPreferredSize(new Dimension(300, 30));
        this.jScrollPane1.setViewportView(this.jadress);
        this.jPanel13.add(this.jScrollPane1);
        this.jPanel1.add(this.jPanel13);
        this.jPanel14.setPreferredSize(new Dimension(560, 50));
        this.jPanel14.setLayout(new FlowLayout(2));
        this.nothing.setDisplayedMnemonic(' ');
        this.nothing.setFont(new Font("Arial", 0, 12));
        this.nothing.setText(AppLocal.getIntString("label.datetime"));
        this.nothing.setPreferredSize(new Dimension(150, 30));
        this.jPanel14.add(this.nothing);
        this.jButtonGeolocalization.setBackground(new Color(129, 207, 224));
        this.jButtonGeolocalization.setText("G\u00e9olocaliser l'adresse");
        this.jButtonGeolocalization.setBorderPainted(false);
        this.jButtonGeolocalization.setHorizontalTextPosition(2);
        this.jButtonGeolocalization.setMinimumSize(new Dimension(128, 23));
        this.jButtonGeolocalization.setPreferredSize(new Dimension(300, 40));
        this.jButtonGeolocalization.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelConfigLocale.this.jButtonGeolocalizationActionPerformed(evt);
            }
        });
        this.jPanel14.add(this.jButtonGeolocalization);
        this.jPanel1.add(this.jPanel14);
        this.add((Component)this.jPanel1, "Center");
        this.jPanel5.setPreferredSize(new Dimension(300, 150));
        this.jPanel5.setLayout(new BorderLayout());
        this.jPanelImage.setPreferredSize(new Dimension(400, 150));
        this.jPanelImage.setLayout(new BorderLayout());
        this.jPanelAddImage.setLayout(new BorderLayout());
        this.jPanel11.setPreferredSize(new Dimension(250, 50));
        GroupLayout jPanel11Layout = new GroupLayout(this.jPanel11);
        this.jPanel11.setLayout(jPanel11Layout);
        jPanel11Layout.setHorizontalGroup(jPanel11Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        jPanel11Layout.setVerticalGroup(jPanel11Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 50, Short.MAX_VALUE));
        this.jPanelAddImage.add((Component)this.jPanel11, "First");
        this.btnAddImage.setBackground(new Color(82, 179, 217));
        this.btnAddImage.setText("Ajouter Image");
        this.btnAddImage.setBorderPainted(false);
        this.btnAddImage.setFocusPainted(false);
        this.btnAddImage.setPreferredSize(new Dimension(250, 40));
        this.btnAddImage.setRequestFocusEnabled(false);
        this.btnAddImage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelConfigLocale.this.btnAddImageActionPerformed(evt);
            }
        });
        this.jPanelAddImage.add((Component)this.btnAddImage, "Center");
        this.jPanel12.setPreferredSize(new Dimension(250, 50));
        GroupLayout jPanel12Layout = new GroupLayout(this.jPanel12);
        this.jPanel12.setLayout(jPanel12Layout);
        jPanel12Layout.setHorizontalGroup(jPanel12Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        jPanel12Layout.setVerticalGroup(jPanel12Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 50, Short.MAX_VALUE));
        this.jPanelAddImage.add((Component)this.jPanel12, "Last");
        this.jPanelImage.add((Component)this.jPanelAddImage, "Center");
        this.jPanelExistImage.setLayout(new BorderLayout());
        this.jPanelExistImage.add((Component)this.jLabelImage, "Center");
        this.btnUpdateImage.setBackground(new Color(129, 207, 224));
        this.btnUpdateImage.setText("Modifier Logo");
        this.btnUpdateImage.setBorderPainted(false);
        this.btnUpdateImage.setFocusPainted(false);
        this.btnUpdateImage.setPreferredSize(new Dimension(73, 40));
        this.btnUpdateImage.setRequestFocusEnabled(false);
        this.btnUpdateImage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelConfigLocale.this.btnUpdateImageActionPerformed(evt);
            }
        });
        this.jPanelExistImage.add((Component)this.btnUpdateImage, "Last");
        this.jPanelImage.add((Component)this.jPanelExistImage, "Center");
        this.jPanel5.add((Component)this.jPanelImage, "First");
        this.add((Component)this.jPanel5, "After");
    }

    private void btnAddImageActionPerformed(ActionEvent evt) {
        this.addImage();
    }

    private void btnUpdateImageActionPerformed(ActionEvent evt) {
        this.addImage();
    }

    private void jButtonGeolocalizationActionPerformed(ActionEvent evt) {
        this.m_addressResto = this.jadress.getText();
        if (this.m_addressResto != null && !this.m_addressResto.equals("")) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    JPanelConfigLocale.this.m_latLng = AddressFinderHelper.localizationAddressResto(JPanelConfigLocale.this.m_addressResto);
                    if (JPanelConfigLocale.this.m_latLng != null) {
                        new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, "Votre adresse a \u00e9t\u00e9 bien g\u00e9olocaliser !", 1500, NPosition.CENTER);
                    } else {
                        new NotifyWindow(NotifyType.WARNING_NOTIFICATION, "Votre adresse ne peut pas \u00eatre g\u00e9olocaliser. ", 1500, NPosition.CENTER);
                    }
                }
            }).start();
        }
    }

    private void jcboLocaleActionPerformed(ActionEvent evt) {
    }

    private static class LocaleInfo {
        private final Locale locale;

        public LocaleInfo(Locale locale) {
            this.locale = locale;
        }

        public Locale getLocale() {
            return this.locale;
        }

        public String toString() {
            return this.locale == null ? "(System default)" : this.locale.getDisplayName();
        }
    }
}

