/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.config;

import com.openbravo.basic.BasicException;
import com.openbravo.basic.BasicStorage;
import com.openbravo.dao.DataLogicSales;
import com.openbravo.dao.DataLogicSystem;
import com.openbravo.data.user.DirtyManager;
import com.openbravo.pos.config.PanelConfig;
import com.openbravo.pos.forms.AppConfig;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.AppView;
import com.openbravo.pos.notify.NPosition;
import com.openbravo.pos.notify.NotifyType;
import com.openbravo.pos.notify.NotifyWindow;
import com.openbravo.pos.ticket.MarqueNFC;
import com.openbravo.pos.util.Event;
import com.openbravo.pos.util.FilerUtils;
import com.openbravo.pos.util.Journal;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.pos.util.SystemUtils;
import com.openbravo.service.ClientService;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.apache.commons.io.FileUtils;

public class JPanelConfigLicence
extends JPanel
implements PanelConfig {
    private DataLogicSystem m_dlSystem;
    private MarqueNFC marqueNFC = null;
    private DataLogicSales m_dlSales;
    private AppView m_App;
    private ImageIcon ok = new ImageIcon(this.getClass().getResource("/com/openbravo/images/ok.png"));
    private ImageIcon certificatOk = new ImageIcon(this.getClass().getResource("/com/openbravo/images/certificat-ok.png"));
    private ImageIcon certificatNo = new ImageIcon(this.getClass().getResource("/com/openbravo/images/invalid.png"));
    private ImageIcon warning = new ImageIcon(this.getClass().getResource("/com/openbravo/images/refundit.png"));
    private ImageIcon no = new ImageIcon(this.getClass().getResource("/com/openbravo/images/deletePhoto.png"));
    private String MarqueFileOnDisk = SystemUtils.SYS_USER_HOME + File.separator + "certificat_marqueNFC525.cer";
    private final String publicKey = "30819f300d06092a864886f70d010101050003818d003081893032301006\n072a8648ce3d02002EC311215SHA512withECDSA106052b81040006031e0\n0048d1af70033784e6af0d71c7b78886c1676f2fd0f493dfff3607ae28bG\n028181008acef7914d9f5e9bd1c5a5384d1286bc4dae4cd3e957518b2705\nd15b55ca440a4d0b6afa6225db08747e221acc48fc805340badfc213ccc1\n8e8143d0bde71e8588d57b60ef5b99761c10cd83081b1f03784dbf21f2cc\n34bc14a608885205bdb303RSA4102413SHA512withRSA078be811c4e413d\ndc8250a8a4ffda0689326895ec9b8409a723ae366016668a90203010001";
    private final String internalString = "dont tel him about this text";
    private final String trialKeyRestauration = "KBBUX-GNTZB-SQZW3-AM2TA-BLMMN";
    private final String trialKeyVenteDetail = "66XEW-AE3X3-J3TGI-KGSLP-S4GFN";
    private final String trialKeyLivraison = "ZFSBI-QY24U-54MQS-PEI5A-ATCG6";
    public final int trialLicencePeriode = 30;
    private final String nameforValidation;
    private final String companyforValidation;
    private final int hardwareIDMethod = 0;
    private final String productID = "pro-caisse-id";
    private final String productEdition;
    private final String productVersion;
    private final Date currentDate = null;
    private final Date currentVersionReleaseDate = null;
    private String licenseKeyFileOnDisk = SystemUtils.SYS_USER_HOME + File.separator + "procaisse_licence.lic";
    private String licenseTextFileOnDisk = SystemUtils.SYS_USER_HOME + File.separator + "procaisse_licence.lic";
    private final DirtyManager dirty = new DirtyManager();
    private static final String DEFAULT_VALUE = "(Default)";
    private String typeLicence;
    private FilerUtils m_FilerUtils = FilerUtils.getInstance();
    private JTextField adresse1Value;
    private JLabel adresse2No;
    private JTextField capitalSocial;
    private JLabel capitalSocialNo;
    private JButton changeInfosMarque;
    private JButton changeProductKeyjButton;
    private JLabel codeNAFLabel1;
    private JLabel codeNAFNo1;
    private JTextField codeNAFValue1;
    private JTextField codePostalValue;
    private JLabel codePostaleNo;
    private JTextField companyjTextField;
    private JTextField emailjTextField;
    private JButton enregistrerButton;
    private JTextField formeJuridique;
    private JLabel formeJuridiqueNo;
    private JTextField greffe;
    private JLabel greffeNo;
    private JLabel jLabel1;
    private JLabel jLabel17;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JPanel jPanel10;
    private JPanel jPanel11;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel8;
    private JPanel jPanel9;
    private JPanel jPanelAddress;
    private JPanel jPanelCODENAF;
    private JPanel jPanelCapitalSocial;
    private JPanel jPanelCity;
    private JPanel jPanelCodePostal;
    private JPanel jPanelCountry;
    private JPanel jPanelFormeJuridique;
    private JPanel jPanelGreffe;
    private JPanel jPanelInfoLicence;
    private JPanel jPanelInfoRestaurant;
    private JPanel jPanelMain;
    private JPanel jPanelMetier;
    private JPanel jPanelPhone;
    private JPanel jPanelRCS;
    private JPanel jPanelSOC;
    private JPanel jPanelSaveUpdates;
    private JPanel jPanelSiret;
    private JPanel jPanelTVA;
    private JPanel jPanelUpdateReason;
    private JScrollPane jScrollPane1;
    private JPanel keyLicensePanel;
    private JTextField keyText;
    private JTextField licenseExpirationDatejTextField;
    private JTextField licenseStatusjTextField;
    private JLabel linkProtactile;
    private JPanel marquePanel;
    private JTextField metier;
    private JLabel metierNo;
    private JLabel pays;
    private JLabel pays1;
    private JLabel pays3;
    private JLabel paysNo;
    private JLabel paysNo1;
    private JTextField paysValue;
    private JLabel phoneNo;
    private JTextField phoneText;
    private JLabel progressjLabel;
    private JLabel raison;
    private JTextField rcs;
    private JLabel rcsNo;
    private JLabel siret10;
    private JLabel siret11;
    private JLabel siret12;
    private JLabel siret13;
    private JLabel siret4;
    private JLabel siret5;
    private JLabel siret7;
    private JLabel siret8;
    private JLabel siret9;
    private JLabel siretLabel;
    private JLabel siretNo;
    private JTextField siretValue;
    private JLabel societeNo;
    private JTextField societeValue;
    private JScrollPane textRaison;
    private JTextArea textRaisonValue;
    private JLabel tvaLabel;
    private JLabel tvaNo;
    private JTextField tvaValue;
    private JTextField versionText;
    private JLabel villeNo;
    private JTextField villeValue;

    public JPanelConfigLicence(DataLogicSales dlSales) throws BasicException, IOException {
        this.nameforValidation = null;
        this.companyforValidation = null;
        this.productEdition = null;
        this.productVersion = null;
        this.initLocationsFiles();
        this.initComponents();
        this.keyText.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                char c = e.getKeyChar();
                e.setKeyChar(("" + c).toUpperCase().charAt(0));
                if (JPanelConfigLicence.this.keyText.getText().length() >= 29) {
                    e.consume();
                } else if (JPanelConfigLicence.this.keyText.getText().length() == 5 || JPanelConfigLicence.this.keyText.getText().length() == 11 || JPanelConfigLicence.this.keyText.getText().length() == 17 || JPanelConfigLicence.this.keyText.getText().length() == 23) {
                    JPanelConfigLicence.this.keyText.setText(JPanelConfigLicence.this.keyText.getText() + "-");
                }
            }
        });
        this.siretValue.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                char c = e.getKeyChar();
                if (JPanelConfigLicence.this.siretValue.getText().length() >= 14 || (c < '0' || c > '9') && c != '\b') {
                    e.consume();
                }
            }
        });
        this.jPanelPhone.setVisible(false);
        this.linkProtactile.addMouseListener(new OpenUrlAction());
        this.m_dlSales = dlSales;
        MarqueNFC marqueNFC = this.m_dlSales.getMarqueNF();
        if (marqueNFC != null) {
            try {
                this.initMarque(marqueNFC);
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        } else {
            this.initMarque();
        }
        if (AppLocal.user != null && !AppLocal.user.getId().equals("0")) {
            this.changeInfosMarque.setVisible(false);
        }
        this.jPanelMain.removeAll();
        this.jPanelMain.add(this.jPanelInfoRestaurant);
        this.jPanelMain.repaint();
        this.jPanelMain.revalidate();
        this.jPanelInfoRestaurant.removeAll();
        this.jPanelInfoRestaurant.add(this.marquePanel);
        this.jPanelInfoRestaurant.repaint();
        this.jPanelInfoRestaurant.revalidate();
        this.jPanelUpdateReason.setVisible(false);
    }

    public JPanelConfigLicence() throws BasicException, IOException {
        this.nameforValidation = null;
        this.companyforValidation = null;
        this.productEdition = null;
        this.productVersion = null;
        this.initLocationsFiles();
        this.initComponents();
        this.linkProtactile.addMouseListener(new OpenUrlAction());
    }

    private void initLocationsFiles() {
        if (AppLocal.IS_APP_PORTABLE.booleanValue()) {
            this.MarqueFileOnDisk = this.m_FilerUtils.getCurrentPath() + File.separator + "certificat_marqueNFC525.cer";
            this.licenseKeyFileOnDisk = this.m_FilerUtils.getCurrentPath() + File.separator + "procaisse_licence.lic";
            this.licenseTextFileOnDisk = this.m_FilerUtils.getCurrentPath() + File.separator + "procaisse_licence.lic";
        }
    }

    private void initMarque() throws IOException {
        String[] champs;
        File MarqueFile = new File(this.MarqueFileOnDisk);
        if (MarqueFile.exists() && (champs = FileUtils.readFileToString((File)MarqueFile).split("\n")).length >= 9) {
            this.siretValue.setText(champs[0]);
            this.isSiretValid(this.siretValue.getText());
            this.siretNo.setVisible(true);
            this.adresse2No.setIcon(this.ok);
            this.adresse2No.setVisible(true);
            this.villeNo.setIcon(this.ok);
            this.villeNo.setVisible(true);
            this.paysNo.setIcon(this.ok);
            this.paysNo.setVisible(true);
            this.codePostaleNo.setIcon(this.ok);
            this.codePostaleNo.setVisible(true);
            this.societeNo.setIcon(this.ok);
            this.societeNo.setVisible(true);
            this.societeValue.setText(champs[3]);
            this.adresse1Value.setText(champs[4]);
            this.codePostalValue.setText(champs[6]);
            this.villeValue.setText(champs[7]);
            this.paysValue.setText(champs[8]);
            if (champs.length == 10) {
                this.phoneText.setText(champs[9]);
            }
        }
    }

    private boolean isTrialLicense(String key) {
        return key.equals("ZFSBI-QY24U-54MQS-PEI5A-ATCG6") || key.equals("KBBUX-GNTZB-SQZW3-AM2TA-BLMMN") || key.equals("66XEW-AE3X3-J3TGI-KGSLP-S4GFN");
    }

    @Override
    public void activate() {
    }

    private static void open(URI uri) {
        if (Desktop.isDesktopSupported()) {
            try {
                Desktop.getDesktop().browse(uri);
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
    }

    @Override
    public boolean hasChanged() {
        return this.dirty.isDirty();
    }

    @Override
    public Component getConfigComponent() {
        return this;
    }

    @Override
    public void loadProperties(AppConfig config) {
        this.typeLicence = config.getProperty("licence.type");
        if (this.typeLicence != null) {
            // empty if block
        }
        this.dirty.setDirty(false);
    }

    @Override
    public void saveProperties(AppConfig config) {
        if (this.typeLicence == null) {
            this.typeLicence = "venteDetail";
        }
        config.setProperty("licence.type", this.typeLicence);
        this.dirty.setDirty(false);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jPanelMain = new JPanel();
        this.jPanelInfoLicence = new JPanel();
        this.jPanel1 = new JPanel();
        this.jPanel8 = new JPanel();
        this.jLabel1 = new JLabel();
        this.licenseStatusjTextField = new JTextField();
        this.jPanel9 = new JPanel();
        this.jLabel2 = new JLabel();
        this.licenseExpirationDatejTextField = new JTextField();
        this.jPanel10 = new JPanel();
        this.jLabel3 = new JLabel();
        this.versionText = new JTextField();
        this.jPanel2 = new JPanel();
        this.jPanel3 = new JPanel();
        this.jLabel5 = new JLabel();
        this.emailjTextField = new JTextField();
        this.jPanel11 = new JPanel();
        this.jLabel6 = new JLabel();
        this.companyjTextField = new JTextField();
        this.changeInfosMarque = new JButton();
        this.changeProductKeyjButton = new JButton();
        this.progressjLabel = new JLabel();
        this.linkProtactile = new JLabel();
        this.jPanelInfoRestaurant = new JPanel();
        this.marquePanel = new JPanel();
        this.jPanelSiret = new JPanel();
        this.siretLabel = new JLabel();
        this.siretValue = new JTextField();
        this.siretNo = new JLabel();
        this.jPanelTVA = new JPanel();
        this.tvaLabel = new JLabel();
        this.tvaValue = new JTextField();
        this.tvaNo = new JLabel();
        this.jPanelCODENAF = new JPanel();
        this.codeNAFLabel1 = new JLabel();
        this.codeNAFValue1 = new JTextField();
        this.codeNAFNo1 = new JLabel();
        this.jPanelSOC = new JPanel();
        this.siret4 = new JLabel();
        this.societeValue = new JTextField();
        this.societeNo = new JLabel();
        this.jPanelAddress = new JPanel();
        this.siret5 = new JLabel();
        this.adresse1Value = new JTextField();
        this.adresse2No = new JLabel();
        this.jPanelPhone = new JPanel();
        this.siret11 = new JLabel();
        this.phoneText = new JTextField();
        this.phoneNo = new JLabel();
        this.jPanelCity = new JPanel();
        this.siret8 = new JLabel();
        this.villeValue = new JTextField();
        this.villeNo = new JLabel();
        this.jPanelCodePostal = new JPanel();
        this.siret7 = new JLabel();
        this.codePostalValue = new JTextField();
        this.codePostaleNo = new JLabel();
        this.jPanelCountry = new JPanel();
        this.pays = new JLabel();
        this.paysValue = new JTextField();
        this.paysNo = new JLabel();
        this.jPanelFormeJuridique = new JPanel();
        this.siret9 = new JLabel();
        this.formeJuridique = new JTextField();
        this.formeJuridiqueNo = new JLabel();
        this.jPanelCapitalSocial = new JPanel();
        this.pays3 = new JLabel();
        this.capitalSocial = new JTextField();
        this.capitalSocialNo = new JLabel();
        this.jPanelRCS = new JPanel();
        this.siret12 = new JLabel();
        this.rcs = new JTextField();
        this.rcsNo = new JLabel();
        this.jPanelGreffe = new JPanel();
        this.siret10 = new JLabel();
        this.greffe = new JTextField();
        this.greffeNo = new JLabel();
        this.jPanelMetier = new JPanel();
        this.siret13 = new JLabel();
        this.metier = new JTextField();
        this.metierNo = new JLabel();
        this.jPanelUpdateReason = new JPanel();
        this.pays1 = new JLabel();
        this.textRaison = new JScrollPane();
        this.textRaisonValue = new JTextArea();
        this.raison = new JLabel();
        this.keyLicensePanel = new JPanel();
        this.jLabel17 = new JLabel();
        this.keyText = new JTextField();
        this.paysNo1 = new JLabel();
        this.jPanelSaveUpdates = new JPanel();
        this.enregistrerButton = new JButton();
        this.setMinimumSize(new Dimension(0, 0));
        this.setPreferredSize(new Dimension(650, 450));
        this.setLayout(new BorderLayout());
        this.jPanelMain.setRequestFocusEnabled(false);
        FlowLayout flowLayout1 = new FlowLayout(3, 2, 2);
        flowLayout1.setAlignOnBaseline(true);
        this.jPanelMain.setLayout(flowLayout1);
        this.jPanelInfoLicence.setPreferredSize(new Dimension(600, 500));
        this.jPanelInfoLicence.setRequestFocusEnabled(false);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Informations de Licence"));
        this.jPanel1.setMaximumSize(new Dimension(300, 600));
        this.jPanel1.setMinimumSize(new Dimension(300, 600));
        this.jPanel1.setPreferredSize(new Dimension(560, 170));
        this.jPanel8.setPreferredSize(new Dimension(550, 40));
        this.jLabel1.setText("Statut de Licence :");
        this.jLabel1.setPreferredSize(new Dimension(240, 30));
        this.jPanel8.add(this.jLabel1);
        this.licenseStatusjTextField.setEditable(false);
        this.licenseStatusjTextField.setFont(new Font("Tahoma", 0, 12));
        this.licenseStatusjTextField.setPreferredSize(new Dimension(280, 30));
        this.licenseStatusjTextField.setVerifyInputWhenFocusTarget(false);
        this.jPanel8.add(this.licenseStatusjTextField);
        this.jPanel1.add(this.jPanel8);
        this.jPanel9.setPreferredSize(new Dimension(550, 40));
        this.jLabel2.setText("Date d'Expiration de Licence:");
        this.jLabel2.setHorizontalTextPosition(10);
        this.jLabel2.setPreferredSize(new Dimension(240, 30));
        this.jPanel9.add(this.jLabel2);
        this.licenseExpirationDatejTextField.setEditable(false);
        this.licenseExpirationDatejTextField.setFont(new Font("Tahoma", 0, 12));
        this.licenseExpirationDatejTextField.setPreferredSize(new Dimension(280, 30));
        this.licenseExpirationDatejTextField.setVerifyInputWhenFocusTarget(false);
        this.jPanel9.add(this.licenseExpirationDatejTextField);
        this.jPanel1.add(this.jPanel9);
        this.jPanel10.setPreferredSize(new Dimension(550, 40));
        this.jLabel3.setText("Version :");
        this.jLabel3.setPreferredSize(new Dimension(240, 30));
        this.jPanel10.add(this.jLabel3);
        this.versionText.setEditable(false);
        this.versionText.setFont(new Font("Tahoma", 0, 12));
        this.versionText.setPreferredSize(new Dimension(280, 30));
        this.versionText.setVerifyInputWhenFocusTarget(false);
        this.versionText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelConfigLicence.this.versionTextActionPerformed(evt);
            }
        });
        this.jPanel10.add(this.versionText);
        this.jPanel1.add(this.jPanel10);
        this.jPanelInfoLicence.add(this.jPanel1);
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Informations de Propri\u00e9taire"));
        this.jPanel2.setPreferredSize(new Dimension(560, 120));
        this.jPanel3.setPreferredSize(new Dimension(550, 40));
        this.jLabel5.setText("E-mail:");
        this.jLabel5.setPreferredSize(new Dimension(240, 30));
        this.jPanel3.add(this.jLabel5);
        this.emailjTextField.setEditable(false);
        this.emailjTextField.setFont(new Font("Tahoma", 0, 12));
        this.emailjTextField.setPreferredSize(new Dimension(280, 30));
        this.jPanel3.add(this.emailjTextField);
        this.jPanel2.add(this.jPanel3);
        this.jPanel11.setPreferredSize(new Dimension(550, 40));
        this.jLabel6.setText("Soci\u00e9t\u00e9:");
        this.jLabel6.setPreferredSize(new Dimension(240, 30));
        this.jPanel11.add(this.jLabel6);
        this.companyjTextField.setEditable(false);
        this.companyjTextField.setFont(new Font("Tahoma", 0, 12));
        this.companyjTextField.setPreferredSize(new Dimension(280, 30));
        this.jPanel11.add(this.companyjTextField);
        this.jPanel2.add(this.jPanel11);
        this.jPanelInfoLicence.add(this.jPanel2);
        this.changeInfosMarque.setText("Changer les informations de marque ");
        this.changeInfosMarque.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelConfigLicence.this.changeInfosMarqueActionPerformed(evt);
            }
        });
        this.jPanelInfoLicence.add(this.changeInfosMarque);
        this.changeProductKeyjButton.setText("Changer le N\u00b0 de S\u00e9rie");
        this.changeProductKeyjButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelConfigLicence.this.changeProductKeyjButtonActionPerformed(evt);
            }
        });
        this.jPanelInfoLicence.add(this.changeProductKeyjButton);
        this.progressjLabel.setForeground(Color.red);
        this.progressjLabel.setCursor(new Cursor(0));
        this.progressjLabel.setPreferredSize(new Dimension(580, 30));
        this.jPanelInfoLicence.add(this.progressjLabel);
        this.linkProtactile.setText("<html>Pour obtenir une licence ou contacter le support contactez-nous au<b><b> 0972663873 </b></b> ou <a href=\"http://giga-tactile.fr/\"><strong>support@biborne.com</strong></a></html>");
        this.linkProtactile.setCursor(new Cursor(0));
        this.linkProtactile.setPreferredSize(new Dimension(580, 60));
        this.jPanelInfoLicence.add(this.linkProtactile);
        this.jPanelMain.add(this.jPanelInfoLicence);
        this.jPanelInfoRestaurant.setPreferredSize(new Dimension(560, 700));
        this.jPanelInfoRestaurant.setLayout(new FlowLayout(0));
        this.marquePanel.setBorder(BorderFactory.createTitledBorder("Coordonn\u00e9es"));
        this.marquePanel.setPreferredSize(new Dimension(510, 590));
        this.marquePanel.setLayout(new FlowLayout(1, 3, 3));
        this.jPanelSiret.setPreferredSize(new Dimension(490, 35));
        this.siretLabel.setFont(new Font("Tahoma", 0, 12));
        this.siretLabel.setText("SIRET :");
        this.siretLabel.setPreferredSize(new Dimension(170, 32));
        this.jPanelSiret.add(this.siretLabel);
        this.siretValue.setEditable(false);
        this.siretValue.setFont(new Font("Tahoma", 0, 12));
        this.siretValue.setPreferredSize(new Dimension(280, 28));
        this.siretValue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelConfigLicence.this.siretValueActionPerformed(evt);
            }
        });
        this.jPanelSiret.add(this.siretValue);
        this.siretNo.setIcon(new ImageIcon(this.getClass().getResource("/com/openbravo/images/deletePhoto.png")));
        this.jPanelSiret.add(this.siretNo);
        this.marquePanel.add(this.jPanelSiret);
        this.jPanelTVA.setPreferredSize(new Dimension(490, 35));
        this.tvaLabel.setFont(new Font("Tahoma", 0, 12));
        this.tvaLabel.setText("TVA Intra :");
        this.tvaLabel.setPreferredSize(new Dimension(170, 32));
        this.jPanelTVA.add(this.tvaLabel);
        this.tvaValue.setEditable(false);
        this.tvaValue.setFont(new Font("Tahoma", 0, 12));
        this.tvaValue.setPreferredSize(new Dimension(280, 28));
        this.tvaValue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelConfigLicence.this.tvaValueActionPerformed(evt);
            }
        });
        this.jPanelTVA.add(this.tvaValue);
        this.tvaNo.setIcon(new ImageIcon(this.getClass().getResource("/com/openbravo/images/deletePhoto.png")));
        this.jPanelTVA.add(this.tvaNo);
        this.marquePanel.add(this.jPanelTVA);
        this.jPanelCODENAF.setPreferredSize(new Dimension(490, 35));
        this.codeNAFLabel1.setFont(new Font("Tahoma", 0, 12));
        this.codeNAFLabel1.setText("Code NAF :");
        this.codeNAFLabel1.setPreferredSize(new Dimension(170, 32));
        this.jPanelCODENAF.add(this.codeNAFLabel1);
        this.codeNAFValue1.setEditable(false);
        this.codeNAFValue1.setFont(new Font("Tahoma", 0, 12));
        this.codeNAFValue1.setPreferredSize(new Dimension(280, 28));
        this.codeNAFValue1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelConfigLicence.this.codeNAFValue1ActionPerformed(evt);
            }
        });
        this.jPanelCODENAF.add(this.codeNAFValue1);
        this.codeNAFNo1.setIcon(new ImageIcon(this.getClass().getResource("/com/openbravo/images/deletePhoto.png")));
        this.jPanelCODENAF.add(this.codeNAFNo1);
        this.marquePanel.add(this.jPanelCODENAF);
        this.jPanelSOC.setPreferredSize(new Dimension(490, 35));
        this.siret4.setFont(new Font("Tahoma", 0, 12));
        this.siret4.setText("Soci\u00e9t\u00e9 :");
        this.siret4.setPreferredSize(new Dimension(170, 32));
        this.jPanelSOC.add(this.siret4);
        this.societeValue.setEditable(false);
        this.societeValue.setFont(new Font("Tahoma", 0, 12));
        this.societeValue.setPreferredSize(new Dimension(280, 28));
        this.jPanelSOC.add(this.societeValue);
        this.societeNo.setIcon(new ImageIcon(this.getClass().getResource("/com/openbravo/images/deletePhoto.png")));
        this.jPanelSOC.add(this.societeNo);
        this.marquePanel.add(this.jPanelSOC);
        this.jPanelAddress.setPreferredSize(new Dimension(490, 35));
        this.siret5.setFont(new Font("Tahoma", 0, 12));
        this.siret5.setText("Adresse  :");
        this.siret5.setPreferredSize(new Dimension(170, 32));
        this.jPanelAddress.add(this.siret5);
        this.adresse1Value.setEditable(false);
        this.adresse1Value.setFont(new Font("Tahoma", 0, 12));
        this.adresse1Value.setPreferredSize(new Dimension(280, 28));
        this.jPanelAddress.add(this.adresse1Value);
        this.adresse2No.setIcon(new ImageIcon(this.getClass().getResource("/com/openbravo/images/deletePhoto.png")));
        this.jPanelAddress.add(this.adresse2No);
        this.marquePanel.add(this.jPanelAddress);
        this.jPanelPhone.setPreferredSize(new Dimension(490, 35));
        this.siret11.setFont(new Font("Tahoma", 0, 12));
        this.siret11.setText("T\u00e9l\u00e9phone :");
        this.siret11.setPreferredSize(new Dimension(170, 32));
        this.jPanelPhone.add(this.siret11);
        this.phoneText.setEditable(false);
        this.phoneText.setFont(new Font("Tahoma", 0, 12));
        this.phoneText.setPreferredSize(new Dimension(280, 28));
        this.phoneText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelConfigLicence.this.phoneTextActionPerformed(evt);
            }
        });
        this.jPanelPhone.add(this.phoneText);
        this.phoneNo.setPreferredSize(new Dimension(20, 20));
        this.jPanelPhone.add(this.phoneNo);
        this.marquePanel.add(this.jPanelPhone);
        this.jPanelCity.setPreferredSize(new Dimension(490, 35));
        this.siret8.setFont(new Font("Tahoma", 0, 12));
        this.siret8.setText("Ville :");
        this.siret8.setPreferredSize(new Dimension(170, 32));
        this.jPanelCity.add(this.siret8);
        this.villeValue.setEditable(false);
        this.villeValue.setFont(new Font("Tahoma", 0, 12));
        this.villeValue.setPreferredSize(new Dimension(280, 28));
        this.villeValue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelConfigLicence.this.villeValueActionPerformed(evt);
            }
        });
        this.jPanelCity.add(this.villeValue);
        this.villeNo.setIcon(new ImageIcon(this.getClass().getResource("/com/openbravo/images/deletePhoto.png")));
        this.jPanelCity.add(this.villeNo);
        this.marquePanel.add(this.jPanelCity);
        this.jPanelCodePostal.setPreferredSize(new Dimension(490, 35));
        this.siret7.setFont(new Font("Tahoma", 0, 12));
        this.siret7.setText("Code Postal :");
        this.siret7.setPreferredSize(new Dimension(170, 32));
        this.jPanelCodePostal.add(this.siret7);
        this.codePostalValue.setEditable(false);
        this.codePostalValue.setFont(new Font("Tahoma", 0, 12));
        this.codePostalValue.setPreferredSize(new Dimension(280, 28));
        this.jPanelCodePostal.add(this.codePostalValue);
        this.codePostaleNo.setIcon(new ImageIcon(this.getClass().getResource("/com/openbravo/images/deletePhoto.png")));
        this.jPanelCodePostal.add(this.codePostaleNo);
        this.marquePanel.add(this.jPanelCodePostal);
        this.jPanelCountry.setPreferredSize(new Dimension(490, 35));
        this.pays.setFont(new Font("Tahoma", 0, 12));
        this.pays.setText("Pays :");
        this.pays.setPreferredSize(new Dimension(170, 32));
        this.jPanelCountry.add(this.pays);
        this.paysValue.setEditable(false);
        this.paysValue.setFont(new Font("Tahoma", 0, 12));
        this.paysValue.setPreferredSize(new Dimension(280, 28));
        this.paysValue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelConfigLicence.this.paysValueActionPerformed(evt);
            }
        });
        this.jPanelCountry.add(this.paysValue);
        this.paysNo.setIcon(new ImageIcon(this.getClass().getResource("/com/openbravo/images/deletePhoto.png")));
        this.jPanelCountry.add(this.paysNo);
        this.marquePanel.add(this.jPanelCountry);
        this.jPanelFormeJuridique.setPreferredSize(new Dimension(490, 35));
        this.siret9.setFont(new Font("Tahoma", 0, 12));
        this.siret9.setText("Forme Juridique :");
        this.siret9.setPreferredSize(new Dimension(170, 32));
        this.jPanelFormeJuridique.add(this.siret9);
        this.formeJuridique.setEditable(false);
        this.formeJuridique.setFont(new Font("Tahoma", 0, 12));
        this.formeJuridique.setPreferredSize(new Dimension(280, 28));
        this.jPanelFormeJuridique.add(this.formeJuridique);
        this.formeJuridiqueNo.setIcon(new ImageIcon(this.getClass().getResource("/com/openbravo/images/deletePhoto.png")));
        this.jPanelFormeJuridique.add(this.formeJuridiqueNo);
        this.marquePanel.add(this.jPanelFormeJuridique);
        this.jPanelCapitalSocial.setPreferredSize(new Dimension(490, 35));
        this.pays3.setFont(new Font("Tahoma", 0, 12));
        this.pays3.setText("Capital Social : ");
        this.pays3.setPreferredSize(new Dimension(170, 32));
        this.jPanelCapitalSocial.add(this.pays3);
        this.capitalSocial.setEditable(false);
        this.capitalSocial.setFont(new Font("Tahoma", 0, 12));
        this.capitalSocial.setPreferredSize(new Dimension(280, 28));
        this.capitalSocial.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelConfigLicence.this.capitalSocialActionPerformed(evt);
            }
        });
        this.jPanelCapitalSocial.add(this.capitalSocial);
        this.capitalSocialNo.setIcon(new ImageIcon(this.getClass().getResource("/com/openbravo/images/deletePhoto.png")));
        this.jPanelCapitalSocial.add(this.capitalSocialNo);
        this.marquePanel.add(this.jPanelCapitalSocial);
        this.jPanelRCS.setPreferredSize(new Dimension(490, 35));
        this.siret12.setFont(new Font("Tahoma", 0, 12));
        this.siret12.setText("RCS : ");
        this.siret12.setPreferredSize(new Dimension(170, 32));
        this.jPanelRCS.add(this.siret12);
        this.rcs.setEditable(false);
        this.rcs.setFont(new Font("Tahoma", 0, 12));
        this.rcs.setPreferredSize(new Dimension(280, 28));
        this.rcs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelConfigLicence.this.rcsActionPerformed(evt);
            }
        });
        this.jPanelRCS.add(this.rcs);
        this.rcsNo.setIcon(new ImageIcon(this.getClass().getResource("/com/openbravo/images/deletePhoto.png")));
        this.jPanelRCS.add(this.rcsNo);
        this.marquePanel.add(this.jPanelRCS);
        this.jPanelGreffe.setPreferredSize(new Dimension(490, 35));
        this.siret10.setFont(new Font("Tahoma", 0, 12));
        this.siret10.setText("Ville du greffe");
        this.siret10.setPreferredSize(new Dimension(170, 32));
        this.jPanelGreffe.add(this.siret10);
        this.greffe.setEditable(false);
        this.greffe.setFont(new Font("Tahoma", 0, 12));
        this.greffe.setPreferredSize(new Dimension(280, 28));
        this.greffe.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelConfigLicence.this.greffeActionPerformed(evt);
            }
        });
        this.jPanelGreffe.add(this.greffe);
        this.greffeNo.setIcon(new ImageIcon(this.getClass().getResource("/com/openbravo/images/deletePhoto.png")));
        this.jPanelGreffe.add(this.greffeNo);
        this.marquePanel.add(this.jPanelGreffe);
        this.jPanelMetier.setPreferredSize(new Dimension(490, 35));
        this.siret13.setFont(new Font("Tahoma", 0, 12));
        this.siret13.setText("Metier");
        this.siret13.setPreferredSize(new Dimension(170, 32));
        this.jPanelMetier.add(this.siret13);
        this.metier.setEditable(false);
        this.metier.setFont(new Font("Tahoma", 0, 12));
        this.metier.setPreferredSize(new Dimension(280, 28));
        this.metier.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelConfigLicence.this.metierActionPerformed(evt);
            }
        });
        this.jPanelMetier.add(this.metier);
        this.metierNo.setIcon(new ImageIcon(this.getClass().getResource("/com/openbravo/images/deletePhoto.png")));
        this.jPanelMetier.add(this.metierNo);
        this.marquePanel.add(this.jPanelMetier);
        this.jPanelUpdateReason.setPreferredSize(new Dimension(490, 35));
        this.pays1.setFont(new Font("Tahoma", 0, 12));
        this.pays1.setText("Raison de modification :");
        this.pays1.setPreferredSize(new Dimension(170, 32));
        this.jPanelUpdateReason.add(this.pays1);
        this.textRaison.setPreferredSize(new Dimension(300, 40));
        this.textRaisonValue.setColumns(20);
        this.textRaisonValue.setRows(5);
        this.textRaisonValue.setPreferredSize(new Dimension(100, 58));
        this.textRaison.setViewportView(this.textRaisonValue);
        this.jPanelUpdateReason.add(this.textRaison);
        this.raison.setIcon(new ImageIcon(this.getClass().getResource("/com/openbravo/images/deletePhoto.png")));
        this.jPanelUpdateReason.add(this.raison);
        this.marquePanel.add(this.jPanelUpdateReason);
        this.jPanelInfoRestaurant.add(this.marquePanel);
        this.keyLicensePanel.setBorder(BorderFactory.createTitledBorder("Information de la Licence"));
        this.keyLicensePanel.setPreferredSize(new Dimension(510, 70));
        this.jLabel17.setFont(new Font("Tahoma", 0, 12));
        this.jLabel17.setText("N\u00b0 de s\u00e9rie :");
        this.keyText.setFont(new Font("Tahoma", 0, 12));
        this.keyText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelConfigLicence.this.keyTextActionPerformed(evt);
            }
        });
        this.paysNo1.setIcon(new ImageIcon(this.getClass().getResource("/com/openbravo/images/deletePhoto.png")));
        GroupLayout keyLicensePanelLayout = new GroupLayout(this.keyLicensePanel);
        this.keyLicensePanel.setLayout(keyLicensePanelLayout);
        keyLicensePanelLayout.setHorizontalGroup(keyLicensePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(keyLicensePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel17, -1, 162, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.keyText, -2, 282, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.paysNo1).addContainerGap()));
        keyLicensePanelLayout.setVerticalGroup(keyLicensePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(keyLicensePanelLayout.createSequentialGroup().addContainerGap().addGroup(keyLicensePanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.paysNo1, -2, 30, -2).addGroup(keyLicensePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.keyText, -2, 30, -2).addComponent(this.jLabel17))).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanelInfoRestaurant.add(this.keyLicensePanel);
        this.jPanelSaveUpdates.setPreferredSize(new Dimension(500, 30));
        this.enregistrerButton.setText("Enregistrer");
        this.enregistrerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelConfigLicence.this.enregistrerButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanelSaveUpdatesLayout = new GroupLayout(this.jPanelSaveUpdates);
        this.jPanelSaveUpdates.setLayout(jPanelSaveUpdatesLayout);
        jPanelSaveUpdatesLayout.setHorizontalGroup(jPanelSaveUpdatesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 500, Short.MAX_VALUE).addGroup(jPanelSaveUpdatesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelSaveUpdatesLayout.createSequentialGroup().addGap(0, 207, Short.MAX_VALUE).addComponent(this.enregistrerButton).addGap(0, 208, Short.MAX_VALUE))));
        jPanelSaveUpdatesLayout.setVerticalGroup(jPanelSaveUpdatesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 30, Short.MAX_VALUE).addGroup(jPanelSaveUpdatesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelSaveUpdatesLayout.createSequentialGroup().addGap(0, 1, Short.MAX_VALUE).addComponent(this.enregistrerButton).addGap(0, 6, Short.MAX_VALUE))));
        this.jPanelInfoRestaurant.add(this.jPanelSaveUpdates);
        this.jPanelMain.add(this.jPanelInfoRestaurant);
        this.jScrollPane1.setViewportView(this.jPanelMain);
        this.add((Component)this.jScrollPane1, "Center");
    }

    private void changeProductKeyjButtonActionPerformed(ActionEvent evt) {
        this.marquePanel.setVisible(true);
        this.toggleMarquePanel(true);
        this.keyLicensePanel.setVisible(false);
        this.enregistrerButton.setVisible(true);
        this.jPanelUpdateReason.setVisible(true);
    }

    private void toggleMarquePanel(Boolean b) {
        this.marquePanel.setEnabled(b);
        this.siretValue.setEditable(b);
        this.tvaValue.setEditable(b);
        this.codeNAFValue1.setEditable(b);
        this.villeValue.setEditable(b);
        this.paysValue.setEditable(b);
        this.codePostalValue.setEditable(b);
        this.adresse1Value.setEditable(b);
        this.societeValue.setEditable(b);
        this.phoneText.setEditable(b);
        this.formeJuridique.setEditable(b);
        this.capitalSocial.setEditable(b);
        this.rcs.setEditable(b);
        this.greffe.setEditable(b);
        this.metier.setEditable(b);
    }

    private void siretValueActionPerformed(ActionEvent evt) {
    }

    private void villeValueActionPerformed(ActionEvent evt) {
    }

    private void keyTextActionPerformed(ActionEvent evt) {
    }

    private void enregistrerButtonActionPerformed(ActionEvent evt) {
        try {
            if (this.textRaisonValue.getText().isEmpty()) {
                new NotifyWindow(NotifyType.WARNING_NOTIFICATION, "Merci de sp\u00e9cifier la raison de modification des informations de licence!", 1500, NPosition.CENTER);
            } else {
                boolean marqueValid = this.saveMarqueNFC525();
                System.out.println("++++++++++++ marqueValid : " + marqueValid);
                if (marqueValid) {
                    BasicStorage.remove("MARQUE_NF_INSTANCE");
                    if (this.keyLicensePanel.isVisible()) {
                        // empty if block
                    }
                    if (!this.keyLicensePanel.isVisible()) {
                        this.addMarque(this.marqueNFC, false);
                        new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, "modification r\u00e9ussite !", 1500, NPosition.CENTER);
                    }
                }
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private void changeInfosMarqueActionPerformed(ActionEvent evt) {
        this.marquePanel.setVisible(true);
        this.toggleMarquePanel(true);
        this.enregistrerButton.setVisible(true);
        this.jPanelUpdateReason.setVisible(true);
        this.keyLicensePanel.setVisible(false);
    }

    private void phoneTextActionPerformed(ActionEvent evt) {
    }

    private void tvaValueActionPerformed(ActionEvent evt) {
    }

    private void paysValueActionPerformed(ActionEvent evt) {
    }

    private void codeNAFValue1ActionPerformed(ActionEvent evt) {
    }

    private void versionTextActionPerformed(ActionEvent evt) {
    }

    private void capitalSocialActionPerformed(ActionEvent evt) {
    }

    private void greffeActionPerformed(ActionEvent evt) {
    }

    private void rcsActionPerformed(ActionEvent evt) {
    }

    private void metierActionPerformed(ActionEvent evt) {
    }

    private void saveMarqueOnDisk(String build) throws IOException {
        FileUtils.writeStringToFile((File)new File(this.MarqueFileOnDisk), (String)build);
    }

    public void addMarque(MarqueNFC marqueNFC, boolean licenceValid) {
        try {
            MarqueNFC oldMarqueInfo = this.m_dlSales.getMarqueNF();
            boolean updated = false;
            if (oldMarqueInfo != null) {
                marqueNFC.setId(oldMarqueInfo.getId());
                if (!oldMarqueInfo.getSiret().equals(marqueNFC.getSiret())) {
                    marqueNFC.setNew_siret(true);
                    marqueNFC.setOld_siret(oldMarqueInfo.getSiret());
                    updated = true;
                    Journal.writeToJET(new Event(410, "Modification des Param\u00e8tres", AppLocal.user.getId(), "Modification du num\u00e9ro de SIRET: " + this.textRaisonValue.getText().replace(",", "-"), new Date().getTime(), (oldMarqueInfo.getSiret() + "=>" + this.marqueNFC.getSiret()).replace(",", "-") + " pour cause de( " + this.textRaisonValue.getText().replace(",", "-") + ")"));
                }
                if (oldMarqueInfo.getCompany() != null && !oldMarqueInfo.getCompany().equals(marqueNFC.getCompany())) {
                    updated = true;
                    Journal.writeToJET(new Event(410, "Modification des Param\u00e8tres", AppLocal.user.getId(), "Modification de la  raison sociale: ", new Date().getTime(), (oldMarqueInfo.getCompany() + "=>" + this.marqueNFC.getCompany()).replace(",", "-") + " pour cause de( " + this.textRaisonValue.getText().replace(",", "-") + ")"));
                }
                if (oldMarqueInfo.getZipCode() != null && !oldMarqueInfo.getZipCode().equals(marqueNFC.getZipCode())) {
                    updated = true;
                    Journal.writeToJET(new Event(410, "Modification des Param\u00e8tres", AppLocal.user.getId(), "Modification du code postale du POS: " + this.textRaisonValue.getText().replace(",", "-"), new Date().getTime(), (oldMarqueInfo.getZipCode() + "=>" + this.marqueNFC.getZipCode()).replace(",", "-") + " pour cause de( " + this.textRaisonValue.getText().replace(",", "-") + ")"));
                }
                if (oldMarqueInfo.getAdresse1() != null && !oldMarqueInfo.getAdresse1().equals(marqueNFC.getAdresse1())) {
                    updated = true;
                    Journal.writeToJET(new Event(410, "Modification des Param\u00e8tres", AppLocal.user.getId(), "Modification de l'adresse du POS: " + this.textRaisonValue.getText().replace(",", "-"), new Date().getTime(), (oldMarqueInfo.getAdresse1() + "=>" + this.marqueNFC.getAdresse1()).replace(",", "-") + " pour cause de( " + this.textRaisonValue.getText().replace(",", "-") + ")"));
                }
                if (oldMarqueInfo.getEmail() != null && !oldMarqueInfo.getEmail().equals(marqueNFC.getEmail())) {
                    updated = true;
                    Journal.writeToJET(new Event(410, "Modification des Param\u00e8tres", AppLocal.user.getId(), "Modification de l'adresse Email du POS: " + this.textRaisonValue.getText().replace(",", "-"), new Date().getTime(), (oldMarqueInfo.getEmail() + "=>" + this.marqueNFC.getEmail()).replace(",", "-") + " pour cause de( " + this.textRaisonValue.getText().replace(",", "-") + ")"));
                }
                if (oldMarqueInfo.getCity() != null && !oldMarqueInfo.getCity().equals(marqueNFC.getCity())) {
                    updated = true;
                    Journal.writeToJET(new Event(410, "Modification des Param\u00e8tres", AppLocal.user.getId(), "Modification de la ville du POS: " + this.textRaisonValue.getText().replace(",", "-"), new Date().getTime(), (oldMarqueInfo.getCity() + "=>" + this.marqueNFC.getCity()).replace(",", "-") + " pour cause de( " + this.textRaisonValue.getText().replace(",", "-") + ")"));
                }
                if (oldMarqueInfo.getCodeNAF() != null && !oldMarqueInfo.getCodeNAF().equals(marqueNFC.getCodeNAF())) {
                    updated = true;
                    Journal.writeToJET(new Event(410, "Modification des Param\u00e8tres", AppLocal.user.getId(), "Modification du Code NAF du POS: " + this.textRaisonValue.getText().replace(",", "-"), new Date().getTime(), (oldMarqueInfo.getCodeNAF() + "=>" + this.marqueNFC.getCodeNAF()).replace(",", "-") + " pour cause de( " + this.textRaisonValue.getText().replace(",", "-") + ")"));
                }
                if (oldMarqueInfo.getCountry() != null && !oldMarqueInfo.getCountry().equals(marqueNFC.getCountry())) {
                    updated = true;
                    Journal.writeToJET(new Event(410, "Modification des Param\u00e8tres", AppLocal.user.getId(), "Modification du Pays du POS: " + this.textRaisonValue.getText().replace(",", "-"), new Date().getTime(), (oldMarqueInfo.getCountry() + "=>" + this.marqueNFC.getCountry()).replace(",", "-") + " pour cause de( " + this.textRaisonValue.getText().replace(",", "-") + ")"));
                }
                if (oldMarqueInfo.getIntraTVA() != null && !oldMarqueInfo.getIntraTVA().equals(marqueNFC.getIntraTVA())) {
                    updated = true;
                    Journal.writeToJET(new Event(410, "Modification des Param\u00e8tres", AppLocal.user.getId(), "Modification du TVA Intra du POS: " + this.textRaisonValue.getText().replace(",", "-"), new Date().getTime(), (oldMarqueInfo.getIntraTVA() + "=>" + this.marqueNFC.getIntraTVA()).replace(",", "-") + " pour cause de( " + this.textRaisonValue.getText().replace(",", "-") + ")"));
                }
                if (oldMarqueInfo.getTel() != null && !oldMarqueInfo.getTel().equals(marqueNFC.getTel())) {
                    updated = true;
                    Journal.writeToJET(new Event(410, "Modification des Param\u00e8tres", AppLocal.user.getId(), "Modification du N\u00b0 de T\u00e9l\u00e9phone du POS: " + this.textRaisonValue.getText().replace(",", "-"), new Date().getTime(), (oldMarqueInfo.getTel() + "=>" + this.marqueNFC.getTel()).replace(",", "-") + " pour cause de( " + this.textRaisonValue.getText().replace(",", "-") + ")"));
                } else if (oldMarqueInfo.getTel() == null && marqueNFC.getTel() != null && !marqueNFC.getTel().trim().isEmpty()) {
                    updated = true;
                    Journal.writeToJET(new Event(410, "Modification des Param\u00e8tres", AppLocal.user.getId(), "Modification du N\u00b0 de T\u00e9l\u00e9phone du POS: " + this.textRaisonValue.getText().replace(",", "-"), new Date().getTime(), this.marqueNFC.getTel().replace(",", "-") + " pour cause de( " + this.textRaisonValue.getText().replace(",", "-") + ")"));
                }
                System.out.println("+++++++ marqueNFC.getForme_juridique() : " + marqueNFC.getForme_juridique());
                System.out.println("+++++++++ marqueNFC.getCapital_social() : " + marqueNFC.getCapital_social());
                if (oldMarqueInfo.getForme_juridique() != null && !oldMarqueInfo.getForme_juridique().equals(marqueNFC.getForme_juridique())) {
                    System.out.println("++++++++++++ step 0");
                    updated = true;
                    Journal.writeToJET(new Event(410, "Modification des Param\u00e8tres", AppLocal.user.getId(), "Modification du Forme juridique Intra du POS: " + this.textRaisonValue.getText().replace(",", "-"), new Date().getTime(), (oldMarqueInfo.getForme_juridique() + "=>" + this.marqueNFC.getForme_juridique()).replace(",", "-") + " pour cause de( " + this.textRaisonValue.getText().replace(",", "-") + ")"));
                } else if (oldMarqueInfo.getForme_juridique() == null && marqueNFC.getForme_juridique() != null && !marqueNFC.getForme_juridique().trim().isEmpty()) {
                    System.out.println("++++++++++++ step 1");
                    updated = true;
                    Journal.writeToJET(new Event(410, "Modification des Param\u00e8tres", AppLocal.user.getId(), "Modification du Forme juridique Intra du POS: " + this.textRaisonValue.getText().replace(",", "-"), new Date().getTime(), this.marqueNFC.getForme_juridique().replace(",", "-") + " pour cause de( " + this.textRaisonValue.getText().replace(",", "-") + ")"));
                }
                if (oldMarqueInfo.getCapital_social() != null && !oldMarqueInfo.getCapital_social().equals(marqueNFC.getCapital_social())) {
                    System.out.println("++++++++++++ step 2");
                    updated = true;
                    Journal.writeToJET(new Event(410, "Modification des Param\u00e8tres", AppLocal.user.getId(), "Modification du TVA Intra du POS: " + this.textRaisonValue.getText().replace(",", "-"), new Date().getTime(), (oldMarqueInfo.getCapital_social() + "=>" + this.marqueNFC.getCapital_social()).replace(",", "-") + " pour cause de( " + this.textRaisonValue.getText().replace(",", "-") + ")"));
                } else if (oldMarqueInfo.getCapital_social() == null && marqueNFC.getCapital_social() != null && !marqueNFC.getCapital_social().trim().isEmpty()) {
                    System.out.println("++++++++++++ step 3");
                    updated = true;
                    Journal.writeToJET(new Event(410, "Modification des Param\u00e8tres", AppLocal.user.getId(), "Modification du TVA Intra du POS: " + this.textRaisonValue.getText().replace(",", "-"), new Date().getTime(), this.marqueNFC.getCapital_social().replace(",", "-") + " pour cause de( " + this.textRaisonValue.getText().replace(",", "-") + ")"));
                }
                if (oldMarqueInfo.getRcs() != null && !oldMarqueInfo.getRcs().equals(marqueNFC.getRcs())) {
                    System.out.println("++++++++++++ step 4");
                    updated = true;
                    Journal.writeToJET(new Event(410, "Modification des Param\u00e8tres", AppLocal.user.getId(), "Modification du TVA Intra du POS: " + this.textRaisonValue.getText().replace(",", "-"), new Date().getTime(), (oldMarqueInfo.getRcs() + "=>" + this.marqueNFC.getRcs()).replace(",", "-") + " pour cause de( " + this.textRaisonValue.getText().replace(",", "-") + ")"));
                } else if (oldMarqueInfo.getRcs() == null && marqueNFC.getRcs() != null && !marqueNFC.getRcs().trim().isEmpty()) {
                    System.out.println("++++++++++++ step 5");
                    updated = true;
                    Journal.writeToJET(new Event(410, "Modification des Param\u00e8tres", AppLocal.user.getId(), "Modification du TVA Intra du POS: " + this.textRaisonValue.getText().replace(",", "-"), new Date().getTime(), this.marqueNFC.getRcs().replace(",", "-") + " pour cause de( " + this.textRaisonValue.getText().replace(",", "-") + ")"));
                }
                if (oldMarqueInfo.getGreffe() != null && !oldMarqueInfo.getGreffe().equals(marqueNFC.getGreffe())) {
                    System.out.println("++++++++++++ step 6");
                    updated = true;
                    Journal.writeToJET(new Event(410, "Modification des Param\u00e8tres", AppLocal.user.getId(), "Modification du TVA Intra du POS: " + this.textRaisonValue.getText().replace(",", "-"), new Date().getTime(), (oldMarqueInfo.getGreffe() + "=>" + this.marqueNFC.getGreffe()).replace(",", "-") + " pour cause de( " + this.textRaisonValue.getText().replace(",", "-") + ")"));
                } else if (oldMarqueInfo.getGreffe() == null && marqueNFC.getGreffe() != null && !marqueNFC.getGreffe().trim().isEmpty()) {
                    System.out.println("++++++++++++ step 7");
                    updated = true;
                    Journal.writeToJET(new Event(410, "Modification des Param\u00e8tres", AppLocal.user.getId(), "Modification du TVA Intra du POS: " + this.textRaisonValue.getText().replace(",", "-"), new Date().getTime(), this.marqueNFC.getGreffe().replace(",", "-") + " pour cause de( " + this.textRaisonValue.getText().replace(",", "-") + ")"));
                }
                if (oldMarqueInfo.getMetier() != null && !oldMarqueInfo.getMetier().equals(marqueNFC.getMetier())) {
                    System.out.println("++++++++++++ step 8");
                    updated = true;
                    Journal.writeToJET(new Event(410, "Modification des Param\u00e8tres", AppLocal.user.getId(), "Modification du TVA Intra du POS: " + this.textRaisonValue.getText().replace(",", "-"), new Date().getTime(), (oldMarqueInfo.getMetier() + "=>" + this.marqueNFC.getMetier()).replace(",", "-") + " pour cause de( " + this.textRaisonValue.getText().replace(",", "-") + ")"));
                } else if (oldMarqueInfo.getMetier() == null && marqueNFC.getMetier() != null && !marqueNFC.getMetier().trim().isEmpty()) {
                    System.out.println("++++++++++++ step 9");
                    updated = true;
                    Journal.writeToJET(new Event(410, "Modification des Param\u00e8tres", AppLocal.user.getId(), "Modification du TVA Intra du POS: " + this.textRaisonValue.getText().replace(",", "-"), new Date().getTime(), this.marqueNFC.getMetier().replace(",", "-") + " pour cause de( " + this.textRaisonValue.getText().replace(",", "-") + ")"));
                }
            } else {
                updated = true;
                Journal.writeToJET(new Event(410, "Modification des Param\u00e8tres", AppLocal.user.getId(), "Initialisation des coordonn\u00e9es du POS: " + this.textRaisonValue.getText().replace(",", "-"), new Date().getTime(), "SIRET : " + marqueNFC.getSiret() + " pour cause de( " + this.textRaisonValue.getText().replace(",", "-") + ")"));
            }
            if (updated || licenceValid) {
                ClientService clientService = new ClientService();
                try {
                    this.m_dlSales.addMarqueNF(marqueNFC);
                    System.out.println("+++++++++++ **************remonte info licence");
                    clientService.synchronizeClientInfos(MarqueNFC.fetchOrStore(this.m_dlSales));
                }
                catch (BasicException ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            }
            AppLocal.marqueNFC = null;
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private boolean isNumber(String aString) {
        try {
            Long.parseLong(aString);
            return true;
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
            return false;
        }
    }

    private boolean isSiretValid(String siret) {
        if (siret.isEmpty()) {
            this.siretNo.setIcon(this.no);
            return false;
        }
        if (siret.length() == 14 && this.isNumber(siret)) {
            this.siretNo.setIcon(this.ok);
            return true;
        }
        this.siretNo.setIcon(this.warning);
        return true;
    }

    private boolean saveMarqueNFC525() throws IOException {
        StringBuilder builder = new StringBuilder();
        String siretValueString = this.siretValue.getText().trim();
        builder.append(siretValueString);
        builder.append("\n");
        String tvaIntraString = this.tvaValue.getText().trim();
        builder.append(tvaIntraString);
        builder.append("\n");
        String codeNafString = this.codeNAFValue1.getText().trim();
        builder.append(codeNafString);
        builder.append("\n");
        String societeString = this.societeValue.getText().trim();
        builder.append(societeString);
        builder.append("\n");
        String adresse1String = this.adresse1Value.getText().trim();
        builder.append(adresse1String);
        builder.append("\n");
        String adresse2String = "";
        builder.append(adresse2String);
        builder.append("\n");
        String codePostaleString = this.codePostalValue.getText().trim();
        builder.append(codePostaleString);
        builder.append("\n");
        String villeString = this.villeValue.getText().trim();
        builder.append(villeString);
        builder.append("\n");
        String paysString = this.paysValue.getText().trim();
        builder.append(paysString);
        String telString = this.phoneText.getText().trim();
        String formJuridiqueString = this.formeJuridique.getText().trim();
        String capitalSocialString = this.capitalSocial.getText().trim();
        String rcsString = this.rcs.getText().trim();
        String greffeString = this.greffe.getText().trim();
        String metierString = this.metier.getText().trim();
        builder.append(telString);
        boolean validateMarque = true;
        if (tvaIntraString.isEmpty()) {
            this.tvaNo.setIcon(this.no);
            validateMarque = false;
        } else {
            this.tvaNo.setIcon(this.ok);
        }
        if (codeNafString.isEmpty()) {
            this.codeNAFNo1.setIcon(this.no);
            validateMarque = false;
        } else {
            this.codeNAFNo1.setIcon(this.ok);
        }
        this.tvaNo.setVisible(true);
        this.codeNAFNo1.setVisible(true);
        if (adresse1String.isEmpty()) {
            this.adresse2No.setIcon(this.no);
            validateMarque = false;
        } else {
            this.adresse2No.setIcon(this.ok);
        }
        this.adresse2No.setVisible(true);
        if (villeString.isEmpty()) {
            this.villeNo.setIcon(this.no);
            validateMarque = false;
        } else {
            this.villeNo.setIcon(this.ok);
        }
        this.villeNo.setVisible(true);
        if (paysString.isEmpty()) {
            this.paysNo.setIcon(this.no);
            validateMarque = false;
        } else {
            this.paysNo.setIcon(this.ok);
        }
        this.paysNo.setVisible(true);
        if (codePostaleString.isEmpty()) {
            this.codePostaleNo.setIcon(this.no);
            validateMarque = false;
        } else {
            this.codePostaleNo.setIcon(this.ok);
        }
        this.codePostaleNo.setVisible(true);
        if (societeString.isEmpty()) {
            this.societeNo.setIcon(this.no);
            validateMarque = false;
        } else {
            this.societeNo.setIcon(this.ok);
        }
        this.societeNo.setVisible(true);
        if (!this.isSiretValid(siretValueString)) {
            validateMarque = false;
        }
        this.siretNo.setVisible(true);
        if (formJuridiqueString.isEmpty()) {
            this.formeJuridiqueNo.setIcon(this.no);
            validateMarque = false;
        } else {
            this.formeJuridiqueNo.setIcon(this.ok);
        }
        this.formeJuridiqueNo.setVisible(true);
        if (capitalSocialString.isEmpty()) {
            this.capitalSocialNo.setIcon(this.no);
            validateMarque = false;
        } else {
            this.capitalSocialNo.setIcon(this.ok);
        }
        this.capitalSocialNo.setVisible(true);
        if (rcsString.isEmpty()) {
            this.rcsNo.setIcon(this.no);
            validateMarque = false;
        } else {
            this.rcsNo.setIcon(this.ok);
        }
        this.rcsNo.setVisible(true);
        if (greffeString.isEmpty()) {
            this.greffeNo.setIcon(this.no);
            validateMarque = false;
        } else {
            this.greffeNo.setIcon(this.ok);
        }
        this.greffeNo.setVisible(true);
        if (metierString.isEmpty()) {
            this.metierNo.setIcon(this.no);
            validateMarque = false;
        } else {
            this.metierNo.setIcon(this.ok);
        }
        this.metierNo.setVisible(true);
        if (validateMarque) {
            this.marqueNFC = new MarqueNFC(siretValueString, tvaIntraString, codeNafString, societeString, adresse1String, adresse2String, codePostaleString, villeString, paysString, telString, formJuridiqueString, capitalSocialString, rcsString, greffeString, metierString);
            this.saveMarqueOnDisk(builder.toString());
        } else {
            JOptionPane.showMessageDialog(this, "Attention ! Des param\u00e8tres sont manquants pour la marque NF525.", "Erreurs dans la marque", 0);
        }
        return validateMarque;
    }

    private void initMarque(MarqueNFC marqueNFC) throws IOException {
        if (marqueNFC != null) {
            this.siretValue.setText(marqueNFC.getSiret());
            this.tvaValue.setText(marqueNFC.getIntraTVA());
            this.codeNAFValue1.setText(marqueNFC.getCodeNAF());
            if (marqueNFC.getIntraTVA() == null || marqueNFC.getIntraTVA().isEmpty()) {
                this.tvaNo.setIcon(this.no);
            } else {
                this.tvaNo.setIcon(this.ok);
            }
            this.tvaNo.setVisible(true);
            if (marqueNFC.getCodeNAF() == null || marqueNFC.getCodeNAF().isEmpty()) {
                this.codeNAFNo1.setIcon(this.no);
            } else {
                this.codeNAFNo1.setIcon(this.ok);
            }
            this.codeNAFNo1.setVisible(true);
            this.isSiretValid(this.siretValue.getText());
            this.siretNo.setVisible(true);
            this.adresse2No.setIcon(this.ok);
            this.adresse2No.setVisible(true);
            this.villeNo.setIcon(this.ok);
            this.villeNo.setVisible(true);
            this.paysNo.setIcon(this.ok);
            this.paysNo.setVisible(true);
            this.codePostaleNo.setIcon(this.ok);
            this.codePostaleNo.setVisible(true);
            this.societeNo.setIcon(this.ok);
            this.societeNo.setVisible(true);
            this.societeValue.setText(marqueNFC.getCompany());
            this.adresse1Value.setText(marqueNFC.getAdresse1());
            this.codePostalValue.setText(marqueNFC.getZipCode());
            this.villeValue.setText(marqueNFC.getCity());
            this.paysValue.setText(marqueNFC.getCountry());
            this.formeJuridique.setText(marqueNFC.getForme_juridique() != null ? marqueNFC.getForme_juridique() : "");
            if (marqueNFC.getForme_juridique() == null || marqueNFC.getForme_juridique().isEmpty()) {
                this.formeJuridiqueNo.setIcon(this.no);
            } else {
                this.formeJuridiqueNo.setIcon(this.ok);
            }
            this.formeJuridiqueNo.setVisible(true);
            this.capitalSocial.setText(marqueNFC.getCapital_social() != null ? marqueNFC.getCapital_social() : "");
            if (marqueNFC.getCapital_social() == null || marqueNFC.getCapital_social().isEmpty()) {
                this.capitalSocialNo.setIcon(this.no);
            } else {
                this.capitalSocialNo.setIcon(this.ok);
            }
            this.capitalSocialNo.setVisible(true);
            this.rcs.setText(marqueNFC.getRcs() != null ? marqueNFC.getRcs() : "");
            if (marqueNFC.getRcs() == null || marqueNFC.getRcs().isEmpty()) {
                this.rcsNo.setIcon(this.no);
            } else {
                this.rcsNo.setIcon(this.ok);
            }
            this.rcsNo.setVisible(true);
            this.greffe.setText(marqueNFC.getGreffe() != null ? marqueNFC.getGreffe() : "");
            if (marqueNFC.getGreffe() == null || marqueNFC.getGreffe().isEmpty()) {
                this.greffeNo.setIcon(this.no);
            } else {
                this.greffeNo.setIcon(this.ok);
            }
            this.greffeNo.setVisible(true);
            this.metier.setText(marqueNFC.getMetier() != null ? marqueNFC.getMetier() : "");
            if (marqueNFC.getMetier() == null || marqueNFC.getMetier().isEmpty()) {
                this.metierNo.setIcon(this.no);
            } else {
                this.metierNo.setIcon(this.ok);
            }
            this.metierNo.setVisible(true);
        }
    }

    public JButton getChangeInfosMarque() {
        return this.changeInfosMarque;
    }

    class OpenUrlAction
    implements MouseListener {
        OpenUrlAction() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            try {
                JPanelConfigLicence.open(new URI("http://pro-tactile.fr"));
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }
}

