/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.config;

import com.openbravo.basic.BasicException;
import com.openbravo.components.SwingSwitchButton;
import com.openbravo.dao.DataLogicSales;
import com.openbravo.dao.DataLogicSalesHelper;
import com.openbravo.data.user.DirtyManager;
import com.openbravo.keen.CassandraManager;
import com.openbravo.pos.config.PanelConfig;
import com.openbravo.pos.forms.AppConfig;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.StartPOS;
import com.openbravo.pos.notify.NPosition;
import com.openbravo.pos.notify.NotifyType;
import com.openbravo.pos.notify.NotifyWindow;
import com.openbravo.pos.sales.JArchives;
import com.openbravo.pos.ticket.MarqueNFC;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.postgresql.db.PostgreService;
import com.openbravo.service.CleanerService;
import fr.protactile.procaisse.services.InfoLicenceGeneratedService;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import se.walkercrou.places.GoogleServices;

public final class JPanelConfigGeneral
extends JPanel
implements PanelConfig {
    private final DirtyManager dirty = new DirtyManager();
    protected DataLogicSales dlSales;
    MarqueNFC entete = null;
    GoogleServices client = new GoogleServices();
    private CassandraManager m_keenProject;
    private PostgreService mPostgreService;
    SwingSwitchButton switchButton = new SwingSwitchButton();
    SwingSwitchButton switchButtonDownloadJsonItem = new SwingSwitchButton();
    private JCheckBox checkBar;
    private JCheckBox checkEmp;
    private JCheckBox checkHappy;
    private JCheckBox checkSP;
    private JCheckBox checkTakeAwayPhone;
    private JCheckBox checkTerasse;
    private JPanel discountBar;
    private JPanel discountEmp;
    private JPanel discountHappyHour;
    private JPanel discountLv;
    private JPanel discountSp;
    private JPanel discountTerasse;
    private JButton generateArchives;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButtonResetLicence;
    private JComboBox<String> jHourEnd;
    private JComboBox<String> jHourStrat;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabelHoraire;
    private JTextField jLabelUserKeenId;
    private JPanel jPanelHoraire;
    private JPanel jPanelHostCode;
    private JPanel jPanelHostName;
    private JPanel jPanelInitDB;
    private JPanel jPanelLAF;
    private JPanel jPanelParent;
    private JPanel jPanelReset;
    private JPanel jPanelScreenMode;
    private JPanel jPanelStatistic;
    private JPanel jPanelTileTypeOrder;
    private JPanel jPanelTypeOrder;
    private JScrollPane jScrollPane2;
    private JComboBox jcboLAF;
    private JComboBox jcboMachineScreenmode;
    private JLabel jlabelMachineCode;
    private JTextField jtxtMachineHostname;
    private JLabel labelPSP;
    private JLabel labelPSP1;
    private JLabel labelPSP2;
    private JLabel labelPSP3;
    private JLabel labelPSP4;
    private JLabel labelPSP5;
    private JPanel panelOnlineSynchParams;
    private JPanel panelResetPreferences;
    private JPanel panelgetOnlineJsonItems;
    private JButton purgeUnsedItems;
    private JButton resetCarte;
    private JButton resetPreferebces;
    private JButton resetZglobal;
    private JCheckBox statsOnline;
    private JTextField textDiscountBar;
    private JTextField textDiscountEmp;
    private JTextField textDiscountHH;
    private JTextField textDiscountLv;
    private JTextField textDiscountSp;
    private JTextField textDiscountTerasse;

    public JPanelConfigGeneral(DataLogicSales dlSales) throws IOException {
        int i;
        this.initComponents();
        this.addToggleActionListener(this.switchButton);
        JLabel label = new JLabel("Synchronisation des param\u00e8tres en ligne  ");
        this.panelOnlineSynchParams.add(label);
        this.panelOnlineSynchParams.add(this.switchButton);
        this.panelOnlineSynchParams.setVisible(true);
        this.addToggleActionListener(this.switchButtonDownloadJsonItem);
        JLabel labelDownloadJsonItem = new JLabel("Telechargement la carte en ligne  ");
        this.panelgetOnlineJsonItems.add(labelDownloadJsonItem);
        this.panelgetOnlineJsonItems.add(this.switchButtonDownloadJsonItem);
        this.panelgetOnlineJsonItems.setVisible(true);
        this.panelResetPreferences.setVisible(false);
        this.dlSales = dlSales;
        this.jcboLAF.addActionListener(this.dirty);
        this.jcboMachineScreenmode.addActionListener(this.dirty);
        this.jPanelLAF.setVisible(false);
        this.jcboMachineScreenmode.addItem("window");
        this.jcboMachineScreenmode.addItem("fullscreen");
        for (i = 0; i < 24; ++i) {
            if (i < 10) {
                this.jHourStrat.addItem("0" + i);
                continue;
            }
            this.jHourStrat.addItem("" + i);
        }
        for (i = 0; i < 24; ++i) {
            if (i < 10) {
                this.jHourEnd.addItem("0" + i);
                continue;
            }
            this.jHourEnd.addItem("" + i);
        }
        this.jLabelUserKeenId.setBackground(null);
        this.jLabelUserKeenId.setBorder(null);
        this.jLabelUserKeenId.getDocument().putProperty("vkType", 4);
        if (AppLocal.user != null && AppLocal.user.getRole().equals("0")) {
            this.resetCarte.setVisible(true);
            this.generateArchives.setVisible(true);
        } else {
            this.resetCarte.setVisible(false);
            this.generateArchives.setVisible(false);
        }
        this.initUserKeenInfo();
    }

    JPanelConfigGeneral() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private void initUserKeenInfo() {
        if (AppLocal.dlItems != null) {
            try {
                String user_keen_id = AppLocal.dlItems.getUserKeenIo();
                System.out.println("+++++++++ user_keen_id : " + user_keen_id);
                if (user_keen_id != null) {
                    this.jLabelUserKeenId.setText("(ID KEEN : " + user_keen_id + " )");
                    DataLogicSalesHelper dataLogicSalesHelper = new DataLogicSalesHelper(null);
                    String codeCaisse = dataLogicSalesHelper.get4lastCharsOfKeenio(user_keen_id);
                    this.jlabelMachineCode.setText(codeCaisse);
                } else {
                    this.jLabelUserKeenId.setText("");
                }
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
    }

    @Override
    public boolean hasChanged() {
        return this.dirty.isDirty();
    }

    @Override
    public Component getConfigComponent() {
        return this;
    }

    @Override
    public void loadProperties(AppConfig config) {
        this.loadButtonSynchro(this.switchButton);
        this.jtxtMachineHostname.setText(config.getProperty("machine.hostname"));
        this.jcboMachineScreenmode.setSelectedItem(config.getProperty("machine.screenmode"));
        this.jHourStrat.setSelectedItem(config.getProperty("horaire.debut"));
        this.jHourEnd.setSelectedItem(config.getProperty("horaire.fin"));
        try {
            this.entete = this.dlSales.getMarqueNF();
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        if (this.entete != null) {
            // empty if block
        }
        if (config.getProperty("order.sp") != null) {
            if ("no".equals(config.getProperty("order.sp"))) {
                this.checkSP.setSelected(false);
                this.discountSp.setVisible(false);
            } else {
                this.checkSP.setSelected(true);
                this.discountSp.setVisible(true);
            }
        } else {
            this.checkSP.setSelected(true);
            this.discountSp.setVisible(false);
        }
        if (config.getProperty("order.emp") != null) {
            if ("no".equals(config.getProperty("order.emp"))) {
                this.checkEmp.setSelected(false);
                this.discountEmp.setVisible(false);
            } else {
                this.checkEmp.setSelected(true);
                this.discountEmp.setVisible(true);
            }
        } else {
            this.checkEmp.setSelected(true);
            this.discountEmp.setVisible(false);
        }
        if (config.getProperty("order.bar") != null && "yes".equals(config.getProperty("order.bar"))) {
            this.checkBar.setSelected(true);
            this.discountBar.setVisible(true);
        } else {
            this.checkBar.setSelected(false);
            this.discountBar.setVisible(false);
        }
        if (config.getProperty("order.terasse") != null && "yes".equals(config.getProperty("order.terasse"))) {
            this.checkTerasse.setSelected(true);
            this.discountTerasse.setVisible(true);
        } else {
            this.checkTerasse.setSelected(false);
            this.discountTerasse.setVisible(false);
        }
        if (config.getProperty("order.happyHour") != null && "yes".equals(config.getProperty("order.happyHour"))) {
            this.checkHappy.setSelected(true);
            this.discountHappyHour.setVisible(true);
        } else {
            this.checkHappy.setSelected(false);
            this.discountHappyHour.setVisible(false);
        }
        this.dirty.setDirty(false);
        if (config.getProperty("stats.online") != null && config.getProperty("stats.online").equals("yes")) {
            this.statsOnline.setSelected(true);
        } else {
            this.statsOnline.setSelected(false);
        }
        this.textDiscountSp.setText(config.getProperty("discount.sp"));
        this.textDiscountEmp.setText(config.getProperty("discount.emp"));
        this.textDiscountLv.setText(config.getProperty("discount.lv"));
        this.textDiscountBar.setText(config.getProperty("discount.bar"));
        this.textDiscountTerasse.setText(config.getProperty("discount.terasse"));
        this.textDiscountHH.setText(config.getProperty("discount.happyHour"));
        if (AppLocal.licence != null && AppLocal.licence.equals("livraison")) {
            this.discountLv.setVisible(true);
        } else {
            this.discountLv.setVisible(false);
        }
        this.checkTakeAwayPhone.setSelected(config.getBooleanProperty("order.take.away.phone"));
        this.loadButtonDownloadJsonItems(this.switchButtonDownloadJsonItem);
    }

    @Override
    public void saveProperties(AppConfig config) {
        if (this.switchButton.getText().equals("ON")) {
            config.setProperty("synchro.param.firebase", "yes");
        } else {
            config.setProperty("synchro.param.firebase", "no");
        }
        config.setProperty("machine.hostname", this.jtxtMachineHostname.getText());
        LAFInfo laf = null;
        config.setProperty("swing.defaultlaf", laf == null ? System.getProperty("swing.defaultlaf", "javax.swing.plaf.metal.MetalLookAndFeel") : laf.getClassName());
        config.setProperty("machine.screenmode", this.comboValue(this.jcboMachineScreenmode.getSelectedItem()));
        config.setProperty("horaire.debut", (String)this.jHourStrat.getSelectedItem());
        config.setProperty("horaire.fin", (String)this.jHourEnd.getSelectedItem());
        if (this.checkSP.isSelected()) {
            config.setProperty("order.sp", "yes");
        } else {
            config.setProperty("order.sp", "no");
        }
        if (this.checkEmp.isSelected()) {
            config.setProperty("order.emp", "yes");
        } else {
            config.setProperty("order.emp", "no");
        }
        if (this.checkBar.isSelected()) {
            config.setProperty("order.bar", "yes");
        } else {
            config.setProperty("order.bar", "no");
        }
        if (this.checkTerasse.isSelected()) {
            config.setProperty("order.terasse", "yes");
        } else {
            config.setProperty("order.terasse", "no");
        }
        if (this.checkHappy.isSelected()) {
            config.setProperty("order.happyHour", "yes");
        } else {
            config.setProperty("order.happyHour", "no");
        }
        config.setProperty("discount.sp", this.textDiscountSp.getText());
        config.setProperty("discount.emp", this.textDiscountEmp.getText());
        config.setProperty("discount.lv", this.textDiscountLv.getText());
        config.setProperty("discount.bar", this.textDiscountBar.getText());
        config.setProperty("discount.terasse", this.textDiscountTerasse.getText());
        config.setProperty("discount.happyHour", this.textDiscountHH.getText());
        if (this.statsOnline.isSelected()) {
            config.setProperty("stats.online", "yes");
        } else {
            config.setProperty("stats.online", "no");
        }
        config.setProperty("order.take.away.phone", this.checkTakeAwayPhone.isSelected() ? "yes" : "no");
        System.out.println("switchButtonDownloadJsonItem.getText() : " + this.switchButtonDownloadJsonItem.getText());
        if (this.switchButtonDownloadJsonItem.getText().equals("ON")) {
            config.setProperty("download.online.json.items", "yes");
        } else {
            config.setProperty("download.online.json.items", "no");
        }
        this.dirty.setDirty(false);
    }

    private String comboValue(Object value) {
        return value == null ? "" : value.toString();
    }

    @Override
    public void activate() {
        this.jPanelParent.removeAll();
        this.jPanelParent.add(this.jPanelHostName);
        this.jPanelParent.add(this.jPanelHostCode);
        if (AppLocal.user != null && AppLocal.user.getRole().equals("0")) {
            this.jPanelParent.add(this.jPanelScreenMode);
            this.jPanelParent.add(this.jPanelHoraire);
            this.jPanelParent.add(this.jPanelHoraire);
            this.jPanelParent.add(this.jPanelStatistic);
            this.jPanelParent.add(this.jPanelInitDB);
            this.jPanelParent.add(this.jPanelReset);
            this.jPanelParent.add(this.jPanelTileTypeOrder);
            this.jPanelParent.add(this.jPanelTypeOrder);
            this.jPanelParent.add(this.discountSp);
            this.jPanelParent.add(this.discountEmp);
            this.jPanelParent.add(this.discountLv);
            this.jPanelParent.add(this.discountBar);
            this.jPanelParent.add(this.discountTerasse);
            this.jPanelParent.add(this.discountHappyHour);
            this.jPanelParent.add(this.panelResetPreferences);
            this.jPanelParent.add(this.panelOnlineSynchParams);
            this.jPanelParent.add(this.panelgetOnlineJsonItems);
        }
    }

    public void loadButtonSynchro(SwingSwitchButton mButton) {
        if (AppLocal.SYNCHRO_PARAM_FIREBASE) {
            mButton.setText("ON");
            mButton.setBackground(Color.GREEN);
        } else {
            mButton.setText("OFF");
            mButton.setBackground(Color.GRAY);
        }
    }

    public void addToggleActionListener(final SwingSwitchButton button) {
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (button.isSelected()) {
                    button.setText("ON");
                    button.setBackground(Color.GREEN);
                    UIManager.put("ToggleButton.select", Color.GREEN);
                } else {
                    button.setText("OFF");
                    button.setBackground(Color.GRAY);
                }
                button.repaint();
            }
        });
    }

    private void initComponents() {
        this.jScrollPane2 = new JScrollPane();
        this.jPanelParent = new JPanel();
        this.jPanelHostName = new JPanel();
        this.jLabel1 = new JLabel();
        this.jtxtMachineHostname = new JTextField();
        this.jPanelHostCode = new JPanel();
        this.jLabel8 = new JLabel();
        this.jlabelMachineCode = new JLabel();
        this.jPanelLAF = new JPanel();
        this.jLabel2 = new JLabel();
        this.jcboLAF = new JComboBox();
        this.jPanelScreenMode = new JPanel();
        this.jLabel3 = new JLabel();
        this.jcboMachineScreenmode = new JComboBox();
        this.jPanelHoraire = new JPanel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jHourStrat = new JComboBox();
        this.jLabel7 = new JLabel();
        this.jHourEnd = new JComboBox();
        this.jLabelHoraire = new JLabel();
        this.jPanelStatistic = new JPanel();
        this.statsOnline = new JCheckBox();
        this.jLabelUserKeenId = new JTextField();
        this.jPanelInitDB = new JPanel();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.resetCarte = new JButton();
        this.generateArchives = new JButton();
        this.resetZglobal = new JButton();
        this.jPanelReset = new JPanel();
        this.jButtonResetLicence = new JButton();
        this.purgeUnsedItems = new JButton();
        this.jPanelTileTypeOrder = new JPanel();
        this.jLabel4 = new JLabel();
        this.jPanelTypeOrder = new JPanel();
        this.checkSP = new JCheckBox();
        this.checkEmp = new JCheckBox();
        this.checkBar = new JCheckBox();
        this.checkHappy = new JCheckBox();
        this.checkTerasse = new JCheckBox();
        this.checkTakeAwayPhone = new JCheckBox();
        this.discountSp = new JPanel();
        this.labelPSP = new JLabel();
        this.textDiscountSp = new JTextField();
        this.discountEmp = new JPanel();
        this.labelPSP3 = new JLabel();
        this.textDiscountEmp = new JTextField();
        this.discountLv = new JPanel();
        this.labelPSP4 = new JLabel();
        this.textDiscountLv = new JTextField();
        this.discountBar = new JPanel();
        this.labelPSP2 = new JLabel();
        this.textDiscountBar = new JTextField();
        this.discountTerasse = new JPanel();
        this.labelPSP1 = new JLabel();
        this.textDiscountTerasse = new JTextField();
        this.discountHappyHour = new JPanel();
        this.labelPSP5 = new JLabel();
        this.textDiscountHH = new JTextField();
        this.panelOnlineSynchParams = new JPanel();
        this.panelgetOnlineJsonItems = new JPanel();
        this.panelResetPreferences = new JPanel();
        this.resetPreferebces = new JButton();
        this.setFont(new Font("Arial", 0, 12));
        this.setPreferredSize(new Dimension(650, 450));
        this.setLayout(new BorderLayout());
        this.jScrollPane2.setVerticalScrollBarPolicy(22);
        this.jPanelParent.setPreferredSize(new Dimension(900, 840));
        this.jPanelParent.setLayout(new FlowLayout(0));
        this.jPanelHostName.setPreferredSize(new Dimension(900, 40));
        this.jPanelHostName.setLayout(new FlowLayout(0));
        this.jLabel1.setFont(new Font("Arial", 1, 12));
        this.jLabel1.setText("Nom Machine");
        this.jLabel1.setPreferredSize(new Dimension(200, 30));
        this.jPanelHostName.add(this.jLabel1);
        this.jtxtMachineHostname.setFont(new Font("Arial", 0, 12));
        this.jtxtMachineHostname.setCursor(new Cursor(0));
        this.jtxtMachineHostname.setMinimumSize(new Dimension(130, 25));
        this.jtxtMachineHostname.setPreferredSize(new Dimension(200, 30));
        this.jPanelHostName.add(this.jtxtMachineHostname);
        this.jPanelParent.add(this.jPanelHostName);
        this.jPanelHostCode.setPreferredSize(new Dimension(900, 40));
        this.jPanelHostCode.setLayout(new FlowLayout(0));
        this.jLabel8.setFont(new Font("Arial", 1, 12));
        this.jLabel8.setText("Code Machine");
        this.jLabel8.setPreferredSize(new Dimension(200, 30));
        this.jPanelHostCode.add(this.jLabel8);
        this.jlabelMachineCode.setBorder(BorderFactory.createLineBorder(new Color(102, 102, 102)));
        this.jlabelMachineCode.setPreferredSize(new Dimension(200, 30));
        this.jPanelHostCode.add(this.jlabelMachineCode);
        this.jPanelParent.add(this.jPanelHostCode);
        this.jPanelLAF.setPreferredSize(new Dimension(900, 40));
        this.jPanelLAF.setLayout(new FlowLayout(0));
        this.jLabel2.setFont(new Font("Arial", 1, 12));
        this.jLabel2.setText("Apparence");
        this.jLabel2.setPreferredSize(new Dimension(200, 30));
        this.jPanelLAF.add(this.jLabel2);
        this.jcboLAF.setFont(new Font("Arial", 0, 14));
        this.jcboLAF.setCursor(new Cursor(0));
        this.jcboLAF.setPreferredSize(new Dimension(200, 30));
        this.jcboLAF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelConfigGeneral.this.jcboLAFActionPerformed(evt);
            }
        });
        this.jPanelLAF.add(this.jcboLAF);
        this.jPanelParent.add(this.jPanelLAF);
        this.jPanelScreenMode.setPreferredSize(new Dimension(900, 40));
        this.jPanelScreenMode.setLayout(new FlowLayout(0));
        this.jLabel3.setFont(new Font("Arial", 1, 12));
        this.jLabel3.setText("Ecran");
        this.jLabel3.setPreferredSize(new Dimension(200, 30));
        this.jPanelScreenMode.add(this.jLabel3);
        this.jcboMachineScreenmode.setFont(new Font("Arial", 0, 14));
        this.jcboMachineScreenmode.setCursor(new Cursor(0));
        this.jcboMachineScreenmode.setPreferredSize(new Dimension(200, 30));
        this.jcboMachineScreenmode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelConfigGeneral.this.jcboMachineScreenmodeActionPerformed(evt);
            }
        });
        this.jPanelScreenMode.add(this.jcboMachineScreenmode);
        this.jPanelParent.add(this.jPanelScreenMode);
        this.jPanelHoraire.setPreferredSize(new Dimension(900, 40));
        this.jPanelHoraire.setLayout(new FlowLayout(0));
        this.jLabel5.setFont(new Font("Tahoma", 1, 11));
        this.jLabel5.setText("Horaire");
        this.jLabel5.setPreferredSize(new Dimension(200, 30));
        this.jPanelHoraire.add(this.jLabel5);
        this.jLabel6.setText("D\u00e9but");
        this.jPanelHoraire.add(this.jLabel6);
        this.jHourStrat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelConfigGeneral.this.jHourStratActionPerformed(evt);
            }
        });
        this.jPanelHoraire.add(this.jHourStrat);
        this.jLabel7.setText("fin");
        this.jPanelHoraire.add(this.jLabel7);
        this.jHourEnd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelConfigGeneral.this.jHourEndActionPerformed(evt);
            }
        });
        this.jPanelHoraire.add(this.jHourEnd);
        this.jLabelHoraire.setPreferredSize(new Dimension(300, 30));
        this.jPanelHoraire.add(this.jLabelHoraire);
        this.jPanelParent.add(this.jPanelHoraire);
        this.jPanelStatistic.setPreferredSize(new Dimension(900, 40));
        this.jPanelStatistic.setLayout(new FlowLayout(0));
        this.statsOnline.setText("Statistiques en ligne");
        this.statsOnline.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelConfigGeneral.this.statsOnlineActionPerformed(evt);
            }
        });
        this.jPanelStatistic.add(this.statsOnline);
        this.jLabelUserKeenId.setEditable(false);
        this.jLabelUserKeenId.setBorder(null);
        this.jLabelUserKeenId.setPreferredSize(new Dimension(400, 30));
        this.jLabelUserKeenId.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelConfigGeneral.this.jLabelUserKeenIdActionPerformed(evt);
            }
        });
        this.jPanelStatistic.add(this.jLabelUserKeenId);
        this.jPanelParent.add(this.jPanelStatistic);
        this.jPanelInitDB.setPreferredSize(new Dimension(950, 40));
        this.jPanelInitDB.setLayout(new FlowLayout(0));
        this.jButton1.setText("R\u00e9ouvrir ma caisse");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelConfigGeneral.this.jButton1ActionPerformed(evt);
            }
        });
        this.jPanelInitDB.add(this.jButton1);
        this.jButton2.setText("r\u00e9cup\u00e9rer l'espace inutilis\u00e9");
        this.jButton2.setPreferredSize(new Dimension(200, 23));
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelConfigGeneral.this.jButton2ActionPerformed(evt);
            }
        });
        this.jPanelInitDB.add(this.jButton2);
        this.resetCarte.setFont(new Font("Arial", 1, 12));
        this.resetCarte.setForeground(new Color(255, 0, 0));
        this.resetCarte.setText("Vider la carte");
        this.resetCarte.setPreferredSize(new Dimension(150, 25));
        this.resetCarte.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelConfigGeneral.this.resetCarteActionPerformed(evt);
            }
        });
        this.jPanelInitDB.add(this.resetCarte);
        this.generateArchives.setFont(new Font("Arial", 1, 12));
        this.generateArchives.setText("Reg\u00e9n\u00e9rer les archives");
        this.generateArchives.setToolTipText("");
        this.generateArchives.setPreferredSize(new Dimension(180, 25));
        this.generateArchives.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelConfigGeneral.this.generateArchivesActionPerformed(evt);
            }
        });
        this.jPanelInitDB.add(this.generateArchives);
        this.resetZglobal.setFont(new Font("Arial", 1, 12));
        this.resetZglobal.setText("R\u00e9initialiser Z global");
        this.resetZglobal.setToolTipText("");
        this.resetZglobal.setPreferredSize(new Dimension(250, 25));
        this.resetZglobal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelConfigGeneral.this.resetZglobalActionPerformed(evt);
            }
        });
        this.jPanelInitDB.add(this.resetZglobal);
        this.jPanelParent.add(this.jPanelInitDB);
        this.jPanelReset.setPreferredSize(new Dimension(950, 40));
        this.jPanelReset.setLayout(new FlowLayout(0));
        this.jButtonResetLicence.setText("R\u00e9initialiser licence");
        this.jButtonResetLicence.setPreferredSize(new Dimension(150, 25));
        this.jButtonResetLicence.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelConfigGeneral.this.jButtonResetLicenceActionPerformed(evt);
            }
        });
        this.jPanelReset.add(this.jButtonResetLicence);
        this.purgeUnsedItems.setFont(new Font("Arial", 1, 12));
        this.purgeUnsedItems.setForeground(new Color(255, 0, 0));
        this.purgeUnsedItems.setText("Purger les produits");
        this.purgeUnsedItems.setPreferredSize(new Dimension(250, 25));
        this.purgeUnsedItems.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelConfigGeneral.this.purgeUnsedItemsActionPerformed(evt);
            }
        });
        this.jPanelReset.add(this.purgeUnsedItems);
        this.jPanelParent.add(this.jPanelReset);
        this.jPanelTileTypeOrder.setPreferredSize(new Dimension(900, 30));
        this.jPanelTileTypeOrder.setLayout(new FlowLayout(0));
        this.jLabel4.setFont(new Font("Tahoma", 1, 12));
        this.jLabel4.setText("Les types commande possible");
        this.jPanelTileTypeOrder.add(this.jLabel4);
        this.jPanelParent.add(this.jPanelTileTypeOrder);
        this.jPanelTypeOrder.setPreferredSize(new Dimension(900, 40));
        this.jPanelTypeOrder.setLayout(new FlowLayout(0));
        this.checkSP.setText("Sur Place");
        this.checkSP.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                JPanelConfigGeneral.this.checkSPItemStateChanged(evt);
            }
        });
        this.checkSP.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelConfigGeneral.this.checkSPActionPerformed(evt);
            }
        });
        this.jPanelTypeOrder.add(this.checkSP);
        this.checkEmp.setText("Emporter");
        this.checkEmp.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                JPanelConfigGeneral.this.checkEmpItemStateChanged(evt);
            }
        });
        this.jPanelTypeOrder.add(this.checkEmp);
        this.checkBar.setText("BAR");
        this.checkBar.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                JPanelConfigGeneral.this.checkBarItemStateChanged(evt);
            }
        });
        this.jPanelTypeOrder.add(this.checkBar);
        this.checkHappy.setText("Happy Hour");
        this.checkHappy.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                JPanelConfigGeneral.this.checkHappyItemStateChanged(evt);
            }
        });
        this.checkHappy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelConfigGeneral.this.checkHappyActionPerformed(evt);
            }
        });
        this.jPanelTypeOrder.add(this.checkHappy);
        this.checkTerasse.setText("Terasse");
        this.checkTerasse.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                JPanelConfigGeneral.this.checkTerasseItemStateChanged(evt);
            }
        });
        this.jPanelTypeOrder.add(this.checkTerasse);
        this.checkTakeAwayPhone.setText("Emporter t\u00e9l\u00e9phone");
        this.checkTakeAwayPhone.setPreferredSize(new Dimension(200, 23));
        this.checkTakeAwayPhone.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                JPanelConfigGeneral.this.checkTakeAwayPhoneItemStateChanged(evt);
            }
        });
        this.jPanelTypeOrder.add(this.checkTakeAwayPhone);
        this.jPanelParent.add(this.jPanelTypeOrder);
        this.discountSp.setPreferredSize(new Dimension(900, 40));
        this.discountSp.setLayout(new FlowLayout(0));
        this.labelPSP.setText("Promotion SP en %");
        this.labelPSP.setPreferredSize(new Dimension(200, 30));
        this.discountSp.add(this.labelPSP);
        this.textDiscountSp.setPreferredSize(new Dimension(40, 30));
        this.discountSp.add(this.textDiscountSp);
        this.jPanelParent.add(this.discountSp);
        this.discountEmp.setPreferredSize(new Dimension(900, 40));
        this.discountEmp.setLayout(new FlowLayout(0));
        this.labelPSP3.setText("Promotion EMP en %");
        this.labelPSP3.setPreferredSize(new Dimension(200, 30));
        this.discountEmp.add(this.labelPSP3);
        this.textDiscountEmp.setPreferredSize(new Dimension(40, 30));
        this.discountEmp.add(this.textDiscountEmp);
        this.jPanelParent.add(this.discountEmp);
        this.discountLv.setPreferredSize(new Dimension(900, 40));
        this.discountLv.setLayout(new FlowLayout(0));
        this.labelPSP4.setText("Promotion LV en %");
        this.labelPSP4.setPreferredSize(new Dimension(200, 30));
        this.discountLv.add(this.labelPSP4);
        this.textDiscountLv.setPreferredSize(new Dimension(40, 30));
        this.discountLv.add(this.textDiscountLv);
        this.jPanelParent.add(this.discountLv);
        this.discountBar.setPreferredSize(new Dimension(900, 40));
        this.discountBar.setLayout(new FlowLayout(0));
        this.labelPSP2.setText("Promotion BAR en %");
        this.labelPSP2.setPreferredSize(new Dimension(200, 30));
        this.discountBar.add(this.labelPSP2);
        this.textDiscountBar.setPreferredSize(new Dimension(40, 30));
        this.discountBar.add(this.textDiscountBar);
        this.jPanelParent.add(this.discountBar);
        this.discountTerasse.setPreferredSize(new Dimension(900, 40));
        this.discountTerasse.setLayout(new FlowLayout(0));
        this.labelPSP1.setText("Promotion Terasse en %");
        this.labelPSP1.setPreferredSize(new Dimension(200, 30));
        this.discountTerasse.add(this.labelPSP1);
        this.textDiscountTerasse.setPreferredSize(new Dimension(40, 30));
        this.discountTerasse.add(this.textDiscountTerasse);
        this.jPanelParent.add(this.discountTerasse);
        this.discountHappyHour.setPreferredSize(new Dimension(900, 40));
        this.discountHappyHour.setLayout(new FlowLayout(0));
        this.labelPSP5.setText("Promotion Happy Hour en %");
        this.labelPSP5.setPreferredSize(new Dimension(200, 30));
        this.discountHappyHour.add(this.labelPSP5);
        this.textDiscountHH.setPreferredSize(new Dimension(40, 30));
        this.discountHappyHour.add(this.textDiscountHH);
        this.jPanelParent.add(this.discountHappyHour);
        this.panelOnlineSynchParams.setPreferredSize(new Dimension(900, 40));
        this.panelOnlineSynchParams.setLayout(new FlowLayout(0));
        this.jPanelParent.add(this.panelOnlineSynchParams);
        this.panelgetOnlineJsonItems.setPreferredSize(new Dimension(900, 40));
        this.panelgetOnlineJsonItems.setLayout(new FlowLayout(0));
        this.jPanelParent.add(this.panelgetOnlineJsonItems);
        this.panelResetPreferences.setPreferredSize(new Dimension(900, 40));
        this.panelResetPreferences.setLayout(new FlowLayout(0));
        this.resetPreferebces.setText("Reset les preferences");
        this.resetPreferebces.setPreferredSize(new Dimension(200, 30));
        this.resetPreferebces.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelConfigGeneral.this.resetPreferebcesActionPerformed(evt);
            }
        });
        this.panelResetPreferences.add(this.resetPreferebces);
        this.jPanelParent.add(this.panelResetPreferences);
        this.jScrollPane2.setViewportView(this.jPanelParent);
        this.add((Component)this.jScrollPane2, "Center");
    }

    private void jHourEndActionPerformed(ActionEvent evt) {
        int end;
        int start = Integer.parseInt((String)this.jHourStrat.getSelectedItem());
        if (start >= (end = Integer.parseInt((String)this.jHourEnd.getSelectedItem()))) {
            this.jLabelHoraire.setText("de " + this.jHourStrat.getSelectedItem() + " \u00e0 " + this.jHourEnd.getSelectedItem() + " du lendemain");
        } else {
            this.jLabelHoraire.setText("de " + this.jHourStrat.getSelectedItem() + " \u00e0 " + this.jHourEnd.getSelectedItem());
        }
    }

    private void jHourStratActionPerformed(ActionEvent evt) {
    }

    private void jcboLAFActionPerformed(ActionEvent evt) {
    }

    private void statsOnlineActionPerformed(ActionEvent evt) {
    }

    private void checkHappyActionPerformed(ActionEvent evt) {
    }

    private void jLabelUserKeenIdActionPerformed(ActionEvent evt) {
    }

    private void checkSPActionPerformed(ActionEvent evt) {
    }

    private void checkSPItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.discountSp.setVisible(true);
        } else {
            this.discountSp.setVisible(false);
        }
    }

    private void checkEmpItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.discountEmp.setVisible(true);
        } else {
            this.discountEmp.setVisible(false);
        }
    }

    private void checkBarItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.discountBar.setVisible(true);
        } else {
            this.discountBar.setVisible(false);
        }
    }

    private void checkTerasseItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.discountTerasse.setVisible(true);
        } else {
            this.discountTerasse.setVisible(false);
        }
    }

    private void checkHappyItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.discountHappyHour.setVisible(true);
        } else {
            this.discountHappyHour.setVisible(false);
        }
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        try {
            int dialogResult = JOptionPane.showConfirmDialog(this, "Veuillez confirmer la r\u00e9ouverture de votre caisse ?", "Warning", 0);
            if (dialogResult == 0) {
                try {
                    CleanerService.build().cleanClotureAfterToday();
                }
                catch (BasicException ex) {
                    Logger.getLogger(JPanelConfigGeneral.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        catch (Exception ex) {
            Logger.getLogger(JPanelConfigGeneral.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        try {
            AppLocal.dlSystem.reclaimUnusedSpace();
        }
        catch (BasicException ex) {
            Logger.getLogger(JPanelConfigGeneral.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void resetCarteActionPerformed(ActionEvent evt) {
        int dialogButton = 0;
        int dialogResult = JOptionPane.showConfirmDialog(this, "Voulez-vous vraiment r\u00e9initialiser votre carte?", "Warning", dialogButton);
        if (dialogResult == 0) {
            try {
                this.dlSales.resetCarte();
                new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, "La carte a \u00e9t\u00e9 r\u00e9initialis\u00e9 avec succ\u00e8s !", 1500, NPosition.CENTER);
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
                new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Une erreur est servenue.", 1500, NPosition.CENTER);
            }
        }
    }

    private void resetPreferebcesActionPerformed(ActionEvent evt) {
        try {
            Preferences preferences = Preferences.userNodeForPackage(StartPOS.class);
            preferences.clear();
            preferences.flush();
            new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, "Les pr\u00e9f\u00e9rences ont \u00e9t\u00e9 r\u00e9initialis\u00e9es.", 1500, NPosition.CENTER);
        }
        catch (BackingStoreException ex) {
            new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Une erreur est servenue.", 1500, NPosition.CENTER);
        }
    }

    private void generateArchivesActionPerformed(ActionEvent evt) {
        try {
            JArchives.showMessage(this, this.dlSales);
        }
        catch (BasicException | IOException ex) {
            new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Une erreur est servenu.", 4000, NPosition.CENTER);
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private void jcboMachineScreenmodeActionPerformed(ActionEvent evt) {
    }

    private void resetZglobalActionPerformed(ActionEvent evt) {
        try {
            this.dlSales.resetZglobal();
            new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, "veuillez red\u00e9marrer la caisse pour reg\u00e9nerer Z global.", 4000, NPosition.CENTER);
        }
        catch (Exception ex) {
            new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Une erreur est servenu.", 4000, NPosition.CENTER);
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private void jButtonResetLicenceActionPerformed(ActionEvent evt) {
        int dialogButton = 0;
        int dialogResult = JOptionPane.showConfirmDialog(null, "vous voulez vraiment r\u00e9initialiser licence id ? \n (cela a un impact sur le click and collect)", "Licence", dialogButton);
        if (dialogResult == 0) {
            InfoLicenceGeneratedService mInfoLicenceGeneratedService = InfoLicenceGeneratedService.getInstance();
            mInfoLicenceGeneratedService.resetLicence();
            JOptionPane.showMessageDialog(new JFrame(), "Licence r\u00e9initialis\u00e9. Les modifications prendront effet apr\u00e8s le red\u00e9marrage de l'application.", AppLocal.getIntString("message.title"), 1);
        }
    }

    private void checkTakeAwayPhoneItemStateChanged(ItemEvent evt) {
    }

    private void jButtonResetIdGlobalActionPerformed(ActionEvent evt) {
        try {
            AppLocal.dlItems.resetIdGlobal();
        }
        catch (BasicException ex) {
            new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Une erreur est servenu.", 4000, NPosition.CENTER);
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private void purgeUnsedItemsActionPerformed(ActionEvent evt) {
        int dialogButton = 0;
        int dialogResult = JOptionPane.showConfirmDialog(null, "vous voulez vraiment Purger les produits supprim\u00e9s non utilis\u00e9s ? ", "Licence", dialogButton);
        if (dialogResult == 0) {
            this.purgeUnsedItems.setText("Purge en cours ...");
            this.purgeUnsedItems.setEnabled(false);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        AppLocal.dlItems.deleteUnusedItems();
                        new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, "Les articles supprim\u00e9s et non utilis\u00e9s ont \u00e9t\u00e9 purg\u00e9s avec succ\u00e8s.", 1500, NPosition.CENTER);
                    }
                    catch (Exception ex) {
                        LogToFile.log("severe", ex.getMessage(), ex);
                        new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Une erreur est servenue.", 1500, NPosition.CENTER);
                    }
                    JPanelConfigGeneral.this.purgeUnsedItems.setText("Purger les produits");
                    JPanelConfigGeneral.this.purgeUnsedItems.setEnabled(true);
                }
            }).start();
        }
    }

    public void loadButtonDownloadJsonItems(SwingSwitchButton mButton) {
        System.out.println("AppLocal.DOWNLOAD_ONLINE_JSON_ITEMS config: " + AppLocal.DOWNLOAD_ONLINE_JSON_ITEMS);
        if (AppLocal.DOWNLOAD_ONLINE_JSON_ITEMS) {
            mButton.setText("ON");
            mButton.setBackground(Color.GREEN);
        } else {
            mButton.setText("OFF");
            mButton.setBackground(Color.GRAY);
        }
    }

    private static class LAFInfo {
        private final String name;
        private final String classname;

        public LAFInfo(String name, String classname) {
            this.name = name;
            this.classname = classname;
        }

        public String getName() {
            return this.name;
        }

        public String getClassName() {
            return this.classname;
        }

        public String toString() {
            return this.name;
        }
    }
}

