/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.config;

import com.openbravo.data.gui.WrapLayout;
import com.openbravo.data.user.DirtyManager;
import com.openbravo.pos.config.PanelConfig;
import com.openbravo.pos.forms.AppConfig;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.util.DateUtils;
import com.openbravo.pos.util.DirectoryEvent;
import com.openbravo.pos.util.SystemUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.nio.file.Paths;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class JPanelConfigDatabase
extends JPanel
implements PanelConfig {
    private final DirtyManager dirty = new DirtyManager();
    private static final int BUFFER_SIZE = 4096;
    private JLabel jLabel1;
    private JLabel jLabel18;
    private JLabel jLabel2;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JPanel jPanel10;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JButton jbtnDbDriverLib;
    private JComboBox jcboDBDriver;
    private JTextField jtxtDbDriver;
    private JTextField jtxtDbDriverLib;
    private JTextField jtxtDbURL;

    public JPanelConfigDatabase(boolean hideExport) {
        this.initComponents();
        this.jtxtDbDriverLib.getDocument().addDocumentListener(this.dirty);
        this.jtxtDbDriver.getDocument().addDocumentListener(this.dirty);
        this.jtxtDbURL.getDocument().addDocumentListener(this.dirty);
        this.jbtnDbDriverLib.addActionListener(new DirectoryEvent(this.jtxtDbDriverLib));
        this.jcboDBDriver.addActionListener(this.dirty);
        this.jcboDBDriver.addItem("Apache Derby Embedded");
        this.jcboDBDriver.addItem("Apache Derby Client/Server");
        this.jcboDBDriver.addItem("HSQLDB");
        this.jcboDBDriver.addItem("MySQL");
        this.jcboDBDriver.addItem("Oracle 11g Express");
        this.jcboDBDriver.addItem("PostgreSQL");
    }

    @Override
    public boolean hasChanged() {
        return this.dirty.isDirty();
    }

    @Override
    public Component getConfigComponent() {
        return this;
    }

    @Override
    public void loadProperties(AppConfig config) {
        this.jcboDBDriver.setSelectedItem(config.getProperty("db.engine"));
        this.jtxtDbDriverLib.setText(config.getProperty("db.driverlib"));
        this.jtxtDbDriver.setText(config.getProperty("db.driver"));
        this.jtxtDbURL.setText(config.getProperty("db.URL"));
        this.dirty.setDirty(false);
    }

    @Override
    public void saveProperties(AppConfig config) {
        config.setProperty("db.engine", this.comboValue(this.jcboDBDriver.getSelectedItem()));
        config.setProperty("db.driverlib", this.jtxtDbDriverLib.getText());
        config.setProperty("db.driver", this.jtxtDbDriver.getText());
        config.setProperty("db.URL", this.jtxtDbURL.getText());
        this.dirty.setDirty(false);
    }

    private String comboValue(Object value) {
        return value == null ? "" : value.toString();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel(new WrapLayout());
        this.jPanel3 = new JPanel();
        this.jLabel6 = new JLabel();
        this.jcboDBDriver = new JComboBox();
        this.jPanel5 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jtxtDbDriver = new JTextField();
        this.jPanel4 = new JPanel();
        this.jLabel18 = new JLabel();
        this.jtxtDbDriverLib = new JTextField();
        this.jbtnDbDriverLib = new JButton();
        this.jPanel10 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jtxtDbURL = new JTextField();
        this.setFont(new Font("Arial", 0, 12));
        this.setPreferredSize(new Dimension(650, 500));
        this.setLayout(new BorderLayout());
        this.jPanel3.setPreferredSize(new Dimension(900, 40));
        this.jPanel3.setLayout(new FlowLayout(0));
        this.jLabel6.setFont(new Font("Arial", 0, 12));
        this.jLabel6.setText("Base de donn\u00e9es");
        this.jLabel6.setPreferredSize(new Dimension(150, 30));
        this.jPanel3.add(this.jLabel6);
        this.jcboDBDriver.setFont(new Font("Arial", 0, 14));
        this.jcboDBDriver.setPreferredSize(new Dimension(400, 30));
        this.jcboDBDriver.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelConfigDatabase.this.jcboDBDriverActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.jcboDBDriver);
        this.jPanel1.add(this.jPanel3);
        this.jPanel5.setPreferredSize(new Dimension(900, 40));
        this.jPanel5.setLayout(new FlowLayout(0));
        this.jLabel1.setFont(new Font("Arial", 0, 12));
        this.jLabel1.setText("Driver Class");
        this.jLabel1.setPreferredSize(new Dimension(150, 30));
        this.jPanel5.add(this.jLabel1);
        this.jtxtDbDriver.setFont(new Font("Arial", 0, 12));
        this.jtxtDbDriver.setPreferredSize(new Dimension(400, 30));
        this.jtxtDbDriver.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelConfigDatabase.this.jtxtDbDriverActionPerformed(evt);
            }
        });
        this.jPanel5.add(this.jtxtDbDriver);
        this.jPanel1.add(this.jPanel5);
        this.jPanel4.setPreferredSize(new Dimension(900, 40));
        this.jPanel4.setLayout(new FlowLayout(0));
        this.jLabel18.setFont(new Font("Arial", 0, 12));
        this.jLabel18.setText("Driver Library");
        this.jLabel18.setPreferredSize(new Dimension(150, 30));
        this.jPanel4.add(this.jLabel18);
        this.jtxtDbDriverLib.setFont(new Font("Arial", 0, 12));
        this.jtxtDbDriverLib.setPreferredSize(new Dimension(400, 30));
        this.jPanel4.add(this.jtxtDbDriverLib);
        this.jbtnDbDriverLib.setIcon(new ImageIcon(this.getClass().getResource("/com/openbravo/images/fileopen.png")));
        this.jbtnDbDriverLib.setMaximumSize(new Dimension(64, 32));
        this.jbtnDbDriverLib.setMinimumSize(new Dimension(64, 32));
        this.jbtnDbDriverLib.setPreferredSize(new Dimension(64, 30));
        this.jbtnDbDriverLib.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelConfigDatabase.this.jbtnDbDriverLibActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.jbtnDbDriverLib);
        this.jPanel1.add(this.jPanel4);
        this.jPanel10.setPreferredSize(new Dimension(900, 40));
        this.jPanel10.setLayout(new FlowLayout(0));
        this.jLabel2.setFont(new Font("Arial", 0, 12));
        this.jLabel2.setText("URL");
        this.jLabel2.setPreferredSize(new Dimension(150, 30));
        this.jPanel10.add(this.jLabel2);
        this.jtxtDbURL.setFont(new Font("Arial", 0, 12));
        this.jtxtDbURL.setPreferredSize(new Dimension(400, 30));
        this.jtxtDbURL.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelConfigDatabase.this.jtxtDbURLActionPerformed(evt);
            }
        });
        this.jPanel10.add(this.jtxtDbURL);
        this.jPanel1.add(this.jPanel10);
        this.add((Component)this.jPanel1, "Center");
    }

    private void jtxtDbDriverActionPerformed(ActionEvent evt) {
    }

    private void jcboDBDriverActionPerformed(ActionEvent evt) {
        String dirname = System.getProperty("dirname.path");
        dirname = dirname == null ? "./" : dirname;
        String m_currentDirectory = Paths.get(".", new String[0]).toAbsolutePath().normalize().toString();
        if ("Apache Derby Embedded".equals(this.jcboDBDriver.getSelectedItem())) {
            this.jtxtDbDriverLib.setText(new File(new File(dirname), "lib/derby.jar").getAbsolutePath());
            this.jtxtDbDriver.setText("org.apache.derby.jdbc.EmbeddedDriver");
            if (AppLocal.IS_APP_PORTABLE.booleanValue()) {
                this.jtxtDbURL.setText("jdbc:derby:" + new File(new File(m_currentDirectory), "procaisse-database").getAbsolutePath() + ";create=true");
            } else {
                this.jtxtDbURL.setText("jdbc:derby:" + new File(new File(SystemUtils.SYS_USER_HOME), "procaisse-database").getAbsolutePath() + ";create=true");
            }
        } else if ("Apache Derby Client/Server".equals(this.jcboDBDriver.getSelectedItem())) {
            this.jtxtDbDriverLib.setText(new File(new File(dirname), "lib/derbyclient.jar").getAbsolutePath());
            this.jtxtDbDriver.setText("org.apache.derby.jdbc.ClientDriver");
            this.jtxtDbURL.setText("jdbc:derby://db.pro-tactile.com:1527//home/yasser/derby/procaisse-" + DateUtils.now() + ";create=true");
        } else if ("HSQLDB".equals(this.jcboDBDriver.getSelectedItem())) {
            this.jtxtDbDriverLib.setText(new File(new File(dirname), "lib/hsqldb.jar").getAbsolutePath());
            this.jtxtDbDriver.setText("org.hsqldb.jdbcDriver");
            this.jtxtDbURL.setText("jdbc:hsqldb:file:" + new File(new File(SystemUtils.SYS_USER_HOME), "procaisse-db").getAbsolutePath() + ";shutdown=true");
        } else if ("MySQL".equals(this.jcboDBDriver.getSelectedItem())) {
            this.jtxtDbDriverLib.setText(new File(new File(dirname), "lib/mysql-connector-java-5.1.26-bin.jar").getAbsolutePath());
            this.jtxtDbDriver.setText("com.mysql.cj.jdbc.Driver");
            this.jtxtDbURL.setText("jdbc:mysql://localhost:3306/procaisse");
        } else if ("Oracle 11g Express".equals(this.jcboDBDriver.getSelectedItem())) {
            this.jtxtDbDriverLib.setText(new File(new File(dirname), "lib/ojdbc6.jar").getAbsolutePath());
            this.jtxtDbDriver.setText("oracle.jdbc.driver.OracleDriver");
            this.jtxtDbURL.setText("jdbc:oracle:thin://localhost:1521/unicentaopos");
        } else if ("PostgreSQL".equals(this.jcboDBDriver.getSelectedItem())) {
            this.jtxtDbDriverLib.setText(new File(new File(dirname), "lib/postgresql-9.2-1003.jdbc4.jar").getAbsolutePath());
            this.jtxtDbDriver.setText("org.postgresql.Driver");
            this.jtxtDbURL.setText("jdbc:postgresql://localhost:5432/procaisse");
        }
    }

    private void jtxtDbURLActionPerformed(ActionEvent evt) {
    }

    private void jbtnDbDriverLibActionPerformed(ActionEvent evt) {
    }

    @Override
    public void activate() {
    }
}

