/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.config;

import com.openbravo.basic.BasicStorage;
import com.openbravo.components.ProgressBarCustomized;
import com.openbravo.dao.DataLogicOrder;
import com.openbravo.dao.DataLogicSales;
import com.openbravo.data.user.DirtyManager;
import com.openbravo.pos.config.PanelConfig;
import com.openbravo.pos.forms.AppConfig;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.AppView;
import com.openbravo.pos.forms.AppViewConnection;
import com.openbravo.pos.forms.JRootApp;
import com.openbravo.pos.notify.NPosition;
import com.openbravo.pos.notify.NotifyType;
import com.openbravo.pos.notify.NotifyWindow;
import com.openbravo.pos.printer.BackupDialogue;
import com.openbravo.pos.util.DateUtils;
import com.openbravo.pos.util.Event;
import com.openbravo.pos.util.FilerUtils;
import com.openbravo.pos.util.Journal;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.pos.util.SystemUtils;
import com.openbravo.pos.util.ZipUtils;
import com.openbravo.service.IntegrityCheacker;
import fr.protactile.procaisse.dao.config.HibernateUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

public class JPanelConfigBack
extends JPanel
implements PanelConfig {
    private final DirtyManager dirty = new DirtyManager();
    public static String url;
    private String emplacement;
    private Integer dBDailyCount;
    private Integer dBWeeklyCount;
    private Integer dBMounthlyCount;
    private String time;
    public static String BACKUP_CONFIG;
    private AppView oApp;
    public static SimpleDateFormat formatter;
    public static Calendar cal;
    FilerUtils m_FilerUtils = FilerUtils.getInstance();
    String parentDirectory = AppLocal.IS_APP_PORTABLE != false ? this.m_FilerUtils.getCurrentPath() : SystemUtils.SYS_USER_HOME;
    BackupDialogue parent = null;
    private DataLogicOrder dlOrders;
    private DataLogicSales dlSales;
    private JButton close;
    private JLabel emplacementLabel;
    private JSpinner hourSpinner;
    private JButton jBntImport;
    private JButton jBtnExport;
    private JButton jButton2;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JPanel jPanel9;
    private JSpinner minutesSpinner;
    private JSpinner nbrMonthlySpinner;
    private JSpinner nbrQuotidienSpinner;
    private JSpinner nbrWeeklySpinner;
    private JPanel sauvegardAndRestorPanel;
    private JPanel savePanel;
    private JButton saveParamsBackup;

    public JPanelConfigBack(AppView oApp) {
        this.initAll(oApp);
    }

    public void initAll(AppView oApp) {
        this.oApp = oApp;
        this.dlOrders = (DataLogicOrder)oApp.getBean("com.openbravo.dao.DataLogicOrder");
        this.dlSales = (DataLogicSales)oApp.getBean("com.openbravo.dao.DataLogicSales");
        url = oApp.getProperties().getProperty("db.URL");
        this.initComponents();
        File fConfig = new File(BACKUP_CONFIG);
        if (fConfig.exists()) {
            try {
                this.initBackupParams();
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        } else {
            StringBuilder cbStringBuilder = new StringBuilder();
            this.emplacement = AppLocal.IS_APP_PORTABLE != false ? this.m_FilerUtils.getCurrentPath() : SystemUtils.SYS_USER_HOME;
            cbStringBuilder.append(this.emplacement);
            cbStringBuilder.append("\n");
            this.dBDailyCount = 7;
            cbStringBuilder.append(this.dBDailyCount);
            cbStringBuilder.append("\n");
            this.dBWeeklyCount = 2;
            cbStringBuilder.append(this.dBWeeklyCount);
            cbStringBuilder.append("\n");
            this.dBMounthlyCount = 2;
            cbStringBuilder.append(this.dBMounthlyCount);
            cbStringBuilder.append("\n");
            this.time = "14:00";
            cbStringBuilder.append(this.time);
            try {
                FileUtils.writeStringToFile((File)new File(BACKUP_CONFIG), (String)cbStringBuilder.toString());
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
        String[] times = this.time.split(":");
        this.hourSpinner.setValue(new Integer(times[0]));
        this.minutesSpinner.setValue(new Integer(times[1]));
        this.nbrQuotidienSpinner.setValue(new Integer(this.dBDailyCount));
        this.nbrWeeklySpinner.setValue(new Integer(this.dBWeeklyCount));
        this.nbrMonthlySpinner.setValue(new Integer(this.dBMounthlyCount));
        this.emplacementLabel.setText(this.emplacement);
        this.savePanel.setVisible(false);
    }

    public JPanelConfigBack(AppView oApp, BackupDialogue parent) {
        this.initAll(oApp);
        this.parent = parent;
    }

    @Override
    public boolean hasChanged() {
        return this.dirty.isDirty();
    }

    @Override
    public Component getConfigComponent() {
        return this;
    }

    @Override
    public void loadProperties(AppConfig config) {
    }

    @Override
    public void saveProperties(AppConfig config) {
    }

    public static String unZipIt(String zipFile, String outputFolder) {
        boolean tmpRet = true;
        byte[] buffer = new byte[1024];
        String nameDB = null;
        try {
            File fTmp;
            File folder = new File(outputFolder);
            if (!folder.exists()) {
                folder.mkdir();
            }
            if ((fTmp = new File(zipFile)).exists()) {
                String tmpCheckFNt;
                System.out.println("+++++++++ start unzip");
                ZipInputStream zis = new ZipInputStream(new FileInputStream(zipFile));
                nameDB = tmpCheckFNt = FilenameUtils.removeExtension((String)fTmp.getName());
                ZipEntry ze = zis.getNextEntry();
                System.out.println("+++++++++ ze : " + ze);
                while (ze != null) {
                    String fileName = ze.getName();
                    File newFile = new File(outputFolder + File.separator + fileName);
                    String tmpCheckFN = FilenameUtils.removeExtension((String)fileName);
                    if (tmpCheckFN.equalsIgnoreCase(fileName)) {
                        boolean success;
                        if (!newFile.exists() && !(success = newFile.mkdirs())) {
                            System.err.println("Could not create directory for " + fileName + ".");
                            return null;
                        }
                    } else {
                        int len;
                        new File(newFile.getParent()).mkdirs();
                        FileOutputStream fos = new FileOutputStream(newFile);
                        while ((len = zis.read(buffer)) > 0) {
                            fos.write(buffer, 0, len);
                        }
                        fos.close();
                    }
                    ze = zis.getNextEntry();
                }
                zis.closeEntry();
                zis.close();
                System.out.println("+++++++++ end unzip");
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
            tmpRet = false;
        }
        return nameDB;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.sauvegardAndRestorPanel = new JPanel();
        this.jBtnExport = new JButton();
        this.jBntImport = new JButton();
        this.jPanel4 = new JPanel();
        this.jPanel5 = new JPanel();
        this.jLabel1 = new JLabel();
        this.hourSpinner = new JSpinner();
        this.jLabel2 = new JLabel();
        this.minutesSpinner = new JSpinner();
        this.jLabel3 = new JLabel();
        this.jPanel6 = new JPanel();
        this.jLabel4 = new JLabel();
        this.nbrQuotidienSpinner = new JSpinner();
        this.jPanel8 = new JPanel();
        this.jLabel6 = new JLabel();
        this.nbrMonthlySpinner = new JSpinner();
        this.jPanel9 = new JPanel();
        this.jLabel7 = new JLabel();
        this.emplacementLabel = new JLabel();
        this.jButton2 = new JButton();
        this.jPanel7 = new JPanel();
        this.jLabel5 = new JLabel();
        this.nbrWeeklySpinner = new JSpinner();
        this.savePanel = new JPanel();
        this.saveParamsBackup = new JButton();
        this.close = new JButton();
        this.setFont(AppLocal.FONT_ARIAL_PLAIN_12);
        this.setPreferredSize(new Dimension(600, 450));
        this.setLayout(new BorderLayout());
        this.jPanel1.setOpaque(false);
        this.jPanel1.setLayout(new BorderLayout());
        this.jPanel2.setBackground(new Color(245, 246, 250));
        this.jPanel2.setOpaque(false);
        this.jPanel2.setPreferredSize(new Dimension(900, 80));
        this.sauvegardAndRestorPanel.setPreferredSize(new Dimension(812, 50));
        this.jBtnExport.setBackground(new Color(250, 190, 88));
        this.jBtnExport.setText("Sauvegarder");
        this.jBtnExport.setFocusPainted(false);
        this.jBtnExport.setHorizontalTextPosition(10);
        this.jBtnExport.setMaximumSize(new Dimension(200, 40));
        this.jBtnExport.setMinimumSize(new Dimension(170, 30));
        this.jBtnExport.setPreferredSize(new Dimension(200, 40));
        this.jBtnExport.setRequestFocusEnabled(false);
        this.jBtnExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelConfigBack.this.jBtnExportActionPerformed(evt);
            }
        });
        this.sauvegardAndRestorPanel.add(this.jBtnExport);
        this.jBntImport.setBackground(new Color(250, 190, 88));
        this.jBntImport.setText("Restaurer");
        this.jBntImport.setFocusPainted(false);
        this.jBntImport.setMaximumSize(new Dimension(200, 40));
        this.jBntImport.setMinimumSize(new Dimension(200, 30));
        this.jBntImport.setPreferredSize(new Dimension(200, 40));
        this.jBntImport.setRequestFocusEnabled(false);
        this.jBntImport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelConfigBack.this.jBntImportActionPerformed(evt);
            }
        });
        this.sauvegardAndRestorPanel.add(this.jBntImport);
        this.jPanel2.add(this.sauvegardAndRestorPanel);
        this.jPanel4.setBackground(new Color(245, 246, 250));
        this.jPanel4.setBorder(BorderFactory.createTitledBorder(null, "Param\u00e8tres de Sauvegarde Automatique", 0, 0, new Font("Segoe UI Historic", 1, 14)));
        this.jPanel4.setToolTipText("");
        this.jPanel4.setAutoscrolls(true);
        this.jPanel4.setOpaque(false);
        this.jPanel4.setVerifyInputWhenFocusTarget(false);
        GridBagLayout jPanel4Layout = new GridBagLayout();
        jPanel4Layout.columnWidths = new int[]{1};
        jPanel4Layout.rowHeights = new int[]{0};
        jPanel4Layout.columnWeights = new double[]{1.0};
        jPanel4Layout.rowWeights = new double[]{0.0};
        this.jPanel4.setLayout(jPanel4Layout);
        this.jPanel5.setOpaque(false);
        this.jPanel5.setPreferredSize(new Dimension(800, 50));
        this.jPanel5.setLayout(new FlowLayout(0));
        this.jLabel1.setFont(new Font("Tahoma", 1, 12));
        this.jLabel1.setText("Heure du d\u00e9clenchement des Backup:");
        this.jLabel1.setPreferredSize(new Dimension(500, 40));
        this.jPanel5.add(this.jLabel1);
        this.hourSpinner.setModel(new SpinnerNumberModel(0, 0, 23, 1));
        this.hourSpinner.setMaximumSize(null);
        this.hourSpinner.setPreferredSize(new Dimension(40, 40));
        this.jPanel5.add(this.hourSpinner);
        this.jLabel2.setFont(new Font("Tahoma", 0, 14));
        this.jLabel2.setText("h");
        this.jLabel2.setPreferredSize(new Dimension(10, 30));
        this.jPanel5.add(this.jLabel2);
        this.minutesSpinner.setModel(new SpinnerNumberModel(0, 0, 59, 10));
        this.minutesSpinner.setMaximumSize(null);
        this.minutesSpinner.setPreferredSize(new Dimension(40, 40));
        this.jPanel5.add(this.minutesSpinner);
        this.jLabel3.setFont(new Font("Tahoma", 0, 14));
        this.jLabel3.setText("min");
        this.jPanel5.add(this.jLabel3);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        this.jPanel4.add((Component)this.jPanel5, gridBagConstraints);
        this.jPanel6.setMinimumSize(new Dimension(252, 30));
        this.jPanel6.setOpaque(false);
        this.jPanel6.setLayout(new FlowLayout(0));
        this.jLabel4.setFont(new Font("Tahoma", 1, 12));
        this.jLabel4.setText("Nombre de backup quotidien maximum :");
        this.jLabel4.setMinimumSize(new Dimension(300, 14));
        this.jLabel4.setPreferredSize(new Dimension(560, 30));
        this.jPanel6.add(this.jLabel4);
        this.nbrQuotidienSpinner.setModel(new SpinnerNumberModel(30, 0, 365, 1));
        this.nbrQuotidienSpinner.setMaximumSize(null);
        this.nbrQuotidienSpinner.setPreferredSize(new Dimension(40, 40));
        this.jPanel6.add(this.nbrQuotidienSpinner);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        this.jPanel4.add((Component)this.jPanel6, gridBagConstraints);
        this.jPanel8.setOpaque(false);
        this.jPanel8.setLayout(new FlowLayout(0));
        this.jLabel6.setFont(new Font("Tahoma", 1, 12));
        this.jLabel6.setHorizontalAlignment(2);
        this.jLabel6.setText("Nombre de backup mensuel maximum :");
        this.jLabel6.setPreferredSize(new Dimension(560, 30));
        this.jPanel8.add(this.jLabel6);
        this.nbrMonthlySpinner.setModel(new SpinnerNumberModel((Number)0, Integer.valueOf(0), null, (Number)1));
        this.nbrMonthlySpinner.setMaximumSize(null);
        this.nbrMonthlySpinner.setPreferredSize(new Dimension(40, 40));
        this.jPanel8.add(this.nbrMonthlySpinner);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        this.jPanel4.add((Component)this.jPanel8, gridBagConstraints);
        this.jPanel9.setOpaque(false);
        this.jPanel9.setLayout(new FlowLayout(0));
        this.jLabel7.setFont(new Font("Tahoma", 1, 12));
        this.jLabel7.setText("Emplacement des Backups :");
        this.jLabel7.setPreferredSize(new Dimension(260, 30));
        this.jPanel9.add(this.jLabel7);
        this.emplacementLabel.setFont(new Font("Tahoma", 3, 11));
        this.emplacementLabel.setPreferredSize(new Dimension(280, 30));
        this.jPanel9.add(this.emplacementLabel);
        this.jButton2.setIcon(new ImageIcon(this.getClass().getResource("/com/openbravo/images/fileopen.png")));
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelConfigBack.this.jButton2ActionPerformed(evt);
            }
        });
        this.jPanel9.add(this.jButton2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.fill = 1;
        this.jPanel4.add((Component)this.jPanel9, gridBagConstraints);
        this.jPanel7.setOpaque(false);
        this.jPanel7.setLayout(new FlowLayout(0));
        this.jLabel5.setFont(new Font("Tahoma", 1, 12));
        this.jLabel5.setText("Nombre de backup hebdomadaire maximum :");
        this.jLabel5.setPreferredSize(new Dimension(560, 30));
        this.jPanel7.add(this.jLabel5);
        this.nbrWeeklySpinner.setModel(new SpinnerNumberModel((Number)0, Integer.valueOf(0), null, (Number)1));
        this.nbrWeeklySpinner.setMaximumSize(null);
        this.nbrWeeklySpinner.setPreferredSize(new Dimension(40, 40));
        this.jPanel7.add(this.nbrWeeklySpinner);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        this.jPanel4.add((Component)this.jPanel7, gridBagConstraints);
        this.jPanel2.add(this.jPanel4);
        this.savePanel.setPreferredSize(new Dimension(812, 50));
        this.saveParamsBackup.setBackground(new Color(0, 151, 230));
        this.saveParamsBackup.setText("Enregistrer ");
        this.saveParamsBackup.setBorder(null);
        this.saveParamsBackup.setFocusPainted(false);
        this.saveParamsBackup.setHorizontalTextPosition(10);
        this.saveParamsBackup.setMaximumSize(new Dimension(200, 40));
        this.saveParamsBackup.setMinimumSize(new Dimension(170, 30));
        this.saveParamsBackup.setPreferredSize(new Dimension(200, 40));
        this.saveParamsBackup.setRequestFocusEnabled(false);
        this.saveParamsBackup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelConfigBack.this.saveParamsBackupActionPerformed(evt);
            }
        });
        this.savePanel.add(this.saveParamsBackup);
        this.close.setBackground(new Color(225, 177, 44));
        this.close.setText("Fermer");
        this.close.setBorder(null);
        this.close.setFocusPainted(false);
        this.close.setHorizontalTextPosition(10);
        this.close.setMaximumSize(new Dimension(200, 40));
        this.close.setMinimumSize(new Dimension(170, 30));
        this.close.setPreferredSize(new Dimension(200, 40));
        this.close.setRequestFocusEnabled(false);
        this.close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JPanelConfigBack.this.closeActionPerformed(evt);
            }
        });
        this.savePanel.add(this.close);
        this.jPanel2.add(this.savePanel);
        this.jPanel1.add((Component)this.jPanel2, "Center");
        this.add((Component)this.jPanel1, "Center");
    }

    private void initBackupParams() throws IOException {
        String[] configBackupString = FileUtils.readFileToString((File)new File(BACKUP_CONFIG)).split("\n");
        if (configBackupString.length == 5) {
            this.emplacement = configBackupString[0];
            this.dBDailyCount = Integer.valueOf(configBackupString[1]);
            this.dBWeeklyCount = Integer.valueOf(configBackupString[2]);
            this.dBMounthlyCount = Integer.valueOf(configBackupString[3]);
            this.time = configBackupString[4];
        }
    }

    private static boolean isJavaWebStart() {
        try {
            Class.forName("javax.jnlp.ServiceManager");
            return true;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    private void jBntImportActionPerformed(ActionEvent evt) {
        JFileChooser fc = new JFileChooser();
        if (fc.showOpenDialog(new JFrame()) == 0) {
            final File f = fc.getSelectedFile();
            new Thread(new Runnable(){

                @Override
                public void run() {
                    JPanelConfigBack.this.restoreBdAt(f);
                }
            }).start();
        }
    }

    private void jBtnExportActionPerformed(ActionEvent evt) {
        final JFileChooser fc = new JFileChooser();
        fc.setDialogTitle("Enregistrer sous");
        fc.setFileSelectionMode(1);
        fc.setAcceptAllFileFilterUsed(false);
        if (fc.showOpenDialog(new JFrame()) == 0) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    ProgressBarCustomized barCustomized = new ProgressBarCustomized("Sauvegarde de la base de donn\u00e9es");
                    JProgressBar pb = barCustomized.getPb();
                    JDialog dialogueProgressBar = barCustomized.getDialogueProgressBar();
                    pb.setValue(5);
                    pb.setString("Lecture de la base de donne\u00e9s...");
                    String dest = fc.getSelectedFile().getAbsolutePath();
                    String[] tabUrl = url.split(":");
                    String url1 = tabUrl[3];
                    String[] tabUrl1 = url1.split(";");
                    String urlExport = "";
                    urlExport = tabUrl1.length > 0 ? tabUrl1[0] : url1;
                    File directory = new File(urlExport);
                    String dataBase = directory.getName();
                    String filename = JPanelConfigBack.buildOutPutZipFileName();
                    File dbdirectory = new File(new File(JPanelConfigBack.this.parentDirectory), dataBase);
                    pb.setValue(5);
                    pb.setString("Fermeture de Session...");
                    JRootApp mApp = (JRootApp)BasicStorage.getObject("APP_ROOT_INSTANCE");
                    mApp.getSession().close();
                    AppViewConnection.shutDown(dbdirectory.getAbsolutePath());
                    try {
                        pb.setValue(35);
                        pb.setString("Compression des fichiers de la base de donn\u00e9es...");
                        ZipUtils.zipFolder(dbdirectory.getAbsolutePath(), dest + File.separator + filename);
                        File fileJournal = new File(AppLocal.JOURNAL_FOLDER);
                        File[] files = new File[]{fileJournal};
                        pb.setValue(85);
                        pb.setString("Sauvegarde du Journal...");
                        ZipUtils.addFilesToExistingZip(new File(dest + File.separator + filename), files);
                        pb.setValue(100);
                        dialogueProgressBar.dispose();
                        Journal.writeToJET(new Event(230, "Sauvegarde", JPanelConfigBack.this.oApp.getAppUserView().getUser().getId(), "chemin du Fichier de Sauvegarde ", new Date().getTime(), dest + File.separator + filename));
                        mApp.tryToClose();
                    }
                    catch (Exception ex) {
                        LogToFile.log("severe", ex.getMessage(), ex);
                    }
                }
            }).start();
            new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, "Base de donn\u00e9 export\u00e9 avec succes.", 1500, NPosition.CENTER);
        }
    }

    public static void backup(String url, String dest) {
        String[] tabUrl = url.split(":");
        String url1 = tabUrl[3];
        String[] tabUrl1 = url1.split(";");
        String urlExport = "";
        urlExport = tabUrl1.length > 0 ? tabUrl1[0] : url1;
        File directory = new File(urlExport);
        String dataBase = directory.getName();
        String filename = JPanelConfigBack.buildOutPutZipFileName();
        String directoryHome = AppLocal.IS_APP_PORTABLE != false ? Paths.get(".", new String[0]).toAbsolutePath().normalize().toString() : SystemUtils.SYS_USER_HOME;
        try {
            ZipUtils.zipFolder(new File(new File(directoryHome), dataBase).getAbsolutePath(), dest + File.separator + filename);
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public static String getDayOfWeek() {
        int day = cal.get(7);
        switch (day) {
            case 1: {
                return "dimanche";
            }
            case 2: {
                return "lundi";
            }
            case 3: {
                return "mardi";
            }
            case 4: {
                return "mercredi";
            }
            case 5: {
                return "jeudi";
            }
            case 6: {
                return "vendredi";
            }
            case 7: {
                return "samedi";
            }
        }
        return "dimanche";
    }

    public static String buildOutPutZipFileName() {
        StringBuilder sb = new StringBuilder();
        sb.append("procaisse-db-");
        sb.append(JPanelConfigBack.getDayOfWeek());
        sb.append("-");
        sb.append(formatter.format(new Date()));
        sb.append(".zip");
        return sb.toString();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle("Dossier des backups");
        chooser.setFileSelectionMode(1);
        chooser.setAcceptAllFileFilterUsed(false);
        if (chooser.showOpenDialog(this) == 0) {
            this.emplacementLabel.setText(chooser.getSelectedFile().getAbsolutePath());
            this.emplacement = chooser.getSelectedFile().getAbsolutePath();
        }
    }

    private void saveParamsBackupActionPerformed(ActionEvent evt) {
        this.saveConfigBack();
        this.parent.dispose();
    }

    private void closeActionPerformed(ActionEvent evt) {
        if (this.parent != null) {
            this.parent.dispose();
        }
    }

    private void saveToDisk() {
        StringBuilder cbStringBuilder = new StringBuilder();
        cbStringBuilder.append(this.emplacementLabel.getText());
        cbStringBuilder.append("\n");
        cbStringBuilder.append(this.nbrQuotidienSpinner.getValue());
        cbStringBuilder.append("\n");
        cbStringBuilder.append(this.nbrWeeklySpinner.getValue());
        cbStringBuilder.append("\n");
        cbStringBuilder.append(this.nbrMonthlySpinner.getValue());
        cbStringBuilder.append("\n");
        cbStringBuilder.append(this.hourSpinner.getValue() + ":" + this.minutesSpinner.getValue());
        try {
            FileUtils.writeStringToFile((File)new File(BACKUP_CONFIG), (String)cbStringBuilder.toString());
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private void updateTask() throws IOException, InterruptedException {
        File task = new File("C:task.bat");
        String commande = "SchTasks /Create /SC DAILY /TN \"backup-derby-bd\" /TR \"\\\"C:\\Program Files\\Procaisse\\runme.bat\\\"\" /ST " + String.format("%02d", this.hourSpinner.getValue()) + ":" + String.format("%02d", this.minutesSpinner.getValue()) + " /f ";
        FileUtils.write((File)task, (CharSequence)commande);
        Process myappProcess = Runtime.getRuntime().exec("powershell.exe Start-Process \"C:\"task.bat -verb RunAs");
    }

    public void saveConfigBack() {
        try {
            if (!this.time.equals(this.hourSpinner.getValue() + ":" + this.minutesSpinner.getValue())) {
                Journal.writeToJET(new Event(300, "Modification des Param\u00e8tres", AppLocal.user.getId(), "Horraire de sauvegarde automatique", new Date().getTime(), (this.time + "=>" + this.hourSpinner.getValue() + ":" + this.minutesSpinner.getValue()).replace(",", "-")));
            }
            if (!this.emplacement.equals(this.emplacementLabel.getText())) {
                Journal.writeToJET(new Event(300, "Modification des Param\u00e8tres", AppLocal.user.getId(), "Chemin des sauvegardes", new Date().getTime(), (this.emplacement + "=>" + this.emplacementLabel.getText()).replace(",", "-")));
            }
            if (!this.dBDailyCount.equals(this.nbrQuotidienSpinner.getValue())) {
                Journal.writeToJET(new Event(300, "Modification des Param\u00e8tres", AppLocal.user.getId(), "Nombre des sauvegardes journalier \u00e0 conserver", new Date().getTime(), (this.dBDailyCount + "=>" + this.nbrQuotidienSpinner.getValue()).replace(",", "-")));
            }
            if (!this.dBWeeklyCount.equals(this.nbrWeeklySpinner.getValue())) {
                Journal.writeToJET(new Event(300, "Modification des Param\u00e8tres", AppLocal.user.getId(), "Nombre des sauvegardes hebdomadaire \u00e0 conserver", new Date().getTime(), (this.dBWeeklyCount + "=>" + this.nbrWeeklySpinner.getValue()).replace(",", "-")));
            }
            if (!this.dBMounthlyCount.equals(this.nbrMonthlySpinner.getValue())) {
                Journal.writeToJET(new Event(300, "Modification des Param\u00e8tres", AppLocal.user.getId(), "Nombre des sauvegardes mensuel \u00e0 conserver", new Date().getTime(), (this.dBMounthlyCount + "=>" + this.nbrMonthlySpinner.getValue()).replace(",", "-")));
            }
            this.updateTask();
            this.saveToDisk();
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public JPanel getSauvegardAndRestorPanel() {
        return this.sauvegardAndRestorPanel;
    }

    public void setSauvegardAndRestorPanel(JPanel sauvegardAndRestorPanel) {
        this.sauvegardAndRestorPanel = sauvegardAndRestorPanel;
    }

    public JPanel getSavePanel() {
        return this.savePanel;
    }

    public void setSavePanel(JPanel savePanel) {
        this.savePanel = savePanel;
    }

    public void restoreBdAt(File f) {
        try {
            ProgressBarCustomized barCustomized = new ProgressBarCustomized("Restauration de la base de donn\u00e9es");
            JProgressBar pb = barCustomized.getPb();
            JDialog dialogueProgressBar = barCustomized.getDialogueProgressBar();
            pb.setValue(5);
            pb.setString("Fermeture de la session en cours...");
            JRootApp mApp = (JRootApp)BasicStorage.getObject("APP_ROOT_INSTANCE");
            mApp.getSession().close();
            String path = SystemUtils.SYS_USER_HOME + File.separator;
            File courante = new File(path + "procaisse-database");
            File tempDB = new File(path + "temp-db");
            if (tempDB.exists()) {
                FileUtils.deleteDirectory((File)tempDB);
            }
            AppViewConnection.shutDown(courante.getAbsolutePath());
            FileUtils.moveDirectory((File)courante, (File)tempDB);
            pb.setString("Extracton des fichiers...");
            pb.setValue(20);
            JPanelConfigBack.unZipIt(f.getAbsolutePath(), new File(SystemUtils.SYS_USER_HOME + File.separator + "procaisse-database").getAbsolutePath());
            pb.setValue(40);
            mApp.setSession(AppViewConnection.createSession(mApp.getProperties()));
            pb.setString("la mise \u00e0 niveau de la base de donn\u00e9es...");
            int input = -1;
            Object caisse = null;
            if (mApp.isDatabaseCorrumpu()) {
                input = 1;
                new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Base de donn\u00e9es corrompu.", 4000, NPosition.BOTTOM_RIGHT);
            } else {
                mApp.doUpgradeDB();
                mApp.createTableArchiv();
                pb.setValue(70);
                pb.setString("Controle de l'int\u00e9grit\u00e9 des donn\u00e9es...");
                HibernateUtils.init(mApp.getProperties());
                DataLogicSales dlsales = mApp.getM_dlSales();
                caisse = null;
            }
            System.out.println("++++++++++++ input : " + input);
            System.out.println("+++++++++++++ JOptionPane.NO_OPTION : 1");
            if (input == 1) {
                pb.setString("Erreurs d'int\u00e9grit\u00e9 rencontr\u00e9s...");
                mApp.getSession().close();
                AppViewConnection.shutDown(courante.getAbsolutePath());
                pb.setString("Fermeture de session...");
                FileUtils.deleteDirectory((File)courante);
                FileUtils.moveDirectory((File)tempDB, (File)courante);
                dialogueProgressBar.dispose();
                Journal.writeToJET(new Event(90, "D\u00e9tection d'un d\u00e9faut d'int\u00e9grit\u00e9", "", "Description", new Date().getTime(), "Restauration de BD refus\u00e9e pour d\u00e9faut d'int\u00e9grit\u00e9"));
                JOptionPane.showMessageDialog(this, "Echec de Restauration de la BD .\n Erreurs d'int\u00e9grit\u00e9 !", "Restaurasion R\u00e9ussite", 1);
            } else {
                IntegrityCheacker cheacker = new IntegrityCheacker(this.dlOrders, this.dlSales);
                boolean correctIntegrity = cheacker.isDBIntegrityCorrectBetween(AppLocal.getDateMigration(), new Date());
                if (correctIntegrity) {
                    pb.setValue(90);
                    try {
                        Journal.writeToJET(new Event(220, "restauration", this.oApp.getAppUserView().getUser().getId(), "Fichier de Restauration de base de donn\u00e9es", new Date().getTime(), f.getAbsolutePath()));
                    }
                    catch (Exception ex) {
                        LogToFile.log("severe", ex.getMessage(), ex);
                    }
                    pb.setValue(100);
                    dialogueProgressBar.dispose();
                    JOptionPane.showMessageDialog(this, "la base de donn\u00e9es import\u00e9 avec succ\u00e9s .\n Veuillez relancer l'application !", "Restaurasion R\u00e9ussite", 1);
                } else {
                    pb.setString("Erreurs d'int\u00e9grit\u00e9 rencontr\u00e9s...");
                    Journal.writeToJET(new Event(90, "D\u00e9tection d'un d\u00e9faut d'int\u00e9grit\u00e9", "", "Description", new Date().getTime(), "Restauration de BD refus\u00e9e pour d\u00e9faut d'int\u00e9grit\u00e9"));
                    mApp.getSession().close();
                    AppViewConnection.shutDown(courante.getAbsolutePath());
                    pb.setString("Fermeture de session...");
                    FileUtils.deleteDirectory((File)courante);
                    FileUtils.moveDirectory((File)tempDB, (File)courante);
                    dialogueProgressBar.dispose();
                    JOptionPane.showMessageDialog(this, "Echec de Restauration de la Base de Donn\u00e9es .\n Erreurs d'int\u00e9grit\u00e9 !", "Echec de Restauration", 1);
                }
            }
            Journal.writeToJET(new Event(40, "Arret de l'application", AppLocal.user != null ? AppLocal.user.getId() : "", "", new Date().getTime(), ""));
            mApp.tryToClose();
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    @Override
    public void activate() {
    }

    static {
        BACKUP_CONFIG = (AppLocal.IS_APP_PORTABLE != false ? Paths.get(".", new String[0]).toAbsolutePath().normalize().toString() : SystemUtils.SYS_USER_HOME) + File.separator + "procaisse-properties" + File.separator + "backup.properties";
        formatter = DateUtils.formatterYEAR_MONTH_DAY_TIRETS6;
        cal = Calendar.getInstance();
    }
}

