/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.config;

import com.openbravo.basic.BasicException;
import com.openbravo.pos.config.JPanelConfigurationStart;
import com.openbravo.pos.forms.AppConfig;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.AppProperties;
import com.openbravo.pos.forms.JRootFrame;
import com.openbravo.pos.util.Event;
import com.openbravo.pos.util.Journal;
import com.openbravo.pos.util.LogToFile;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class JFrmConfig
extends JFrame {
    private final JPanelConfigurationStart config;

    public JFrmConfig(AppProperties props) {
        this.initComponents();
        try {
            this.setIconImage(ImageIO.read(JRootFrame.class.getResourceAsStream("/com/openbravo/images/favicon.png")));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.setTitle("BIBORNE - 10.0.1.27 - " + AppLocal.getIntString("Menu.Configuration"));
        this.addWindowListener(new MyFrameListener());
        this.config = new JPanelConfigurationStart(props);
        this.getContentPane().add((Component)this.config, "Center");
        try {
            this.config.activate();
        }
        catch (BasicException basicException) {
            // empty catch block
        }
    }

    private void initComponents() {
        this.setDefaultCloseOperation(0);
        this.setMinimumSize(new Dimension(700, 450));
        this.setPreferredSize(new Dimension(750, 450));
        this.setSize(new Dimension(758, 561));
        this.setLocationRelativeTo(null);
    }

    public static void main(final String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                AppConfig config = AppConfig.getInstance(true, new File(args[0]));
                try {
                    UIManager.setLookAndFeel(config.getProperty("swing.defaultlaf"));
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException exception) {
                    // empty catch block
                }
                new JFrmConfig(config).setVisible(true);
            }
        });
    }

    private class MyFrameListener
    extends WindowAdapter {
        private MyFrameListener() {
        }

        @Override
        public void windowClosing(WindowEvent evt) {
            if (JFrmConfig.this.config.deactivate()) {
                JFrmConfig.this.dispose();
            }
        }

        @Override
        public void windowClosed(WindowEvent evt) {
            try {
                Journal.writeToJET(new Event(40, "Arret de l'application", " ", " ", new Date().getTime(), " "));
            }
            catch (Exception ex) {
                LogToFile.log("severe", null, ex);
            }
            System.exit(0);
        }
    }
}

