/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.config;

import com.openbravo.pos.config.SiteConfig;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.pos.util.SystemUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;

public class ConfigurationManagerSite {
    private File configfile;
    private final Properties props = new Properties();
    private SiteConfig mSiteConfig = new SiteConfig();

    public ConfigurationManagerSite() {
        this.init();
        this.load();
    }

    private void init() {
        try {
            boolean newFile;
            File dir = new File(new File(SystemUtils.SYS_USER_HOME), "procaisse-properties");
            FileUtils.forceMkdir((File)dir);
            this.configfile = new File(dir, "site.orders.properties");
            if (!this.configfile.exists() && !(newFile = this.configfile.createNewFile())) {
                Logger.getLogger(ConfigurationManagerSite.class.getName()).log(Level.SEVERE, "AN error occurs when trying to create file");
            }
        }
        catch (IOException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private void load() {
        FileInputStream in = null;
        try {
            in = new FileInputStream(this.configfile);
            this.props.load(in);
            ((InputStream)in).close();
        }
        catch (IOException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        finally {
            try {
                if (in != null) {
                    ((InputStream)in).close();
                }
            }
            catch (IOException ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
    }

    public Boolean getBooleanProperty(String key, boolean defaultValue) {
        String value = this.props.getProperty(key);
        return value == null || value.isEmpty() ? defaultValue : (!value.equalsIgnoreCase("yes") ? Boolean.FALSE : Boolean.TRUE);
    }

    public String getProperty(String sKey) {
        String value = this.props.getProperty(sKey);
        return value == null ? "" : value;
    }

    public void setProperty(String sKey, String sValue) {
        this.props.setProperty(sKey, sValue);
    }

    public void save(SiteConfig mSiteConfig) {
        this.props.setProperty("site.at.spot", mSiteConfig.isAt_spot() ? "yes" : "no");
        this.props.setProperty("site.take.away", mSiteConfig.isTake_away() ? "yes" : "no");
        this.props.setProperty("site.delivery", mSiteConfig.isDelivery() ? "yes" : "no");
        this.props.setProperty("site.platform", mSiteConfig.isPlatform() ? "yes" : "no");
        this.props.setProperty("site.platform.url", mSiteConfig.getPlatfom_url());
        this.props.setProperty("site.stripe", mSiteConfig.isStripe() ? "yes" : "no");
        this.props.setProperty("site.hide.image.option", mSiteConfig.isHide_image_option() ? "yes" : "no");
        try (FileOutputStream out = new FileOutputStream(this.configfile);){
            this.props.store(out, "Procaisse. Configuration file.");
        }
        catch (IOException ioe) {
            LogToFile.log("sever", "Unable to save property file of site Procaisse named '<application Property file name>'. Raison : " + ioe.getMessage(), ioe);
        }
    }

    public SiteConfig getmSiteConfig() {
        this.mSiteConfig.setAt_spot(this.getBooleanProperty("site.at.spot", false));
        this.mSiteConfig.setTake_away(this.getBooleanProperty("site.take.away", false));
        this.mSiteConfig.setDelivery(this.getBooleanProperty("site.delivery", false));
        this.mSiteConfig.setPlatform(this.getBooleanProperty("site.platform", false));
        this.mSiteConfig.setPlatfom_url(this.getProperty("site.platform.url"));
        this.mSiteConfig.setStripe(this.getBooleanProperty("site.stripe", false));
        this.mSiteConfig.setHide_image_option(this.getBooleanProperty("site.hide.image.option", false));
        return this.mSiteConfig;
    }
}

