/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.admin;

import com.openbravo.basic.BasicException;
import com.openbravo.basic.BasicStorage;
import com.openbravo.beans.JFlowPanel;
import com.openbravo.dao.DataLogicSystem;
import com.openbravo.data.user.DirtyManager;
import com.openbravo.pos.admin.DataLogicAdmin;
import com.openbravo.pos.admin.Permission;
import com.openbravo.pos.admin.RoleInfo;
import com.openbravo.pos.admin.User;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.AppView;
import com.openbravo.pos.forms.BeanFactoryApp;
import com.openbravo.pos.forms.BeanFactoryException;
import com.openbravo.pos.forms.JPanelView;
import com.openbravo.pos.notify.NPosition;
import com.openbravo.pos.notify.NotifyType;
import com.openbravo.pos.notify.NotifyWindow;
import com.openbravo.pos.util.Hashcypher;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.pos.util.StringUtils;
import fr.protactile.procaisse.cache.SharedMemoryCache;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class UserPanel
extends JPanel
implements JPanelView,
BeanFactoryApp {
    protected AppView m_App;
    protected EventListenerList listeners = new EventListenerList();
    private DataLogicAdmin m_dlUser;
    protected DataLogicSystem dlSystem;
    protected User userCurrent;
    protected Boolean existElement;
    protected Boolean newElement;
    protected List<RoleInfo> listRoles;
    private DirtyManager m_Dirty;
    private String m_sPassword;
    private List<Permission> listPermission;
    private List<User> users;
    private final JFlowPanel flowpanel;
    List<JButton> btnsUser;
    private int indexUser;
    private int numManager;
    private boolean finger_print;
    private boolean dallas_integrated;
    private final String end_finger_print = "\u00e0&\u00e0\u00e0\u00e0\u00e0\u00e0\u00e0\u00e0\u00e0";
    private String text_dallas = "";
    private boolean glory_enabled;
    public String OPEN_DRAWER = "Ouverture terroir caisse";
    public final String ID_OPEN_DRAWER = "0";
    public String UNLOCK_CAISSE = "Deverrouillage caisse";
    public final String ID_UNLOCK_CAISSE = "1";
    public String ADD_PROMOTION = "Ajouter promotion";
    public final String ID_ADD_PROMOTION = "2";
    public String CANCEL_ORDER = "Annulation commande";
    public final String ID_CANCEL_ORDER = "3";
    public String TRANSFERT_ORDER = "Transferer commande";
    public final String ID_TRANSFERT_ORDER = "4";
    public String GET_EMAILS = "Recevoir les statistique par email";
    public final String ID_GET_EMAILS = "5";
    public String ADD_PRODUCT_DIVERS = "Ajouter Produit Divers";
    public final String ID_ADD_PRODUCT_DIVERS = "6";
    public String LOCK_CAISSE = "Verrouillage caisse";
    public final String ID_LOCK_CAISSE = "7";
    public String GLORY_FUNCTIONS = "Acc\u00e9e aux fonctions du Monnayeur";
    public final String ID_GLORY_FUNCTIONS = "8";
    public String GLORY_FUNCTIONS_ADVANCED = "Acc\u00e9e aux fonctions avanc\u00e9es du Monnayeur";
    public final String ID_GLORY_FUNCTIONS_ADVANCED = "9";
    public String PAID_ORDER = "Encaisser commande";
    public final String ID_PAID_ORDER = "10";
    public String RAPPEL_TICKET = "Rappel Ticket";
    public final String ID_RAPPEL_TICKET = "11";
    public String ADD_FREE_OPTIONS = "Ajouter des options gratuites";
    public final String ID_ADD_FREE_OPTIONS = "12";
    public String FOND_CAISSE = "Voir le fond caisse";
    public final String ID_FOND_CAISSE = "13";
    public String DELETE_LINES_ORDER = "Supprimer les lignes de commandes";
    public final String ID_DELETE_LINES_ORDER = "14";
    public final String ID_PRINT_TICKET_CAISSE = "15";
    public final String ID_PRINT_TICKET_KITCHEN = "16";
    public final String ID_PRINT_JUSTIFICATIF_PAYMENT = "17";
    public final String ID_DUPLICATE_TICKET = "18";
    public final String ID_PRINT_LABEL = "19";
    public final String ID_X_GLOBAL = "20";
    public String X_GLOBAL = "X Global";
    public final String ID_BACKOFFICE_CASHLOGY = "22";
    public String BACKOFFICE_CASHLOGY = "BackOffice Cashlogy";
    public final String ID_STOCK_MANAGEMENT = "21";
    public String STOCK_MANAGEMENT = "Gestion de stock";
    private JLabel emailLabel;
    private JTextField emailText;
    private JButton jAdd;
    private JButton jBtnDeletePwd;
    private JButton jBtnPwd;
    private JButton jButton1;
    private JCheckBox jCheckBoxAddFreeOptions;
    private JCheckBox jCheckBoxCancel;
    private JCheckBox jCheckBoxDeleteLinesOrder;
    private JCheckBox jCheckBoxDrawer;
    private JCheckBox jCheckBoxDuplicateTicket;
    private JCheckBox jCheckBoxEmailSender;
    private JCheckBox jCheckBoxFondCaisse;
    private JCheckBox jCheckBoxGloryFunctions;
    private JCheckBox jCheckBoxGloryFunctionsAdvanced;
    private JCheckBox jCheckBoxLock;
    private JCheckBox jCheckBoxPaidOrder;
    private JCheckBox jCheckBoxPrintJustificatifPayment;
    private JCheckBox jCheckBoxPrintLabel;
    private JCheckBox jCheckBoxPrintTicketCaisse;
    private JCheckBox jCheckBoxPrintTicketKitchen;
    private JCheckBox jCheckBoxProductDiver;
    private JCheckBox jCheckBoxPromotion;
    private JCheckBox jCheckBoxRappelTicket;
    private JCheckBox jCheckBoxTransfert;
    private JCheckBox jCheckBoxUnLock;
    private JCheckBox jCheckBoxXGlobal;
    private JCheckBox jCheckBoxbackOfficeCashlogy;
    private JButton jDelete;
    private JTextField jFingerPrint;
    private JPanel jInfoUser;
    private JLabel jLabel1;
    private JLabel jLabel17;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JPanel jManage;
    private JPanel jPanel1;
    private JPanel jPanel5;
    private JPanel jPanel7;
    private JPanel jPanel9;
    private JPanel jPanelTitle;
    private JPanel jPanelUsers;
    private JPanel jPersist;
    private JButton jSave;
    private JTextField m_jName;
    private JComboBox m_jRole;
    private JPanel panePermissions;
    private JPanel panelAddPWD;
    private JPanel panelBody;
    private JPanel panelDeletePWD;
    private JPanel panelEmail;
    private JPanel panelFingerPrint;
    private JPanel panelName;
    private JPanel panelRole;
    private JCheckBox stockManagement;
    private JPanel userPane;
    private JScrollPane userScroll;

    public UserPanel() {
        this.initComponents();
        this.flowpanel = new JFlowPanel();
        this.jPanelTitle.setLayout(new FlowLayout(0));
        if ("venteDetail".equals(AppLocal.licence)) {
            this.jCheckBoxTransfert.setVisible(false);
        }
    }

    public void loadCatalog() throws BasicException {
        this.indexUser = 0;
        this.users = "0".equals(this.m_App.getAppUserView().getUser().getRole()) ? this.m_dlUser.getUsers() : this.m_dlUser.getUsers();
        this.numManager = 0;
        this.users.stream().filter(user -> "1".equals(user.getRole())).forEachOrdered(_item -> ++this.numManager);
        this.btnsUser.clear();
        this.flowpanel.removeAll();
        for (final User user2 : this.users) {
            final JButton btn = new JButton();
            btn.setText(user2.getName());
            btn.setPreferredSize(new Dimension(180, 60));
            btn.setFocusPainted(false);
            btn.setFocusable(true);
            btn.setRequestFocusEnabled(true);
            btn.setHorizontalAlignment(0);
            btn.setHorizontalTextPosition(4);
            btn.setVerticalTextPosition(0);
            btn.setContentAreaFilled(true);
            btn.setBorderPainted(false);
            btn.setOpaque(true);
            btn.setRolloverEnabled(true);
            btn.setForeground(Color.BLACK);
            btn.setBackground(new Color(129, 207, 224));
            btn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    UserPanel.this.loadUser(user2, btn);
                }
            });
            this.flowpanel.add(btn);
            this.btnsUser.add(btn);
        }
        this.flowpanel.revalidate();
        this.flowpanel.repaint();
        this.userScroll.getViewport().setView(this.flowpanel);
        if (this.users.size() > 0) {
            if (this.userCurrent != null) {
                for (int i = 0; i < this.users.size(); ++i) {
                    if (!this.userCurrent.getId().equals(this.users.get(i).getId())) continue;
                    this.indexUser = i;
                    break;
                }
            }
            this.loadUser(this.users.get(this.indexUser), this.btnsUser.get(this.indexUser));
        }
    }

    public void loadUser(User user, JButton btnUser) {
        if (user != null) {
            this.jPersist.removeAll();
            this.jPersist.add(this.jSave);
            if (!"0".equals(user.getRole())) {
                this.jPersist.add(this.jDelete);
            }
            this.jPersist.add(this.jAdd);
            this.jPersist.revalidate();
            this.jPersist.repaint();
            this.existElement = true;
            this.newElement = false;
            this.userCurrent = user;
            this.m_sPassword = user.getPassword();
            if (this.m_sPassword != null) {
                this.jBtnDeletePwd.setVisible(true);
            } else {
                this.jBtnDeletePwd.setVisible(false);
            }
            this.m_jName.setText(user.getName());
            this.jFingerPrint.setText(user.getFingerprint());
            this.text_dallas = this.jFingerPrint.getText();
            this.emailText.setText(user.getEmail());
            for (RoleInfo role : this.listRoles) {
                if (!this.userCurrent.getRole().equals(role.getID())) continue;
                this.m_jRole.setSelectedItem(role);
            }
            this.listPermission.clear();
            this.jCheckBoxDrawer.setSelected(false);
            this.jCheckBoxUnLock.setSelected(false);
            this.jCheckBoxLock.setSelected(false);
            this.jCheckBoxPromotion.setSelected(false);
            this.jCheckBoxCancel.setSelected(false);
            this.jCheckBoxTransfert.setSelected(false);
            this.jCheckBoxEmailSender.setSelected(false);
            this.jCheckBoxProductDiver.setSelected(false);
            this.jCheckBoxPaidOrder.setSelected(false);
            this.jCheckBoxRappelTicket.setSelected(false);
            this.jCheckBoxAddFreeOptions.setSelected(false);
            this.jCheckBoxFondCaisse.setSelected(false);
            this.jCheckBoxDeleteLinesOrder.setSelected(false);
            this.jCheckBoxPrintTicketCaisse.setSelected(false);
            this.jCheckBoxPrintTicketKitchen.setSelected(false);
            this.jCheckBoxPrintJustificatifPayment.setSelected(false);
            this.jCheckBoxDuplicateTicket.setSelected(false);
            this.jCheckBoxPrintLabel.setSelected(false);
            this.jCheckBoxXGlobal.setSelected(false);
            this.jCheckBoxbackOfficeCashlogy.setSelected(false);
            this.stockManagement.setSelected(false);
            if (this.glory_enabled) {
                this.jCheckBoxGloryFunctions.setSelected(false);
                this.jCheckBoxGloryFunctionsAdvanced.setSelected(false);
            }
            try {
                this.listPermission = this.m_dlUser.getPermissionByUser(this.userCurrent.getId());
            }
            catch (BasicException ex) {
                LogToFile.log("severe", null, ex);
            }
            for (Permission permission : this.listPermission) {
                switch (permission.getId()) {
                    case "0": {
                        this.jCheckBoxDrawer.setSelected(true);
                        break;
                    }
                    case "1": {
                        this.jCheckBoxUnLock.setSelected(true);
                        break;
                    }
                    case "2": {
                        this.jCheckBoxPromotion.setSelected(true);
                        break;
                    }
                    case "3": {
                        this.jCheckBoxCancel.setSelected(true);
                        break;
                    }
                    case "4": {
                        this.jCheckBoxTransfert.setSelected(true);
                        break;
                    }
                    case "5": {
                        this.jCheckBoxEmailSender.setSelected(true);
                        break;
                    }
                    case "6": {
                        this.jCheckBoxProductDiver.setSelected(true);
                        break;
                    }
                    case "7": {
                        this.jCheckBoxLock.setSelected(true);
                        break;
                    }
                    case "8": {
                        this.jCheckBoxGloryFunctions.setSelected(true);
                        break;
                    }
                    case "9": {
                        this.jCheckBoxGloryFunctionsAdvanced.setSelected(true);
                        break;
                    }
                    case "10": {
                        this.jCheckBoxPaidOrder.setSelected(true);
                        break;
                    }
                    case "11": {
                        this.jCheckBoxRappelTicket.setSelected(true);
                        break;
                    }
                    case "12": {
                        this.jCheckBoxAddFreeOptions.setSelected(true);
                        break;
                    }
                    case "13": {
                        this.jCheckBoxFondCaisse.setSelected(true);
                        break;
                    }
                    case "14": {
                        this.jCheckBoxDeleteLinesOrder.setSelected(true);
                        break;
                    }
                    case "15": {
                        this.jCheckBoxPrintTicketCaisse.setSelected(true);
                        break;
                    }
                    case "16": {
                        this.jCheckBoxPrintTicketKitchen.setSelected(true);
                        break;
                    }
                    case "17": {
                        this.jCheckBoxPrintJustificatifPayment.setSelected(true);
                        break;
                    }
                    case "18": {
                        this.jCheckBoxDuplicateTicket.setSelected(true);
                        break;
                    }
                    case "19": {
                        this.jCheckBoxPrintLabel.setSelected(true);
                        break;
                    }
                    case "20": {
                        this.jCheckBoxXGlobal.setSelected(true);
                        break;
                    }
                    case "22": {
                        this.jCheckBoxbackOfficeCashlogy.setSelected(true);
                        break;
                    }
                    case "21": {
                        this.stockManagement.setSelected(true);
                    }
                }
            }
            this.btnsUser.forEach(btn -> btn.setBackground(new Color(129, 207, 224)));
            btnUser.setBackground(new Color(89, 171, 227));
        }
    }

    public void setComponentEnabled(boolean value) {
        this.setEnabled(value);
    }

    public void addActionListener(ActionListener l) {
        this.listeners.add(ActionListener.class, l);
    }

    public void removeActionListener(ActionListener l) {
        this.listeners.remove(ActionListener.class, l);
    }

    private void selectCategoryPanel(int supplementID) {
    }

    private void selectIndicatorPanel(Icon icon, String label, String texttip) {
        CardLayout cl = (CardLayout)this.jPanelUsers.getLayout();
        cl.show(this.jPanelUsers, "subcategories");
    }

    private void selectIndicatorCategories() {
        CardLayout cl = (CardLayout)this.jPanelUsers.getLayout();
        cl.show(this.jPanelUsers, "rootcategories");
    }

    @Override
    public String getTitle() {
        return "Gestion des Utilisateurs";
    }

    @Override
    public void activate() throws BasicException {
        AppLocal.reload_permission = true;
        AppLocal.user_management = true;
        this.listRoles = "0".equals(this.m_App.getAppUserView().getUser().getRole()) ? this.m_dlUser.getAllRoles() : this.m_dlUser.getRoles();
        this.m_jRole.removeAllItems();
        this.listRoles.stream().filter(role -> !"venteDetail".equals(AppLocal.licence) || !"3".equals(role.getID())).forEachOrdered(role -> this.m_jRole.addItem(role));
        this.m_jRole.setSelectedItem(null);
        this.userScroll.getViewport().setView(null);
        this.loadCatalog();
    }

    @Override
    public boolean deactivate() {
        return true;
    }

    @Override
    public void init(AppView app) throws BeanFactoryException {
        this.m_App = app;
        this.dlSystem = (DataLogicSystem)this.m_App.getBean("com.openbravo.dao.DataLogicSystem");
        this.m_dlUser = (DataLogicAdmin)this.m_App.getBean("com.openbravo.pos.admin.DataLogicAdmin");
        this.existElement = false;
        this.btnsUser = new ArrayList<JButton>();
        this.newElement = false;
        this.userCurrent = null;
        this.users = new ArrayList<User>();
        this.listRoles = new ArrayList<RoleInfo>();
        this.m_Dirty = new DirtyManager();
        this.m_sPassword = null;
        this.listPermission = new ArrayList<Permission>();
        this.finger_print = AppLocal.CLE_DALLAS || AppLocal.DALLAS_INTEGRATED;
        boolean bl = this.glory_enabled = this.m_App.getProperties().getProperty("module.glory") != null && "yes".equals(this.m_App.getProperties().getProperty("module.glory"));
        if (!this.finger_print) {
            this.panelBody.removeAll();
            this.panelBody.add(this.panelName);
            this.panelBody.add(this.panelEmail);
            this.panelBody.add(this.panelRole);
            this.panelBody.add(this.panelAddPWD);
            this.panelBody.add(this.panelDeletePWD);
            this.panelBody.add(this.panePermissions);
        }
        this.jCheckBoxGloryFunctions.setVisible(this.glory_enabled);
        this.jCheckBoxGloryFunctionsAdvanced.setVisible(this.glory_enabled);
        if (AppLocal.DALLAS_INTEGRATED) {
            this.jFingerPrint.addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent e) {
                }

                @Override
                public void keyPressed(KeyEvent e) {
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        UserPanel.this.getFingerPrint();
                    }
                }
            });
        }
    }

    @Override
    public Object getBean() {
        return this;
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    private void initComponents() {
        this.jPanel5 = new JPanel();
        this.jManage = new JPanel();
        this.jPersist = new JPanel();
        this.jSave = new JButton();
        this.jDelete = new JButton();
        this.jAdd = new JButton();
        this.jInfoUser = new JPanel();
        this.jPanel1 = new JPanel();
        this.jPanel9 = new JPanel();
        this.panelBody = new JPanel();
        this.panelName = new JPanel();
        this.jLabel3 = new JLabel();
        this.m_jName = new JTextField();
        this.panelEmail = new JPanel();
        this.emailLabel = new JLabel();
        this.emailText = new JTextField();
        this.panelRole = new JPanel();
        this.jLabel17 = new JLabel();
        this.m_jRole = new JComboBox();
        this.panelFingerPrint = new JPanel();
        this.jLabel5 = new JLabel();
        this.jFingerPrint = new JTextField();
        this.jButton1 = new JButton();
        this.panelAddPWD = new JPanel();
        this.jLabel2 = new JLabel();
        this.jBtnPwd = new JButton();
        this.panelDeletePWD = new JPanel();
        this.jLabel4 = new JLabel();
        this.jBtnDeletePwd = new JButton();
        this.panePermissions = new JPanel();
        this.jCheckBoxUnLock = new JCheckBox();
        this.jCheckBoxDrawer = new JCheckBox();
        this.jCheckBoxPromotion = new JCheckBox();
        this.jCheckBoxCancel = new JCheckBox();
        this.jCheckBoxLock = new JCheckBox();
        this.jCheckBoxTransfert = new JCheckBox();
        this.jCheckBoxEmailSender = new JCheckBox();
        this.jCheckBoxProductDiver = new JCheckBox();
        this.jCheckBoxGloryFunctions = new JCheckBox();
        this.jCheckBoxGloryFunctionsAdvanced = new JCheckBox();
        this.jCheckBoxRappelTicket = new JCheckBox();
        this.jCheckBoxAddFreeOptions = new JCheckBox();
        this.jCheckBoxPaidOrder = new JCheckBox();
        this.jCheckBoxFondCaisse = new JCheckBox();
        this.jCheckBoxDeleteLinesOrder = new JCheckBox();
        this.jCheckBoxPrintTicketCaisse = new JCheckBox();
        this.jCheckBoxPrintTicketKitchen = new JCheckBox();
        this.jCheckBoxDuplicateTicket = new JCheckBox();
        this.jCheckBoxPrintLabel = new JCheckBox();
        this.jCheckBoxPrintJustificatifPayment = new JCheckBox();
        this.jCheckBoxXGlobal = new JCheckBox();
        this.jCheckBoxbackOfficeCashlogy = new JCheckBox();
        this.stockManagement = new JCheckBox();
        this.jPanelUsers = new JPanel();
        this.userPane = new JPanel();
        this.userScroll = new JScrollPane();
        this.jPanel7 = new JPanel();
        this.jPanelTitle = new JPanel();
        this.jLabel1 = new JLabel();
        this.setLayout(new BorderLayout());
        this.jPanel5.setLayout(new BorderLayout());
        this.jManage.setPreferredSize(new Dimension(200, 80));
        this.jManage.setLayout(new BorderLayout());
        this.jPersist.setPreferredSize(new Dimension(10, 50));
        this.jPersist.setLayout(new GridLayout(1, 0));
        this.jSave.setIcon(new ImageIcon(this.getClass().getResource("/com/openbravo/images/filesave.png")));
        this.jSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UserPanel.this.jSaveActionPerformed(evt);
            }
        });
        this.jPersist.add(this.jSave);
        this.jDelete.setIcon(new ImageIcon(this.getClass().getResource("/com/openbravo/images/sale_delete.png")));
        this.jDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UserPanel.this.jDeleteActionPerformed(evt);
            }
        });
        this.jPersist.add(this.jDelete);
        this.jAdd.setIcon(new ImageIcon(this.getClass().getResource("/com/openbravo/images/editnew.png")));
        this.jAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UserPanel.this.jAddActionPerformed(evt);
            }
        });
        this.jPersist.add(this.jAdd);
        this.jManage.add((Component)this.jPersist, "North");
        this.jPanel5.add((Component)this.jManage, "After");
        this.jInfoUser.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new BorderLayout());
        this.jPanel9.setPreferredSize(new Dimension(10, 50));
        this.jPanel1.add((Component)this.jPanel9, "North");
        this.panelBody.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 204)));
        this.panelBody.setLayout(new FlowLayout(0, 2, 2));
        this.panelName.setPreferredSize(new Dimension(600, 35));
        this.panelName.setLayout(new FlowLayout(0));
        this.jLabel3.setFont(new Font("Arial", 0, 12));
        this.jLabel3.setText("Nom *");
        this.jLabel3.setMaximumSize(new Dimension(140, 25));
        this.jLabel3.setMinimumSize(new Dimension(140, 25));
        this.jLabel3.setPreferredSize(new Dimension(140, 30));
        this.panelName.add(this.jLabel3);
        this.m_jName.setFont(new Font("Arial", 0, 12));
        this.m_jName.setPreferredSize(new Dimension(300, 30));
        this.panelName.add(this.m_jName);
        this.panelBody.add(this.panelName);
        this.panelEmail.setPreferredSize(new Dimension(600, 35));
        this.panelEmail.setLayout(new FlowLayout(0));
        this.emailLabel.setFont(new Font("Arial", 0, 12));
        this.emailLabel.setText("Email ");
        this.emailLabel.setMaximumSize(new Dimension(140, 25));
        this.emailLabel.setMinimumSize(new Dimension(140, 25));
        this.emailLabel.setPreferredSize(new Dimension(140, 30));
        this.panelEmail.add(this.emailLabel);
        this.emailText.setFont(new Font("Arial", 0, 12));
        this.emailText.setPreferredSize(new Dimension(300, 30));
        this.panelEmail.add(this.emailText);
        this.panelBody.add(this.panelEmail);
        this.panelRole.setPreferredSize(new Dimension(600, 35));
        this.panelRole.setLayout(new FlowLayout(0));
        this.jLabel17.setFont(new Font("Arial", 0, 12));
        this.jLabel17.setText("R\u00f4le *");
        this.jLabel17.setPreferredSize(new Dimension(140, 30));
        this.panelRole.add(this.jLabel17);
        this.m_jRole.setFont(new Font("Arial", 0, 14));
        this.m_jRole.setPreferredSize(new Dimension(300, 30));
        this.panelRole.add(this.m_jRole);
        this.panelBody.add(this.panelRole);
        this.panelFingerPrint.setPreferredSize(new Dimension(600, 40));
        this.panelFingerPrint.setLayout(new FlowLayout(0));
        this.jLabel5.setPreferredSize(new Dimension(140, 30));
        this.panelFingerPrint.add(this.jLabel5);
        this.jFingerPrint.setPreferredSize(new Dimension(240, 30));
        this.panelFingerPrint.add(this.jFingerPrint);
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/com/openbravo/images/fingerPrintS.png")));
        this.jButton1.setPreferredSize(new Dimension(50, 36));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UserPanel.this.jButton1ActionPerformed(evt);
            }
        });
        this.panelFingerPrint.add(this.jButton1);
        this.panelBody.add(this.panelFingerPrint);
        this.panelAddPWD.setPreferredSize(new Dimension(600, 35));
        this.panelAddPWD.setLayout(new FlowLayout(0));
        this.jLabel2.setPreferredSize(new Dimension(140, 30));
        this.panelAddPWD.add(this.jLabel2);
        this.jBtnPwd.setFont(new Font("Arial", 0, 12));
        this.jBtnPwd.setText("D\u00e9finir un mot de passe");
        this.jBtnPwd.setPreferredSize(new Dimension(300, 30));
        this.jBtnPwd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UserPanel.this.jBtnPwdActionPerformed(evt);
            }
        });
        this.panelAddPWD.add(this.jBtnPwd);
        this.panelBody.add(this.panelAddPWD);
        this.panelDeletePWD.setPreferredSize(new Dimension(600, 35));
        this.panelDeletePWD.setLayout(new FlowLayout(0));
        this.jLabel4.setPreferredSize(new Dimension(140, 30));
        this.panelDeletePWD.add(this.jLabel4);
        this.jBtnDeletePwd.setFont(new Font("Arial", 0, 12));
        this.jBtnDeletePwd.setText("Supprimer Mot de passe");
        this.jBtnDeletePwd.setPreferredSize(new Dimension(300, 30));
        this.jBtnDeletePwd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UserPanel.this.jBtnDeletePwdActionPerformed(evt);
            }
        });
        this.panelDeletePWD.add(this.jBtnDeletePwd);
        this.panelBody.add(this.panelDeletePWD);
        this.panePermissions.setPreferredSize(new Dimension(700, 400));
        this.panePermissions.setLayout(new FlowLayout(0));
        this.jCheckBoxUnLock.setText("D\u00e9verrouillage caisse");
        this.jCheckBoxUnLock.setPreferredSize(new Dimension(300, 30));
        this.panePermissions.add(this.jCheckBoxUnLock);
        this.jCheckBoxDrawer.setText("Ouverture tiroir  caisse");
        this.jCheckBoxDrawer.setPreferredSize(new Dimension(300, 30));
        this.jCheckBoxDrawer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UserPanel.this.jCheckBoxDrawerActionPerformed(evt);
            }
        });
        this.panePermissions.add(this.jCheckBoxDrawer);
        this.jCheckBoxPromotion.setText("Ajouter promotion");
        this.jCheckBoxPromotion.setPreferredSize(new Dimension(300, 30));
        this.panePermissions.add(this.jCheckBoxPromotion);
        this.jCheckBoxCancel.setText("Annulation commande");
        this.jCheckBoxCancel.setPreferredSize(new Dimension(300, 30));
        this.panePermissions.add(this.jCheckBoxCancel);
        this.jCheckBoxLock.setText("Verrouillage caisse");
        this.jCheckBoxLock.setPreferredSize(new Dimension(300, 30));
        this.jCheckBoxLock.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UserPanel.this.jCheckBoxLockActionPerformed(evt);
            }
        });
        this.panePermissions.add(this.jCheckBoxLock);
        this.jCheckBoxTransfert.setText("Transferer Commande");
        this.jCheckBoxTransfert.setPreferredSize(new Dimension(300, 30));
        this.jCheckBoxTransfert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UserPanel.this.jCheckBoxTransfertActionPerformed(evt);
            }
        });
        this.panePermissions.add(this.jCheckBoxTransfert);
        this.jCheckBoxEmailSender.setText("Recevoir les statistiques par email");
        this.jCheckBoxEmailSender.setPreferredSize(new Dimension(300, 30));
        this.panePermissions.add(this.jCheckBoxEmailSender);
        this.jCheckBoxProductDiver.setText("Ajouter des produits divers");
        this.jCheckBoxProductDiver.setPreferredSize(new Dimension(300, 30));
        this.panePermissions.add(this.jCheckBoxProductDiver);
        this.jCheckBoxGloryFunctions.setText("Acc\u00e9e aux fonctions du Monnayeur");
        this.jCheckBoxGloryFunctions.setPreferredSize(new Dimension(300, 30));
        this.panePermissions.add(this.jCheckBoxGloryFunctions);
        this.jCheckBoxGloryFunctionsAdvanced.setText("<html>Acc\u00e9e aux fonctions<strong> avanc\u00e9es</strong> du Monnayeur ");
        this.jCheckBoxGloryFunctionsAdvanced.setPreferredSize(new Dimension(300, 30));
        this.jCheckBoxGloryFunctionsAdvanced.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                UserPanel.this.jCheckBoxGloryFunctionsAdvancedStateChanged(evt);
            }
        });
        this.panePermissions.add(this.jCheckBoxGloryFunctionsAdvanced);
        this.jCheckBoxRappelTicket.setText("Rappel Ticket");
        this.jCheckBoxRappelTicket.setPreferredSize(new Dimension(300, 30));
        this.jCheckBoxRappelTicket.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UserPanel.this.jCheckBoxRappelTicketActionPerformed(evt);
            }
        });
        this.panePermissions.add(this.jCheckBoxRappelTicket);
        this.jCheckBoxAddFreeOptions.setText("Ajouter des options gratuites");
        this.jCheckBoxAddFreeOptions.setPreferredSize(new Dimension(300, 30));
        this.jCheckBoxAddFreeOptions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UserPanel.this.jCheckBoxAddFreeOptionsActionPerformed(evt);
            }
        });
        this.panePermissions.add(this.jCheckBoxAddFreeOptions);
        this.jCheckBoxPaidOrder.setText("Encaisser Commande");
        this.jCheckBoxPaidOrder.setPreferredSize(new Dimension(300, 30));
        this.jCheckBoxPaidOrder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UserPanel.this.jCheckBoxPaidOrderActionPerformed(evt);
            }
        });
        this.panePermissions.add(this.jCheckBoxPaidOrder);
        this.jCheckBoxFondCaisse.setText("Voir le fond caisse");
        this.jCheckBoxFondCaisse.setPreferredSize(new Dimension(300, 30));
        this.jCheckBoxFondCaisse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UserPanel.this.jCheckBoxFondCaisseActionPerformed(evt);
            }
        });
        this.panePermissions.add(this.jCheckBoxFondCaisse);
        this.jCheckBoxDeleteLinesOrder.setText("Supprimer les lignes de commandes");
        this.jCheckBoxDeleteLinesOrder.setPreferredSize(new Dimension(300, 30));
        this.jCheckBoxDeleteLinesOrder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UserPanel.this.jCheckBoxDeleteLinesOrderActionPerformed(evt);
            }
        });
        this.panePermissions.add(this.jCheckBoxDeleteLinesOrder);
        this.jCheckBoxPrintTicketCaisse.setText("Imprimer Ticket Caisse");
        this.jCheckBoxPrintTicketCaisse.setPreferredSize(new Dimension(300, 30));
        this.jCheckBoxPrintTicketCaisse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UserPanel.this.jCheckBoxPrintTicketCaisseActionPerformed(evt);
            }
        });
        this.panePermissions.add(this.jCheckBoxPrintTicketCaisse);
        this.jCheckBoxPrintTicketKitchen.setText("Imprimer ticket cuisine");
        this.jCheckBoxPrintTicketKitchen.setPreferredSize(new Dimension(300, 30));
        this.jCheckBoxPrintTicketKitchen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UserPanel.this.jCheckBoxPrintTicketKitchenActionPerformed(evt);
            }
        });
        this.panePermissions.add(this.jCheckBoxPrintTicketKitchen);
        this.jCheckBoxDuplicateTicket.setText("Dupliquer commande");
        this.jCheckBoxDuplicateTicket.setPreferredSize(new Dimension(300, 30));
        this.jCheckBoxDuplicateTicket.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UserPanel.this.jCheckBoxDuplicateTicketActionPerformed(evt);
            }
        });
        this.panePermissions.add(this.jCheckBoxDuplicateTicket);
        this.jCheckBoxPrintLabel.setText("Imprimer Etiquette");
        this.jCheckBoxPrintLabel.setPreferredSize(new Dimension(300, 30));
        this.jCheckBoxPrintLabel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UserPanel.this.jCheckBoxPrintLabelActionPerformed(evt);
            }
        });
        this.panePermissions.add(this.jCheckBoxPrintLabel);
        this.jCheckBoxPrintJustificatifPayment.setText("Imprimer Justificatif de paiement");
        this.jCheckBoxPrintJustificatifPayment.setPreferredSize(new Dimension(300, 30));
        this.jCheckBoxPrintJustificatifPayment.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UserPanel.this.jCheckBoxPrintJustificatifPaymentActionPerformed(evt);
            }
        });
        this.panePermissions.add(this.jCheckBoxPrintJustificatifPayment);
        this.jCheckBoxXGlobal.setText("X Global");
        this.jCheckBoxXGlobal.setPreferredSize(new Dimension(300, 30));
        this.jCheckBoxXGlobal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UserPanel.this.jCheckBoxXGlobalActionPerformed(evt);
            }
        });
        this.panePermissions.add(this.jCheckBoxXGlobal);
        this.jCheckBoxbackOfficeCashlogy.setText("Acc\u00e9der au BackOffice Cashlogy");
        this.jCheckBoxbackOfficeCashlogy.setPreferredSize(new Dimension(300, 30));
        this.jCheckBoxbackOfficeCashlogy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UserPanel.this.jCheckBoxbackOfficeCashlogyActionPerformed(evt);
            }
        });
        this.panePermissions.add(this.jCheckBoxbackOfficeCashlogy);
        this.stockManagement.setText("Gestion de stock");
        this.stockManagement.setPreferredSize(new Dimension(300, 30));
        this.stockManagement.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UserPanel.this.stockManagementActionPerformed(evt);
            }
        });
        this.panePermissions.add(this.stockManagement);
        this.panelBody.add(this.panePermissions);
        this.jPanel1.add((Component)this.panelBody, "Center");
        this.jInfoUser.add((Component)this.jPanel1, "Center");
        this.jPanel5.add((Component)this.jInfoUser, "Center");
        this.jPanelUsers.setMaximumSize(new Dimension(275, 600));
        this.jPanelUsers.setPreferredSize(new Dimension(220, 600));
        this.jPanelUsers.setLayout(new BorderLayout());
        this.userPane.setFont(new Font("Arial", 0, 11));
        this.userPane.setMinimumSize(new Dimension(200, 100));
        this.userPane.setPreferredSize(new Dimension(400, 130));
        this.userPane.setLayout(new BorderLayout());
        this.userPane.add((Component)this.userScroll, "Center");
        this.jPanelUsers.add((Component)this.userPane, "Center");
        this.jPanel7.setPreferredSize(new Dimension(10, 50));
        this.jPanelUsers.add((Component)this.jPanel7, "North");
        this.jPanel5.add((Component)this.jPanelUsers, "Before");
        this.add((Component)this.jPanel5, "Center");
        this.jPanelTitle.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, new Color(0, 0, 0)));
        this.jPanelTitle.setPreferredSize(new Dimension(1238, 50));
        this.jLabel1.setFont(new Font("Tahoma", 1, 14));
        this.jLabel1.setText("Gestion des Utilisateurs");
        this.jLabel1.setPreferredSize(new Dimension(200, 30));
        this.jPanelTitle.add(this.jLabel1);
        this.add((Component)this.jPanelTitle, "First");
    }

    private void jSaveActionPerformed(ActionEvent evt) {
        if (this.newElement.booleanValue()) {
            if (!this.m_jName.getText().isEmpty() && this.m_jRole.getSelectedItem() != null) {
                this.userCurrent = new User();
                String shortId = StringUtils.getShortID();
                System.out.println("++++++++ shortId : " + shortId);
                this.userCurrent.setId(shortId);
                this.userCurrent.setName(this.m_jName.getText());
                this.userCurrent.setPassword(this.m_sPassword);
                this.userCurrent.setEmail(this.emailText.getText() == null ? "" : this.emailText.getText().trim());
                RoleInfo role = (RoleInfo)this.m_jRole.getSelectedItem();
                this.userCurrent.setRole(role.getID());
                this.userCurrent.setFingerprint(this.jFingerPrint.getText());
                this.listPermission.clear();
                if (this.jCheckBoxDrawer.isSelected() || "1".equals(role.getID())) {
                    this.listPermission.add(new Permission("0", this.OPEN_DRAWER));
                }
                if (this.jCheckBoxUnLock.isSelected() || "1".equals(role.getID()) || "2".equals(role.getID())) {
                    this.listPermission.add(new Permission("1", this.UNLOCK_CAISSE));
                }
                if (this.jCheckBoxPromotion.isSelected() || "1".equals(role.getID())) {
                    this.listPermission.add(new Permission("2", this.ADD_PROMOTION));
                }
                if (this.jCheckBoxCancel.isSelected() || "1".equals(role.getID())) {
                    this.listPermission.add(new Permission("3", this.CANCEL_ORDER));
                }
                if (this.jCheckBoxTransfert.isSelected() || "1".equals(role.getID())) {
                    this.listPermission.add(new Permission("4", this.TRANSFERT_ORDER));
                }
                if (this.jCheckBoxEmailSender.isSelected() || "1".equals(role.getID())) {
                    this.listPermission.add(new Permission("5", this.GET_EMAILS));
                }
                if (this.jCheckBoxProductDiver.isSelected() || "1".equals(role.getID())) {
                    this.listPermission.add(new Permission("6", this.ADD_PRODUCT_DIVERS));
                }
                if (this.jCheckBoxLock.isSelected() || "1".equals(role.getID())) {
                    this.listPermission.add(new Permission("7", this.LOCK_CAISSE));
                }
                if (this.glory_enabled) {
                    if (this.jCheckBoxGloryFunctions.isSelected() || "1".equals(role.getID())) {
                        this.listPermission.add(new Permission("8", this.GLORY_FUNCTIONS));
                    }
                    if (this.jCheckBoxGloryFunctionsAdvanced.isSelected()) {
                        this.listPermission.add(new Permission("9", this.GLORY_FUNCTIONS_ADVANCED));
                    }
                }
                if (this.jCheckBoxPaidOrder.isSelected() || "1".equals(role.getID())) {
                    this.listPermission.add(new Permission("10", this.PAID_ORDER));
                }
                if (this.jCheckBoxRappelTicket.isSelected() || "1".equals(role.getID())) {
                    this.listPermission.add(new Permission("11", this.RAPPEL_TICKET));
                }
                if (this.jCheckBoxAddFreeOptions.isSelected() || "1".equals(role.getID())) {
                    this.listPermission.add(new Permission("12", this.ADD_FREE_OPTIONS));
                }
                if (this.jCheckBoxFondCaisse.isSelected() || "1".equals(role.getID())) {
                    this.listPermission.add(new Permission("13", this.FOND_CAISSE));
                }
                if (this.jCheckBoxDeleteLinesOrder.isSelected() || "1".equals(role.getID())) {
                    this.listPermission.add(new Permission("14", this.DELETE_LINES_ORDER));
                }
                if (this.jCheckBoxPrintTicketCaisse.isSelected() || "1".equals(role.getID())) {
                    this.listPermission.add(new Permission("15", ""));
                }
                if (this.jCheckBoxPrintTicketKitchen.isSelected() || "1".equals(role.getID())) {
                    this.listPermission.add(new Permission("16", ""));
                }
                if (this.jCheckBoxPrintJustificatifPayment.isSelected() || "1".equals(role.getID())) {
                    this.listPermission.add(new Permission("17", ""));
                }
                if (this.jCheckBoxDuplicateTicket.isSelected() || "1".equals(role.getID())) {
                    this.listPermission.add(new Permission("18", ""));
                }
                if (this.jCheckBoxPrintLabel.isSelected() || "1".equals(role.getID())) {
                    this.listPermission.add(new Permission("19", ""));
                }
                if (this.jCheckBoxXGlobal.isSelected() || "1".equals(role.getID())) {
                    this.listPermission.add(new Permission("20", this.X_GLOBAL));
                }
                if (this.jCheckBoxbackOfficeCashlogy.isSelected()) {
                    this.listPermission.add(new Permission("22", this.BACKOFFICE_CASHLOGY));
                }
                if (this.stockManagement.isSelected() || "1".equals(role.getID())) {
                    this.listPermission.add(new Permission("21", this.STOCK_MANAGEMENT));
                }
                try {
                    this.m_dlUser.addUser(this.userCurrent, this.listPermission, this.m_App.getAppUserView().getUser().getId());
                    new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, "Utilisateur Ajout\u00e9.", 1500, NPosition.CENTER);
                    this.loadCatalog();
                }
                catch (BasicException ex) {
                    ex.printStackTrace();
                    new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "une erreur est servenu.", 1500, NPosition.CENTER);
                }
            } else {
                new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Merci de pr\u00e9ciser tous les champs.", 1500, NPosition.CENTER);
            }
        } else if (!this.m_jName.getText().isEmpty() && this.m_jRole.getSelectedItem() != null) {
            this.userCurrent.setName(this.m_jName.getText());
            this.userCurrent.setPassword(this.m_sPassword);
            this.userCurrent.setEmail(this.emailText.getText() == null ? "" : this.emailText.getText().trim());
            if (!this.userCurrent.getId().equals(this.m_App.getAppUserView().getUser().getId())) {
                RoleInfo role = (RoleInfo)this.m_jRole.getSelectedItem();
                this.userCurrent.setRole(role.getID());
            }
            if (!this.jFingerPrint.getText().isEmpty()) {
                this.userCurrent.setFingerprint(this.jFingerPrint.getText());
            }
            this.listPermission.clear();
            if (this.jCheckBoxDrawer.isSelected()) {
                this.listPermission.add(new Permission("0", this.OPEN_DRAWER));
            }
            if (this.jCheckBoxUnLock.isSelected()) {
                this.listPermission.add(new Permission("1", this.UNLOCK_CAISSE));
            }
            if (this.jCheckBoxPromotion.isSelected()) {
                this.listPermission.add(new Permission("2", this.ADD_PROMOTION));
            }
            if (this.jCheckBoxCancel.isSelected()) {
                this.listPermission.add(new Permission("3", this.CANCEL_ORDER));
            }
            if (this.jCheckBoxTransfert.isSelected()) {
                this.listPermission.add(new Permission("4", this.TRANSFERT_ORDER));
            }
            if (this.jCheckBoxEmailSender.isSelected()) {
                this.listPermission.add(new Permission("5", this.GET_EMAILS));
            }
            if (this.jCheckBoxProductDiver.isSelected()) {
                this.listPermission.add(new Permission("6", this.ADD_PRODUCT_DIVERS));
            }
            if (this.jCheckBoxLock.isSelected()) {
                this.listPermission.add(new Permission("7", this.LOCK_CAISSE));
            }
            if (this.glory_enabled) {
                if (this.jCheckBoxGloryFunctions.isSelected()) {
                    this.listPermission.add(new Permission("8", this.GLORY_FUNCTIONS));
                }
                if (this.jCheckBoxGloryFunctionsAdvanced.isSelected()) {
                    this.listPermission.add(new Permission("9", this.GLORY_FUNCTIONS_ADVANCED));
                }
            }
            if (this.jCheckBoxPaidOrder.isSelected()) {
                this.listPermission.add(new Permission("10", this.PAID_ORDER));
            }
            if (this.jCheckBoxRappelTicket.isSelected()) {
                this.listPermission.add(new Permission("11", this.RAPPEL_TICKET));
            }
            if (this.jCheckBoxAddFreeOptions.isSelected()) {
                this.listPermission.add(new Permission("12", this.ADD_FREE_OPTIONS));
            }
            if (this.jCheckBoxFondCaisse.isSelected()) {
                this.listPermission.add(new Permission("13", this.FOND_CAISSE));
            }
            if (this.jCheckBoxDeleteLinesOrder.isSelected()) {
                this.listPermission.add(new Permission("14", this.DELETE_LINES_ORDER));
            }
            if (this.jCheckBoxPrintTicketCaisse.isSelected()) {
                this.listPermission.add(new Permission("15", ""));
            }
            if (this.jCheckBoxPrintTicketKitchen.isSelected()) {
                this.listPermission.add(new Permission("16", ""));
            }
            if (this.jCheckBoxPrintJustificatifPayment.isSelected()) {
                this.listPermission.add(new Permission("17", ""));
            }
            if (this.jCheckBoxDuplicateTicket.isSelected()) {
                this.listPermission.add(new Permission("18", ""));
            }
            if (this.jCheckBoxPrintLabel.isSelected()) {
                this.listPermission.add(new Permission("19", ""));
            }
            if (this.jCheckBoxXGlobal.isSelected()) {
                this.listPermission.add(new Permission("20", this.X_GLOBAL));
            }
            if (this.jCheckBoxbackOfficeCashlogy.isSelected()) {
                this.listPermission.add(new Permission("22", this.BACKOFFICE_CASHLOGY));
            }
            if (this.stockManagement.isSelected()) {
                this.listPermission.add(new Permission("21", this.STOCK_MANAGEMENT));
            }
            try {
                this.m_dlUser.updateUser(this.userCurrent, this.listPermission, this.m_App.getAppUserView().getUser().getId());
                new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, "Utilisateur modifi\u00e9.", 1500, NPosition.CENTER);
                this.loadCatalog();
            }
            catch (BasicException ex) {
                ex.printStackTrace();
                new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "une erreur est servenu.", 1500, NPosition.CENTER);
            }
        } else {
            new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "merci de pr\ufffdciser tous les champs.", 1500, NPosition.CENTER);
        }
        if (this.userCurrent != null) {
            String keyCachePermission = SharedMemoryCache.makeKey("PERMISSIONS_USER_", (Object)this.userCurrent.getId());
            SharedMemoryCache.getInstance().remove(keyCachePermission);
            BasicStorage.remove("USER_INFO_" + this.userCurrent.getId());
        }
    }

    private void jDeleteActionPerformed(ActionEvent evt) {
        if (this.userCurrent != null) {
            if ("1".equals(this.userCurrent.getRole()) && this.numManager == 1) {
                new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Vous ne pouvez pas supprimer le dernier manager.", 1500, NPosition.CENTER);
            } else {
                int dialogButton = 0;
                int dialogResult = JOptionPane.showConfirmDialog(this.getComponent(), "Etes-vous s\u00fbr de vouloir supprimer cet utilisateur?", "Suppression", dialogButton);
                if (dialogResult == 0) {
                    try {
                        this.m_dlUser.deleteUser(this.userCurrent.getId());
                        this.loadCatalog();
                        new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, "Utilisateur supprim\u00e9.", 1500, NPosition.CENTER);
                    }
                    catch (BasicException ex) {
                        LogToFile.log("severe", null, ex);
                    }
                }
            }
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    private void jAddActionPerformed(ActionEvent evt) {
        this.newElement = true;
        this.existElement = false;
        this.userCurrent = null;
        this.m_jName.setText("");
        this.emailText.setText("");
        this.jFingerPrint.setText("");
        this.text_dallas = "";
        this.m_jRole.setSelectedItem(null);
        this.m_sPassword = null;
        this.listPermission.clear();
        this.jCheckBoxDrawer.setSelected(false);
        this.jCheckBoxUnLock.setSelected(false);
        this.jCheckBoxLock.setSelected(true);
        this.jCheckBoxPromotion.setSelected(false);
        this.jCheckBoxCancel.setSelected(false);
        this.jCheckBoxTransfert.setSelected(false);
        this.jCheckBoxEmailSender.setSelected(false);
        this.jCheckBoxProductDiver.setSelected(false);
        this.jCheckBoxPaidOrder.setSelected(false);
        this.jCheckBoxRappelTicket.setSelected(false);
        this.jCheckBoxAddFreeOptions.setSelected(false);
        this.jCheckBoxFondCaisse.setSelected(false);
        this.jCheckBoxDeleteLinesOrder.setSelected(false);
        this.jCheckBoxPrintTicketCaisse.setSelected(false);
        this.jCheckBoxPrintTicketKitchen.setSelected(false);
        this.jCheckBoxPrintJustificatifPayment.setSelected(false);
        this.jCheckBoxDuplicateTicket.setSelected(false);
        this.jCheckBoxPrintLabel.setSelected(false);
        this.jCheckBoxXGlobal.setSelected(false);
        this.jCheckBoxbackOfficeCashlogy.setSelected(false);
        this.stockManagement.setSelected(false);
        if (this.glory_enabled) {
            this.jCheckBoxGloryFunctions.setSelected(false);
            this.jCheckBoxGloryFunctionsAdvanced.setSelected(false);
        }
    }

    private void jBtnPwdActionPerformed(ActionEvent evt) {
        String sNewPassword = Hashcypher.changePassword(this);
        if (sNewPassword != null) {
            this.m_sPassword = sNewPassword;
            this.m_Dirty.setDirty(true);
        }
    }

    private void jBtnDeletePwdActionPerformed(ActionEvent evt) {
        this.m_sPassword = null;
    }

    private void jCheckBoxDrawerActionPerformed(ActionEvent evt) {
    }

    private void jCheckBoxTransfertActionPerformed(ActionEvent evt) {
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.jFingerPrint.requestFocus();
    }

    private void jCheckBoxLockActionPerformed(ActionEvent evt) {
    }

    private void jCheckBoxGloryFunctionsAdvancedStateChanged(ChangeEvent evt) {
        if (this.jCheckBoxGloryFunctionsAdvanced.isSelected()) {
            this.jCheckBoxGloryFunctions.setSelected(true);
        }
    }

    private void jCheckBoxPaidOrderActionPerformed(ActionEvent evt) {
    }

    private void jCheckBoxRappelTicketActionPerformed(ActionEvent evt) {
    }

    private void jCheckBoxAddFreeOptionsActionPerformed(ActionEvent evt) {
    }

    private void jCheckBoxFondCaisseActionPerformed(ActionEvent evt) {
    }

    private void jCheckBoxDeleteLinesOrderActionPerformed(ActionEvent evt) {
    }

    private void jCheckBoxPrintTicketCaisseActionPerformed(ActionEvent evt) {
    }

    private void jCheckBoxPrintTicketKitchenActionPerformed(ActionEvent evt) {
    }

    private void jCheckBoxDuplicateTicketActionPerformed(ActionEvent evt) {
    }

    private void jCheckBoxPrintLabelActionPerformed(ActionEvent evt) {
    }

    private void jCheckBoxPrintJustificatifPaymentActionPerformed(ActionEvent evt) {
    }

    private void jCheckBoxXGlobalActionPerformed(ActionEvent evt) {
    }

    private void jCheckBoxbackOfficeCashlogyActionPerformed(ActionEvent evt) {
    }

    private void stockManagementActionPerformed(ActionEvent evt) {
    }

    private void getFingerPrint() {
        if (this.jFingerPrint.getText().endsWith("\u00e0&\u00e0\u00e0\u00e0\u00e0\u00e0\u00e0\u00e0\u00e0")) {
            this.jFingerPrint.setText(this.text_dallas);
        } else {
            this.text_dallas = this.jFingerPrint.getText();
            this.panelBody.requestFocus();
        }
    }

    private class SmallCategoryRenderer
    extends DefaultListCellRenderer {
        private SmallCategoryRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, (Object)null, index, isSelected, cellHasFocus);
            User user = (User)value;
            this.setText(user.getName());
            return this;
        }
    }

    private class CategoriesListModel
    extends AbstractListModel {
        private final List m_aCategories;

        public CategoriesListModel(List aCategories) {
            this.m_aCategories = aCategories;
        }

        @Override
        public int getSize() {
            return this.m_aCategories.size();
        }

        @Override
        public Object getElementAt(int i) {
            return this.m_aCategories.get(i);
        }
    }
}

