/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.admin;

import com.openbravo.basic.BasicException;
import com.openbravo.data.loader.SerializerRead;
import com.openbravo.pos.admin.Permission;
import com.openbravo.pos.util.Hashcypher;
import com.procaisse.db.metadata.DataRead;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class User {
    private String id;
    private String name;
    private String email;
    private String password;
    private String role;
    private boolean disabled;
    private String fingerprint;
    private String ref_synchro;
    private boolean removed;
    private Date removedAt;
    private List<Permission> permissions;

    public User() {
        this.permissions = new ArrayList<Permission>();
    }

    public User(String id, String name, String password, String role, boolean disabled, boolean removed, String fingerprint, String email, String ref_synchro) {
        this.id = id;
        this.name = name;
        this.email = email;
        this.password = password;
        this.role = role;
        this.disabled = disabled;
        this.removed = removed;
        this.fingerprint = fingerprint;
        this.ref_synchro = ref_synchro;
        this.permissions = new ArrayList<Permission>();
    }

    public User(String id, String name, String password, String role, String email) {
        this.id = id;
        this.name = name;
        this.password = password;
        this.role = role;
        this.email = email;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public String getFingerprint() {
        return this.fingerprint;
    }

    public void setFingerprint(String fingerprint) {
        this.fingerprint = fingerprint;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String toString() {
        return this.name + "id : " + this.id + ", removed : " + this.removed;
    }

    public boolean authenticate() {
        return this.password == null || this.password.equals("") || this.password.startsWith("empty:");
    }

    public boolean authenticate(String sPwd) {
        return Hashcypher.authenticate(sPwd, this.password);
    }

    public static SerializerRead getSerializerRead() {
        return new SerializerRead(){

            @Override
            public Object readValues(DataRead dr) throws BasicException {
                User user = new User();
                user.id = dr.getString(1);
                user.name = dr.getString(2);
                user.password = dr.getString(3);
                user.role = dr.getString(4);
                user.removed = dr.getBoolean(5);
                user.disabled = dr.getBoolean(6);
                user.removedAt = dr.getTimestamp(7);
                user.fingerprint = dr.getString(8);
                user.email = dr.getString(9);
                user.ref_synchro = dr.getString(10);
                return user;
            }
        };
    }

    public String getRef_synchro() {
        return this.ref_synchro;
    }

    public void setRef_synchro(String ref_synchro) {
        this.ref_synchro = ref_synchro;
    }

    public List<Permission> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(List<Permission> permissions) {
        this.permissions = permissions;
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public void setRemoved(boolean removed) {
        this.removed = removed;
    }

    public Date getRemovedAt() {
        return this.removedAt;
    }

    public void setRemovedAt(Date removedAt) {
        this.removedAt = removedAt;
    }
}

