/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.pos.admin;

import com.openbravo.basic.BasicException;
import com.openbravo.data.loader.SerializerRead;
import com.openbravo.data.loader.SerializerReadClass;
import com.openbravo.data.loader.SerializerWriteParams;
import com.openbravo.data.loader.SerializerWriteString;
import com.openbravo.format.Formats;
import com.openbravo.pos.admin.PeopleInfo;
import com.openbravo.pos.admin.Permission;
import com.openbravo.pos.admin.RoleInfo;
import com.openbravo.pos.admin.User;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.BeanFactoryDataSingle;
import com.openbravo.pos.util.Event;
import com.openbravo.pos.util.Journal;
import com.openbravo.pos.util.LogToFile;
import com.procaisse.db.connection.Session;
import com.procaisse.db.metadata.DataParams;
import com.procaisse.db.metadata.Datas;
import com.procaisse.db.metadata.TableDefinition;
import com.procaisse.db.sql.PreparedSentence;
import com.procaisse.db.sql.SentenceList;
import com.procaisse.db.sql.StaticSentence;
import fr.protactile.procaisse.cache.SharedMemoryCache;
import java.util.Date;
import java.util.List;

public class DataLogicAdmin
extends BeanFactoryDataSingle {
    private Session s;
    private TableDefinition m_tpeople;
    private TableDefinition m_troles;
    private TableDefinition m_tresources;
    private SharedMemoryCache mSharedMemoryCache = SharedMemoryCache.getInstance();
    private String requestUser;

    @Override
    public void init(Session s) {
        this.s = s;
        this.m_tpeople = new TableDefinition(s, "PEOPLE", new String[]{"ID", "NAME", "APPPASSWORD", "ROLE", "VISIBLE", "CARD", "IMAGE"}, new String[]{"ID", AppLocal.getIntString("label.peoplename"), AppLocal.getIntString("Label.Password"), AppLocal.getIntString("label.role"), AppLocal.getIntString("label.peoplevisible"), AppLocal.getIntString("label.card"), AppLocal.getIntString("label.peopleimage")}, new Datas[]{Datas.STRING, Datas.STRING, Datas.STRING, Datas.STRING, Datas.BOOLEAN, Datas.STRING, Datas.IMAGE}, new Formats[]{Formats.STRING, Formats.STRING, Formats.STRING, Formats.STRING, Formats.BOOLEAN, Formats.STRING, Formats.NULL}, new int[]{0});
        this.m_troles = new TableDefinition(s, "ROLES", new String[]{"ID", "NAME", "PERMISSIONS"}, new String[]{"ID", AppLocal.getIntString("Label.Name"), "PERMISSIONS"}, new Datas[]{Datas.STRING, Datas.STRING, Datas.BYTES}, new Formats[]{Formats.STRING, Formats.STRING, Formats.NULL}, new int[]{0});
        this.m_tresources = new TableDefinition(s, "RESOURCES", new String[]{"ID", "NAME", "RESTYPE", "CONTENT"}, new String[]{"ID", AppLocal.getIntString("Label.Name"), AppLocal.getIntString("label.type"), "CONTENT"}, new Datas[]{Datas.STRING, Datas.STRING, Datas.INT, Datas.BYTES}, new Formats[]{Formats.STRING, Formats.STRING, Formats.INT, Formats.NULL}, new int[]{0});
        this.requestUser = "SELECT ID, NAME, APPPASSWORD, ROLE,removed, disabled,removedAt, fingerprint, EMAIL, REF_SYNCHRO FROM PEOPLE ";
    }

    public final SentenceList getRolesList() {
        return new StaticSentence(this.s, "SELECT ID, NAME FROM ROLES ORDER BY NAME", null, (SerializerRead)new SerializerReadClass(RoleInfo.class));
    }

    public final TableDefinition getTablePeople() {
        return this.m_tpeople;
    }

    public final TableDefinition getTableRoles() {
        return this.m_troles;
    }

    public final TableDefinition getTableResources() {
        return this.m_tresources;
    }

    public final SentenceList getPeopleList() {
        return new StaticSentence(this.s, "SELECT ID, NAME FROM PEOPLE ORDER BY NAME", null, (SerializerRead)new SerializerReadClass(PeopleInfo.class));
    }

    public List<User> getUsers() throws BasicException {
        return new PreparedSentence(this.s, this.requestUser + "WHERE hidden = 0 AND removed = 0 AND ROLE <> '0' ORDER BY NAME ", null, User.getSerializerRead()).list();
    }

    public List<User> getAllUsers() throws BasicException {
        return new PreparedSentence(this.s, this.requestUser + "WHERE hidden = 0 AND removed = 0 ORDER BY NAME ", null, User.getSerializerRead()).list();
    }

    public List<User> getUsersExcept(String id) throws BasicException {
        return new PreparedSentence(this.s, this.requestUser + "WHERE ID <> ? ORDER BY NAME ", SerializerWriteString.INSTANCE, User.getSerializerRead()).list((Object)id);
    }

    public User getUserByid(String id) throws BasicException {
        return (User)new PreparedSentence(this.s, this.requestUser + "WHERE id = ? ", SerializerWriteString.INSTANCE, User.getSerializerRead()).find((Object)id);
    }

    public RoleInfo getRoleById(String id) throws BasicException {
        return (RoleInfo)new PreparedSentence(this.s, "SELECT ID, NAME from ROLES WHERE id = ? ", SerializerWriteString.INSTANCE, RoleInfo.getSerializerRead()).find((Object)id);
    }

    void updateUser(final User user, List<Permission> listPermission, String idOperator) throws BasicException {
        User oldUser = this.getUserByid(user.getId());
        new PreparedSentence(this.s, "UPDATE  PEOPLE SET NAME = ?, APPPASSWORD = ?, ROLE = ?, fingerprint = ?, EMAIL = ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, user.getName());
                this.setString(2, user.getPassword());
                this.setString(3, user.getRole());
                this.setString(4, user.getFingerprint());
                this.setString(5, user.getEmail());
                this.setString(6, user.getId());
            }
        });
        this.persistPermission(user, listPermission);
        try {
            Journal.writeToJET(new Event(130, "Habilitation d'utilisateur", idOperator, "Modifications sur Utilisateur :(" + this.getRoleById(oldUser.getRole()).getName() + " => " + this.getRoleById(user.getRole()).getName(), new Date().getTime(), "activation : " + listPermission.toString().replace(",", "-").replace("\n", " __ ") + ")"));
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void deleteUser(final String id) throws BasicException {
        User user = this.getUserByid(id);
        List<Permission> oldPermission = this.getPermissionByUser(user.getId());
        if (user != null) {
            new StaticSentence(this.s, "UPDATE PEOPLE SET removed = 1, removedAt = ? WHERE ID = ?", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setTimestamp(1, new Date());
                    this.setString(2, id);
                }
            });
            try {
                Journal.writeToJET(new Event(130, "Habilitation d'utilisateur", id, "Suppression d'Utilisateur (" + this.getRoleById(user.getRole()).getName() + ")", new Date().getTime(), " d\u00e9sactivation :" + oldPermission.toString().replace(",", "-").replace("\n", "__")));
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
    }

    public List<RoleInfo> getRoles() throws BasicException {
        return new PreparedSentence(this.s, "SELECT ID, NAME FROM ROLES WHERE ID <> '0' ORDER BY NAME", null, new SerializerReadClass(RoleInfo.class)).list();
    }

    public List<RoleInfo> getAllRoles() throws BasicException {
        return new PreparedSentence(this.s, "SELECT ID, NAME FROM ROLES ORDER BY NAME", null, new SerializerReadClass(RoleInfo.class)).list();
    }

    public List<Permission> getPermission() throws BasicException {
        return new PreparedSentence(this.s, "SELECT ID, NAME FROM PERMISSIONS ORDER BY NAME", null, Permission.getSerializerRead()).list();
    }

    public List<Permission> getPermissionByUser(String id) throws BasicException {
        return new PreparedSentence(this.s, "SELECT P.ID, P.NAME FROM PERMISSIONS P JOIN USER_PERMISSION PU ON P.ID = PU.idPermission WHERE PU.idUser = ? ORDER BY P.NAME", SerializerWriteString.INSTANCE, Permission.getSerializerRead()).list((Object)id);
    }

    public boolean hasPermission(String idUser, String idPermission) throws BasicException {
        String keyCachePermission = SharedMemoryCache.makeKey("PERMISSIONS_USER_", (Object)idUser);
        List permissions = null;
        if (this.mSharedMemoryCache.containsKey(keyCachePermission)) {
            permissions = (List)this.mSharedMemoryCache.get(keyCachePermission);
        } else {
            permissions = this.getPermissionByUser(idUser);
            this.mSharedMemoryCache.put(keyCachePermission, permissions);
        }
        if (permissions == null || permissions != null && permissions.isEmpty()) {
            return false;
        }
        int found = -1;
        for (Permission permission : permissions) {
            if (!permission.getId().equals(idPermission)) continue;
            found = 1;
        }
        return found != -1;
    }

    public List<User> getUsersHavingPermission(String idPermission) throws BasicException {
        return new PreparedSentence(this.s, "SELECT p.ID, p.NAME, p.APPPASSWORD, p.ROLE, p.removed, p.disabled, p.removedAt, p.fingerprint, p.EMAIL, p.REF_SYNCHRO from USER_PERMISSION up , PEOPLE p where up.IDUSER=p.ID AND up.IDPERMISSION='" + idPermission + "' AND hidden = 0 AND removed = 0 ORDER BY NAME ", null, User.getSerializerRead()).list();
    }

    public List<User> getSynchroUsers() throws BasicException {
        List users = new PreparedSentence(this.s, this.requestUser + "ORDER BY NAME ", null, User.getSerializerRead()).list();
        for (User user : users) {
            user.setPermissions(this.getPermissionByUser(user.getId()));
        }
        return users;
    }

    public void addUser(final User user) throws BasicException {
        new PreparedSentence(this.s, "INSERT INTO PEOPLE (ID, NAME, APPPASSWORD, ROLE, fingerprint, EMAIL) VALUES (?, ?, ?, ?, ?, ?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, user.getId());
                this.setString(2, user.getName());
                this.setString(3, user.getPassword());
                this.setString(4, user.getRole());
                this.setString(5, user.getFingerprint());
                this.setString(6, user.getEmail());
            }
        });
        new PreparedSentence(this.s, "INSERT INTO COUNTER_USER (ID_USER) VALUES (?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, user.getId());
            }
        });
    }

    public void addPermissionUser(final Permission permission, final User user) throws BasicException {
        new PreparedSentence(this.s, "INSERT INTO USER_PERMISSION (idUser, idPermission) VALUES (?, ?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, user.getId());
                this.setString(2, permission.getId());
            }
        });
    }

    public void addUser(User user, List<Permission> listPermission, String id) throws BasicException {
        this.addUser(user);
        for (Permission permission : listPermission) {
            this.addPermissionUser(permission, user);
        }
        try {
            Journal.writeToJET(new Event(130, "Habilitation d'utilisateur", id, "Nouveau Utilisateur (" + this.getRoleById(user.getRole()).getName() + ")", new Date().getTime(), "activation : " + listPermission.toString().replace(",", "-").replace("\n", " __ ")));
        }
        catch (Exception ex) {
            LogToFile.log("sever", ex.getMessage(), ex);
        }
    }

    public void persistPermission(final User user, List<Permission> listPermission) throws BasicException {
        int found;
        List<Permission> oldPermission = this.getPermissionByUser(user.getId());
        for (final Permission permissionOld : oldPermission) {
            found = -1;
            for (Permission permissionNew : listPermission) {
                if (!permissionOld.getId().equals(permissionNew.getId())) continue;
                found = 1;
            }
            if (found != -1) continue;
            new PreparedSentence(this.s, "DELETE FROM USER_PERMISSION WHERE idUser = ? AND idPermission = ? ", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setString(1, user.getId());
                    this.setString(2, permissionOld.getId());
                }
            });
        }
        for (final Permission permissionNew : listPermission) {
            found = -1;
            for (Permission permissionOld : oldPermission) {
                if (!permissionOld.getId().equals(permissionNew.getId())) continue;
                found = 1;
            }
            if (found != -1) continue;
            System.out.println("user.getId() : " + user.getId());
            System.out.println("permissionNew.getId() : " + permissionNew.getId());
            new PreparedSentence(this.s, "INSERT INTO USER_PERMISSION (idUser, idPermission) VALUES (?, ?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

                @Override
                public void writeValues() throws BasicException {
                    this.setString(1, user.getId());
                    this.setString(2, permissionNew.getId());
                }
            });
        }
    }

    public void addPermission(final String idUser, final String idPermission) throws BasicException {
        System.out.println("idPermission " + idPermission);
        new PreparedSentence(this.s, "INSERT INTO USER_PERMISSION (idUser, idPermission) VALUES (?, ?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, idUser);
                this.setString(2, idPermission);
            }
        });
    }
}

