/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.models;

import com.openbravo.format.Formats;
import com.openbravo.pos.ticket.TicketLineInfo;
import com.openbravo.pos.util.AppVarUtils;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;

public class HBoxLine
extends HBox {
    TicketLineInfo line;
    Label label = new Label();
    Label labelUnit = new Label();
    Label labelPrice = new Label();
    Button btnImage = new Button();
    private GridPane pane = new GridPane();

    public HBoxLine(TicketLineInfo line) {
        this.line = line;
        this.pane.setPrefWidth(AppVarUtils.getScreenDimension().getWidth() * 0.27);
        String name_product = line.printPanier();
        this.label.setWrapText(true);
        this.label.getStyleClass().add((Object)"align-left");
        this.label.setText(name_product);
        this.labelPrice.setText(line.printValueProduct());
        this.label.setPrefWidth(this.pane.getPrefWidth() * 0.5);
        this.labelPrice.setPrefWidth(this.pane.getPrefWidth() * 0.2);
        this.labelUnit.setPrefWidth(this.pane.getPrefWidth() * 0.1);
        this.btnImage.setPrefWidth(this.pane.getPrefWidth() * 0.1);
        this.labelUnit.setText(Formats.INT.formatValue(line.getUnits_paid()) + "/" + Formats.INT.formatValue(line.getMultiply()));
        HBox.setHgrow((Node)this.label, (Priority)Priority.ALWAYS);
        this.btnImage.setText("$");
        this.btnImage.getStyleClass().add((Object)"btn_paid_list");
        this.pane.add((Node)this.label, 0, 0);
        this.pane.add((Node)this.labelPrice, 1, 0);
        if (line.getUnits_paid() != 0.0) {
            this.pane.add((Node)this.btnImage, 2, 0);
            this.pane.add((Node)this.labelUnit, 3, 0);
        }
        this.getChildren().addAll((Object[])new Node[]{this.pane});
    }

    public HBoxLine(String name) {
        this.pane.setPrefWidth(AppVarUtils.getScreenDimension().getWidth() * 0.27);
        this.label.setText(name);
        this.label.setPrefWidth(this.pane.getPrefWidth() * 0.5);
        this.pane.add((Node)this.label, 0, 0);
        this.getChildren().addAll((Object[])new Node[]{this.pane});
    }

    public HBoxLine(String name, String price) {
        this.pane.setPrefWidth(AppVarUtils.getScreenDimension().getWidth() * 0.27);
        this.label.setText(name);
        this.labelPrice.setText(price);
        this.label.setPrefWidth(this.pane.getPrefWidth() * 0.5);
        this.labelPrice.setPrefWidth(this.pane.getPrefWidth() * 0.2);
        this.pane.add((Node)this.label, 0, 0);
        this.pane.add((Node)this.labelPrice, 1, 0);
        this.getChildren().addAll((Object[])new Node[]{this.pane});
    }
}

