/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.models;

import com.openbravo.format.Formats;
import com.openbravo.pos.ticket.OptionItemOrder;
import com.openbravo.pos.ticket.TicketLineInfo;
import com.openbravo.pos.util.AppVarUtils;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Color;

public class HBoxItemsLater
extends HBox {
    TicketLineInfo line;
    Label label = new Label();
    private Label label_image = new Label();
    private GridPane pane = new GridPane();
    private GridPane pane_right = new GridPane();
    private double maxWidth;
    private double width_right;
    private double width_image;
    private Image imagePromo;
    private Button buttonLater;
    private Button buttonNow;
    private OptionItemOrder optionItemOrder;
    private EventHandler mEventHandlerClickLater = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            if (HBoxItemsLater.this.line != null) {
                HBoxItemsLater.this.line.setTime_served("later");
            }
            if (HBoxItemsLater.this.optionItemOrder != null) {
                HBoxItemsLater.this.optionItemOrder.setTime_served("later");
            }
            HBoxItemsLater.this.selectLater();
        }
    };
    private EventHandler mEventHandlerClickNow = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            if (HBoxItemsLater.this.line != null) {
                HBoxItemsLater.this.line.setTime_served("now");
            }
            if (HBoxItemsLater.this.optionItemOrder != null) {
                HBoxItemsLater.this.optionItemOrder.setTime_served("now");
            }
            HBoxItemsLater.this.selectNow();
        }
    };

    public HBoxItemsLater(TicketLineInfo line) {
        this.maxWidth = AppVarUtils.getScreenDimension().getWidth() * 0.8 - 120.0;
        this.line = line;
        this.init(line.printPanier(), line.getImage_product(), "text-size-14");
    }

    public HBoxItemsLater(OptionItemOrder optionItemOrder) {
        this.maxWidth = AppVarUtils.getScreenDimension().getWidth() * 0.8 - 120.0;
        this.optionItemOrder = optionItemOrder;
        this.init(optionItemOrder.getDisplayedName(), optionItemOrder.getImage_item(), "text-size-14");
    }

    public String printPrice(double price) {
        if (price != 0.0) {
            return Formats.CURRENCY.formatValue(price);
        }
        return "";
    }

    public String printQuantity(double multiply) {
        if (multiply == (double)Math.round(multiply)) {
            return Formats.INT.formatValue(multiply);
        }
        return Formats.DOUBLE.formatValue(multiply);
    }

    public void init(String nameItem, Image imageItem, String class_size) {
        this.pane.setPadding(new Insets(0.0, 0.0, 0.0, 60.0));
        this.width_right = this.maxWidth * 0.6;
        this.width_image = this.maxWidth * 0.35;
        this.pane.setPrefWidth(this.maxWidth);
        this.pane_right.setPrefWidth(this.width_right);
        this.pane_right.setPrefHeight(150.0);
        this.pane_right.setVgap(5.0);
        this.pane_right.setHgap(5.0);
        this.label_image.setPrefWidth(this.width_image);
        this.label_image.setAlignment(Pos.CENTER);
        this.pane_right.setAlignment(Pos.CENTER);
        this.label.setWrapText(true);
        this.label.getStyleClass().add((Object)"align-left");
        this.label.getStyleClass().add((Object)class_size);
        this.label.setText(nameItem.toUpperCase());
        this.label.setPrefWidth(this.pane_right.getPrefWidth());
        this.label.setPrefHeight(this.pane_right.getPrefHeight() * 0.4);
        this.buttonLater = new Button();
        this.buttonLater.setText("\u23f3 Apr\u00e8s le repas");
        this.buttonLater.setPrefWidth(this.pane_right.getPrefWidth() * 0.4);
        this.buttonLater.setPrefHeight(this.pane_right.getPrefHeight() * 0.4);
        this.buttonLater.setStyle("-fx-font-size: 14px; -fx-text-fill: black; -fx-border-color: black; -fx-border-radius: 8px; -fx-background-radius: 8px; -fx-background-color: transparent");
        this.buttonLater.setOnAction(this.mEventHandlerClickLater);
        this.buttonNow = new Button();
        this.buttonNow.setText("Maintenant");
        this.buttonNow.setStyle("-fx-font-size: 14px; -fx-text-fill: black; -fx-border-color: black; -fx-border-radius: 8px; -fx-background-radius: 8px; -fx-background-color: #0CA85845;");
        this.buttonNow.setPrefWidth(this.pane_right.getPrefWidth() * 0.4);
        this.buttonNow.setPrefHeight(this.pane_right.getPrefHeight() * 0.4);
        this.buttonNow.setOnAction(this.mEventHandlerClickNow);
        this.pane_right.add((Node)this.label, 0, 0, 2, 1);
        this.pane_right.add((Node)this.buttonLater, 0, 1, 1, 1);
        this.pane_right.add((Node)this.buttonNow, 1, 1, 1, 1);
        if (imageItem != null) {
            ImageView imageViewProduct = new ImageView();
            imageViewProduct.setImage(imageItem);
            imageViewProduct.setFitWidth(this.width_image * 0.8);
            imageViewProduct.setPreserveRatio(true);
            imageViewProduct.setSmooth(true);
            imageViewProduct.setCache(true);
            this.label_image.setGraphic((Node)imageViewProduct);
        }
        this.pane.add((Node)this.label_image, 0, 0);
        this.pane.add((Node)this.pane_right, 1, 0);
        DropShadow dropShadow = new DropShadow();
        dropShadow.setOffsetX(0.0);
        dropShadow.setOffsetY(4.0);
        dropShadow.setRadius(4.0);
        dropShadow.setColor(Color.rgb((int)0, (int)0, (int)0, (double)0.25));
        this.pane.setEffect((Effect)dropShadow);
        this.pane.setStyle("-fx-background-radius: 20px; -fx-background-color: white;");
        this.getChildren().addAll((Object[])new Node[]{this.pane});
    }

    public Button getButtonLater() {
        return this.buttonLater;
    }

    public void setButtonLater(Button buttonLater) {
        this.buttonLater = buttonLater;
    }

    public Button getButtonNow() {
        return this.buttonNow;
    }

    public void setButtonNow(Button buttonNow) {
        this.buttonNow = buttonNow;
    }

    public TicketLineInfo getLine() {
        return this.line;
    }

    public void setLine(TicketLineInfo line) {
        this.line = line;
    }

    public OptionItemOrder getOptionItemOrder() {
        return this.optionItemOrder;
    }

    public void setOptionItemOrder(OptionItemOrder optionItemOrder) {
        this.optionItemOrder = optionItemOrder;
    }

    public void selectNow() {
        this.buttonLater.setStyle("-fx-font-size: 14px; -fx-text-fill: black; -fx-border-color: black; -fx-border-radius: 8px; -fx-background-radius: 8px; -fx-background-color: transparent");
        this.buttonNow.setStyle("-fx-font-size: 14px; -fx-text-fill: black; -fx-border-color: black; -fx-border-radius: 8px; -fx-background-radius: 8px; -fx-background-color: #0CA85845;");
    }

    public void selectLater() {
        this.buttonNow.setStyle("-fx-font-size: 14px; -fx-text-fill: black; -fx-border-color: black; -fx-border-radius: 8px; -fx-background-radius: 8px; -fx-background-color: transparent");
        this.buttonLater.setStyle("-fx-font-size: 14px; -fx-text-fill: black; -fx-border-color: black; -fx-border-radius: 8px; -fx-background-radius: 8px; -fx-background-color: #0CA85845;");
    }
}

