/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.models;

import com.openbravo.format.Formats;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.ticket.ItemOrderInfo;
import com.openbravo.pos.ticket.OptionItemOrder;
import com.openbravo.pos.ticket.ProductTicket;
import com.openbravo.pos.ticket.TicketLineInfo;
import com.openbravo.pos.util.AppVarUtils;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;

public class HBoxBorne
extends HBox {
    TicketLineInfo line;
    Label label = new Label();
    private Label label_image = new Label();
    Label labelUnit = new Label();
    Label labelPrice = new Label();
    Button btnImage = new Button();
    private GridPane pane = new GridPane();
    private GridPane pane_right = new GridPane();
    private HBox hboxProduit = new HBox();
    private double maxWidth;
    private double width_right;
    private double width_image;
    private Image imagePromo;

    public HBoxBorne(TicketLineInfo line, Image imagePromo) {
        this.maxWidth = AppVarUtils.getScreenDimension().getWidth() * 0.6 - 60.0;
        this.imagePromo = imagePromo;
        this.init(line, "text-size-14");
    }

    public HBoxBorne(TicketLineInfo line, String class_size, double width) {
        this.maxWidth = width * 0.6 - 60.0;
        this.init(line, class_size);
    }

    public HBoxBorne(String text_discount, String discount) {
        this.maxWidth = AppVarUtils.getScreenDimension().getWidth() * 0.6 - 60.0;
        this.width_right = this.maxWidth * 0.65;
        HBox hboxDiscount = new HBox();
        hboxDiscount.setPrefWidth(this.width_right);
        this.pane.setPrefWidth(this.maxWidth);
        Label labelDiscount = new Label();
        labelDiscount.setPrefWidth(this.width_right * 0.7);
        labelDiscount.getStyleClass().add((Object)"text-size-14");
        labelDiscount.setText(text_discount);
        Label labelPriceDiscount = new Label("-" + discount);
        labelPriceDiscount.setPrefWidth(this.width_right * 0.3);
        labelPriceDiscount.getStyleClass().add((Object)"text-size-14");
        labelPriceDiscount.setAlignment(Pos.CENTER);
        hboxDiscount.getChildren().addAll((Object[])new Node[]{labelDiscount, labelPriceDiscount});
        this.pane.setAlignment(Pos.CENTER_RIGHT);
        this.pane.add((Node)hboxDiscount, 0, 0);
        this.getChildren().addAll((Object[])new Node[]{this.pane});
    }

    public String printPrice(double price) {
        if (price != 0.0) {
            return Formats.CURRENCY.formatValue(price);
        }
        return "";
    }

    public String printQuantity(double multiply) {
        if (multiply == (double)Math.round(multiply)) {
            return Formats.INT.formatValue(multiply);
        }
        return Formats.DOUBLE.formatValue(multiply);
    }

    public void init(TicketLineInfo line, String class_size) {
        this.line = line;
        this.width_right = this.maxWidth * 0.65;
        this.width_image = this.maxWidth * 0.35;
        this.pane.setPrefWidth(this.maxWidth);
        this.pane_right.setPrefWidth(this.width_right);
        this.label_image.setPrefWidth(this.width_image);
        this.label_image.setAlignment(Pos.CENTER);
        this.pane_right.setAlignment(Pos.CENTER);
        String name_product = line.printPanier();
        this.label.setWrapText(true);
        this.label.getStyleClass().add((Object)"align-left");
        this.label.getStyleClass().add((Object)class_size);
        this.label.setText(name_product.toUpperCase());
        this.labelPrice.setText(line.printValueProduct());
        this.labelPrice.getStyleClass().add((Object)class_size);
        this.labelPrice.setAlignment(Pos.CENTER);
        this.label.setPrefWidth(this.width_right * 0.7);
        this.labelPrice.setPrefWidth(this.width_right * 0.3);
        this.hboxProduit.getChildren().addAll((Object[])new Node[]{this.label, this.labelPrice});
        this.pane_right.add((Node)this.hboxProduit, 0, 0);
        int i = 1;
        for (OptionItemOrder supplement : line.getListSupplements()) {
            System.out.println("++++++++++++ supplement.getIdProduct() : " + supplement.getIdProduct());
            if (supplement.getIdProduct() != -1) continue;
            HBox hboxOption = new HBox();
            Label labelOption = new Label();
            labelOption.setPrefWidth(this.width_right * 0.7);
            labelOption.getStyleClass().add((Object)class_size);
            Label labelPriceOption = new Label(this.printPrice(line.getMultiply() * supplement.getPrice()));
            if (supplement.getNumberOption() > 1) {
                labelOption.setText("+" + this.printQuantity(line.getMultiply() * (double)supplement.getNumberOption()) + " " + supplement.getDisplayedName().toUpperCase());
            } else if (line.getMultiply() > 1.0) {
                labelOption.setText("+" + this.printQuantity(line.getMultiply()) + " " + supplement.getDisplayedName().toUpperCase());
            } else {
                labelOption.setText("+" + supplement.getDisplayedName().toUpperCase());
            }
            labelPriceOption.setPrefWidth(this.width_right * 0.3);
            labelPriceOption.getStyleClass().add((Object)class_size);
            labelPriceOption.setAlignment(Pos.CENTER);
            hboxOption.getChildren().addAll((Object[])new Node[]{labelOption, labelPriceOption});
            this.pane_right.add((Node)hboxOption, 0, i);
            ++i;
        }
        for (ItemOrderInfo ingredient : line.getListIngredients()) {
            if (ingredient.getIdProduct() != -1) continue;
            HBox hboxIngredient = new HBox();
            Label labelIngredient = new Label(" " + AppLocal.getIntString("Label.without") + " " + ingredient.getDisplayedName().toUpperCase());
            labelIngredient.setPrefWidth(this.width_right);
            labelIngredient.getStyleClass().add((Object)class_size);
            hboxIngredient.getChildren().addAll((Object[])new Node[]{labelIngredient});
            this.pane_right.add((Node)hboxIngredient, 0, i);
            ++i;
        }
        for (ProductTicket item : line.getListProducts()) {
            HBox hboxItem = new HBox();
            Label labelItem = new Label();
            labelItem.setPrefWidth(this.width_right * 0.7);
            labelItem.getStyleClass().add((Object)class_size);
            Label labelPriceItem = new Label();
            labelPriceItem.setPrefWidth(this.width_right * 0.3);
            labelPriceItem.getStyleClass().add((Object)class_size);
            labelPriceItem.setAlignment(Pos.CENTER);
            double quantity = line.getMultiply() * (double)item.getNumberProduct();
            if (quantity > 1.0) {
                labelItem.setText(" " + this.printQuantity(quantity) + " " + item.getDisplayedName().toUpperCase());
                labelPriceItem.setText(item.printPrice());
            } else {
                labelItem.setText(" " + item.getDisplayedName().toUpperCase());
                labelPriceItem.setText(item.printPrice());
            }
            hboxItem.getChildren().addAll((Object[])new Node[]{labelItem, labelPriceItem});
            this.pane_right.add((Node)hboxItem, 0, i);
            ++i;
            for (OptionItemOrder supplement : line.getListSupplements()) {
                if (supplement.getIdProduct() != item.getIdProduct() || supplement.getIdCarte() != item.getIdCarte() || supplement.getIndex_carte() != item.getIndex_carte()) continue;
                HBox hboxOption = new HBox();
                Label labelOption = new Label();
                labelOption.setPrefWidth(this.width_right * 0.7);
                labelOption.getStyleClass().add((Object)class_size);
                Label labelPriceOption = new Label(this.printPrice(line.getMultiply() * supplement.getPrice()));
                if (supplement.getNumberOption() > 1) {
                    labelOption.setText("+" + this.printQuantity(line.getMultiply() * (double)supplement.getNumberOption()) + " " + supplement.getDisplayedName().toUpperCase());
                } else if (line.getMultiply() > 1.0) {
                    labelOption.setText("+" + this.printQuantity(line.getMultiply()) + " " + supplement.getDisplayedName().toUpperCase());
                } else {
                    labelOption.setText("+" + supplement.getDisplayedName().toUpperCase());
                }
                labelPriceOption.setPrefWidth(this.width_right * 0.3);
                labelPriceOption.getStyleClass().add((Object)class_size);
                labelPriceOption.setAlignment(Pos.CENTER);
                hboxOption.getChildren().addAll((Object[])new Node[]{labelOption, labelPriceOption});
                this.pane_right.add((Node)hboxOption, 0, i);
                ++i;
            }
            for (ItemOrderInfo ingredient : line.getListIngredients()) {
                if (ingredient.getIdProduct() != item.getIdProduct() || ingredient.getIdCarte() != item.getIdCarte() || ingredient.getIndex_carte() != item.getIndex_carte()) continue;
                HBox hboxIngredient = new HBox();
                Label labelIngredient = new Label(" " + AppLocal.getIntString("Label.without") + " " + ingredient.getDisplayedName().toUpperCase());
                labelIngredient.setPrefWidth(this.width_right);
                labelIngredient.getStyleClass().add((Object)class_size);
                hboxIngredient.getChildren().addAll((Object[])new Node[]{labelIngredient});
                this.pane_right.add((Node)hboxIngredient, 0, i);
                ++i;
            }
        }
        if (line.getValueDiscount() > 0.0) {
            HBox hboxDiscount = new HBox();
            Label labelDiscount = new Label();
            labelDiscount.setPrefWidth(this.width_right * 0.7);
            labelDiscount.getStyleClass().add((Object)class_size);
            if (line.isPromo_basket()) {
                labelDiscount.setText("Promotion");
            } else {
                labelDiscount.setText(line.printLabelDiscount());
            }
            Label labelPriceDiscount = new Label("-" + Formats.CURRENCY.formatValue(line.getDiscount()));
            labelPriceDiscount.setPrefWidth(this.width_right * 0.3);
            labelPriceDiscount.getStyleClass().add((Object)class_size);
            labelPriceDiscount.setAlignment(Pos.CENTER);
            hboxDiscount.getChildren().addAll((Object[])new Node[]{labelDiscount, labelPriceDiscount});
            this.pane_right.add((Node)hboxDiscount, 0, i);
        }
        System.out.println("+++++++++++++++++ line image " + line.getImage_product());
        if (line.getImage_product() != null) {
            ImageView imageViewProduct = new ImageView();
            imageViewProduct.setImage(line.getImage_product());
            imageViewProduct.setFitWidth(this.width_image * 0.8);
            imageViewProduct.setPreserveRatio(true);
            imageViewProduct.setSmooth(true);
            imageViewProduct.setCache(true);
            this.label_image.setGraphic((Node)imageViewProduct);
        }
        if (line.getDiscount() == line.getPriceProduct() && line.isPromo_product()) {
            StackPane stack_pane = new StackPane();
            stack_pane.setPrefWidth(this.width_image);
            stack_pane.setAlignment(Pos.BOTTOM_CENTER);
            ImageView imageViewPromo = new ImageView();
            imageViewPromo.setImage(this.imagePromo);
            imageViewPromo.setFitWidth(this.width_image * 0.8);
            imageViewPromo.setPreserveRatio(true);
            imageViewPromo.setSmooth(true);
            imageViewPromo.setCache(true);
            stack_pane.getChildren().add((Object)this.label_image);
            stack_pane.getChildren().add((Object)imageViewPromo);
            Label labelPromo = new Label("OFFRE");
            labelPromo.setPrefWidth(imageViewPromo.getBoundsInLocal().getWidth());
            labelPromo.setPrefHeight(imageViewPromo.getBoundsInLocal().getHeight());
            labelPromo.setAlignment(Pos.CENTER);
            labelPromo.getStyleClass().add((Object)"text-white");
            labelPromo.getStyleClass().add((Object)"text-size-20");
            stack_pane.getChildren().add((Object)labelPromo);
            this.pane.add((Node)stack_pane, 0, 0);
        } else {
            this.pane.add((Node)this.label_image, 0, 0);
        }
        this.pane.add((Node)this.pane_right, 1, 0);
        this.getChildren().addAll((Object[])new Node[]{this.pane});
    }
}

