/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.models;

import com.openbravo.format.Formats;
import com.openbravo.pos.ticket.OptionItemOrder;
import com.openbravo.pos.ticket.TicketLineInfo;
import java.util.Objects;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;

public class CashierLaterItemBox
extends VBox {
    TicketLineInfo line;
    final String defaultTimeServed;
    Label label = new Label();
    private Label label_image = new Label();
    private GridPane pane = new GridPane();
    private final double maxWidth;
    private final double maxHeight;
    private Button buttonLater;
    private Button buttonNow;
    private OptionItemOrder optionItemOrder;
    private final EventHandler mEventHandlerClickLater = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            if (CashierLaterItemBox.this.line != null) {
                CashierLaterItemBox.this.line.setTime_served("later");
            }
            if (CashierLaterItemBox.this.optionItemOrder != null) {
                CashierLaterItemBox.this.optionItemOrder.setTime_served("later");
            }
            CashierLaterItemBox.this.selectLater();
        }
    };
    private final EventHandler mEventHandlerClickNow = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            if (CashierLaterItemBox.this.line != null) {
                CashierLaterItemBox.this.line.setTime_served("now");
            }
            if (CashierLaterItemBox.this.optionItemOrder != null) {
                CashierLaterItemBox.this.optionItemOrder.setTime_served("now");
            }
            CashierLaterItemBox.this.selectNow();
        }
    };

    public CashierLaterItemBox(TicketLineInfo line, double maxWidth, double maxHeight) {
        this.maxWidth = maxWidth;
        this.maxHeight = maxHeight;
        this.line = line;
        this.defaultTimeServed = line.getTime_served();
        this.init(line.printPanier(), line.getImage_product());
    }

    public CashierLaterItemBox(OptionItemOrder optionItemOrder, double maxWidth, double maxHeight) {
        this.maxWidth = maxWidth;
        this.maxHeight = maxHeight;
        this.optionItemOrder = optionItemOrder;
        this.defaultTimeServed = optionItemOrder.getTime_served();
        this.init(optionItemOrder.getDisplayedName(), optionItemOrder.getImage_item());
    }

    public String printPrice(double price) {
        if (price != 0.0) {
            return Formats.CURRENCY.formatValue(price);
        }
        return "";
    }

    public String printQuantity(double multiply) {
        if (multiply == (double)Math.round(multiply)) {
            return Formats.INT.formatValue(multiply);
        }
        return Formats.DOUBLE.formatValue(multiply);
    }

    private void init(String nameItem, Image imageItem) {
        this.setPadding(new Insets(8.0));
        this.setPrefWidth(this.maxWidth);
        this.setPrefHeight(this.maxHeight);
        this.setMaxWidth(this.maxWidth);
        this.setMaxHeight(this.maxHeight);
        this.setAlignment(Pos.CENTER);
        this.setSpacing(10.0);
        this.setStyle("-fx-background-radius: 20px; -fx-border-radius: 20px; -fx-border-width: 1px; -fx-border-color: #FFFFFF1F; -fx-background-color: #1E2023;");
        this.label_image.setPrefHeight(this.maxHeight * 0.6);
        this.label_image.setAlignment(Pos.CENTER);
        if (imageItem != null) {
            double imageHeight = this.maxHeight * 0.6;
            ImageView imageViewProduct = new ImageView();
            imageViewProduct.setImage(imageItem);
            imageViewProduct.setFitHeight(imageHeight * 0.8);
            imageViewProduct.setPreserveRatio(true);
            imageViewProduct.setSmooth(true);
            imageViewProduct.setCache(true);
            this.label_image.setGraphic((Node)imageViewProduct);
        }
        this.label.setWrapText(true);
        this.label.setStyle("-fx-font-size: 14pt; -fx-text-fill: white;");
        this.label.setAlignment(Pos.CENTER);
        this.label.setText(nameItem.toUpperCase());
        this.label.setPrefWidth(this.maxWidth * 0.8);
        this.label.setPrefHeight(this.maxHeight * 0.2);
        HBox box = new HBox();
        box.setStyle("-fx-background-color: trannsparent;");
        box.setSpacing(20.0);
        box.setAlignment(Pos.CENTER);
        String laterBtnBgColor = "#5C606B";
        String nowBtnBgColor = "#0B8871";
        if (Objects.equals(this.defaultTimeServed, "later")) {
            laterBtnBgColor = "#0B8871";
            nowBtnBgColor = "#5C606B";
        }
        this.buttonLater = new Button();
        this.buttonLater.setText("\u23f3 Apr\u00e8s le repas");
        this.buttonLater.setPrefWidth(this.maxWidth * 0.45);
        this.buttonLater.setPrefHeight(this.maxHeight * 0.2);
        this.buttonLater.setStyle("-fx-font-size: 14pt; -fx-text-fill: white; -fx-border-radius: 8px; -fx-background-radius: 8px; -fx-background-color: " + laterBtnBgColor + ";");
        this.buttonLater.setOnAction(this.mEventHandlerClickLater);
        box.getChildren().add((Object)this.buttonLater);
        this.buttonNow = new Button();
        this.buttonNow.setText("Maintenant");
        this.buttonNow.setStyle("-fx-font-size: 14pt; -fx-text-fill: white; -fx-border-radius: 8px; -fx-background-radius: 8px; -fx-background-color: " + nowBtnBgColor + ";");
        this.buttonNow.setPrefWidth(this.maxWidth * 0.45);
        this.buttonNow.setPrefHeight(this.maxHeight * 0.2);
        this.buttonNow.setOnAction(this.mEventHandlerClickNow);
        box.getChildren().add((Object)this.buttonNow);
        this.getChildren().addAll((Object[])new Node[]{this.label_image, this.label, box});
    }

    public Button getButtonLater() {
        return this.buttonLater;
    }

    public void setButtonLater(Button buttonLater) {
        this.buttonLater = buttonLater;
    }

    public Button getButtonNow() {
        return this.buttonNow;
    }

    public void setButtonNow(Button buttonNow) {
        this.buttonNow = buttonNow;
    }

    public TicketLineInfo getLine() {
        return this.line;
    }

    public void setLine(TicketLineInfo line) {
        this.line = line;
    }

    public OptionItemOrder getOptionItemOrder() {
        return this.optionItemOrder;
    }

    public void setOptionItemOrder(OptionItemOrder optionItemOrder) {
        this.optionItemOrder = optionItemOrder;
    }

    public void selectNow() {
        this.buttonLater.setStyle("-fx-font-size: 14pt; -fx-text-fill: white; -fx-border-radius: 8px; -fx-background-radius: 8px; -fx-background-color: #5C606B;");
        this.buttonNow.setStyle("-fx-font-size: 14pt; -fx-text-fill: white; -fx-border-radius: 8px; -fx-background-radius: 8px; -fx-background-color: #0B8871;");
    }

    public void selectLater() {
        this.buttonNow.setStyle("-fx-font-size: 14pt; -fx-text-fill: white; -fx-border-radius: 8px; -fx-background-radius: 8px; -fx-background-color: #5C606B;");
        this.buttonLater.setStyle("-fx-font-size: 14pt; -fx-text-fill: white; -fx-border-radius: 8px; -fx-background-radius: 8px; -fx-background-color: #0B8871;");
    }
}

