/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.keen.writer;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import com.openbravo.keen.pojo.User;
import com.openbravo.keen.writer.AbstractWriter;
import com.openbravo.pos.forms.AppLocal;
import java.util.ArrayList;
import java.util.List;

public class UserWriter
extends AbstractWriter {
    private List<User> mList;

    public UserWriter() {
        this.mList = new ArrayList<User>();
    }

    public UserWriter(List<User> mList) {
        this.mList = mList;
    }

    public List<User> getList() {
        return this.mList;
    }

    public void setList(List<User> mList) {
        this.mList = mList;
    }

    @Override
    public boolean writeList() {
        if (this.mList != null && this.mList.size() > 0) {
            System.out.println("WriteList " + this.mList.size());
            for (User m : this.mList) {
                this.write(m);
                System.out.println(m);
            }
            this.closeSession();
            return true;
        }
        this.closeSession();
        return false;
    }

    @Override
    public void migrate(boolean dropIfExist) {
        if (this.session == null) {
            this.openSession();
        }
        if (this.session != null) {
            if (dropIfExist) {
                this.session.execute(User.dropTable());
            }
            this.session.execute(User.createTable());
        }
    }

    public User find() {
        User mUser = null;
        long licenceId = AppLocal.getLicenceId();
        long activationId = AppLocal.getActivationId();
        Select mQuery = QueryBuilder.select().from(User.TABLE_NAME).where(QueryBuilder.eq((String)"activation_id", (Object)activationId)).and(QueryBuilder.eq((String)"licence_id", (Object)licenceId)).and(QueryBuilder.eq((String)"pos_token", (Object)AppLocal.token)).limit(1).allowFiltering();
        ResultSet rs = this.session.execute((Statement)mQuery);
        System.out.println("++++++++++++++ rs : " + rs);
        Row row = rs.one();
        System.out.println("+++++++++ row : " + row);
        if (row != null) {
            mUser = new User();
            mUser.setKeen_id(row.getString("keen_id"));
            mUser.setPos_token(row.getString("pos_token"));
            mUser.setFull_name(row.getString("full_name"));
            mUser.setCompany(row.getString("company"));
            mUser.setEmail(row.getString("email"));
            mUser.setLicence_id(row.getLong("licence_id"));
            mUser.setActivation_id(row.getLong("activation_id"));
            mUser.setTimestamp(row.getLong("timestamp"));
        }
        return mUser;
    }

    @Override
    protected Class getClassType() {
        return User.class;
    }
}

