/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.keen.writer;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import com.datastax.driver.core.querybuilder.Update;
import com.openbravo.keen.pojo.Order;
import com.openbravo.keen.writer.AbstractWriter;
import com.openbravo.pos.forms.AppLocal;
import java.util.ArrayList;
import java.util.List;

public class OrderWriter
extends AbstractWriter {
    private List<Order> mList;

    public OrderWriter() {
        this.mList = new ArrayList<Order>();
    }

    public OrderWriter(List<Order> mList) {
        this.mList = mList;
    }

    public List<Order> getList() {
        return this.mList;
    }

    public void setList(List<Order> mList) {
        this.mList = mList;
    }

    @Override
    public boolean writeList() {
        if (this.mList != null && this.mList.size() > 0) {
            System.out.println("WriteList " + this.mList.size());
            for (Order m : this.mList) {
                System.out.println(m);
                this.write(m);
            }
            this.closeSession();
            return true;
        }
        this.closeSession();
        return false;
    }

    @Override
    public void migrate(boolean dropIfExist) {
        if (this.session == null) {
            this.openSession();
        }
        if (this.session != null) {
            if (dropIfExist) {
                this.session.execute(Order.dropTable());
            }
            this.session.execute(Order.createTable());
        }
    }

    @Override
    protected Class getClassType() {
        return Order.class;
    }

    public Order findByIdOrderAndUserKeen(String userKeenId, String idOrder) {
        Order mOrder = null;
        long licenceId = AppLocal.getLicenceId();
        Select mQuery = QueryBuilder.select().from(Order.TABLE_NAME).where(QueryBuilder.eq((String)"procaisse_licence_id", (Object)licenceId)).and(QueryBuilder.eq((String)"keenio_user_id", (Object)userKeenId)).and(QueryBuilder.eq((String)"order_id", (Object)idOrder)).limit(1).allowFiltering();
        ResultSet rs = this.session.execute((Statement)mQuery);
        Row row = rs.one();
        if (row != null) {
            mOrder = new Order();
            mOrder.fromRow(row);
        }
        return mOrder;
    }

    public void updateSourceOrder(String userKeenId, Order order, String idOrder, String source) {
        long licenceId = AppLocal.getLicenceId();
        Update.Where mQuery = QueryBuilder.update((String)Order.TABLE_NAME).with(QueryBuilder.set((String)"sent_from", (Object)source)).where(QueryBuilder.eq((String)"procaisse_licence_id", (Object)licenceId)).and(QueryBuilder.eq((String)"keenio_user_id", (Object)userKeenId)).and(QueryBuilder.eq((String)"user_id", (Object)order.getUser_id())).and(QueryBuilder.eq((String)"user_name", (Object)order.getUser_name())).and(QueryBuilder.eq((String)"order_id", (Object)idOrder)).and(QueryBuilder.eq((String)"id", (Object)order.getId()));
        this.session.execute((Statement)mQuery);
    }
}

