/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.keen.writer;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import com.openbravo.keen.pojo.OrderItem;
import com.openbravo.keen.writer.AbstractWriter;
import com.openbravo.pos.forms.AppLocal;
import java.util.ArrayList;
import java.util.List;

public class OrderItemWriter
extends AbstractWriter {
    private List<OrderItem> mList;

    public OrderItemWriter() {
        this.mList = new ArrayList<OrderItem>();
    }

    public OrderItemWriter(List<OrderItem> mList) {
        this.mList = mList;
    }

    public List<OrderItem> getList() {
        return this.mList;
    }

    public void setList(List<OrderItem> mList) {
        this.mList = mList;
    }

    @Override
    public boolean writeList() {
        if (this.mList != null && this.mList.size() > 0) {
            System.out.println("WriteList " + this.mList.size());
            for (OrderItem m : this.mList) {
                this.write(m);
            }
            this.closeSession();
            return true;
        }
        this.closeSession();
        return false;
    }

    @Override
    public void migrate(boolean dropIfExist) {
        if (this.session == null) {
            this.openSession();
        }
        if (this.session != null) {
            if (dropIfExist) {
                this.session.execute(OrderItem.dropTable());
            }
            this.session.execute(OrderItem.createTable());
        }
    }

    @Override
    protected Class getClassType() {
        return OrderItem.class;
    }

    public List<OrderItem> findByIdOrderAndUserKeen(String userKeenId, String idOrder) {
        List mList;
        ArrayList<OrderItem> mResult = null;
        long licenceId = AppLocal.getLicenceId();
        Select mQuery = QueryBuilder.select().from(OrderItem.TABLE_NAME).where(QueryBuilder.eq((String)"procaisse_licence_id", (Object)licenceId)).and(QueryBuilder.eq((String)"keenio_user_id", (Object)userKeenId)).and(QueryBuilder.eq((String)"order_id", (Object)idOrder)).allowFiltering();
        ResultSet rs = this.session.execute((Statement)mQuery);
        if (rs != null && (mList = rs.all()) != null && mList.size() > 0) {
            mResult = new ArrayList<OrderItem>();
            for (Row row : mList) {
                OrderItem mObject = new OrderItem();
                mObject.fromRow(row);
                mResult.add(mObject);
            }
        }
        return mResult;
    }
}

