/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.keen.writer;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import com.openbravo.keen.pojo.Cashier;
import com.openbravo.keen.writer.AbstractWriter;
import com.openbravo.pos.forms.AppLocal;
import java.util.ArrayList;
import java.util.List;

public class CashierWriter
extends AbstractWriter<Cashier> {
    private List<Cashier> mList;

    public CashierWriter() {
        this.mList = new ArrayList<Cashier>();
    }

    public CashierWriter(List<Cashier> mList) {
        this.mList = mList;
    }

    public List<Cashier> getList() {
        return this.mList;
    }

    public void setList(List<Cashier> mList) {
        this.mList = mList;
    }

    @Override
    public boolean writeList() {
        if (this.mList != null && this.mList.size() > 0) {
            System.out.println("WriteList " + this.mList.size());
            for (Cashier mCashier : this.mList) {
                this.write(mCashier);
                System.out.println(mCashier);
            }
            this.closeSession();
            return true;
        }
        this.closeSession();
        return false;
    }

    @Override
    public void migrate(boolean dropIfExist) {
        if (this.session == null) {
            this.openSession();
        }
        if (this.session != null) {
            if (dropIfExist) {
                this.session.execute(Cashier.dropTable());
            }
            this.session.execute(Cashier.createTable());
        }
    }

    @Override
    protected Class getClassType() {
        return Cashier.class;
    }

    public List<Cashier> findByIdOrderAndUserKeen(String userKeenId, String idOrder) {
        List mList;
        ArrayList<Cashier> mResult = null;
        long licenceId = AppLocal.getLicenceId();
        Select mQuery = QueryBuilder.select().from(Cashier.TABLE_NAME).where(QueryBuilder.eq((String)"procaisse_licence_id", (Object)licenceId)).and(QueryBuilder.eq((String)"keenio_user_id", (Object)userKeenId)).and(QueryBuilder.eq((String)"order_id", (Object)idOrder)).allowFiltering();
        ResultSet rs = this.session.execute((Statement)mQuery);
        if (rs != null && (mList = rs.all()) != null && mList.size() > 0) {
            mResult = new ArrayList<Cashier>();
            for (Row row : mList) {
                Cashier mCashier = new Cashier();
                mCashier.fromRow(row);
                mResult.add(mCashier);
            }
        }
        return mResult;
    }
}

