/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.keen.writer;

import com.datastax.driver.core.Session;
import com.datastax.driver.mapping.Mapper;
import com.datastax.driver.mapping.MappingManager;
import com.openbravo.keen.ClusterFactory;

public abstract class AbstractWriter<T> {
    protected ClusterFactory mClusterFactory = null;
    protected Session session = null;
    protected MappingManager manager = null;
    protected Mapper mapper;
    private Class<T> mClass;

    public abstract boolean writeList();

    public abstract void migrate(boolean var1);

    protected abstract Class getClassType();

    protected void setClassType(Class<T> klass) {
        this.mClass = klass;
    }

    protected void init() {
        this.mClusterFactory = ClusterFactory.getInstance();
        this.session = this.mClusterFactory.getSession();
        if (this.session != null) {
            this.manager = new MappingManager(this.session);
        }
    }

    protected <T> Mapper<T> mapper() {
        if (this.manager != null) {
            return this.manager.mapper(this.getClassType());
        }
        return null;
    }

    protected <T> Mapper<T> mapper(Class<T> klass) {
        if (this.manager != null) {
            return this.manager.mapper(klass);
        }
        return null;
    }

    private void initMapper() {
        this.mapper = this.mapper();
    }

    public boolean write(Object mObject) {
        if (this.mapper == null) {
            this.initMapper();
        }
        if (mObject != null && this.mapper != null) {
            this.mapper.save(mObject);
            return true;
        }
        return false;
    }

    public void delete(Object mObject) {
        if (this.mapper == null) {
            this.initMapper();
        }
        if (mObject != null && this.mapper != null) {
            this.mapper.delete(mObject);
        }
    }

    public void openSession() {
        this.session = this.mClusterFactory.openSession();
    }

    public void closeSession() {
        this.mClusterFactory.closeSession();
    }
}

