/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.keen.pojo;

import com.datastax.driver.mapping.annotations.PartitionKey;
import com.datastax.driver.mapping.annotations.Table;
import com.openbravo.pos.util.DataParser;
import com.openbravo.pos.util.DateUtils;
import java.text.ParseException;
import java.util.Map;

@Table(keyspace="procaisse", name="users", readConsistency="QUORUM", writeConsistency="QUORUM", caseSensitiveKeyspace=false, caseSensitiveTable=false)
public class User {
    public static String TABLE_NAME = "users";
    @PartitionKey
    private String keen_id;
    private String full_name;
    private String company;
    private String email;
    private String pos_token;
    private Long licence_id;
    private Long activation_id;
    private Long timestamp;

    public String getKeen_id() {
        return this.keen_id;
    }

    public void setKeen_id(String keen_id) {
        this.keen_id = keen_id;
    }

    public String getFull_name() {
        return this.full_name;
    }

    public void setFull_name(String full_name) {
        this.full_name = full_name;
    }

    public String getCompany() {
        return this.company;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Long getLicence_id() {
        return this.licence_id;
    }

    public void setLicence_id(Long licence_id) {
        this.licence_id = licence_id;
    }

    public Long getActivation_id() {
        return this.activation_id;
    }

    public void setActivation_id(Long activation_id) {
        this.activation_id = activation_id;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public String getPos_token() {
        return this.pos_token;
    }

    public void setPos_token(String pos_token) {
        this.pos_token = pos_token;
    }

    public static String dropTable() {
        String mQuery = "DROP TABLE IF EXISTS " + TABLE_NAME;
        return mQuery;
    }

    public static String createTable() {
        String mStructure = "CREATE TABLE IF NOT EXISTS " + TABLE_NAME + " (keen_id text, full_name text, company text, email text, pos_token text, licence_id bigint,activation_id bigint,timestamp bigint,PRIMARY KEY(keen_id))";
        return mStructure;
    }

    public static User fromMap(Map<String, String> next) throws ParseException {
        User mObject = new User();
        mObject.setKeen_id(next.get("keen.id"));
        mObject.setFull_name(next.get("full_name"));
        mObject.setCompany(next.get("company"));
        mObject.setEmail(next.get("email"));
        mObject.setLicence_id(DataParser.asLong(next.get("licence_id")));
        mObject.setActivation_id(DataParser.asLong(next.get("activation_id")));
        mObject.setTimestamp(DateUtils.toCalendar(next.get("keen.timestamp")).getTime().getTime());
        return mObject;
    }

    public String toString() {
        return "User{keen_id=" + this.keen_id + ", full_name=" + this.full_name + ", company=" + this.company + ", email=" + this.email + ", licence_id=" + this.licence_id + ", activation_id=" + this.activation_id + ", timestamp=" + this.timestamp + "}";
    }
}

