/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.keen.pojo;

import com.datastax.driver.core.Row;
import com.datastax.driver.core.utils.UUIDs;
import com.datastax.driver.mapping.annotations.Column;
import com.datastax.driver.mapping.annotations.PartitionKey;
import com.datastax.driver.mapping.annotations.Table;
import com.openbravo.keen.MappedModel;
import com.openbravo.pos.util.DataParser;
import java.text.ParseException;
import java.util.Map;
import java.util.UUID;

@Table(keyspace="procaisse", name="transaction_fidelite", readConsistency="QUORUM", writeConsistency="QUORUM", caseSensitiveKeyspace=false, caseSensitiveTable=false)
public class Transaction_Fidelite
implements MappedModel {
    public static String TABLE_NAME = "transaction_fidelite";
    @PartitionKey(value=2)
    @Column(name="id")
    private UUID id;
    private Long siret;
    @PartitionKey(value=1)
    private String phone;
    private Double amount;
    @PartitionKey(value=0)
    private Long franchise_uuid;
    private Long timestamp;
    private Double value_in;
    private Double value_out;
    private Boolean migrated;

    public static String getTABLE_NAME() {
        return TABLE_NAME;
    }

    public static void setTABLE_NAME(String TABLE_NAME) {
        Transaction_Fidelite.TABLE_NAME = TABLE_NAME;
    }

    public Boolean getIsMigrated() {
        return this.migrated;
    }

    public void setIsMigrated(Boolean migrated) {
        this.migrated = migrated;
    }

    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public Long getSiret() {
        return this.siret;
    }

    public void setSiret(Long siret) {
        this.siret = siret;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String Phone) {
        this.phone = Phone;
    }

    public Double getAmount() {
        return this.amount;
    }

    public void setAmount(Double amount) {
        this.amount = amount;
    }

    public Long getFranchise_uuid() {
        return this.franchise_uuid;
    }

    public void setFranchise_uuid(Long franchise_uuid) {
        this.franchise_uuid = franchise_uuid;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public Double getValue_in() {
        return this.value_in;
    }

    public void setValue_in(Double value_in) {
        this.value_in = value_in;
    }

    public Double getValue_out() {
        return this.value_out;
    }

    public void setValue_out(Double value_out) {
        this.value_out = value_out;
    }

    @Override
    public MappedModel fromMap(Map<String, Object> map) throws ParseException {
        Transaction_Fidelite mObject = new Transaction_Fidelite();
        mObject.setId(UUIDs.random());
        mObject.setSiret((Long)map.get("siret"));
        mObject.setPhone((String)map.get("phone"));
        mObject.setAmount((Double)map.get("amount"));
        mObject.setTimestamp((Long)map.get("timestamp"));
        mObject.setValue_in((Double)map.get("value_in"));
        mObject.setValue_out((Double)map.get("value_out"));
        mObject.setFranchise_uuid((Long)map.get("franchise_uuid"));
        mObject.setIsMigrated((Boolean)map.get("migrated"));
        return mObject;
    }

    @Override
    public void fromRow(Row row) {
        this.setId(row.getUUID("id"));
        this.setSiret(row.getLong("siret"));
        this.setPhone(row.getString("phone"));
        this.setFranchise_uuid(row.getLong("franchise_uuid"));
        this.setAmount(row.getDouble("amount"));
        this.setValue_in(row.getDouble("value_in"));
        this.setValue_out(row.getDouble("value_out"));
        this.setTimestamp(row.getLong("timestamp"));
        this.setIsMigrated(row.getBool("migrated"));
    }

    @Override
    public void fillKeysIfNull() {
        if (this.timestamp == null) {
            this.timestamp = new Long("0");
        }
        if (this.siret == null) {
            this.siret = new Long("0");
        }
        if (this.id == null) {
            this.id = UUIDs.random();
        }
    }

    public static Transaction_Fidelite fromMapFile(Map<String, String> next) throws ParseException {
        Transaction_Fidelite mObject = new Transaction_Fidelite();
        mObject.setId(UUIDs.random());
        mObject.setAmount(DataParser.asDouble(next.get("amount")));
        mObject.setTimestamp(DataParser.asLong(next.get("timestamp")));
        mObject.setValue_in(DataParser.asDouble(next.get("value_in")));
        mObject.setValue_out(DataParser.asDouble(next.get("value_out")));
        mObject.setFranchise_uuid(DataParser.asLong(next.get("franchise_uuid")));
        mObject.setPhone(next.get("phone"));
        mObject.setSiret(DataParser.asLong(next.get("siret")));
        mObject.setIsMigrated(DataParser.asBoolean(next.get("migrated")));
        return mObject;
    }

    public static String dropTable() {
        String mQuery = "DROP TABLE IF EXISTS " + TABLE_NAME;
        return mQuery;
    }
}

