/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.keen.pojo;

import com.datastax.driver.core.Row;
import com.datastax.driver.core.utils.UUIDs;
import com.datastax.driver.mapping.annotations.Column;
import com.datastax.driver.mapping.annotations.PartitionKey;
import com.datastax.driver.mapping.annotations.Table;
import com.openbravo.keen.MappedModel;
import com.openbravo.pos.util.DataParser;
import java.text.ParseException;
import java.util.Map;
import java.util.UUID;

@Table(keyspace="procaisse", name="order_items", readConsistency="QUORUM", writeConsistency="QUORUM", caseSensitiveKeyspace=false, caseSensitiveTable=false)
public class OrderItem
implements MappedModel {
    public static String TABLE_NAME = "order_items";
    @PartitionKey(value=6)
    @Column(name="id")
    private UUID id;
    @PartitionKey(value=4)
    private String name;
    @PartitionKey(value=3)
    private String category_name;
    @PartitionKey(value=1)
    private String keenio_user_id;
    @PartitionKey(value=0)
    private Long procaisse_licence_id;
    private Double price;
    private Double price_amount;
    private Double price_buy;
    private Double ht_amount;
    private Double ttc_amount;
    private Double quantity;
    private Double tax_amount;
    private Double tax_rate;
    @PartitionKey(value=2)
    private Integer item_id;
    private Integer category_id;
    private Boolean menu;
    private Integer at_spot;
    private Integer delivery;
    private Integer take_away;
    @PartitionKey(value=5)
    private String order_id;
    private String order_type;
    private Long timestamp;
    private Long paid_at;
    private Integer uber;
    private Integer delivero;
    private Integer just_eat;
    private Double discount;
    private String label_discount;
    private String type_discount;

    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCategory_name() {
        return this.category_name;
    }

    public void setCategory_name(String category_name) {
        this.category_name = category_name;
    }

    public String getKeenio_user_id() {
        return this.keenio_user_id;
    }

    public void setKeenio_user_id(String keenio_user_id) {
        this.keenio_user_id = keenio_user_id;
    }

    public Long getProcaisse_licence_id() {
        return this.procaisse_licence_id;
    }

    public void setProcaisse_licence_id(Long procaisse_licence_id) {
        this.procaisse_licence_id = procaisse_licence_id;
    }

    public Double getPrice() {
        return this.price;
    }

    public void setPrice(Double price) {
        this.price = price;
    }

    public Double getPrice_amount() {
        return this.price_amount;
    }

    public void setPrice_amount(Double price_amount) {
        this.price_amount = price_amount;
    }

    public Double getPrice_buy() {
        return this.price_buy;
    }

    public void setPrice_buy(Double price_buy) {
        this.price_buy = price_buy;
    }

    public Double getHt_amount() {
        return this.ht_amount;
    }

    public void setHt_amount(Double ht_amount) {
        this.ht_amount = ht_amount;
    }

    public Double getTtc_amount() {
        return this.ttc_amount;
    }

    public void setTtc_amount(Double ttc_amount) {
        this.ttc_amount = ttc_amount;
    }

    public Double getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Double quantity) {
        this.quantity = quantity;
    }

    public Double getTax_amount() {
        return this.tax_amount;
    }

    public void setTax_amount(Double tax_amount) {
        this.tax_amount = tax_amount;
    }

    public Double getTax_rate() {
        return this.tax_rate;
    }

    public void setTax_rate(Double tax_rate) {
        this.tax_rate = tax_rate;
    }

    public Integer getItem_id() {
        return this.item_id;
    }

    public void setItem_id(Integer item_id) {
        this.item_id = item_id;
    }

    public Integer getCategory_id() {
        return this.category_id;
    }

    public void setCategory_id(Integer category_id) {
        this.category_id = category_id;
    }

    public Boolean getMenu() {
        return this.menu;
    }

    public void setMenu(Boolean menu) {
        this.menu = menu;
    }

    public Integer getAt_spot() {
        return this.at_spot;
    }

    public void setAt_spot(Integer at_spot) {
        this.at_spot = at_spot;
    }

    public Integer getDelivery() {
        return this.delivery;
    }

    public void setDelivery(Integer delivery) {
        this.delivery = delivery;
    }

    public Integer getTake_away() {
        return this.take_away;
    }

    public void setTake_away(Integer take_away) {
        this.take_away = take_away;
    }

    public String getOrder_id() {
        return this.order_id;
    }

    public void setOrder_id(String order_id) {
        this.order_id = order_id;
    }

    public String getOrder_type() {
        return this.order_type;
    }

    public void setOrder_type(String order_type) {
        this.order_type = order_type;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public Long getPaid_at() {
        return this.paid_at;
    }

    public void setPaid_at(Long paid_at) {
        this.paid_at = paid_at;
    }

    public Integer getUber() {
        return this.uber;
    }

    public void setUber(Integer uber) {
        this.uber = uber;
    }

    public Integer getDelivero() {
        return this.delivero;
    }

    public void setDelivero(Integer delivero) {
        this.delivero = delivero;
    }

    public Integer getJust_eat() {
        return this.just_eat;
    }

    public void setJust_eat(Integer just_eat) {
        this.just_eat = just_eat;
    }

    public Double getDiscount() {
        return this.discount;
    }

    public void setDiscount(Double discount) {
        this.discount = discount;
    }

    public String getLabel_discount() {
        return this.label_discount;
    }

    public void setLabel_discount(String label_discount) {
        this.label_discount = label_discount;
    }

    public String getType_discount() {
        return this.type_discount;
    }

    public void setType_discount(String type_discount) {
        this.type_discount = type_discount;
    }

    public static String dropTable() {
        String mQuery = "DROP TABLE IF EXISTS " + TABLE_NAME;
        return mQuery;
    }

    public static String createTable() {
        String mStructure = "CREATE TABLE IF NOT EXISTS " + TABLE_NAME + " (id uuid, name text, category_name text, keenio_user_id text, procaisse_licence_id bigint, price double, price_amount double, price_buy double, ht_amount double, ttc_amount double, tax_amount double, tax_rate double, quantity double, item_id int, category_id int, menu boolean, at_spot int, delivery int, take_away int, order_id text, order_type text, timestamp bigint, paid_at bigint, PRIMARY KEY(procaisse_licence_id, keenio_user_id, item_id, category_name, name, order_id, id))";
        return mStructure;
    }

    public static OrderItem fromMapFile(Map<String, String> next) throws ParseException {
        OrderItem mObject = new OrderItem();
        mObject.setId(UUIDs.random());
        mObject.setName(next.get("name"));
        mObject.setCategory_name(next.get("category_name"));
        mObject.setKeenio_user_id(next.get("keenio_user_id"));
        mObject.setProcaisse_licence_id(DataParser.asLong(next.get("procaisse_licence_id")));
        mObject.setPrice(DataParser.asDouble(next.get("price")));
        mObject.setPrice_amount(DataParser.asDouble(next.get("price_amount")));
        mObject.setPrice_buy(DataParser.asDouble(next.get("price_buy")));
        mObject.setHt_amount(DataParser.asDouble(next.get("ht_amount")));
        mObject.setTtc_amount(DataParser.asDouble(next.get("ttc_amount")));
        mObject.setQuantity(DataParser.asDouble(next.get("quantity")));
        mObject.setTax_amount(DataParser.asDouble(next.get("tax_amount")));
        mObject.setTax_rate(DataParser.asDouble(next.get("tax_rate")));
        mObject.setItem_id(DataParser.asInteger(next.get("item_id")));
        mObject.setCategory_id(DataParser.asInteger(next.get("category_id")));
        mObject.setMenu(DataParser.asBoolean(next.get("menu")));
        mObject.setAt_spot(DataParser.asInteger(next.get("at_spot")));
        mObject.setDelivery(DataParser.asInteger(next.get("delivery")));
        mObject.setTake_away(DataParser.asInteger(next.get("take_away")));
        mObject.setOrder_id(next.get("order_id"));
        mObject.setOrder_type(next.get("order_type"));
        mObject.setTimestamp(DataParser.asLong(next.get("timestamp")));
        String paid_at = next.get("paid_at");
        if (paid_at == null || paid_at.isEmpty()) {
            paid_at = next.get("timestamp");
        }
        mObject.setPaid_at(DataParser.asLong(paid_at));
        mObject.setUber(DataParser.asInteger(next.get("uber")));
        mObject.setDelivero(DataParser.asInteger(next.get("delivero")));
        mObject.setJust_eat(DataParser.asInteger(next.get("just_eat")));
        mObject.setDiscount(DataParser.asDouble(next.get("discount")));
        mObject.setLabel_discount(next.get("label_discount"));
        mObject.setType_discount(next.get("type_discount"));
        return mObject;
    }

    @Override
    public MappedModel fromMap(Map<String, Object> map) throws ParseException {
        OrderItem mObject = new OrderItem();
        mObject.setId(UUIDs.random());
        mObject.setName((String)map.getOrDefault("name", "-"));
        mObject.setCategory_name((String)map.getOrDefault("category_name", "-"));
        mObject.setKeenio_user_id((String)map.get("keenio_user_id"));
        mObject.setProcaisse_licence_id((Long)map.get("procaisse_licence_id"));
        mObject.setPrice((Double)map.get("price"));
        mObject.setPrice_amount((Double)map.get("price_amount"));
        mObject.setPrice_buy((Double)map.get("price_buy"));
        mObject.setHt_amount((Double)map.get("ht_amount"));
        mObject.setTtc_amount((Double)map.get("ttc_amount"));
        mObject.setQuantity((Double)map.get("quantity"));
        mObject.setTax_amount((Double)map.get("tax_amount"));
        mObject.setTax_rate((Double)map.get("tax_rate"));
        mObject.setItem_id((Integer)map.get("item_id"));
        mObject.setCategory_id((Integer)map.get("category_id"));
        mObject.setMenu((Boolean)map.get("menu"));
        mObject.setAt_spot((Integer)map.get("at_spot"));
        mObject.setDelivery((Integer)map.get("delivery"));
        mObject.setTake_away((Integer)map.get("take_away"));
        mObject.setOrder_id((String)map.get("order_id"));
        mObject.setOrder_type((String)map.get("order_type"));
        mObject.setTimestamp((Long)map.get("timestamp"));
        Long paid_at = (Long)map.get("paid_at");
        if (paid_at == null) {
            paid_at = (Long)map.get("timestamp");
        }
        mObject.setPaid_at(paid_at);
        mObject.setUber((Integer)map.get("uber"));
        mObject.setDelivero((Integer)map.get("delivero"));
        mObject.setJust_eat((Integer)map.get("just_eat"));
        mObject.setDiscount((Double)map.get("discount"));
        mObject.setLabel_discount((String)map.get("label_discount"));
        mObject.setType_discount((String)map.get("type_discount"));
        mObject.fillKeysIfNull();
        return mObject;
    }

    @Override
    public void fromRow(Row row) {
        this.setId(row.getUUID("id"));
        this.setName(row.getString("name"));
        this.setCategory_name(row.getString("category_name"));
        this.setKeenio_user_id(row.getString("keenio_user_id"));
        this.setProcaisse_licence_id(row.getLong("procaisse_licence_id"));
        this.setPrice(row.getDouble("price"));
        this.setPrice_amount(row.getDouble("price_amount"));
        this.setPrice_buy(row.getDouble("price_buy"));
        this.setHt_amount(row.getDouble("ht_amount"));
        this.setTtc_amount(row.getDouble("ttc_amount"));
        this.setQuantity(row.getDouble("quantity"));
        this.setTax_amount(row.getDouble("tax_amount"));
        this.setTax_rate(row.getDouble("tax_rate"));
        this.setItem_id(row.getInt("item_id"));
        this.setCategory_id(row.getInt("category_id"));
        this.setMenu(row.getBool("menu"));
        this.setAt_spot(row.getInt("at_spot"));
        this.setDelivery(row.getInt("delivery"));
        this.setTake_away(row.getInt("take_away"));
        this.setOrder_id(row.getString("order_id"));
        this.setOrder_type(row.getString("order_type"));
        this.setTimestamp(row.getLong("timestamp"));
        this.setPaid_at(row.getLong("paid_at"));
        this.setUber(row.getInt("uber"));
        this.setDelivero(row.getInt("delivero"));
        this.setJust_eat(row.getInt("just_eat"));
        this.setDiscount(row.getDouble("discount"));
        this.setLabel_discount(row.getString("label_discount"));
        this.setType_discount(row.getString("type_discount"));
    }

    @Override
    public void fillKeysIfNull() {
        if (this.procaisse_licence_id == null) {
            this.procaisse_licence_id = new Long("0");
        }
        if (this.keenio_user_id == null) {
            this.keenio_user_id = "-";
        }
        if (this.item_id == null) {
            this.item_id = 0;
        }
        if (this.category_name == null) {
            this.category_name = "-";
        }
        if (this.name == null) {
            this.name = "-";
        }
        if (this.order_id == null) {
            this.order_id = "-";
        }
        if (this.id == null) {
            this.id = UUIDs.random();
        }
    }

    public String toString() {
        return "OrderItem{id=" + this.id + ", name=" + this.name + ", category_name=" + this.category_name + ", keenio_user_id=" + this.keenio_user_id + ", procaisse_licence_id=" + this.procaisse_licence_id + ", price=" + this.price + ", price_amount=" + this.price_amount + ", price_buy=" + this.price_buy + ", ht_amount=" + this.ht_amount + ", ttc_amount=" + this.ttc_amount + ", quantity=" + this.quantity + ", tax_amount=" + this.tax_amount + ", tax_rate=" + this.tax_rate + ", item_id=" + this.item_id + ", category_id=" + this.category_id + ", menu=" + this.menu + ", at_spot=" + this.at_spot + ", delivery=" + this.delivery + ", take_away=" + this.take_away + ", order_id=" + this.order_id + ", order_type=" + this.order_type + ", timestamp=" + this.timestamp + ", paid_at=" + this.paid_at + ", uber=" + this.uber + ", delivero=" + this.delivero + ", just_eat=" + this.just_eat + "}";
    }
}

