/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.keen.pojo;

import com.datastax.driver.core.Row;
import com.datastax.driver.core.utils.UUIDs;
import com.datastax.driver.mapping.annotations.Column;
import com.datastax.driver.mapping.annotations.PartitionKey;
import com.datastax.driver.mapping.annotations.Table;
import com.openbravo.keen.MappedModel;
import com.openbravo.pos.util.DataParser;
import java.text.ParseException;
import java.util.Map;
import java.util.UUID;

@Table(keyspace="procaisse", name="orders", readConsistency="QUORUM", writeConsistency="QUORUM", caseSensitiveKeyspace=false, caseSensitiveTable=false)
public class Order
implements MappedModel {
    public static String TABLE_NAME = "orders";
    @PartitionKey(value=5)
    @Column(name="id")
    private UUID id;
    @PartitionKey(value=3)
    private String user_name;
    @PartitionKey(value=2)
    private String user_id;
    @PartitionKey(value=1)
    private String keenio_user_id;
    @PartitionKey(value=0)
    private Long procaisse_licence_id;
    private Double real_total;
    private Double total;
    private Integer at_spot;
    private Integer delivery;
    private Integer take_away;
    @PartitionKey(value=4)
    private String order_id;
    private String type;
    private Long timestamp;
    private Long paid_at;
    private Integer uber;
    private Integer delivero;
    private Integer just_eat;
    private String source_order;
    private Double discount;
    private String label_discount;
    private String type_discount;
    private String sent_from;

    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public String getUser_name() {
        return this.user_name;
    }

    public void setUser_name(String user_name) {
        this.user_name = user_name;
    }

    public String getUser_id() {
        return this.user_id;
    }

    public void setUser_id(String user_id) {
        this.user_id = user_id;
    }

    public String getKeenio_user_id() {
        return this.keenio_user_id;
    }

    public void setKeenio_user_id(String keenio_user_id) {
        this.keenio_user_id = keenio_user_id;
    }

    public Long getProcaisse_licence_id() {
        return this.procaisse_licence_id;
    }

    public void setProcaisse_licence_id(Long procaisse_licence_id) {
        this.procaisse_licence_id = procaisse_licence_id;
    }

    public Double getReal_total() {
        return this.real_total;
    }

    public void setReal_total(Double real_total) {
        this.real_total = real_total;
    }

    public Double getTotal() {
        return this.total;
    }

    public void setTotal(Double total) {
        this.total = total;
    }

    public Integer getAt_spot() {
        return this.at_spot;
    }

    public void setAt_spot(Integer at_spot) {
        this.at_spot = at_spot;
    }

    public Integer getDelivery() {
        return this.delivery;
    }

    public void setDelivery(Integer delivery) {
        this.delivery = delivery;
    }

    public Integer getTake_away() {
        return this.take_away;
    }

    public void setTake_away(Integer take_away) {
        this.take_away = take_away;
    }

    public String getOrder_id() {
        return this.order_id;
    }

    public void setOrder_id(String order_id) {
        this.order_id = order_id;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public Long getPaid_at() {
        return this.paid_at;
    }

    public void setPaid_at(Long paid_at) {
        this.paid_at = paid_at;
    }

    public Integer getUber() {
        return this.uber;
    }

    public void setUber(Integer uber) {
        this.uber = uber;
    }

    public Integer getDelivero() {
        return this.delivero;
    }

    public void setDelivero(Integer delivero) {
        this.delivero = delivero;
    }

    public Integer getJust_eat() {
        return this.just_eat;
    }

    public void setJust_eat(Integer just_eat) {
        this.just_eat = just_eat;
    }

    public String getSource_order() {
        return this.source_order;
    }

    public void setSource_order(String source_order) {
        this.source_order = source_order;
    }

    public Double getDiscount() {
        return this.discount;
    }

    public void setDiscount(Double discount) {
        this.discount = discount;
    }

    public String getLabel_discount() {
        return this.label_discount;
    }

    public void setLabel_discount(String label_discount) {
        this.label_discount = label_discount;
    }

    public String getType_discount() {
        return this.type_discount;
    }

    public void setType_discount(String type_discount) {
        this.type_discount = type_discount;
    }

    public String getSent_from() {
        return this.sent_from;
    }

    public void setSent_from(String sent_from) {
        this.sent_from = sent_from;
    }

    public static String dropTable() {
        String mQuery = "DROP TABLE IF EXISTS " + TABLE_NAME;
        return mQuery;
    }

    public static String createTable() {
        String mStructure = "CREATE TABLE IF NOT EXISTS " + TABLE_NAME + " (id uuid, user_name text, user_id text, keenio_user_id text, procaisse_licence_id bigint, real_total double, total double, at_spot int, delivery int, take_away int, order_id text, type text, timestamp bigint, paid_at bigint, PRIMARY KEY(procaisse_licence_id, keenio_user_id, user_id, user_name, order_id, id))";
        return mStructure;
    }

    public static Order fromMapFile(Map<String, String> next) throws ParseException {
        Order mObject = new Order();
        mObject.setId(UUIDs.random());
        mObject.setUser_name(next.get("user_name"));
        mObject.setUser_id(next.get("user_id"));
        mObject.setKeenio_user_id(next.get("keenio_user_id"));
        mObject.setProcaisse_licence_id(DataParser.asLong(next.get("procaisse_licence_id")));
        mObject.setReal_total(DataParser.asDouble(next.get("real_total")));
        mObject.setTotal(DataParser.asDouble(next.get("total")));
        mObject.setAt_spot(DataParser.asInteger(next.get("at_spot")));
        mObject.setDelivery(DataParser.asInteger(next.get("delivery")));
        mObject.setTake_away(DataParser.asInteger(next.get("take_away")));
        mObject.setOrder_id(next.get("order_id"));
        mObject.setType(next.get("type"));
        mObject.setTimestamp(DataParser.asLong(next.get("timestamp")));
        String paid_at = next.get("paid_at");
        if (paid_at == null || paid_at.isEmpty()) {
            paid_at = next.get("timestamp");
        }
        mObject.setPaid_at(DataParser.asLong(paid_at));
        mObject.setUber(DataParser.asInteger(next.get("uber")));
        mObject.setDelivero(DataParser.asInteger(next.get("delivero")));
        mObject.setJust_eat(DataParser.asInteger(next.get("just_eat")));
        mObject.setSource_order(next.get("source_order"));
        mObject.setDiscount(DataParser.asDouble(next.get("discount")));
        mObject.setLabel_discount(next.get("label_discount"));
        mObject.setType_discount(next.get("type_discount"));
        mObject.setSent_from(next.get("sent_from"));
        return mObject;
    }

    @Override
    public MappedModel fromMap(Map<String, Object> map) throws ParseException {
        Order mObject = new Order();
        mObject.setId(UUIDs.random());
        mObject.setUser_name((String)map.get("user_name"));
        mObject.setUser_id((String)map.get("user_id"));
        mObject.setKeenio_user_id((String)map.get("keenio_user_id"));
        mObject.setProcaisse_licence_id((Long)map.get("procaisse_licence_id"));
        mObject.setReal_total((Double)map.get("real_total"));
        mObject.setTotal((Double)map.get("total"));
        mObject.setAt_spot((Integer)map.get("at_spot"));
        mObject.setDelivery((Integer)map.get("delivery"));
        mObject.setTake_away((Integer)map.get("take_away"));
        mObject.setOrder_id((String)map.get("order_id"));
        mObject.setType((String)map.get("type"));
        mObject.setTimestamp((Long)map.get("timestamp"));
        Long paid_at = (Long)map.get("paid_at");
        if (paid_at == null) {
            paid_at = (Long)map.get("timestamp");
        }
        mObject.setPaid_at(paid_at);
        mObject.setUber((Integer)map.get("uber"));
        mObject.setDelivero((Integer)map.get("delivero"));
        mObject.setJust_eat((Integer)map.get("just_eat"));
        mObject.setSource_order((String)map.get("source_order"));
        mObject.setDiscount((Double)map.get("discount"));
        mObject.setLabel_discount((String)map.get("label_discount"));
        mObject.setType_discount((String)map.get("type_discount"));
        mObject.setSent_from((String)map.get("sent_from"));
        mObject.fillKeysIfNull();
        return mObject;
    }

    @Override
    public void fromRow(Row row) {
        this.setId(row.getUUID("id"));
        this.setUser_name(row.getString("user_name"));
        this.setUser_id(row.getString("user_id"));
        this.setKeenio_user_id(row.getString("keenio_user_id"));
        this.setProcaisse_licence_id(row.getLong("procaisse_licence_id"));
        this.setReal_total(row.getDouble("real_total"));
        this.setTotal(row.getDouble("total"));
        this.setAt_spot(row.getInt("at_spot"));
        this.setDelivery(row.getInt("delivery"));
        this.setTake_away(row.getInt("take_away"));
        this.setOrder_id(row.getString("order_id"));
        this.setType(row.getString("type"));
        this.setTimestamp(row.getLong("timestamp"));
        this.setPaid_at(row.getLong("paid_at"));
        this.setUber(row.getInt("uber"));
        this.setDelivero(row.getInt("delivero"));
        this.setJust_eat(row.getInt("just_eat"));
        this.setSource_order(row.getString("source_order"));
        this.setDiscount(row.getDouble("discount"));
        this.setLabel_discount(row.getString("label_discount"));
        this.setType_discount(row.getString("type_discount"));
        this.setSent_from(row.getString("sent_from"));
    }

    @Override
    public void fillKeysIfNull() {
        if (this.procaisse_licence_id == null) {
            this.procaisse_licence_id = new Long("0");
        }
        if (this.keenio_user_id == null) {
            this.keenio_user_id = "-";
        }
        if (this.user_id == null) {
            this.user_id = "-";
        }
        if (this.user_name == null) {
            this.user_name = "-";
        }
        if (this.order_id == null) {
            this.order_id = "-";
        }
        if (this.id == null) {
            this.id = UUIDs.random();
        }
    }

    public String toString() {
        return "Order{id=" + this.id + ", user_name=" + this.user_name + ", user_id=" + this.user_id + ", keenio_user_id=" + this.keenio_user_id + ", procaisse_licence_id=" + this.procaisse_licence_id + ", real_total=" + this.real_total + ", total=" + this.total + ", at_spot=" + this.at_spot + ", delivery=" + this.delivery + ", take_away=" + this.take_away + ", order_id=" + this.order_id + ", type=" + this.type + ", timestamp=" + this.timestamp + ", paid_at=" + this.paid_at + ", uber=" + this.uber + ", delivero=" + this.delivero + ", just_eat=" + this.just_eat + "}";
    }
}

