/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.keen.pojo;

import com.datastax.driver.core.Row;
import com.datastax.driver.core.utils.UUIDs;
import com.datastax.driver.mapping.annotations.Column;
import com.datastax.driver.mapping.annotations.PartitionKey;
import com.datastax.driver.mapping.annotations.Table;
import com.openbravo.keen.MappedModel;
import com.openbravo.pos.util.DataParser;
import java.text.ParseException;
import java.util.Map;
import java.util.UUID;

@Table(keyspace="procaisse", name="annulations", readConsistency="QUORUM", writeConsistency="QUORUM", caseSensitiveKeyspace=false, caseSensitiveTable=false)
public class Annulation
implements MappedModel {
    public static String TABLE_NAME = "annulations";
    @PartitionKey(value=3)
    @Column(name="id")
    private UUID id;
    @PartitionKey(value=1)
    private String keenio_user_id;
    @PartitionKey(value=0)
    private Long procaisse_licence_id;
    private Double amount;
    private Integer at_spot;
    private Integer delivery;
    private Integer take_away;
    @PartitionKey(value=2)
    private String order_id;
    private String order_type;
    private Long timestamp;
    private Long paid_at;
    private Integer uber;
    private Integer delivero;
    private Integer just_eat;

    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public String getKeenio_user_id() {
        return this.keenio_user_id;
    }

    public void setKeenio_user_id(String keenio_user_id) {
        this.keenio_user_id = keenio_user_id;
    }

    public Long getProcaisse_licence_id() {
        return this.procaisse_licence_id;
    }

    public void setProcaisse_licence_id(Long procaisse_licence_id) {
        this.procaisse_licence_id = procaisse_licence_id;
    }

    public Double getAmount() {
        return this.amount;
    }

    public void setAmount(Double amount) {
        this.amount = amount;
    }

    public Integer getAt_spot() {
        return this.at_spot;
    }

    public void setAt_spot(Integer at_spot) {
        this.at_spot = at_spot;
    }

    public Integer getDelivery() {
        return this.delivery;
    }

    public void setDelivery(Integer delivery) {
        this.delivery = delivery;
    }

    public Integer getTake_away() {
        return this.take_away;
    }

    public void setTake_away(Integer take_away) {
        this.take_away = take_away;
    }

    public String getOrder_id() {
        return this.order_id;
    }

    public void setOrder_id(String order_id) {
        this.order_id = order_id;
    }

    public String getOrder_type() {
        return this.order_type;
    }

    public void setOrder_type(String order_type) {
        this.order_type = order_type;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public Long getPaid_at() {
        return this.paid_at;
    }

    public void setPaid_at(Long paid_at) {
        this.paid_at = paid_at;
    }

    public Integer getUber() {
        return this.uber;
    }

    public void setUber(Integer uber) {
        this.uber = uber;
    }

    public Integer getDelivero() {
        return this.delivero;
    }

    public void setDelivero(Integer delivero) {
        this.delivero = delivero;
    }

    public Integer getJust_eat() {
        return this.just_eat;
    }

    public void setJust_eat(Integer just_eat) {
        this.just_eat = just_eat;
    }

    public static String dropTable() {
        String mQuery = "DROP TABLE IF EXISTS " + TABLE_NAME;
        return mQuery;
    }

    public static String createTable() {
        String mStructure = "CREATE TABLE IF NOT EXISTS " + TABLE_NAME + " (id uuid, keenio_user_id text, procaisse_licence_id bigint,amount double,at_spot int, delivery int, take_away int, order_id text, order_type text, timestamp bigint, paid_at bigint, PRIMARY KEY(procaisse_licence_id, keenio_user_id, order_id, id))";
        return mStructure;
    }

    public static Annulation fromMapFile(Map<String, String> next) throws ParseException {
        Annulation mObject = new Annulation();
        mObject.setId(UUIDs.random());
        mObject.setKeenio_user_id(next.get("keenio_user_id"));
        mObject.setProcaisse_licence_id(DataParser.asLong(next.get("procaisse_licence_id")));
        mObject.setAmount(DataParser.asDouble(next.get("amount")));
        mObject.setAt_spot(DataParser.asInteger(next.get("at_spot")));
        mObject.setDelivery(DataParser.asInteger(next.get("delivery")));
        mObject.setTake_away(DataParser.asInteger(next.get("take_away")));
        mObject.setOrder_id(next.get("order_id"));
        mObject.setOrder_type(next.get("order_type"));
        mObject.setTimestamp(DataParser.asLong(next.get("timestamp")));
        String paid_at = next.get("paid_at");
        if (paid_at == null || paid_at.isEmpty()) {
            paid_at = next.get("timestamp");
        }
        mObject.setPaid_at(DataParser.asLong(paid_at));
        mObject.setUber(DataParser.asInteger(next.get("uber")));
        mObject.setDelivero(DataParser.asInteger(next.get("delivero")));
        mObject.setJust_eat(DataParser.asInteger(next.get("just_eat")));
        return mObject;
    }

    @Override
    public MappedModel fromMap(Map<String, Object> map) throws ParseException {
        Annulation mObject = new Annulation();
        mObject.setId(UUIDs.random());
        mObject.setKeenio_user_id((String)map.get("keenio_user_id"));
        mObject.setProcaisse_licence_id((Long)map.get("procaisse_licence_id"));
        mObject.setAmount((Double)map.get("amount"));
        mObject.setAt_spot((Integer)map.get("at_spot"));
        mObject.setDelivery((Integer)map.get("delivery"));
        mObject.setTake_away((Integer)map.get("take_away"));
        mObject.setOrder_id((String)map.get("order_id"));
        mObject.setOrder_type((String)map.get("order_type"));
        mObject.setTimestamp((Long)map.get("timestamp"));
        Long paid_at = (Long)map.get("paid_at");
        if (paid_at == null) {
            paid_at = (Long)map.get("timestamp");
        }
        mObject.setPaid_at(paid_at);
        mObject.setUber((Integer)map.get("uber"));
        mObject.setDelivero((Integer)map.get("delivero"));
        mObject.setJust_eat((Integer)map.get("just_eat"));
        mObject.fillKeysIfNull();
        return mObject;
    }

    @Override
    public void fromRow(Row row) {
        this.setId(row.getUUID("id"));
        this.setKeenio_user_id(row.getString("keenio_user_id"));
        this.setProcaisse_licence_id(row.getLong("procaisse_licence_id"));
        this.setAmount(row.getDouble("amount"));
        this.setAt_spot(row.getInt("at_spot"));
        this.setDelivery(row.getInt("delivery"));
        this.setTake_away(row.getInt("take_away"));
        this.setOrder_id(row.getString("order_id"));
        this.setOrder_type(row.getString("order_type"));
        this.setTimestamp(row.getLong("timestamp"));
        this.setPaid_at(row.getLong("paid_at"));
        this.setUber(row.getInt("uber"));
        this.setDelivero(row.getInt("delivero"));
        this.setJust_eat(row.getInt("just_eat"));
    }

    @Override
    public void fillKeysIfNull() {
        if (this.procaisse_licence_id == null) {
            this.procaisse_licence_id = new Long("0");
        }
        if (this.keenio_user_id == null) {
            this.keenio_user_id = "-";
        }
        if (this.order_id == null) {
            this.order_id = "-";
        }
        if (this.id == null) {
            this.id = UUIDs.random();
        }
    }

    public String toString() {
        return "Annulation{id=" + this.id + ", keenio_user_id=" + this.keenio_user_id + ", procaisse_licence_id=" + this.procaisse_licence_id + ", amount=" + this.amount + ", at_spot=" + this.at_spot + ", delivery=" + this.delivery + ", take_away=" + this.take_away + ", order_id=" + this.order_id + ", order_type=" + this.order_type + ", timestamp=" + this.timestamp + ", paid_at=" + this.paid_at + ", uber=" + this.uber + ", delivero=" + this.delivero + ", just_eat=" + this.just_eat + "}";
    }
}

