/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.keen;

import com.openbravo.keen.MappedModel;
import com.openbravo.keen.pojo.Annulation;
import com.openbravo.keen.pojo.Cashier;
import com.openbravo.keen.pojo.Category;
import com.openbravo.keen.pojo.Option;
import com.openbravo.keen.pojo.OptionCategory;
import com.openbravo.keen.pojo.Order;
import com.openbravo.keen.pojo.OrderItem;
import com.openbravo.keen.pojo.Payment;
import com.openbravo.keen.pojo.Suivi;
import com.openbravo.keen.pojo.User;
import com.openbravo.keen.writer.AnnulationWriter;
import com.openbravo.keen.writer.CashierWriter;
import com.openbravo.keen.writer.CategoryWriter;
import com.openbravo.keen.writer.OptionCategoryWriter;
import com.openbravo.keen.writer.OptionWriter;
import com.openbravo.keen.writer.OrderItemWriter;
import com.openbravo.keen.writer.OrderWriter;
import com.openbravo.keen.writer.PaymentWriter;
import com.openbravo.keen.writer.SuiviWriter;
import com.openbravo.keen.writer.UserWriter;
import com.openbravo.pos.ticket.MarqueNFC;
import java.text.ParseException;
import java.util.List;
import java.util.Map;

public class OCassandraObject {
    private UserWriter mUserWriter = new UserWriter();
    private OrderWriter mOrderWriter = new OrderWriter();
    private CashierWriter mCashierWriter = new CashierWriter();
    private CategoryWriter mCategoryWriter = new CategoryWriter();
    private OptionCategoryWriter mOptionCategoryWriter = new OptionCategoryWriter();
    private OptionWriter mOptionWriter = new OptionWriter();
    private OrderItemWriter mOrderItemWriter = new OrderItemWriter();
    private PaymentWriter mPaymentWriter = new PaymentWriter();
    private AnnulationWriter mAnnulationWriter = new AnnulationWriter();
    private SuiviWriter mSuiviWriter = new SuiviWriter();

    public String host() {
        return "procaisse-db-stats.pro-tactile.com";
    }

    public void writeEventMap(MappedModel model, Map<String, Object> params_fields) throws ParseException {
        MappedModel modelFilled;
        if (model != null && (modelFilled = model.fromMap(params_fields)) != null) {
            try {
                this.writeEvent(modelFilled);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }

    public void writeEvent(MappedModel model) throws ParseException {
        if (model != null) {
            if (model instanceof Order) {
                this.mOrderWriter.write(model);
            } else if (model instanceof Cashier) {
                this.mCashierWriter.write(model);
            } else if (model instanceof Category) {
                this.mCategoryWriter.write(model);
            } else if (model instanceof Option) {
                this.mOptionWriter.write(model);
            } else if (model instanceof OptionCategory) {
                this.mOptionCategoryWriter.write(model);
            } else if (model instanceof OrderItem) {
                this.mOrderItemWriter.write(model);
            } else if (model instanceof Payment) {
                this.mPaymentWriter.write(model);
            } else if (model instanceof Annulation) {
                this.mAnnulationWriter.write(model);
            } else if (model instanceof Suivi) {
                System.out.println("++++++++++++ model : " + model);
                System.out.println(" +++++++++++++++ id suivi : " + ((Suivi)model).getId());
                this.mSuiviWriter.write(model);
            }
        }
    }

    public int removeLines(String userKeenId, String idOrder) {
        Order mOrder = this.mOrderWriter.findByIdOrderAndUserKeen(userKeenId, idOrder);
        List<Cashier> mCashier = this.mCashierWriter.findByIdOrderAndUserKeen(userKeenId, idOrder);
        List<Category> mCategory = this.mCategoryWriter.findByIdOrderAndUserKeen(userKeenId, idOrder);
        List<Option> mOption = this.mOptionWriter.findByIdOrderAndUserKeen(userKeenId, idOrder);
        List<OptionCategory> mOptionCategory = this.mOptionCategoryWriter.findByIdOrderAndUserKeen(userKeenId, idOrder);
        List<OrderItem> mOrderItem = this.mOrderItemWriter.findByIdOrderAndUserKeen(userKeenId, idOrder);
        List<Payment> mPayment = this.mPaymentWriter.findByIdOrderAndUserKeen(userKeenId, idOrder);
        if (mOrder != null) {
            this.mOrderWriter.delete(mOrder);
        }
        if (mCashier != null) {
            for (Cashier cashier : mCashier) {
                this.mCashierWriter.delete(cashier);
            }
        }
        if (mCategory != null) {
            for (Category category : mCategory) {
                this.mCategoryWriter.delete(category);
            }
        }
        if (mOption != null) {
            for (Option option : mOption) {
                this.mOptionWriter.delete(option);
            }
        }
        if (mOptionCategory != null) {
            for (OptionCategory optionCategory : mOptionCategory) {
                this.mOptionCategoryWriter.delete(optionCategory);
            }
        }
        if (mOrderItem != null) {
            for (OrderItem orderItem : mOrderItem) {
                this.mOrderItemWriter.delete(orderItem);
            }
        }
        if (mPayment != null) {
            for (Payment payment : mPayment) {
                this.mPaymentWriter.delete(payment);
            }
        }
        return 0;
    }

    public User readUserInfo() {
        User mUser = this.mUserWriter.find();
        return mUser;
    }

    public User pushUserInfo(MarqueNFC marqueNFC) {
        return null;
    }

    public void removePayments(String userKeenId, String idOrder) {
        List<Payment> mPayment = this.mPaymentWriter.findByIdOrderAndUserKeen(userKeenId, idOrder);
        if (mPayment != null) {
            for (Payment next : mPayment) {
                this.mPaymentWriter.delete(next);
            }
        }
    }

    public boolean existOrder(String userKeenId, String idOrder) {
        Order mOrder = this.mOrderWriter.findByIdOrderAndUserKeen(userKeenId, idOrder);
        return mOrder != null;
    }

    public void updateSuiviOrder(Suivi suiviOrder, String userKeenId, String idOrder, Long date_close, Long closing_time) {
        this.mSuiviWriter.updateSuiviOrder(suiviOrder, userKeenId, idOrder, date_close, closing_time);
    }

    public Suivi findByIdOrderAndUserKeen(String userKeenId, String idOrder) {
        return this.mSuiviWriter.findByIdOrderAndUserKeen(userKeenId, idOrder);
    }

    public boolean existCancelOrder(String userKeenId, String idOrder) {
        Annulation mAnnulation = this.mAnnulationWriter.findByIdOrderAndUserKeen(userKeenId, idOrder);
        return mAnnulation != null;
    }

    public int removeAnnulation(String userKeenId, String idOrder) {
        Annulation mAnnulation = this.mAnnulationWriter.findByIdOrderAndUserKeen(userKeenId, idOrder);
        if (mAnnulation != null) {
            this.mAnnulationWriter.delete(mAnnulation);
        }
        System.out.println("++++++++++++++ remove cancel");
        return 0;
    }

    public void updateSourceOrder(String userKeenId, Order order, String idOrder, String source) {
        this.mOrderWriter.updateSourceOrder(userKeenId, order, idOrder, source);
    }

    public Order getOrder(String userKeenId, String idOrder) {
        return this.mOrderWriter.findByIdOrderAndUserKeen(userKeenId, idOrder);
    }
}

