/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.keen;

import com.openbravo.dao.DataLogicItems;
import com.openbravo.keen.OCassandraObject;
import com.openbravo.keen.pojo.Annulation;
import com.openbravo.keen.pojo.Cashier;
import com.openbravo.keen.pojo.Category;
import com.openbravo.keen.pojo.Option;
import com.openbravo.keen.pojo.OptionCategory;
import com.openbravo.keen.pojo.Order;
import com.openbravo.keen.pojo.OrderItem;
import com.openbravo.keen.pojo.Payment;
import com.openbravo.keen.pojo.Suivi;
import com.openbravo.keen.pojo.User;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.payment.PaymentInfo;
import com.openbravo.pos.ticket.MarqueNFC;
import com.openbravo.pos.ticket.OptionItemOrder;
import com.openbravo.pos.ticket.TicketInfo;
import com.openbravo.pos.ticket.TicketLineInfo;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.pos.util.StringUtils;
import com.utils.NetworkUtils;
import fr.protactile.procaisse.cache.StorageInMemoryCache;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CassandraManager {
    private static CassandraManager m_instance = null;
    private String USER_KEEN_ID = null;
    private DataLogicItems dlItems = null;
    private boolean isUserKeenIOSaved = false;
    private OCassandraObject mOCassandraObject;
    private StorageInMemoryCache<Integer, Map> mCacheItems;
    private StorageInMemoryCache<Integer, Map> mCacheOptions;
    private final long MAX_CACHE_TIMETOLIVE = 3600L;
    private final long MAX_CACHE_TIMERINTERVAL = 600L;
    private final int MAX_CACHE_ELEMENTS = 1000;
    private boolean is_synchronizing = false;
    private final String INSIDE = "inside";
    private final String MODE_CAISSE = "Caisse";
    private final String SOURCE_CAISSE = "caisse";
    private final String SOURCE_UBEREAT = "Uber Eats";
    private final String SOURCE_BORNE_CB = "borne cb";
    private final String SOURCE_BORNE = "borne";
    private final String SOURCE_ONLINE = "online";
    private final String SOURCE_WEB = "web";

    private CassandraManager() {
        if (AppLocal.IS_STATS_ONLINE_ENABLED.booleanValue()) {
            this.init();
            this.mCacheItems = new StorageInMemoryCache(3600L, 600L, 1000);
            this.mCacheOptions = new StorageInMemoryCache(3600L, 600L, 1000);
        }
    }

    private void init() {
        if (this.mOCassandraObject == null && this.isNetworkConnected()) {
            this.mOCassandraObject = new OCassandraObject();
        }
    }

    public static CassandraManager getInstance() {
        if (m_instance == null) {
            m_instance = new CassandraManager();
        }
        return m_instance;
    }

    public void setDlItems(DataLogicItems dlItems) {
        if (this.dlItems == null) {
            this.dlItems = dlItems;
        }
    }

    private boolean isNetworkConnected() {
        return NetworkUtils.isNetworkConnected("procaisse-db-stats.pro-tactile.com", 80, 5000);
    }

    private void updateUserKeenIoOrIgnore() {
        if (this.dlItems != null && this.USER_KEEN_ID != null) {
            try {
                String result = this.dlItems.getUserKeenIo();
                System.out.println("+++++++++++ Cassandra");
                if (result == null || result != null && !result.equals(this.USER_KEEN_ID)) {
                    this.dlItems.updateUserKeenIo(this.USER_KEEN_ID);
                }
                this.isUserKeenIOSaved = true;
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
    }

    private void updateUserKeenIoCaisse() {
        if (this.dlItems != null && this.USER_KEEN_ID != null) {
            try {
                this.dlItems.updateUserKeenIo(this.USER_KEEN_ID);
                this.isUserKeenIOSaved = true;
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
    }

    private void readInfoUserLocal() {
        if (this.dlItems != null && this.USER_KEEN_ID == null && this.mOCassandraObject != null) {
            try {
                String result = this.dlItems.getUserKeenIo();
                System.out.println("+++++++++readInfoUserLocal()");
                if (result != null) {
                    this.USER_KEEN_ID = result;
                    this.isUserKeenIOSaved = true;
                } else {
                    User mUser = this.mOCassandraObject.readUserInfo();
                    if (mUser == null) {
                        MarqueNFC marqueNFC = MarqueNFC.fetchOrStore(AppLocal.dlSales);
                        mUser = this.mOCassandraObject.pushUserInfo(marqueNFC);
                    }
                    if (mUser != null) {
                        this.USER_KEEN_ID = mUser.getKeen_id();
                        this.updateUserKeenIoCaisse();
                    }
                }
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
    }

    private void pushOrderTypeAttributes(Map<String, Object> object, String orderType) {
        object.put("at_spot", 0);
        object.put("delivery", 0);
        object.put("take_away", 0);
        object.put("uber", 0);
        object.put("delivero", 0);
        object.put("just_eat", 0);
        switch (orderType) {
            case "Sur Place": {
                object.replace("at_spot", 1);
                break;
            }
            case "A Emporter": {
                object.replace("take_away", 1);
                break;
            }
            case "En Livraison": {
                object.replace("delivery", 1);
                break;
            }
            case "Uber Eats": {
                object.replace("uber", 1);
                break;
            }
            case "Delivero": {
                object.replace("delivero", 1);
                break;
            }
            case "Just Eat": {
                object.replace("just_eat", 1);
            }
        }
    }

    public void trackOrder(TicketInfo ticket) {
        System.out.println("trackOrder : " + ticket.getId());
        this.is_synchronizing = true;
        try {
            this.init();
            if (this.USER_KEEN_ID == null) {
                try {
                    this.readInfoUserLocal();
                }
                catch (Exception ex) {
                    LogToFile.log("severe", null, ex);
                }
            }
            if (!this.isUserKeenIOSaved) {
                this.updateUserKeenIoOrIgnore();
            }
            long licenceId = AppLocal.getLicenceId();
            if (this.dlItems != null && this.mOCassandraObject != null && ticket != null && this.USER_KEEN_ID != null && licenceId != -1L && this.isNetworkConnected()) {
                long timestamp = ticket.getM_dDate().getTime();
                try {
                    String sent_from = this.getSourceOrder(ticket);
                    System.out.println("+++++++++++++++++ sent_from+++++++++++++++++******************* : " + sent_from);
                    HashMap<String, Object> order = new HashMap<String, Object>();
                    order.put("keenio_user_id", this.USER_KEEN_ID);
                    order.put("procaisse_licence_id", licenceId);
                    order.put("order_id", ticket.getId());
                    order.put("timestamp", timestamp);
                    order.put("paid_at", ticket.getDatePaid() != null ? ticket.getDatePaid().getTime() : timestamp);
                    order.put("total", ticket.getTotal());
                    order.put("real_total", ticket.getRealTotal());
                    order.put("type", ticket.getType());
                    order.put("user_id", ticket.getUser().getId());
                    order.put("user_name", ticket.getUser().getName());
                    order.put("source_order", ticket.getOrdered_from());
                    order.put("discount", ticket.getDiscount());
                    order.put("label_discount", ticket.getLabel_discount());
                    order.put("type_discount", ticket.getTypeDiscount());
                    order.put("sent_from", sent_from);
                    this.pushOrderTypeAttributes(order, ticket.getType());
                    this.mOCassandraObject.writeEventMap(new Order(), order);
                    HashMap<String, Object> cachier = new HashMap<String, Object>();
                    cachier.put("keenio_user_id", this.USER_KEEN_ID);
                    cachier.put("procaisse_licence_id", licenceId);
                    cachier.put("order_id", ticket.getId());
                    cachier.put("order_type", ticket.getType());
                    cachier.put("user_id", ticket.getUser().getId());
                    cachier.put("name", ticket.getUser().getName());
                    cachier.put("total", ticket.getTotal());
                    cachier.put("timestamp", timestamp);
                    cachier.put("paid_at", ticket.getDatePaid() != null ? ticket.getDatePaid().getTime() : timestamp);
                    this.pushOrderTypeAttributes(cachier, ticket.getType());
                    this.mOCassandraObject.writeEventMap(new Cashier(), cachier);
                    for (PaymentInfo p : ticket.getPayments()) {
                        HashMap<String, Object> payment = new HashMap<String, Object>();
                        payment.put("keenio_user_id", this.USER_KEEN_ID);
                        payment.put("procaisse_licence_id", licenceId);
                        payment.put("order_id", ticket.getId());
                        payment.put("order_type", ticket.getType());
                        payment.put("name", p.getName());
                        payment.put("amount", p.getTotal());
                        payment.put("timestamp", timestamp);
                        payment.put("paid_at", ticket.getDatePaid() != null ? ticket.getDatePaid().getTime() : timestamp);
                        payment.put("source_order", ticket.getOrdered_from());
                        this.pushOrderTypeAttributes(payment, ticket.getType());
                        this.mOCassandraObject.writeEventMap(new Payment(), payment);
                    }
                    HashMap<Integer, Map> categories_products = new HashMap<Integer, Map>();
                    for (TicketLineInfo line : ticket.getLines()) {
                        HashMap<String, Object> item = new HashMap<String, Object>();
                        String itemToken = StringUtils.uuidTimestamp();
                        Map<String, Object> item_info = null;
                        try {
                            if (this.mCacheItems != null) {
                                item_info = this.mCacheItems.get(line.getProductID());
                            }
                            if (this.dlItems != null && item_info == null) {
                                item_info = this.dlItems.getItemInfoById(line.getProductID());
                                this.mCacheItems.put(line.getProductID(), item_info);
                            }
                        }
                        catch (Exception ex) {
                            LogToFile.log("severe", ex.getMessage(), ex);
                        }
                        item.put("item_uuid", itemToken);
                        item.put("keenio_user_id", this.USER_KEEN_ID);
                        item.put("procaisse_licence_id", licenceId);
                        item.put("order_id", ticket.getId());
                        item.put("order_type", ticket.getType());
                        item.put("timestamp", timestamp);
                        item.put("paid_at", ticket.getDatePaid() != null ? ticket.getDatePaid().getTime() : ticket.getM_dDate().getTime());
                        item.put("item_id", line.getProductID());
                        item.put("name", line.getNameProduct());
                        item.put("quantity", line.getMultiply());
                        item.put("price", line.getPriceProduct());
                        item.put("price_amount", line.getValueProduct());
                        item.put("ht_amount", line.getHtAmount());
                        item.put("ttc_amount", line.getPriceAfterDiscount());
                        item.put("tax_rate", line.getTaxRate());
                        item.put("tax_amount", line.getTax());
                        item.put("menu", line.isMenu());
                        item.put("discount", line.getValueDiscount());
                        item.put("label_discount", line.getLabelDiscount());
                        item.put("type_discount", line.getType_discount());
                        this.pushOrderTypeAttributes(item, ticket.getType());
                        if (item_info != null && item_info.containsKey("price_buy")) {
                            item.put("price_buy", item_info.get("price_buy"));
                        } else {
                            item.put("price_buy", 0.0);
                        }
                        HashMap<String, Object> category = new HashMap<String, Object>();
                        if (item_info != null && item_info.containsKey("category_name")) {
                            item.put("category_name", item_info.get("category_name"));
                            category.put("category_name", item_info.get("category_name"));
                        } else {
                            item.put("category_name", "");
                        }
                        if (item_info != null && item_info.containsKey("category_id")) {
                            item.put("category_id", item_info.get("category_id"));
                            category.put("category_id", item_info.get("category_id"));
                        } else {
                            item.put("category_id", 0);
                        }
                        if (category.size() > 0) {
                            category.put("keenio_user_id", this.USER_KEEN_ID);
                            category.put("procaisse_licence_id", licenceId);
                            category.put("order_id", ticket.getId());
                            category.put("order_type", ticket.getType());
                            category.put("timestamp", ticket.getM_dDate().getTime());
                            category.put("paid_at", ticket.getDatePaid() != null ? ticket.getDatePaid().getTime() : timestamp);
                            category.put("quantity", line.getMultiply());
                            category.put("amount", line.getPriceAfterDiscount());
                            this.pushOrderTypeAttributes(category, ticket.getType());
                            Integer k = (Integer)category.get("category_id");
                            if (categories_products.containsKey(k)) {
                                Map old = (Map)categories_products.get(k);
                                old.replace("quantity", (Double)old.get("quantity") + line.getMultiply());
                                old.replace("amount", (Double)old.get("amount") + line.getPriceAfterDiscount());
                                categories_products.replace(k, old);
                            } else {
                                categories_products.put((Integer)category.get("category_id"), category);
                            }
                        }
                        ArrayList options = new ArrayList();
                        for (OptionItemOrder opt : line.getListSupplements()) {
                            HashMap<String, Object> option = new HashMap<String, Object>();
                            Map<String, Object> option_info = null;
                            try {
                                if (this.mCacheOptions != null) {
                                    option_info = this.mCacheOptions.get(opt.getSupplement());
                                }
                                if (this.dlItems != null && option_info == null) {
                                    option_info = this.dlItems.getOptionInfoById(opt.getSupplement());
                                    this.mCacheOptions.put(opt.getSupplement(), option_info);
                                }
                            }
                            catch (Exception ex) {
                                LogToFile.log("severe", ex.getMessage(), ex);
                            }
                            option.put("item_uuid", itemToken);
                            option.put("keenio_user_id", this.USER_KEEN_ID);
                            option.put("procaisse_licence_id", licenceId);
                            option.put("order_id", ticket.getId());
                            option.put("order_type", ticket.getType());
                            option.put("timestamp", timestamp);
                            option.put("paid_at", ticket.getDatePaid() != null ? ticket.getDatePaid().getTime() : timestamp);
                            option.put("item_id", line.getProductID());
                            option.put("option_id", opt.getSupplement());
                            option.put("name", opt.getNameSupplement());
                            option.put("quantity", opt.getNumberOption());
                            option.put("price", opt.getPrice() / (double)(opt.getNumberOption() - opt.getNumber_free()));
                            option.put("amount", opt.getPrice());
                            option.put("amount_total", opt.getPrice() * line.getMultiply());
                            option.put("is_ingredient", false);
                            option.put("option_category_id", 0);
                            option.put("option_category_name", "");
                            option.put("quantity_total", (double)opt.getNumberOption() * line.getMultiply());
                            this.pushOrderTypeAttributes(option, ticket.getType());
                            if (option_info != null && option_info.containsKey("category_id") && option_info.containsKey("category_name")) {
                                HashMap<String, Object> option_category = new HashMap<String, Object>();
                                option_category.put("keenio_user_id", this.USER_KEEN_ID);
                                option_category.put("procaisse_licence_id", licenceId);
                                option_category.put("order_id", ticket.getId());
                                option_category.put("order_type", ticket.getType());
                                option_category.put("timestamp", timestamp);
                                option_category.put("paid_at", ticket.getDatePaid() != null ? ticket.getDatePaid().getTime() : timestamp);
                                option_category.put("category_id", option_info.get("category_id"));
                                option_category.put("category_name", option_info.get("category_name"));
                                option_category.put("quantity", (double)opt.getNumberOption() * line.getMultiply());
                                option_category.put("amount", opt.getPrice() * line.getMultiply());
                                this.pushOrderTypeAttributes(option_category, ticket.getType());
                                option.replace("option_category_id", option_info.get("category_id"));
                                option.replace("option_category_name", option_info.get("category_name"));
                                this.mOCassandraObject.writeEventMap(new OptionCategory(), option_category);
                            }
                            this.mOCassandraObject.writeEventMap(new Option(), option);
                        }
                        this.mOCassandraObject.writeEventMap(new OrderItem(), item);
                    }
                    for (Map.Entry entry : categories_products.entrySet()) {
                        Integer key = (Integer)entry.getKey();
                        Map value = (Map)entry.getValue();
                        this.mOCassandraObject.writeEventMap(new Category(), value);
                    }
                    System.out.println("+++++++++++++++ synchro ticket");
                    this.dlItems.setTicketSynchronized(ticket.getId(), true);
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            }
            this.is_synchronizing = false;
        }
        catch (Exception ex) {
            LogToFile.log("severe", null, ex);
        }
    }

    public void removeAttachedOrder(TicketInfo ticket, boolean isInflux) {
        try {
            this.init();
            if (this.USER_KEEN_ID == null) {
                try {
                    this.readInfoUserLocal();
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            }
            if (this.mOCassandraObject != null) {
                this.cancelOrder(ticket);
                boolean test = this.mOCassandraObject.existOrder(this.USER_KEEN_ID, ticket.getId());
                System.out.println("+++++++++++ test 1 : " + test);
                int result = this.mOCassandraObject.removeLines(this.USER_KEEN_ID, ticket.getId());
                boolean test2 = this.mOCassandraObject.existOrder(this.USER_KEEN_ID, ticket.getId());
                System.out.println("+++++++++++ test 2 : " + test2);
                if (this.dlItems != null && result == 0) {
                    try {
                        this.dlItems.unsetTicketSynchronized(ticket.getId(), false, true);
                    }
                    catch (Exception ex) {
                        LogToFile.log("severe", null, ex);
                    }
                }
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public String readUserInfoInflux() {
        block5: {
            try {
                System.out.println("++++++++++++++ test user cassandra");
                this.init();
                if (this.mOCassandraObject == null) break block5;
                try {
                    System.out.println("++++++++++++++ test 1 user cassandra");
                    User mUser = this.mOCassandraObject.readUserInfo();
                    System.out.println("++++++++ mUser : " + mUser);
                    if (mUser != null) {
                        this.USER_KEEN_ID = mUser.getKeen_id();
                        this.isUserKeenIOSaved = false;
                        return mUser.getKeen_id();
                    }
                }
                catch (Exception e) {
                    LogToFile.log("severe", null, e);
                }
            }
            catch (Exception ex) {
                LogToFile.log("severe", null, ex);
                return null;
            }
        }
        return null;
    }

    public void pushUserInfoInflux() {
        block5: {
            try {
                this.init();
                if (this.mOCassandraObject == null) break block5;
                try {
                    MarqueNFC marqueNFC = MarqueNFC.fetchOrStore(AppLocal.dlSales);
                    User mUser = this.mOCassandraObject.pushUserInfo(marqueNFC);
                    if (mUser != null) {
                        this.USER_KEEN_ID = mUser.getKeen_id();
                        this.isUserKeenIOSaved = false;
                    }
                }
                catch (Exception e) {
                    LogToFile.log("severe", null, e);
                }
            }
            catch (Exception ex) {
                LogToFile.log("severe", null, ex);
            }
        }
    }

    public void doSynchronize() {
        try {
            this.init();
            if (this.dlItems != null && this.isNetworkConnected() && this.mOCassandraObject != null) {
                List<String> mListIds = this.dlItems.loadOrderIdsNotSynchronized(500);
                if (!this.is_synchronizing) {
                    for (String mListId : mListIds) {
                        String string = mListId;
                        TicketInfo mTicketInfo = this.dlItems.fetchTicketNotSynchronized(string, true);
                        if (mTicketInfo == null) continue;
                        this.trackOrder(mTicketInfo);
                    }
                }
                List<TicketInfo> unattached = this.dlItems.loadOrderSynchronizedToUnattach();
                for (TicketInfo ticketInfo : unattached) {
                    this.removeAttachedOrder(ticketInfo, true);
                }
                List<TicketInfo> ticketsToVerify = this.dlItems.loadOrderSynchronizedToVerify();
                System.out.println("+++++++++++ ticketsToVerify : " + ticketsToVerify);
                if (ticketsToVerify != null && !ticketsToVerify.isEmpty()) {
                    System.out.println("++++++++++++ ticketsToVerify size : " + ticketsToVerify.size());
                    for (TicketInfo ticket : ticketsToVerify) {
                        this.verifyAttachedOrder(ticket, true);
                    }
                }
                List<TicketInfo> list = this.dlItems.loadOrderToSynchSource(500);
                System.out.println("+++++++++++ ticketsToSynchSource : " + list);
                if (list != null && !list.isEmpty()) {
                    System.out.println("++++++++++++ ticketsToSynchSource size : " + list.size());
                    System.out.println("++++++++++++++++ first*****************");
                    for (TicketInfo ticket : list) {
                        this.updateSourceOrder(ticket);
                    }
                    System.out.println("++++++++++++++++ end*****************");
                }
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", null, ex);
        }
    }

    public void clearCache() {
        if (this.mCacheItems != null) {
            this.mCacheItems.forceClean();
        }
        if (this.mCacheOptions != null) {
            this.mCacheOptions.forceClean();
        }
    }

    public void updatePaymentdOrder(TicketInfo ticket, boolean isInflux) {
        try {
            this.init();
            if (this.USER_KEEN_ID == null) {
                try {
                    this.readInfoUserLocal();
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            }
            if (this.mOCassandraObject != null && this.USER_KEEN_ID != null) {
                if (this.mOCassandraObject.existOrder(this.USER_KEEN_ID, ticket.getId())) {
                    this.mOCassandraObject.removePayments(this.USER_KEEN_ID, ticket.getId());
                    this.addPayment(ticket);
                } else {
                    this.trackOrder(ticket);
                }
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", null, ex);
        }
    }

    private void addPayment(TicketInfo ticket) {
        block5: {
            try {
                long timestamp = ticket.getM_dDate().getTime();
                long licenceId = AppLocal.getLicenceId();
                if (!this.isNetworkConnected()) break block5;
                try {
                    for (PaymentInfo p : ticket.getPayments()) {
                        HashMap<String, Object> payment = new HashMap<String, Object>();
                        payment.put("keenio_user_id", this.USER_KEEN_ID);
                        payment.put("procaisse_licence_id", licenceId);
                        payment.put("order_id", ticket.getId());
                        payment.put("order_type", ticket.getType());
                        payment.put("name", p.getName());
                        payment.put("amount", p.getTotal());
                        payment.put("timestamp", timestamp);
                        payment.put("paid_at", ticket.getDatePaid() != null ? ticket.getDatePaid().getTime() : timestamp);
                        this.pushOrderTypeAttributes(payment, ticket.getType());
                        this.mOCassandraObject.writeEventMap(new Payment(), payment);
                    }
                }
                catch (ParseException ex) {
                    LogToFile.log("severe", null, ex);
                }
            }
            catch (Exception ex) {
                LogToFile.log("severe", null, ex);
            }
        }
    }

    public void cancelOrder(TicketInfo ticket) {
        System.out.println("cancelOrder : " + ticket.getId());
        System.out.println("+++++++ ticket.getTotalOrder() : " + ticket.getTotalOrder());
        try {
            long licenceId = AppLocal.getLicenceId();
            if (this.mOCassandraObject != null && ticket != null && this.USER_KEEN_ID != null && licenceId != -1L && this.isNetworkConnected()) {
                try {
                    long timestamp = ticket.getM_dDate().getTime();
                    HashMap<String, Object> annulation = new HashMap<String, Object>();
                    annulation.put("keenio_user_id", this.USER_KEEN_ID);
                    annulation.put("procaisse_licence_id", licenceId);
                    annulation.put("order_id", ticket.getId());
                    annulation.put("timestamp", timestamp);
                    annulation.put("paid_at", ticket.getDatePaid() != null ? ticket.getDatePaid().getTime() : timestamp);
                    annulation.put("amount", ticket.getTotalOrder());
                    annulation.put("order_type", ticket.getType());
                    this.pushOrderTypeAttributes(annulation, ticket.getType());
                    this.mOCassandraObject.writeEventMap(new Annulation(), annulation);
                }
                catch (ParseException ex) {
                    Logger.getLogger(CassandraManager.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", null, ex);
        }
    }

    public void suiviOrderKitchen(String order_id, Long date_start, Long date_end, Long closing_time, Long preparation_time, int number_products) {
        try {
            this.init();
            if (this.USER_KEEN_ID == null) {
                try {
                    this.readInfoUserLocal();
                }
                catch (Exception ex) {
                    LogToFile.log("severe", null, ex);
                }
            }
            if (!this.isUserKeenIOSaved) {
                this.updateUserKeenIoOrIgnore();
            }
            long licenceId = AppLocal.getLicenceId();
            if (this.dlItems != null && this.mOCassandraObject != null && this.USER_KEEN_ID != null && licenceId != -1L && this.isNetworkConnected()) {
                HashMap<String, Object> suivi = new HashMap<String, Object>();
                suivi.put("keenio_user_id", this.USER_KEEN_ID);
                suivi.put("procaisse_licence_id", licenceId);
                suivi.put("numero_commande", order_id);
                suivi.put("date_debut", date_start);
                suivi.put("date_fin", date_end);
                suivi.put("duree_close", closing_time);
                suivi.put("duree_ready", preparation_time);
                suivi.put("number_products", number_products);
                this.mOCassandraObject.writeEventMap(new Suivi(), suivi);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            LogToFile.log("severe", null, ex);
        }
    }

    public void closeOrderKitchen(Long date_start, Long preparation_time, int number_products, String order_id, Long date_end, Long closing_time) {
        try {
            this.init();
            if (this.USER_KEEN_ID == null) {
                try {
                    this.readInfoUserLocal();
                }
                catch (Exception ex) {
                    LogToFile.log("severe", null, ex);
                }
            }
            if (!this.isUserKeenIOSaved) {
                this.updateUserKeenIoOrIgnore();
            }
            long licenceId = AppLocal.getLicenceId();
            if (this.dlItems != null && this.mOCassandraObject != null && this.USER_KEEN_ID != null && licenceId != -1L && this.isNetworkConnected()) {
                Suivi suiviOrder = this.mOCassandraObject.findByIdOrderAndUserKeen(this.USER_KEEN_ID, order_id);
                if (suiviOrder != null) {
                    this.mOCassandraObject.updateSuiviOrder(suiviOrder, this.USER_KEEN_ID, order_id, date_end, closing_time);
                } else {
                    HashMap<String, Object> suivi = new HashMap<String, Object>();
                    suivi.put("keenio_user_id", this.USER_KEEN_ID);
                    suivi.put("procaisse_licence_id", licenceId);
                    suivi.put("numero_commande", order_id);
                    suivi.put("date_debut", date_start);
                    suivi.put("date_fin", date_end);
                    suivi.put("duree_close", closing_time);
                    suivi.put("duree_ready", preparation_time);
                    suivi.put("number_products", number_products);
                    this.mOCassandraObject.writeEventMap(new Suivi(), suivi);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            LogToFile.log("severe", null, ex);
        }
    }

    public void setSynchronizing() {
        this.is_synchronizing = true;
    }

    public void verifyAttachedOrder(TicketInfo ticket, boolean isInflux) {
        try {
            this.init();
            if (this.USER_KEEN_ID == null) {
                try {
                    this.readInfoUserLocal();
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            }
            if (this.mOCassandraObject != null) {
                boolean verify = true;
                if (this.mOCassandraObject.existOrder(this.USER_KEEN_ID, ticket.getId())) {
                    System.out.println("++++++++++++++++ exist : " + ticket.getId());
                    this.cancelOrder(ticket);
                    int result = this.mOCassandraObject.removeLines(this.USER_KEEN_ID, ticket.getId());
                    verify = result == 0;
                } else {
                    System.out.println("++++++++++ dont exist : " + ticket.getId());
                }
                if (this.dlItems != null && verify) {
                    try {
                        this.dlItems.unsetTicketSynchronized(ticket.getId(), false, true);
                    }
                    catch (Exception ex) {
                        LogToFile.log("severe", null, ex);
                    }
                }
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private String getSourceOrder(TicketInfo ticket) {
        if (ticket.getOrdered_from() != null && ticket.getOrdered_from().equals("inside")) {
            if (AppLocal.modeCaisse != null && AppLocal.modeCaisse.equals("Caisse")) {
                if (ticket.getType() != null && ticket.getType().equalsIgnoreCase("Drive")) {
                    return "Drive";
                }
                return "caisse";
            }
            return "borne cb";
        }
        if (ticket.getSent_from() != null) {
            switch (ticket.getSent_from()) {
                case "borne": {
                    return "borne";
                }
                case "web": {
                    return "online";
                }
                case "Uber Eats": {
                    return "Uber Eats";
                }
            }
        }
        return "";
    }

    public void updateSourceOrder(TicketInfo ticket) {
        try {
            Order order;
            this.init();
            if (this.USER_KEEN_ID == null) {
                try {
                    this.readInfoUserLocal();
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            }
            if (this.mOCassandraObject != null && (order = this.mOCassandraObject.getOrder(this.USER_KEEN_ID, ticket.getId())) != null) {
                String source = this.getSourceOrder(ticket);
                this.mOCassandraObject.updateSourceOrder(this.USER_KEEN_ID, order, ticket.getId(), source);
                if (this.dlItems != null) {
                    try {
                        this.dlItems.setSourceOrderSynchronized(ticket.getId());
                    }
                    catch (Exception ex) {
                        LogToFile.log("severe", null, ex);
                    }
                }
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }
}

