/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.events;

import java.util.Date;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.scene.input.MouseDragEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;

public class EventScrollToSwipePane
implements EventHandler {
    private double lastYposition = 0.0;
    private double lastXposition = 0.0;
    private long lastTimePressed = 0L;

    public void handle(Event event) {
        Object text = "";
        String eventType = event.getEventType().toString();
        MouseEvent m_event = null;
        MouseDragEvent m_dragEvent = null;
        if (event instanceof MouseEvent) {
            m_event = (MouseEvent)event;
        } else if (event instanceof MouseDragEvent) {
            m_dragEvent = (MouseDragEvent)event;
        }
        switch (eventType) {
            case "MOUSE_CLICKED": {
                text = "Mouse Clicked";
                if (m_event == null) break;
                long l = new Date().getTime();
                break;
            }
            case "MOUSE_ENTERED": {
                text = "Mouse entedered";
                break;
            }
            case "MOUSE_EXITED": {
                text = "Mouse exited";
                break;
            }
            case "MOUSE_DRAGGED": {
                text = "Mouse dragged";
                break;
            }
            case "MOUSE_MOVED": {
                text = "Mouse mouved";
                break;
            }
            case "MOUSE_RELEASED": {
                long currentReleased;
                text = "Mouse releasead";
                if (m_event == null || (currentReleased = new Date().getTime()) - this.lastTimePressed <= 100L) break;
                this.dispatchEventScroll(m_event.getSource(), m_event.getTarget(), m_event.getSceneX(), m_event.getSceneY());
                break;
            }
            case "MOUSE_PRESSED": {
                text = "Mouse pressed";
                if (m_event == null) break;
                this.lastYposition = m_event.getSceneY();
                this.lastXposition = m_event.getSceneX();
                this.lastTimePressed = new Date().getTime();
                break;
            }
            default: {
                text = "Evento desconhecido: " + eventType;
            }
        }
    }

    private void dispatchEventScroll(Object source, EventTarget target, double newXposition, double newYposition) {
        double deltaY = newYposition - this.lastYposition;
        double deltaX = newXposition - this.lastXposition;
        this.lastYposition = newYposition;
        this.lastXposition = newXposition;
        ScrollEvent newScrollEvent = new ScrollEvent(source, target, ScrollEvent.SCROLL, 0.0, 0.0, 0.0, 0.0, false, false, false, false, false, false, deltaX, deltaY, 0.0, 0.0, ScrollEvent.HorizontalTextScrollUnits.CHARACTERS, deltaX, ScrollEvent.VerticalTextScrollUnits.NONE, deltaY, 0, null);
        Event.fireEvent((EventTarget)target, (Event)newScrollEvent);
    }
}

