/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.events;

import com.openbravo.events.CustomBasketScrollEvent;
import com.openbravo.models.DriveHBoxBorne;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.scene.Node;
import javafx.scene.control.ListCell;
import javafx.scene.input.MouseEvent;

public class DriveBasketListBorne
extends ListCell<DriveHBoxBorne> {
    private double lastYposition = 0.0;

    public DriveBasketListBorne() {
        this.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                DriveBasketListBorne.this.lastYposition = event.getSceneY();
                if (DriveBasketListBorne.this.isEmpty()) {
                    event.consume();
                }
            }
        });
        this.setOnMouseDragged((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                double newYposition = event.getSceneY();
                double diff = newYposition - DriveBasketListBorne.this.lastYposition;
                DriveBasketListBorne.this.lastYposition = newYposition;
                CustomBasketScrollEvent cse = new CustomBasketScrollEvent();
                cse.fireVerticalScroll((int)diff, (Object)DriveBasketListBorne.this, (EventTarget)event.getSource());
            }
        });
    }

    protected void updateItem(DriveHBoxBorne item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (item != null && !empty) {
            this.setGraphic((Node)item);
        }
        if (empty) {
            this.setGraphic(null);
        }
    }
}

