/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.events;

import com.openbravo.components.OrderCell;
import com.openbravo.events.CustomBasketScrollEvent;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.scene.Node;
import javafx.scene.control.ListCell;
import javafx.scene.input.MouseEvent;

public class CustomOrderListCell
extends ListCell<OrderCell> {
    private double lastYposition = 0.0;

    public CustomOrderListCell() {
        this.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                CustomOrderListCell.this.lastYposition = event.getSceneY();
                if (CustomOrderListCell.this.isEmpty()) {
                    event.consume();
                }
            }
        });
        this.setOnMouseDragged((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                double newYposition = event.getSceneY();
                double diff = newYposition - CustomOrderListCell.this.lastYposition;
                CustomOrderListCell.this.lastYposition = newYposition;
                CustomBasketScrollEvent cse = new CustomBasketScrollEvent();
                cse.fireVerticalScroll((int)diff, (Object)CustomOrderListCell.this, (EventTarget)event.getSource());
            }
        });
    }

    protected void updateItem(OrderCell item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (item != null && !empty) {
            this.setGraphic((Node)item);
        }
        if (empty) {
            this.setGraphic(null);
        }
    }
}

