/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.events;

import com.openbravo.events.CustomBasketScrollEvent;
import com.openbravo.models.HBoxItemsLater;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.scene.Node;
import javafx.scene.control.ListCell;
import javafx.scene.input.MouseEvent;

public class CustomListItemsLater
extends ListCell<HBoxItemsLater> {
    private double lastYposition = 0.0;

    public CustomListItemsLater() {
        this.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                CustomListItemsLater.this.lastYposition = event.getSceneY();
                if (CustomListItemsLater.this.isEmpty()) {
                    event.consume();
                }
            }
        });
        this.setOnMouseDragged((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                double newYposition = event.getSceneY();
                double diff = newYposition - CustomListItemsLater.this.lastYposition;
                CustomListItemsLater.this.lastYposition = newYposition;
                CustomBasketScrollEvent cse = new CustomBasketScrollEvent();
                cse.fireVerticalScroll((int)diff, (Object)CustomListItemsLater.this, (EventTarget)event.getSource());
            }
        });
    }

    protected void updateItem(HBoxItemsLater item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (item != null && !empty) {
            this.setGraphic((Node)item);
        }
        if (empty) {
            this.setGraphic(null);
        }
    }
}

