/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.events;

import com.openbravo.components.CheckBoxCell;
import com.openbravo.events.CustomBasketScrollEvent;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.scene.Node;
import javafx.scene.control.ListCell;
import javafx.scene.input.MouseEvent;

public class CustomCheckBoxListCell
extends ListCell<CheckBoxCell> {
    private double lastYposition = 0.0;

    public CustomCheckBoxListCell() {
        this.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                CustomCheckBoxListCell.this.lastYposition = event.getSceneY();
                if (CustomCheckBoxListCell.this.isEmpty()) {
                    event.consume();
                }
            }
        });
        this.setOnMouseDragged((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                double newYposition = event.getSceneY();
                double diff = newYposition - CustomCheckBoxListCell.this.lastYposition;
                CustomCheckBoxListCell.this.lastYposition = newYposition;
                CustomBasketScrollEvent cse = new CustomBasketScrollEvent();
                cse.fireVerticalScroll((int)diff, (Object)CustomCheckBoxListCell.this, (EventTarget)event.getSource());
            }
        });
    }

    protected void updateItem(CheckBoxCell item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (item != null && !empty) {
            this.setGraphic((Node)item);
        }
        if (empty) {
            this.setGraphic(null);
        }
    }
}

