/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.events;

import com.openbravo.components.CatalogGrouItems;
import com.openbravo.events.CustomBasketScrollEvent;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.scene.Node;
import javafx.scene.control.ListCell;
import javafx.scene.input.MouseEvent;

public class CustomCatalogGroupOptions
extends ListCell<CatalogGrouItems> {
    private double lastYposition = 0.0;

    public CustomCatalogGroupOptions() {
        this.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                CustomCatalogGroupOptions.this.lastYposition = event.getSceneY();
                if (CustomCatalogGroupOptions.this.isEmpty()) {
                    event.consume();
                }
            }
        });
        this.setOnMouseDragged((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                double newYposition = event.getSceneY();
                double diff = newYposition - CustomCatalogGroupOptions.this.lastYposition;
                CustomCatalogGroupOptions.this.lastYposition = newYposition;
                CustomBasketScrollEvent cse = new CustomBasketScrollEvent();
                cse.fireVerticalScroll((int)diff, (Object)CustomCatalogGroupOptions.this, (EventTarget)event.getSource());
            }
        });
    }

    protected void updateItem(CatalogGrouItems item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (item != null && !empty) {
            this.setGraphic((Node)item);
        }
        if (empty) {
            this.setGraphic(null);
        }
    }
}

