/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.events;

import com.openbravo.animation.AnimationNode;
import com.openbravo.animation.AnimationPack;
import com.openbravo.animation.AnimationType;
import com.openbravo.animation.AnimationsUtils;
import com.openbravo.components.CatalogCatagory;
import com.openbravo.events.CustomBasketScrollEvent;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.util.AppVarUtils;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.scene.Node;
import javafx.scene.control.ListCell;
import javafx.scene.input.MouseEvent;

public class CustomCatalogCategories
extends ListCell<CatalogCatagory> {
    private double lastYposition = 0.0;
    protected AnimationType[] types = new AnimationType[]{AnimationType.TRANSITION_TOP};
    private List<CatalogCatagory> listItems;
    private final int max_line = (int)(AppVarUtils.getScreenDimension().getHeight() * 0.6 / 160.0);
    protected AnimationNode anim;

    public CustomCatalogCategories(List<CatalogCatagory> items) {
        this.listItems = items;
        this.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                CustomCatalogCategories.this.lastYposition = event.getSceneY();
            }
        });
        this.setOnMouseDragged((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                int indexCell = ((CatalogCatagory)((Object)((CustomCatalogCategories)((Object)event.getSource())).getChildren().get(0))).getIndexLine();
                boolean change = false;
                if (change) {
                    Collections.sort(CustomCatalogCategories.this.listItems, new Comparator<CatalogCatagory>(){

                        @Override
                        public int compare(CatalogCatagory items1, CatalogCatagory items2) {
                            return items1.getIndexLine() - items2.getIndexLine();
                        }
                    });
                }
                double newYposition = event.getSceneY();
                double diff = newYposition - CustomCatalogCategories.this.lastYposition;
                AppLocal.step_drag.add(Math.abs(diff));
                CustomCatalogCategories.this.lastYposition = newYposition;
                AppLocal.diff_drag += (int)diff;
                CustomBasketScrollEvent cse = new CustomBasketScrollEvent();
                AppLocal.lastEventCatalog = (EventTarget)event.getSource();
                cse.fireVerticalScroll((int)diff, (Object)CustomCatalogCategories.this, AppLocal.lastEventCatalog);
            }
        });
    }

    protected void updateItem(CatalogCatagory item, boolean empty) {
        Object[] f;
        super.updateItem((Object)item, empty);
        if (item != null && !empty) {
            this.setGraphic((Node)item);
        }
        if (empty) {
            this.setGraphic(null);
        }
        this.anim = new AnimationPack((Node)this);
        if (this.anim.getKeyFrames().isEmpty() && (f = AnimationsUtils.getKeyFrames(this.types, this.anim)) != null) {
            this.anim.getKeyFrames().addAll(f);
        }
    }
}

