/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.events;

import com.openbravo.components.HBoxCell;
import com.openbravo.events.CustomBasketScrollEvent;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.scene.Node;
import javafx.scene.control.ListCell;
import javafx.scene.input.MouseEvent;

public class CustomBasketListCell
extends ListCell<HBoxCell> {
    private double lastYposition = 0.0;

    public CustomBasketListCell() {
        this.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                CustomBasketListCell.this.lastYposition = event.getSceneY();
                if (CustomBasketListCell.this.isEmpty()) {
                    event.consume();
                }
            }
        });
        this.setOnMouseDragged((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                double newYposition = event.getSceneY();
                double diff = newYposition - CustomBasketListCell.this.lastYposition;
                CustomBasketListCell.this.lastYposition = newYposition;
                CustomBasketScrollEvent cse = new CustomBasketScrollEvent();
                cse.fireVerticalScroll((int)diff, (Object)CustomBasketListCell.this, (EventTarget)event.getSource());
            }
        });
    }

    protected void updateItem(HBoxCell item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (item != null && !empty) {
            this.setGraphic((Node)item);
        }
        if (empty) {
            this.setGraphic(null);
        }
    }
}

