/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.data.gui;

import com.openbravo.basic.BasicException;
import com.openbravo.data.gui.MessageInf;
import com.openbravo.data.loader.LocalRes;
import com.openbravo.data.user.BrowsableEditableData;
import com.openbravo.data.user.StateListener;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class JSaver
extends JPanel
implements StateListener {
    protected BrowsableEditableData m_bd;
    private JSeparator jSeparator1;
    private JButton jbtnDelete;
    private JButton jbtnNew;
    private JButton jbtnSave;

    public JSaver(BrowsableEditableData bd) {
        this.initComponents();
        this.m_bd = bd;
        this.m_bd.addStateListener(this);
    }

    @Override
    public void updateState(int iState) {
        switch (iState) {
            case 3: {
                this.jbtnNew.setEnabled(this.m_bd.canInsertData());
                this.jbtnDelete.setEnabled(false);
                this.jbtnSave.setEnabled(this.m_bd.canInsertData());
                break;
            }
            case 2: {
                this.jbtnNew.setEnabled(this.m_bd.canInsertData());
                this.jbtnDelete.setEnabled(false);
                this.jbtnSave.setEnabled(this.m_bd.canDeleteData());
                break;
            }
            case 0: {
                this.jbtnNew.setEnabled(this.m_bd.canInsertData());
                this.jbtnDelete.setEnabled(false);
                this.jbtnSave.setEnabled(false);
                break;
            }
            case 1: {
                this.jbtnNew.setEnabled(this.m_bd.canInsertData());
                this.jbtnDelete.setEnabled(this.m_bd.canDeleteData());
                this.jbtnSave.setEnabled(this.m_bd.canUpdateData());
            }
        }
    }

    private void initComponents() {
        this.jbtnNew = new JButton();
        this.jbtnDelete = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jbtnSave = new JButton();
        this.setLayout(new FlowLayout(0));
        this.jbtnNew.setIcon(new ImageIcon(this.getClass().getResource("/com/openbravo/images/editnew.png")));
        this.jbtnNew.setToolTipText("Add New");
        this.jbtnNew.setFocusPainted(false);
        this.jbtnNew.setFocusable(false);
        this.jbtnNew.setMargin(new Insets(2, 8, 2, 8));
        this.jbtnNew.setRequestFocusEnabled(false);
        this.jbtnNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSaver.this.jbtnNewActionPerformed(evt);
            }
        });
        this.add(this.jbtnNew);
        this.jbtnDelete.setIcon(new ImageIcon(this.getClass().getResource("/com/openbravo/images/sale_delete.png")));
        this.jbtnDelete.setToolTipText("Delete");
        this.jbtnDelete.setFocusPainted(false);
        this.jbtnDelete.setFocusable(false);
        this.jbtnDelete.setMargin(new Insets(2, 8, 2, 8));
        this.jbtnDelete.setRequestFocusEnabled(false);
        this.jbtnDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSaver.this.jbtnDeleteActionPerformed(evt);
            }
        });
        this.add(this.jbtnDelete);
        this.add(this.jSeparator1);
        this.jbtnSave.setIcon(new ImageIcon(this.getClass().getResource("/com/openbravo/images/filesave.png")));
        this.jbtnSave.setToolTipText("Save");
        this.jbtnSave.setFocusPainted(false);
        this.jbtnSave.setFocusable(false);
        this.jbtnSave.setMargin(new Insets(2, 8, 2, 8));
        this.jbtnSave.setRequestFocusEnabled(false);
        this.jbtnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSaver.this.jbtnSaveActionPerformed(evt);
            }
        });
        this.add(this.jbtnSave);
    }

    private void jbtnSaveActionPerformed(ActionEvent evt) {
        try {
            this.m_bd.saveData();
        }
        catch (BasicException eD) {
            MessageInf msg = new MessageInf(-67108864, LocalRes.getIntString("message.nosave"), eD);
            msg.show(this);
        }
    }

    private void jbtnDeleteActionPerformed(ActionEvent evt) {
        try {
            this.m_bd.actionDelete();
        }
        catch (BasicException eD) {
            MessageInf msg = new MessageInf(-67108864, LocalRes.getIntString("message.nodelete"), eD);
            msg.show(this);
        }
    }

    private void jbtnNewActionPerformed(ActionEvent evt) {
        try {
            this.m_bd.actionInsert();
        }
        catch (BasicException eD) {
            MessageInf msg = new MessageInf(-67108864, LocalRes.getIntString("message.nonew"), eD);
            msg.show(this);
        }
    }
}

