/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.data.gui;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public abstract class ButtonEditor
extends DefaultCellEditor
implements ActionListener {
    private static final long serialVersionUID = 1L;
    protected int row;
    protected int column;
    protected JTable table;
    protected JButton button;
    protected JPanel panel = new JPanel(new GridBagLayout());

    public ButtonEditor() {
        super(new JCheckBox());
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.row = row;
        this.column = column;
        this.table = table;
        this.button = (JButton)value;
        if (this.button.getActionListeners().length == 0) {
            this.button.addActionListener(this);
        }
        this.panel.add(this.button);
        this.panel.setBackground(table.getGridColor());
        return this.panel;
    }

    public static TableCellRenderer getRenderer() {
        return new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JPanel panel = new JPanel(new GridBagLayout());
                panel.add((JButton)value);
                panel.setBackground(table.getGridColor());
                return panel;
            }
        };
    }
}

