/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.dao;

import com.openbravo.basic.BasicException;
import com.openbravo.data.loader.SerializerRead;
import com.openbravo.data.loader.SerializerReadBasic;
import com.openbravo.data.loader.SerializerReadBoolean;
import com.openbravo.data.loader.SerializerReadBytes;
import com.openbravo.data.loader.SerializerReadInteger;
import com.openbravo.data.loader.SerializerReadString;
import com.openbravo.data.loader.SerializerWrite;
import com.openbravo.data.loader.SerializerWriteBasic;
import com.openbravo.data.loader.SerializerWriteBasicExt;
import com.openbravo.data.loader.SerializerWriteInteger;
import com.openbravo.data.loader.SerializerWriteParams;
import com.openbravo.data.loader.SerializerWriteString;
import com.openbravo.format.Formats;
import com.openbravo.pos.admin.User;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.AppUser;
import com.openbravo.pos.forms.BeanFactoryDataSingle;
import com.openbravo.pos.ticket.Borne;
import com.openbravo.pos.ticket.MarqueNFC;
import com.openbravo.pos.util.InfoAvomark;
import com.openbravo.pos.util.InfoQoodos;
import com.openbravo.pos.util.LogToFile;
import com.procaisse.avomark.AvomarkService;
import com.procaisse.db.connection.Session;
import com.procaisse.db.metadata.DataParams;
import com.procaisse.db.metadata.DataRead;
import com.procaisse.db.metadata.Datas;
import com.procaisse.db.sql.PreparedSentence;
import com.procaisse.db.sql.SentenceExec;
import com.procaisse.db.sql.SentenceFind;
import com.procaisse.db.sql.SentenceList;
import com.procaisse.db.sql.StaticSentence;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import javax.imageio.ImageIO;

public class DataLogicSystem
extends BeanFactoryDataSingle {
    protected String m_sInitScript;
    private SentenceFind m_version;
    private SentenceFind m_soft_version;
    private SentenceFind m_tokenByLocalToken;
    private SentenceFind m_token;
    private SentenceFind status_borne;
    private SentenceExec m_dummy;
    private String m_dbVersion;
    protected SentenceList m_peoplevisible;
    protected SentenceFind m_peoplebycard;
    protected SerializerRead peopleread;
    protected SentenceList m_permissionlist;
    protected SerializerRead productIdRead;
    private SentenceFind m_rolepermissions;
    private SentenceExec m_changepassword;
    private SentenceFind m_locationfind;
    private SentenceExec m_insertCSVEntry;
    private SentenceFind m_getProductAllFields;
    private SentenceFind m_getProductRefAndCode;
    private SentenceFind m_getProductRefAndName;
    private SentenceFind m_getProductCodeAndName;
    private SentenceFind m_getProductByReference;
    private SentenceFind m_getProductByCode;
    private SentenceFind m_getProductByName;
    private SentenceFind m_resourcebytes;
    private SentenceExec m_resourcebytesinsert;
    private SentenceExec m_resourcebytesupdate;
    protected SentenceFind m_sequencecash;
    protected SentenceFind m_activecash;
    protected SentenceExec m_insertcash;
    protected SentenceExec m_draweropened;
    protected SentenceExec m_updatepermissions;
    protected SentenceExec m_lineremoved;
    protected SentenceExec m_insertMarque;
    protected PreparedSentence m_getMarqueNF;
    protected PreparedSentence m_getInfoQoodos;
    protected SentenceExec m_upgradeSoftware;
    protected SentenceExec m_insertInfoQoodos;
    protected SentenceExec m_updateInfoQoodos;
    protected SentenceExec m_insertTokenQoodos;
    protected SentenceExec changeStatusBorne;
    protected PreparedSentence m_getInfoAvomark;
    protected SentenceExec m_updateInfoAvomark;
    protected SentenceExec m_insertInfoAvomark;
    private String SQL;
    private Map<String, byte[]> resourcescache;
    private Session s;
    private String requestUser;

    @Override
    public void init(Session s) {
        this.s = s;
        this.m_sInitScript = "/com/openbravo/pos/scripts/" + s.DB.getName();
        this.m_dbVersion = s.DB.getName();
        this.m_version = new PreparedSentence(s, "SELECT VERSION FROM APPLICATIONS WHERE ID = ?", SerializerWriteString.INSTANCE, SerializerReadString.INSTANCE);
        this.m_soft_version = new PreparedSentence(s, "SELECT SOFTWARE_VERSION FROM SOFTWARE WHERE NAME = ? order by ID DESC ", SerializerWriteString.INSTANCE, SerializerReadString.INSTANCE);
        this.m_tokenByLocalToken = new PreparedSentence(s, "SELECT token FROM caisse WHERE token = ?", SerializerWriteString.INSTANCE, SerializerReadString.INSTANCE);
        this.m_token = new PreparedSentence(s, "SELECT token FROM caisse order by ID desc fetch first 1 rows only ", null, SerializerReadString.INSTANCE);
        this.m_dummy = new StaticSentence(s, "SELECT * FROM PEOPLE WHERE 1 = 0");
        this.peopleread = new SerializerRead(){

            @Override
            public Object readValues(DataRead dr) throws BasicException {
                return new AppUser(dr.getString(1), dr.getString(2), dr.getString(3), dr.getString(4), dr.getInt(5));
            }
        };
        this.productIdRead = new SerializerRead(){

            @Override
            public String readValues(DataRead dr) throws BasicException {
                return dr.getString(1);
            }
        };
        this.m_getProductAllFields = new PreparedSentence(s, "SELECT ID FROM PRODUCTS WHERE REFERENCE=? AND CODE=? AND NAME=? ", new SerializerWriteBasic(Datas.STRING, Datas.STRING, Datas.STRING), this.productIdRead);
        this.m_getProductRefAndCode = new PreparedSentence(s, "SELECT ID FROM PRODUCTS WHERE REFERENCE=? AND CODE=?", new SerializerWriteBasic(Datas.STRING, Datas.STRING), this.productIdRead);
        this.m_getProductRefAndName = new PreparedSentence(s, "SELECT ID FROM PRODUCTS WHERE REFERENCE=? AND NAME=? ", new SerializerWriteBasic(Datas.STRING, Datas.STRING), this.productIdRead);
        this.m_getProductCodeAndName = new PreparedSentence(s, "SELECT ID FROM PRODUCTS WHERE CODE=? AND NAME=? ", new SerializerWriteBasic(Datas.STRING, Datas.STRING), this.productIdRead);
        this.m_getProductByReference = new PreparedSentence(s, "SELECT ID FROM PRODUCTS WHERE REFERENCE=? ", SerializerWriteString.INSTANCE, this.productIdRead);
        this.m_getProductByCode = new PreparedSentence(s, "SELECT ID FROM PRODUCTS WHERE CODE=? ", SerializerWriteString.INSTANCE, this.productIdRead);
        this.m_getProductByName = new PreparedSentence(s, "SELECT ID FROM PRODUCTS WHERE NAME=? ", SerializerWriteString.INSTANCE, this.productIdRead);
        this.m_peoplevisible = new StaticSentence(s, "SELECT ID, NAME, APPPASSWORD, ROLE FROM PEOPLE WHERE hidden = 0 AND ROLE <> '3' ORDER BY ID", null, this.peopleread);
        this.m_peoplebycard = new PreparedSentence(s, "SELECT ID, NAME, APPPASSWORD, CARD, ROLE, IMAGE FROM PEOPLE WHERE CARD = ? AND VISIBLE = " + s.DB.TRUE(), SerializerWriteString.INSTANCE, this.peopleread);
        this.m_resourcebytes = new PreparedSentence(s, "SELECT CONTENT FROM RESOURCES WHERE NAME = ?", SerializerWriteString.INSTANCE, SerializerReadBytes.INSTANCE);
        Datas[] resourcedata = new Datas[]{Datas.STRING, Datas.STRING, Datas.INT, Datas.BYTES};
        this.m_resourcebytesinsert = new PreparedSentence(s, "INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES (?, ?, ?, ?)", new SerializerWriteBasic(resourcedata));
        this.m_resourcebytesupdate = new PreparedSentence(s, "UPDATE RESOURCES SET NAME = ?, RESTYPE = ?, CONTENT = ? WHERE NAME = ?", new SerializerWriteBasicExt(resourcedata, new int[]{1, 2, 3, 1}));
        this.m_rolepermissions = new PreparedSentence(s, "SELECT PERMISSIONS FROM ROLES WHERE ID = ?", SerializerWriteString.INSTANCE, SerializerReadBytes.INSTANCE);
        this.m_changepassword = new StaticSentence(s, "UPDATE PEOPLE SET APPPASSWORD = ? WHERE ID = ?", (SerializerWrite)new SerializerWriteBasic(Datas.STRING, Datas.STRING));
        this.m_sequencecash = new StaticSentence(s, "SELECT MAX(HOSTSEQUENCE) FROM CLOSEDCASH WHERE HOST = ?", SerializerWriteString.INSTANCE, SerializerReadInteger.INSTANCE);
        this.m_activecash = new StaticSentence(s, "SELECT HOST, HOSTSEQUENCE, DATESTART, DATEEND, NOSALES FROM CLOSEDCASH WHERE MONEY = ?", SerializerWriteString.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.STRING, Datas.INT, Datas.TIMESTAMP, Datas.TIMESTAMP, Datas.INT}));
        this.m_insertcash = new StaticSentence(s, "INSERT INTO CLOSEDCASH(MONEY, HOST, HOSTSEQUENCE, DATESTART, DATEEND) VALUES (?, ?, ?, ?, ?)", (SerializerWrite)new SerializerWriteBasic(Datas.STRING, Datas.STRING, Datas.INT, Datas.TIMESTAMP, Datas.TIMESTAMP));
        this.m_draweropened = new StaticSentence(s, "INSERT INTO DRAWEROPENED ( NAME, TICKETID) VALUES (?, ?)", (SerializerWrite)new SerializerWriteBasic(Datas.STRING, Datas.STRING));
        this.m_lineremoved = new StaticSentence(s, "INSERT INTO LINEREMOVED (NAME, TICKETID, PRODUCTID, PRODUCTNAME, UNITS) VALUES (?, ?, ?, ?, ?)", (SerializerWrite)new SerializerWriteBasic(Datas.STRING, Datas.STRING, Datas.INT, Datas.STRING, Datas.DOUBLE));
        this.m_locationfind = new StaticSentence(s, "SELECT NAME FROM LOCATIONS WHERE ID = ?", SerializerWriteString.INSTANCE, SerializerReadString.INSTANCE);
        this.m_permissionlist = new StaticSentence(s, "SELECT P.NAME FROM PERMISSIONS P JOIN USER_PERMISSION UP ON P.ID = UP.idPermission WHERE UP.idUser = ?", SerializerWriteString.INSTANCE, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.STRING}));
        this.m_updatepermissions = new StaticSentence(s, "INSERT INTO PERMISSIONS (ID, PERMISSIONS) VALUES (?, ?)", (SerializerWrite)new SerializerWriteBasic(Datas.STRING, Datas.STRING));
        this.m_insertCSVEntry = new StaticSentence(s, "INSERT INTO CSVIMPORT (ID, ROWNUMBER, CSVERROR, REFERENCE, CODE, NAME, PRICEBUY, PRICESELL, PREVIOUSBUY, PREVIOUSSELL,CATEGORY) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", (SerializerWrite)new SerializerWriteBasic(Datas.STRING, Datas.STRING, Datas.STRING, Datas.STRING, Datas.STRING, Datas.STRING, Datas.DOUBLE, Datas.DOUBLE, Datas.DOUBLE, Datas.DOUBLE, Datas.STRING));
        this.m_insertMarque = new StaticSentence(s, "INSERT INTO MARUQENF525 ( SIRET , TVAINTRA , CODENAF ,COMPANY ,ADDRESS1 ,ADDRESS2 ,ZIPCODE , CITY ,COUNTRY  ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)", SerializerWriteParams.INSTANCE);
        this.m_getMarqueNF = new PreparedSentence(s, "SELECT  ID, SIRET, TVAINTRA, CODENAF, COMPANY, ADDRESS1, ADDRESS2, ZIPCODE, CITY, COUNTRY, NEW_SIRET, UPDATE_SIRET_AT, OLD_SIRET, FORME_JURIDIQUE, CAPITAL_SOCIAL, RCS, GREFFE, METIER, FIRST_CONNEXION FROM MARUQENF525 ORDER BY ID", null, MarqueNFC.getSerializerRead());
        this.m_getInfoQoodos = new PreparedSentence(s, "SELECT  ID, USERNAME, PASSWORD, DEVICE_ID, TOKEN, DATE_EXPIRATION FROM INFOS_QOODOS ORDER BY ID", null, InfoQoodos.getSerializerRead());
        String q = "INSERT INTO SOFTWARE (NAME,OLD_DATABASE_VERSION, DATABASE_VERSION, SOFTWARE_VERSION, LAST_UPGRADE_DATE) VALUES(?,?, ?, ? , ?)";
        this.m_upgradeSoftware = new StaticSentence(s, q, SerializerWriteParams.INSTANCE);
        String request_insert_qoodos = "INSERT INTO INFOS_QOODOS(USERNAME, PASSWORD, DEVICE_ID) VALUES(?,?,?)";
        String request_insert_Avomark = "INSERT INTO INFOS_AVOMARK(USERNAME, PASSWORD, DEVICE_ID) VALUES(?,?,?)";
        this.m_insertInfoQoodos = new StaticSentence(s, request_insert_qoodos, SerializerWriteParams.INSTANCE);
        this.m_insertInfoAvomark = new StaticSentence(s, request_insert_Avomark, SerializerWriteParams.INSTANCE);
        String request_update_qoodos = "UPDATE INFOS_QOODOS SET USERNAME =?, PASSWORD =?, DEVICE_ID =?, TOKEN = ?";
        String request_update_Avomark = "UPDATE INFOS_AVOMARK SET USERNAME =?, PASSWORD =?, DEVICE_ID =?, TOKEN = ?";
        this.m_updateInfoQoodos = new StaticSentence(s, request_update_qoodos, SerializerWriteParams.INSTANCE);
        this.m_updateInfoAvomark = new StaticSentence(s, request_update_Avomark, SerializerWriteParams.INSTANCE);
        String request_insert_token_qoodos = "UPDATE INFOS_QOODOS SET TOKEN = ?, DATE_EXPIRATION = ? ";
        this.m_insertTokenQoodos = new StaticSentence(s, request_insert_token_qoodos, SerializerWriteParams.INSTANCE);
        String request_change_status_borne = "UPDATE caisse SET disabled =? WHERE token = ?";
        this.changeStatusBorne = new StaticSentence(s, request_change_status_borne, SerializerWriteParams.INSTANCE);
        this.status_borne = new PreparedSentence(s, "SELECT token FROM caisse WHERE token = ?", SerializerWriteString.INSTANCE, SerializerReadBoolean.INSTANCE);
        this.resetResourcesCache();
        this.requestUser = "SELECT ID, NAME, APPPASSWORD, ROLE,removed, disabled,removedAt, fingerprint, EMAIL, REF_SYNCHRO FROM PEOPLE ";
        this.m_getInfoAvomark = new PreparedSentence(s, "SELECT  ID, USERNAME, PASSWORD, DEVICE_ID, TOKEN FROM INFOS_AVOMARK ORDER BY ID", null, InfoAvomark.getSerializerRead());
    }

    public String getInitScript() {
        return this.m_sInitScript;
    }

    public String getDBVersion() {
        return this.m_dbVersion;
    }

    public final String findVersion() throws BasicException {
        return (String)this.m_version.find((Object)"procaisse");
    }

    public final String findSoftVersion() throws BasicException {
        return (String)this.m_soft_version.find((Object)"procaisse");
    }

    public final String findToken() throws BasicException {
        return (String)this.m_tokenByLocalToken.find((Object)AppLocal.token);
    }

    public final String lastToken() throws BasicException {
        String token = (String)this.m_token.find();
        return token;
    }

    public final String getUser() throws BasicException {
        return "";
    }

    public final void execDummy() throws BasicException {
        this.m_dummy.exec();
    }

    public final List listPeopleVisible() throws BasicException {
        return this.m_peoplevisible.list();
    }

    public final List<String> getPermissions(String userId) throws BasicException {
        List rawList = this.m_permissionlist.list((Object)userId);
        ArrayList<String> permissions = new ArrayList<String>();
        for (Object[] row : rawList) {
            permissions.add((String)row[0]);
        }
        return permissions;
    }

    public final AppUser findPeopleByCard(String card) throws BasicException {
        return (AppUser)this.m_peoplebycard.find((Object)card);
    }

    public final String findRolePermissions(String sRole) {
        try {
            return Formats.BYTEA.formatValue(this.m_rolepermissions.find((Object)sRole));
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
            return null;
        }
    }

    public final void execChangePassword(Object[] userdata) throws BasicException {
        this.m_changepassword.exec(userdata);
    }

    public final void resetResourcesCache() {
        this.resourcescache = new HashMap<String, byte[]>();
    }

    private byte[] getResource(String name) {
        byte[] resource = this.resourcescache.get(name);
        if (resource == null) {
            try {
                resource = (byte[])this.m_resourcebytes.find((Object)name);
                this.resourcescache.put(name, resource);
            }
            catch (Exception ex) {
                resource = null;
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
        return resource;
    }

    public final void setResource(String name, int type, byte[] data) {
        Object[] value = new Object[]{UUID.randomUUID().toString(), name, type, data};
        try {
            if (this.m_resourcebytesupdate.exec(value) == 0) {
                this.m_resourcebytesinsert.exec(value);
            }
            this.resourcescache.put(name, data);
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public final void setResourceAsBinary(String sName, byte[] data) {
        this.setResource(sName, 2, data);
    }

    public final byte[] getResourceAsBinary(String sName) {
        return this.getResource(sName);
    }

    public final String getResourceAsText(String sName) {
        return Formats.BYTEA.formatValue(this.getResource(sName));
    }

    public final String getResourceAsXML(String sName) {
        return Formats.BYTEA.formatValue(this.getResource(sName));
    }

    public final BufferedImage getResourceAsImage(String sName) {
        try {
            byte[] img = this.getResource(sName);
            return img == null ? null : ImageIO.read(new ByteArrayInputStream(img));
        }
        catch (IOException e) {
            return null;
        }
    }

    public final void setResourceAsProperties(String sName, Properties p) {
        if (p == null) {
            this.setResource(sName, 0, null);
        } else {
            try {
                ByteArrayOutputStream o = new ByteArrayOutputStream();
                p.storeToXML((OutputStream)o, "Procaisse", "UTF8");
                this.setResource(sName, 0, o.toByteArray());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public final Properties getResourceAsProperties(String sName) {
        Properties p = new Properties();
        try {
            byte[] img = this.getResourceAsBinary(sName);
            if (img != null) {
                p.loadFromXML(new ByteArrayInputStream(img));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return p;
    }

    public final int getSequenceCash(String host) throws BasicException {
        Integer i = (Integer)this.m_sequencecash.find((Object)host);
        return i == null ? 1 : i;
    }

    public final Object[] findActiveCash(String sActiveCashIndex) throws BasicException {
        return (Object[])this.m_activecash.find((Object)sActiveCashIndex);
    }

    public final void execInsertCash(Object[] cash) throws BasicException {
        this.m_insertcash.exec(cash);
    }

    public final void execDrawerOpened(Object[] drawer) throws BasicException {
        this.m_draweropened.exec(drawer);
    }

    public final void execUpdatePermissions(Object[] permissions) throws BasicException {
        this.m_updatepermissions.exec(permissions);
    }

    public final void execLineRemoved(Object[] line) {
        try {
            this.m_lineremoved.exec(line);
        }
        catch (BasicException basicException) {
            // empty catch block
        }
    }

    public final String findLocationName(String iLocation) throws BasicException {
        return (String)this.m_locationfind.find((Object)iLocation);
    }

    public final void execAddCSVEntry(Object[] csv) throws BasicException {
        this.m_insertCSVEntry.exec(csv);
    }

    public final String getProductRecordType(Object[] myProduct) throws BasicException {
        if (this.m_getProductAllFields.find(myProduct) != null) {
            return this.m_getProductAllFields.find(myProduct).toString();
        }
        if (this.m_getProductRefAndCode.find(myProduct[0], myProduct[1]) != null) {
            return "name error";
        }
        if (this.m_getProductRefAndName.find(myProduct[0], myProduct[2]) != null) {
            return "barcode error";
        }
        if (this.m_getProductCodeAndName.find(myProduct[1], myProduct[2]) != null) {
            return "reference error";
        }
        if (this.m_getProductByReference.find(myProduct[0]) != null) {
            return "Duplicate Reference found.";
        }
        if (this.m_getProductByCode.find(myProduct[1]) != null) {
            return "Duplicate Barcode found.";
        }
        if (this.m_getProductByName.find(myProduct[2]) != null) {
            return "Duplicate Description found.";
        }
        return "new";
    }

    public final void addMarqueNF(final MarqueNFC marqueNFC) throws BasicException {
        this.m_insertMarque.exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, marqueNFC.getSiret());
                this.setString(2, marqueNFC.getIntraTVA());
                this.setString(3, marqueNFC.getCodeNAF());
                this.setString(4, marqueNFC.getCompany());
                this.setString(5, marqueNFC.getAdresse1());
                this.setString(6, marqueNFC.getEmail());
                this.setString(7, marqueNFC.getZipCode());
                this.setString(8, marqueNFC.getCity());
                this.setString(9, marqueNFC.getCountry());
            }
        });
    }

    public MarqueNFC getMarqueInfo() throws BasicException {
        List marque = this.m_getMarqueNF.list();
        if (marque.size() > 0) {
            return (MarqueNFC)marque.get(0);
        }
        return null;
    }

    public void upgradeSoftware(final String old_db_version) throws BasicException {
        this.m_upgradeSoftware.exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, "procaisse");
                this.setString(2, old_db_version);
                this.setString(3, "3.94.47");
                this.setString(4, "10.0.1.27");
                this.setTimestamp(5, new Date());
            }
        });
    }

    public void insertTokenQoodos(final InfoQoodos infoQoodos) throws BasicException {
        this.m_insertTokenQoodos.exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, infoQoodos.getToken());
                this.setTimestamp(2, infoQoodos.getDate_expiration());
            }
        });
    }

    public void addInfoQoodos(final InfoQoodos infoQoodos) throws BasicException {
        this.m_insertInfoQoodos.exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, infoQoodos.getUsername());
                this.setString(2, infoQoodos.getPassword());
                this.setString(3, infoQoodos.getDevice_id());
            }
        });
    }

    public void addInfoAvomark(final InfoAvomark infoAvomark) throws BasicException {
        this.m_insertInfoAvomark.exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, infoAvomark.getUsername());
                this.setString(2, infoAvomark.getPassword());
                this.setInt(3, infoAvomark.getDevice_id());
            }
        });
    }

    public void updateInfoQoodos(final InfoQoodos infoQoodos, final String token) throws BasicException {
        this.m_updateInfoQoodos.exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, infoQoodos.getUsername());
                this.setString(2, infoQoodos.getPassword());
                this.setString(3, infoQoodos.getDevice_id());
                this.setString(4, token);
            }
        });
    }

    public void updateInfoAvomark(final InfoAvomark infoAvomark, final String token) throws BasicException {
        this.m_updateInfoAvomark.exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, infoAvomark.getUsername());
                this.setString(2, infoAvomark.getPassword());
                this.setInt(3, infoAvomark.getDevice_id());
                this.setString(4, token);
            }
        });
    }

    public InfoQoodos getInfoQoodos() throws BasicException {
        List infoQoodos;
        List list = infoQoodos = this.m_getInfoQoodos != null ? this.m_getInfoQoodos.list() : null;
        if (infoQoodos != null && infoQoodos.size() > 0) {
            return (InfoQoodos)infoQoodos.get(0);
        }
        return null;
    }

    public InfoAvomark getInfoAvomark() throws BasicException {
        List infoAvomark;
        List list = infoAvomark = this.m_getInfoAvomark != null ? this.m_getInfoAvomark.list() : null;
        if (infoAvomark != null && infoAvomark.size() > 0) {
            return (InfoAvomark)infoAvomark.get(0);
        }
        return null;
    }

    public void persistInfoQoodos(InfoQoodos infoQoodos) throws BasicException {
        InfoQoodos oldInfo = this.getInfoQoodos();
        if (oldInfo != null) {
            if (oldInfo.getUsername() != null && oldInfo.getUsername().equals(infoQoodos.getUsername()) && oldInfo.getPassword() != null && oldInfo.getPassword().equals(infoQoodos.getPassword()) && oldInfo.getDevice_id() != null && oldInfo.getDevice_id().equals(infoQoodos.getDevice_id())) {
                this.updateInfoQoodos(infoQoodos, oldInfo.getToken());
            } else {
                this.updateInfoQoodos(infoQoodos, null);
            }
        } else {
            this.addInfoQoodos(infoQoodos);
        }
    }

    public void persistInfoAvomark(InfoAvomark infoAvomark) throws BasicException {
        InfoAvomark oldInfo = this.getInfoAvomark();
        if (oldInfo != null) {
            if (oldInfo.getUsername() != null && oldInfo.getUsername().equals(infoAvomark.getUsername()) && oldInfo.getPassword() != null && oldInfo.getPassword().equals(infoAvomark.getPassword()) && oldInfo.getDevice_id() != 0 && oldInfo.getDevice_id() == infoAvomark.getDevice_id()) {
                this.updateInfoAvomark(infoAvomark, oldInfo.getToken());
            } else {
                String token = null;
                AvomarkService mAvomarkService = AvomarkService.getInstance();
                try {
                    token = mAvomarkService.getToken(infoAvomark.getUsername(), infoAvomark.getUsername(), infoAvomark.getDevice_id());
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
                this.updateInfoAvomark(infoAvomark, token);
            }
        } else {
            this.addInfoAvomark(infoAvomark);
        }
    }

    public void changeStatus(final boolean disabled) throws BasicException {
        this.changeStatusBorne.exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setBoolean(1, disabled);
                this.setString(2, AppLocal.token);
            }
        });
    }

    public boolean borneDisbled() throws BasicException {
        return (Boolean)this.status_borne.find((Object)AppLocal.token);
    }

    public Integer getCountUser() throws BasicException {
        Object[] recsales = (Object[])new StaticSentence(this.s, "SELECT  COUNT(C.ID) FROM COUNTER_USER C ", null, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.INT})).find();
        if (recsales != null) {
            return (Integer)recsales[0];
        }
        return 0;
    }

    public void addCounteruser(final String idUser) throws BasicException {
        new PreparedSentence(this.s, "INSERT INTO COUNTER_USER (ID_USER) VALUES(?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setString(1, idUser);
            }
        });
    }

    public List<User> getAllUsers() throws BasicException {
        return new PreparedSentence(this.s, this.requestUser, null, User.getSerializerRead()).list();
    }

    public void deleteBorne(Borne borne) throws BasicException {
        new PreparedSentence(this.s, "DELETE FROM BORNES WHERE ID = ? ", SerializerWriteInteger.INSTANCE).exec((Object)borne.getId());
    }

    public Date getDateDeleteLogs() throws BasicException {
        Object[] recsales = (Object[])new StaticSentence(this.s, "SELECT  LAST_DELETE FROM APPLICATION_LOGS WHERE ID = 1", null, (SerializerRead)new SerializerReadBasic(new Datas[]{Datas.TIMESTAMP})).find();
        if (recsales != null) {
            return (Date)recsales[0];
        }
        return null;
    }

    public void addDateDeleteLogs() throws BasicException {
        new PreparedSentence(this.s, "INSERT INTO APPLICATION_LOGS (LAST_DELETE) VALUES(?)", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, new Date());
            }
        });
    }

    public void updteDateDeleteLogs() throws BasicException {
        new PreparedSentence(this.s, "UPDATE  APPLICATION_LOGS SET LAST_DELETE = ? WHERE ID = 1", SerializerWriteParams.INSTANCE).exec((Object)new DataParams(){

            @Override
            public void writeValues() throws BasicException {
                this.setTimestamp(1, new Date());
            }
        });
    }

    public void saveLastDelete(boolean add_delete_date) throws BasicException {
        if (add_delete_date) {
            this.addDateDeleteLogs();
        } else {
            this.updteDateDeleteLogs();
        }
    }

    public void createTablePRODUCTS_SIZE() throws SQLException {
        DatabaseMetaData dbmd = this.s.getConnection().getMetaData();
        ResultSet rs = dbmd.getTables(null, "APP", "PRODUCTS_SIZE", null);
        if (!rs.next()) {
            this.s.getConnection().createStatement().execute("CREATE TABLE PRODUCTS_SIZE (    ID INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY,    name_size VARCHAR(255) DEFAULT  NULL,    label_size VARCHAR(255) DEFAULT  NULL,    price DOUBLE PRECISION DEFAULT 0 NOT NULL,    price_sp DOUBLE PRECISION DEFAULT 0 NOT NULL,    price_emp DOUBLE PRECISION DEFAULT 0 NOT NULL,    price_lv DOUBLE PRECISION DEFAULT 0 NOT NULL,    price_bar DOUBLE PRECISION DEFAULT 0 NOT NULL,    price_terasse DOUBLE PRECISION DEFAULT 0 NOT NULL,    price_happy_hour DOUBLE PRECISION DEFAULT 0 NOT NULL,    product INTEGER NOT NULL,    REF_WEB VARCHAR(255) DEFAULT NULL,    PRICE_UBER DOUBLE PRECISION DEFAULT 0 NOT NULL,    PRICE_DELIVERO DOUBLE PRECISION DEFAULT 0 NOT NULL,    PRICE_PLATFORM DOUBLE PRECISION DEFAULT 0 NOT NULL,    SIZE_ENABLED SMALLINT DEFAULT 1 NOT NULL,    PRIMARY KEY (ID),    CONSTRAINT PRODUCT_SIZE_FK1 FOREIGN KEY (product) REFERENCES PRODUCTS(ID))");
        }
    }

    public void createTableTAGS_WORKSHIFT() throws SQLException {
        DatabaseMetaData dbmd = this.s.getConnection().getMetaData();
        ResultSet rs = dbmd.getTables(null, "APP", "TAGS_WORKSHIFT", null);
        if (!rs.next()) {
            this.s.getConnection().createStatement().execute("CREATE TABLE TAGS_WORKSHIFT ( ID INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY, START_SHIFT VARCHAR(255) DEFAULT NULL, END_SHIFT VARCHAR(255) DEFAULT NULL, IDTIMETABLE INTEGER NOT NULL, PRIMARY KEY (ID), CONSTRAINT TAGS_WORKSHIFT_FK FOREIGN KEY (IDTIMETABLE) REFERENCES TAGS_TIMETABLE(ID))");
        }
    }

    public void reclaimUnusedSpace() throws BasicException {
        new PreparedSentence(this.s, "call SYSCS_UTIL.SYSCS_COMPRESS_TABLE('APP', 'LINES', 0)", null).exec();
        new PreparedSentence(this.s, "call SYSCS_UTIL.SYSCS_COMPRESS_TABLE('APP', 'TOTAL_TAX', 0)", null).exec();
        new PreparedSentence(this.s, "call SYSCS_UTIL.SYSCS_COMPRESS_TABLE('APP', 'TOTAL_ENCAISSEMENT', 0)", null).exec();
        new PreparedSentence(this.s, "call SYSCS_UTIL.SYSCS_COMPRESS_TABLE('APP', 'TICKETLINES', 0)", null).exec();
        new PreparedSentence(this.s, "call SYSCS_UTIL.SYSCS_COMPRESS_TABLE('APP', 'INGREDIENT_TICKET', 0)", null).exec();
        new PreparedSentence(this.s, "call SYSCS_UTIL.SYSCS_COMPRESS_TABLE('APP', 'OPTION_TICKET', 0)", null).exec();
        new PreparedSentence(this.s, "call SYSCS_UTIL.SYSCS_COMPRESS_TABLE('APP', 'PRODUCT_TICKET', 0)", null).exec();
        new PreparedSentence(this.s, "call SYSCS_UTIL.SYSCS_COMPRESS_TABLE('APP', 'ENTETE', 0)", null).exec();
        new PreparedSentence(this.s, "call SYSCS_UTIL.SYSCS_COMPRESS_TABLE('APP', 'GRAND_TOTAL', 0)", null).exec();
        new PreparedSentence(this.s, "call SYSCS_UTIL.SYSCS_COMPRESS_TABLE('APP', 'TICKETS', 0)", null).exec();
        new PreparedSentence(this.s, "call SYSCS_UTIL.SYSCS_COMPRESS_TABLE('APP', 'RECEIPTS', 0)", null).exec();
        new PreparedSentence(this.s, "call SYSCS_UTIL.SYSCS_COMPRESS_TABLE('APP', 'PAYMENTS', 0)", null).exec();
        new PreparedSentence(this.s, "call SYSCS_UTIL.SYSCS_COMPRESS_TABLE('APP', 'TICKET_PAYMENT', 0)", null).exec();
        new PreparedSentence(this.s, "call SYSCS_UTIL.SYSCS_COMPRESS_TABLE('APP', 'DUPLICATA', 0)", null).exec();
        new PreparedSentence(this.s, "call SYSCS_UTIL.SYSCS_COMPRESS_TABLE('APP', 'ENTETE_NOTE', 0)", null).exec();
        new PreparedSentence(this.s, "call SYSCS_UTIL.SYSCS_COMPRESS_TABLE('APP', 'DOCUMENT', 0)", null).exec();
    }
}

